/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.HostSubnet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class HostSubnetFluent<A extends HostSubnetFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private List<String> egressCIDRs = new ArrayList<String>();
    private List<String> egressIPs = new ArrayList<String>();
    private String host;
    private String hostIP;
    private String kind;
    private ObjectMetaBuilder metadata;
    private String subnet;
    private Map<String, Object> additionalProperties;

    public HostSubnetFluent() {
    }

    public HostSubnetFluent(HostSubnet instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HostSubnet instance) {
        HostSubnet hostSubnet = instance = instance != null ? instance : new HostSubnet();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withEgressCIDRs(instance.getEgressCIDRs());
            this.withEgressIPs(instance.getEgressIPs());
            this.withHost(instance.getHost());
            this.withHostIP(instance.getHostIP());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSubnet(instance.getSubnet());
            this.withApiVersion(instance.getApiVersion());
            this.withEgressCIDRs(instance.getEgressCIDRs());
            this.withEgressIPs(instance.getEgressIPs());
            this.withHost(instance.getHost());
            this.withHostIP(instance.getHostIP());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSubnet(instance.getSubnet());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToEgressCIDRs(int index, String item) {
        if (this.egressCIDRs == null) {
            this.egressCIDRs = new ArrayList<String>();
        }
        this.egressCIDRs.add(index, item);
        return (A)this;
    }

    public A setToEgressCIDRs(int index, String item) {
        if (this.egressCIDRs == null) {
            this.egressCIDRs = new ArrayList<String>();
        }
        this.egressCIDRs.set(index, item);
        return (A)this;
    }

    public A addToEgressCIDRs(String ... items) {
        if (this.egressCIDRs == null) {
            this.egressCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.egressCIDRs.add(item);
        }
        return (A)this;
    }

    public A addAllToEgressCIDRs(Collection<String> items) {
        if (this.egressCIDRs == null) {
            this.egressCIDRs = new ArrayList<String>();
        }
        for (String item : items) {
            this.egressCIDRs.add(item);
        }
        return (A)this;
    }

    public A removeFromEgressCIDRs(String ... items) {
        if (this.egressCIDRs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.egressCIDRs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromEgressCIDRs(Collection<String> items) {
        if (this.egressCIDRs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.egressCIDRs.remove(item);
        }
        return (A)this;
    }

    public List<String> getEgressCIDRs() {
        return this.egressCIDRs;
    }

    public String getEgressCIDR(int index) {
        return this.egressCIDRs.get(index);
    }

    public String getFirstEgressCIDR() {
        return this.egressCIDRs.get(0);
    }

    public String getLastEgressCIDR() {
        return this.egressCIDRs.get(this.egressCIDRs.size() - 1);
    }

    public String getMatchingEgressCIDR(Predicate<String> predicate) {
        for (String item : this.egressCIDRs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEgressCIDR(Predicate<String> predicate) {
        for (String item : this.egressCIDRs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEgressCIDRs(List<String> egressCIDRs) {
        if (egressCIDRs != null) {
            this.egressCIDRs = new ArrayList<String>();
            for (String item : egressCIDRs) {
                this.addToEgressCIDRs(item);
            }
        } else {
            this.egressCIDRs = null;
        }
        return (A)this;
    }

    public A withEgressCIDRs(String ... egressCIDRs) {
        if (this.egressCIDRs != null) {
            this.egressCIDRs.clear();
            this._visitables.remove("egressCIDRs");
        }
        if (egressCIDRs != null) {
            for (String item : egressCIDRs) {
                this.addToEgressCIDRs(item);
            }
        }
        return (A)this;
    }

    public boolean hasEgressCIDRs() {
        return this.egressCIDRs != null && !this.egressCIDRs.isEmpty();
    }

    public A addToEgressIPs(int index, String item) {
        if (this.egressIPs == null) {
            this.egressIPs = new ArrayList<String>();
        }
        this.egressIPs.add(index, item);
        return (A)this;
    }

    public A setToEgressIPs(int index, String item) {
        if (this.egressIPs == null) {
            this.egressIPs = new ArrayList<String>();
        }
        this.egressIPs.set(index, item);
        return (A)this;
    }

    public A addToEgressIPs(String ... items) {
        if (this.egressIPs == null) {
            this.egressIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.egressIPs.add(item);
        }
        return (A)this;
    }

    public A addAllToEgressIPs(Collection<String> items) {
        if (this.egressIPs == null) {
            this.egressIPs = new ArrayList<String>();
        }
        for (String item : items) {
            this.egressIPs.add(item);
        }
        return (A)this;
    }

    public A removeFromEgressIPs(String ... items) {
        if (this.egressIPs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.egressIPs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromEgressIPs(Collection<String> items) {
        if (this.egressIPs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.egressIPs.remove(item);
        }
        return (A)this;
    }

    public List<String> getEgressIPs() {
        return this.egressIPs;
    }

    public String getEgressIP(int index) {
        return this.egressIPs.get(index);
    }

    public String getFirstEgressIP() {
        return this.egressIPs.get(0);
    }

    public String getLastEgressIP() {
        return this.egressIPs.get(this.egressIPs.size() - 1);
    }

    public String getMatchingEgressIP(Predicate<String> predicate) {
        for (String item : this.egressIPs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEgressIP(Predicate<String> predicate) {
        for (String item : this.egressIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEgressIPs(List<String> egressIPs) {
        if (egressIPs != null) {
            this.egressIPs = new ArrayList<String>();
            for (String item : egressIPs) {
                this.addToEgressIPs(item);
            }
        } else {
            this.egressIPs = null;
        }
        return (A)this;
    }

    public A withEgressIPs(String ... egressIPs) {
        if (this.egressIPs != null) {
            this.egressIPs.clear();
            this._visitables.remove("egressIPs");
        }
        if (egressIPs != null) {
            for (String item : egressIPs) {
                this.addToEgressIPs(item);
            }
        }
        return (A)this;
    }

    public boolean hasEgressIPs() {
        return this.egressIPs != null && !this.egressIPs.isEmpty();
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public String getHostIP() {
        return this.hostIP;
    }

    public A withHostIP(String hostIP) {
        this.hostIP = hostIP;
        return (A)this;
    }

    public boolean hasHostIP() {
        return this.hostIP != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public String getSubnet() {
        return this.subnet;
    }

    public A withSubnet(String subnet) {
        this.subnet = subnet;
        return (A)this;
    }

    public boolean hasSubnet() {
        return this.subnet != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HostSubnetFluent that = (HostSubnetFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.egressCIDRs, that.egressCIDRs)) {
            return false;
        }
        if (!Objects.equals(this.egressIPs, that.egressIPs)) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.hostIP, that.hostIP)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.subnet, that.subnet)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.egressCIDRs, this.egressIPs, this.host, this.hostIP, this.kind, this.metadata, this.subnet, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.egressCIDRs != null && !this.egressCIDRs.isEmpty()) {
            sb.append("egressCIDRs:");
            sb.append(this.egressCIDRs + ",");
        }
        if (this.egressIPs != null && !this.egressIPs.isEmpty()) {
            sb.append("egressIPs:");
            sb.append(this.egressIPs + ",");
        }
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.hostIP != null) {
            sb.append("hostIP:");
            sb.append(this.hostIP + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.subnet != null) {
            sb.append("subnet:");
            sb.append(this.subnet + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)HostSubnetFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

