/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReference;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReferenceFluent;
import io.fabric8.openshift.api.model.config.v1.SchedulerSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SchedulerSpecFluent<A extends SchedulerSpecFluent<A>>
extends BaseFluent<A> {
    private String defaultNodeSelector;
    private Boolean mastersSchedulable;
    private ConfigMapNameReferenceBuilder policy;
    private String profile;
    private Map<String, Object> additionalProperties;

    public SchedulerSpecFluent() {
    }

    public SchedulerSpecFluent(SchedulerSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SchedulerSpec instance) {
        SchedulerSpec schedulerSpec = instance = instance != null ? instance : new SchedulerSpec();
        if (instance != null) {
            this.withDefaultNodeSelector(instance.getDefaultNodeSelector());
            this.withMastersSchedulable(instance.getMastersSchedulable());
            this.withPolicy(instance.getPolicy());
            this.withProfile(instance.getProfile());
            this.withDefaultNodeSelector(instance.getDefaultNodeSelector());
            this.withMastersSchedulable(instance.getMastersSchedulable());
            this.withPolicy(instance.getPolicy());
            this.withProfile(instance.getProfile());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getDefaultNodeSelector() {
        return this.defaultNodeSelector;
    }

    public A withDefaultNodeSelector(String defaultNodeSelector) {
        this.defaultNodeSelector = defaultNodeSelector;
        return (A)this;
    }

    public boolean hasDefaultNodeSelector() {
        return this.defaultNodeSelector != null;
    }

    public Boolean getMastersSchedulable() {
        return this.mastersSchedulable;
    }

    public A withMastersSchedulable(Boolean mastersSchedulable) {
        this.mastersSchedulable = mastersSchedulable;
        return (A)this;
    }

    public boolean hasMastersSchedulable() {
        return this.mastersSchedulable != null;
    }

    public ConfigMapNameReference buildPolicy() {
        return this.policy != null ? this.policy.build() : null;
    }

    public A withPolicy(ConfigMapNameReference policy) {
        this._visitables.get("policy").remove(this.policy);
        if (policy != null) {
            this.policy = new ConfigMapNameReferenceBuilder(policy);
            this._visitables.get("policy").add(this.policy);
        } else {
            this.policy = null;
            this._visitables.get("policy").remove(this.policy);
        }
        return (A)this;
    }

    public boolean hasPolicy() {
        return this.policy != null;
    }

    public A withNewPolicy(String name) {
        return this.withPolicy(new ConfigMapNameReference(name));
    }

    public PolicyNested<A> withNewPolicy() {
        return new PolicyNested(null);
    }

    public PolicyNested<A> withNewPolicyLike(ConfigMapNameReference item) {
        return new PolicyNested(item);
    }

    public PolicyNested<A> editPolicy() {
        return this.withNewPolicyLike(Optional.ofNullable(this.buildPolicy()).orElse(null));
    }

    public PolicyNested<A> editOrNewPolicy() {
        return this.withNewPolicyLike(Optional.ofNullable(this.buildPolicy()).orElse(new ConfigMapNameReferenceBuilder().build()));
    }

    public PolicyNested<A> editOrNewPolicyLike(ConfigMapNameReference item) {
        return this.withNewPolicyLike(Optional.ofNullable(this.buildPolicy()).orElse(item));
    }

    public String getProfile() {
        return this.profile;
    }

    public A withProfile(String profile) {
        this.profile = profile;
        return (A)this;
    }

    public boolean hasProfile() {
        return this.profile != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SchedulerSpecFluent that = (SchedulerSpecFluent)o;
        if (!Objects.equals(this.defaultNodeSelector, that.defaultNodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.mastersSchedulable, that.mastersSchedulable)) {
            return false;
        }
        if (!Objects.equals(this.policy, that.policy)) {
            return false;
        }
        if (!Objects.equals(this.profile, that.profile)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.defaultNodeSelector, this.mastersSchedulable, this.policy, this.profile, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.defaultNodeSelector != null) {
            sb.append("defaultNodeSelector:");
            sb.append(this.defaultNodeSelector + ",");
        }
        if (this.mastersSchedulable != null) {
            sb.append("mastersSchedulable:");
            sb.append(this.mastersSchedulable + ",");
        }
        if (this.policy != null) {
            sb.append("policy:");
            sb.append(this.policy + ",");
        }
        if (this.profile != null) {
            sb.append("profile:");
            sb.append(this.profile + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withMastersSchedulable() {
        return this.withMastersSchedulable(true);
    }

    public class PolicyNested<N>
    extends ConfigMapNameReferenceFluent<PolicyNested<N>>
    implements Nested<N> {
        ConfigMapNameReferenceBuilder builder;

        PolicyNested(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SchedulerSpecFluent.this.withPolicy(this.builder.build());
        }

        public N endPolicy() {
            return this.and();
        }
    }
}

