/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.aws.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.aws.v1.PrivateLinkAccessStatus;
import io.fabric8.openshift.api.model.hive.aws.v1.VPCEndpointService;
import io.fabric8.openshift.api.model.hive.aws.v1.VPCEndpointServiceBuilder;
import io.fabric8.openshift.api.model.hive.aws.v1.VPCEndpointServiceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PrivateLinkAccessStatusFluent<A extends PrivateLinkAccessStatusFluent<A>>
extends BaseFluent<A> {
    private String hostedZoneID;
    private String vpcEndpointID;
    private VPCEndpointServiceBuilder vpcEndpointService;
    private Map<String, Object> additionalProperties;

    public PrivateLinkAccessStatusFluent() {
    }

    public PrivateLinkAccessStatusFluent(PrivateLinkAccessStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PrivateLinkAccessStatus instance) {
        PrivateLinkAccessStatus privateLinkAccessStatus = instance = instance != null ? instance : new PrivateLinkAccessStatus();
        if (instance != null) {
            this.withHostedZoneID(instance.getHostedZoneID());
            this.withVpcEndpointID(instance.getVpcEndpointID());
            this.withVpcEndpointService(instance.getVpcEndpointService());
            this.withHostedZoneID(instance.getHostedZoneID());
            this.withVpcEndpointID(instance.getVpcEndpointID());
            this.withVpcEndpointService(instance.getVpcEndpointService());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getHostedZoneID() {
        return this.hostedZoneID;
    }

    public A withHostedZoneID(String hostedZoneID) {
        this.hostedZoneID = hostedZoneID;
        return (A)this;
    }

    public boolean hasHostedZoneID() {
        return this.hostedZoneID != null;
    }

    public String getVpcEndpointID() {
        return this.vpcEndpointID;
    }

    public A withVpcEndpointID(String vpcEndpointID) {
        this.vpcEndpointID = vpcEndpointID;
        return (A)this;
    }

    public boolean hasVpcEndpointID() {
        return this.vpcEndpointID != null;
    }

    public VPCEndpointService buildVpcEndpointService() {
        return this.vpcEndpointService != null ? this.vpcEndpointService.build() : null;
    }

    public A withVpcEndpointService(VPCEndpointService vpcEndpointService) {
        this._visitables.get("vpcEndpointService").remove(this.vpcEndpointService);
        if (vpcEndpointService != null) {
            this.vpcEndpointService = new VPCEndpointServiceBuilder(vpcEndpointService);
            this._visitables.get("vpcEndpointService").add(this.vpcEndpointService);
        } else {
            this.vpcEndpointService = null;
            this._visitables.get("vpcEndpointService").remove(this.vpcEndpointService);
        }
        return (A)this;
    }

    public boolean hasVpcEndpointService() {
        return this.vpcEndpointService != null;
    }

    public VpcEndpointServiceNested<A> withNewVpcEndpointService() {
        return new VpcEndpointServiceNested(null);
    }

    public VpcEndpointServiceNested<A> withNewVpcEndpointServiceLike(VPCEndpointService item) {
        return new VpcEndpointServiceNested(item);
    }

    public VpcEndpointServiceNested<A> editVpcEndpointService() {
        return this.withNewVpcEndpointServiceLike(Optional.ofNullable(this.buildVpcEndpointService()).orElse(null));
    }

    public VpcEndpointServiceNested<A> editOrNewVpcEndpointService() {
        return this.withNewVpcEndpointServiceLike(Optional.ofNullable(this.buildVpcEndpointService()).orElse(new VPCEndpointServiceBuilder().build()));
    }

    public VpcEndpointServiceNested<A> editOrNewVpcEndpointServiceLike(VPCEndpointService item) {
        return this.withNewVpcEndpointServiceLike(Optional.ofNullable(this.buildVpcEndpointService()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PrivateLinkAccessStatusFluent that = (PrivateLinkAccessStatusFluent)o;
        if (!Objects.equals(this.hostedZoneID, that.hostedZoneID)) {
            return false;
        }
        if (!Objects.equals(this.vpcEndpointID, that.vpcEndpointID)) {
            return false;
        }
        if (!Objects.equals(this.vpcEndpointService, that.vpcEndpointService)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hostedZoneID, this.vpcEndpointID, this.vpcEndpointService, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostedZoneID != null) {
            sb.append("hostedZoneID:");
            sb.append(this.hostedZoneID + ",");
        }
        if (this.vpcEndpointID != null) {
            sb.append("vpcEndpointID:");
            sb.append(this.vpcEndpointID + ",");
        }
        if (this.vpcEndpointService != null) {
            sb.append("vpcEndpointService:");
            sb.append(this.vpcEndpointService + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class VpcEndpointServiceNested<N>
    extends VPCEndpointServiceFluent<VpcEndpointServiceNested<N>>
    implements Nested<N> {
        VPCEndpointServiceBuilder builder;

        VpcEndpointServiceNested(VPCEndpointService item) {
            this.builder = new VPCEndpointServiceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PrivateLinkAccessStatusFluent.this.withVpcEndpointService(this.builder.build());
        }

        public N endVpcEndpointService() {
            return this.and();
        }
    }
}

