/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.v1.BackupConfig;
import io.fabric8.openshift.api.model.hive.v1.VeleroBackupConfig;
import io.fabric8.openshift.api.model.hive.v1.VeleroBackupConfigBuilder;
import io.fabric8.openshift.api.model.hive.v1.VeleroBackupConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class BackupConfigFluent<A extends BackupConfigFluent<A>>
extends BaseFluent<A> {
    private Integer minBackupPeriodSeconds;
    private VeleroBackupConfigBuilder velero;
    private Map<String, Object> additionalProperties;

    public BackupConfigFluent() {
    }

    public BackupConfigFluent(BackupConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BackupConfig instance) {
        BackupConfig backupConfig = instance = instance != null ? instance : new BackupConfig();
        if (instance != null) {
            this.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds());
            this.withVelero(instance.getVelero());
            this.withMinBackupPeriodSeconds(instance.getMinBackupPeriodSeconds());
            this.withVelero(instance.getVelero());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getMinBackupPeriodSeconds() {
        return this.minBackupPeriodSeconds;
    }

    public A withMinBackupPeriodSeconds(Integer minBackupPeriodSeconds) {
        this.minBackupPeriodSeconds = minBackupPeriodSeconds;
        return (A)this;
    }

    public boolean hasMinBackupPeriodSeconds() {
        return this.minBackupPeriodSeconds != null;
    }

    public VeleroBackupConfig buildVelero() {
        return this.velero != null ? this.velero.build() : null;
    }

    public A withVelero(VeleroBackupConfig velero) {
        this._visitables.get("velero").remove(this.velero);
        if (velero != null) {
            this.velero = new VeleroBackupConfigBuilder(velero);
            this._visitables.get("velero").add(this.velero);
        } else {
            this.velero = null;
            this._visitables.get("velero").remove(this.velero);
        }
        return (A)this;
    }

    public boolean hasVelero() {
        return this.velero != null;
    }

    public A withNewVelero(Boolean enabled, String namespace) {
        return this.withVelero(new VeleroBackupConfig(enabled, namespace));
    }

    public VeleroNested<A> withNewVelero() {
        return new VeleroNested(null);
    }

    public VeleroNested<A> withNewVeleroLike(VeleroBackupConfig item) {
        return new VeleroNested(item);
    }

    public VeleroNested<A> editVelero() {
        return this.withNewVeleroLike(Optional.ofNullable(this.buildVelero()).orElse(null));
    }

    public VeleroNested<A> editOrNewVelero() {
        return this.withNewVeleroLike(Optional.ofNullable(this.buildVelero()).orElse(new VeleroBackupConfigBuilder().build()));
    }

    public VeleroNested<A> editOrNewVeleroLike(VeleroBackupConfig item) {
        return this.withNewVeleroLike(Optional.ofNullable(this.buildVelero()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BackupConfigFluent that = (BackupConfigFluent)o;
        if (!Objects.equals(this.minBackupPeriodSeconds, that.minBackupPeriodSeconds)) {
            return false;
        }
        if (!Objects.equals(this.velero, that.velero)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.minBackupPeriodSeconds, this.velero, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.minBackupPeriodSeconds != null) {
            sb.append("minBackupPeriodSeconds:");
            sb.append(this.minBackupPeriodSeconds + ",");
        }
        if (this.velero != null) {
            sb.append("velero:");
            sb.append(this.velero + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class VeleroNested<N>
    extends VeleroBackupConfigFluent<VeleroNested<N>>
    implements Nested<N> {
        VeleroBackupConfigBuilder builder;

        VeleroNested(VeleroBackupConfig item) {
            this.builder = new VeleroBackupConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BackupConfigFluent.this.withVelero(this.builder.build());
        }

        public N endVelero() {
            return this.and();
        }
    }
}

