/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CatalogSourceStatus;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.ConfigMapResourceReference;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.ConfigMapResourceReferenceBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.ConfigMapResourceReferenceFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.GRPCConnectionState;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.GRPCConnectionStateBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.GRPCConnectionStateFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.RegistryServiceStatus;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.RegistryServiceStatusBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.RegistryServiceStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class CatalogSourceStatusFluent<A extends CatalogSourceStatusFluent<A>>
extends BaseFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private ConfigMapResourceReferenceBuilder configMapReference;
    private GRPCConnectionStateBuilder connectionState;
    private String latestImageRegistryPoll;
    private String message;
    private String reason;
    private RegistryServiceStatusBuilder registryService;
    private Map<String, Object> additionalProperties;

    public CatalogSourceStatusFluent() {
    }

    public CatalogSourceStatusFluent(CatalogSourceStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CatalogSourceStatus instance) {
        CatalogSourceStatus catalogSourceStatus = instance = instance != null ? instance : new CatalogSourceStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withConfigMapReference(instance.getConfigMapReference());
            this.withConnectionState(instance.getConnectionState());
            this.withLatestImageRegistryPoll(instance.getLatestImageRegistryPoll());
            this.withMessage(instance.getMessage());
            this.withReason(instance.getReason());
            this.withRegistryService(instance.getRegistryService());
            this.withConditions(instance.getConditions());
            this.withConfigMapReference(instance.getConfigMapReference());
            this.withConnectionState(instance.getConnectionState());
            this.withLatestImageRegistryPoll(instance.getLatestImageRegistryPoll());
            this.withMessage(instance.getMessage());
            this.withReason(instance.getReason());
            this.withRegistryService(instance.getRegistryService());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConfigMapResourceReference buildConfigMapReference() {
        return this.configMapReference != null ? this.configMapReference.build() : null;
    }

    public A withConfigMapReference(ConfigMapResourceReference configMapReference) {
        this._visitables.get("configMapReference").remove(this.configMapReference);
        if (configMapReference != null) {
            this.configMapReference = new ConfigMapResourceReferenceBuilder(configMapReference);
            this._visitables.get("configMapReference").add(this.configMapReference);
        } else {
            this.configMapReference = null;
            this._visitables.get("configMapReference").remove(this.configMapReference);
        }
        return (A)this;
    }

    public boolean hasConfigMapReference() {
        return this.configMapReference != null;
    }

    public A withNewConfigMapReference(String lastUpdateTime, String name, String namespace, String resourceVersion, String uid) {
        return this.withConfigMapReference(new ConfigMapResourceReference(lastUpdateTime, name, namespace, resourceVersion, uid));
    }

    public ConfigMapReferenceNested<A> withNewConfigMapReference() {
        return new ConfigMapReferenceNested(null);
    }

    public ConfigMapReferenceNested<A> withNewConfigMapReferenceLike(ConfigMapResourceReference item) {
        return new ConfigMapReferenceNested(item);
    }

    public ConfigMapReferenceNested<A> editConfigMapReference() {
        return this.withNewConfigMapReferenceLike(Optional.ofNullable(this.buildConfigMapReference()).orElse(null));
    }

    public ConfigMapReferenceNested<A> editOrNewConfigMapReference() {
        return this.withNewConfigMapReferenceLike(Optional.ofNullable(this.buildConfigMapReference()).orElse(new ConfigMapResourceReferenceBuilder().build()));
    }

    public ConfigMapReferenceNested<A> editOrNewConfigMapReferenceLike(ConfigMapResourceReference item) {
        return this.withNewConfigMapReferenceLike(Optional.ofNullable(this.buildConfigMapReference()).orElse(item));
    }

    public GRPCConnectionState buildConnectionState() {
        return this.connectionState != null ? this.connectionState.build() : null;
    }

    public A withConnectionState(GRPCConnectionState connectionState) {
        this._visitables.get("connectionState").remove(this.connectionState);
        if (connectionState != null) {
            this.connectionState = new GRPCConnectionStateBuilder(connectionState);
            this._visitables.get("connectionState").add(this.connectionState);
        } else {
            this.connectionState = null;
            this._visitables.get("connectionState").remove(this.connectionState);
        }
        return (A)this;
    }

    public boolean hasConnectionState() {
        return this.connectionState != null;
    }

    public A withNewConnectionState(String address, String lastConnect, String lastObservedState) {
        return this.withConnectionState(new GRPCConnectionState(address, lastConnect, lastObservedState));
    }

    public ConnectionStateNested<A> withNewConnectionState() {
        return new ConnectionStateNested(null);
    }

    public ConnectionStateNested<A> withNewConnectionStateLike(GRPCConnectionState item) {
        return new ConnectionStateNested(item);
    }

    public ConnectionStateNested<A> editConnectionState() {
        return this.withNewConnectionStateLike(Optional.ofNullable(this.buildConnectionState()).orElse(null));
    }

    public ConnectionStateNested<A> editOrNewConnectionState() {
        return this.withNewConnectionStateLike(Optional.ofNullable(this.buildConnectionState()).orElse(new GRPCConnectionStateBuilder().build()));
    }

    public ConnectionStateNested<A> editOrNewConnectionStateLike(GRPCConnectionState item) {
        return this.withNewConnectionStateLike(Optional.ofNullable(this.buildConnectionState()).orElse(item));
    }

    public String getLatestImageRegistryPoll() {
        return this.latestImageRegistryPoll;
    }

    public A withLatestImageRegistryPoll(String latestImageRegistryPoll) {
        this.latestImageRegistryPoll = latestImageRegistryPoll;
        return (A)this;
    }

    public boolean hasLatestImageRegistryPoll() {
        return this.latestImageRegistryPoll != null;
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public String getReason() {
        return this.reason;
    }

    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public RegistryServiceStatus buildRegistryService() {
        return this.registryService != null ? this.registryService.build() : null;
    }

    public A withRegistryService(RegistryServiceStatus registryService) {
        this._visitables.get("registryService").remove(this.registryService);
        if (registryService != null) {
            this.registryService = new RegistryServiceStatusBuilder(registryService);
            this._visitables.get("registryService").add(this.registryService);
        } else {
            this.registryService = null;
            this._visitables.get("registryService").remove(this.registryService);
        }
        return (A)this;
    }

    public boolean hasRegistryService() {
        return this.registryService != null;
    }

    public A withNewRegistryService(String createdAt, String port, String protocol, String serviceName, String serviceNamespace) {
        return this.withRegistryService(new RegistryServiceStatus(createdAt, port, protocol, serviceName, serviceNamespace));
    }

    public RegistryServiceNested<A> withNewRegistryService() {
        return new RegistryServiceNested(null);
    }

    public RegistryServiceNested<A> withNewRegistryServiceLike(RegistryServiceStatus item) {
        return new RegistryServiceNested(item);
    }

    public RegistryServiceNested<A> editRegistryService() {
        return this.withNewRegistryServiceLike(Optional.ofNullable(this.buildRegistryService()).orElse(null));
    }

    public RegistryServiceNested<A> editOrNewRegistryService() {
        return this.withNewRegistryServiceLike(Optional.ofNullable(this.buildRegistryService()).orElse(new RegistryServiceStatusBuilder().build()));
    }

    public RegistryServiceNested<A> editOrNewRegistryServiceLike(RegistryServiceStatus item) {
        return this.withNewRegistryServiceLike(Optional.ofNullable(this.buildRegistryService()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CatalogSourceStatusFluent that = (CatalogSourceStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.configMapReference, that.configMapReference)) {
            return false;
        }
        if (!Objects.equals(this.connectionState, that.connectionState)) {
            return false;
        }
        if (!Objects.equals(this.latestImageRegistryPoll, that.latestImageRegistryPoll)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.reason, that.reason)) {
            return false;
        }
        if (!Objects.equals(this.registryService, that.registryService)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.configMapReference, this.connectionState, this.latestImageRegistryPoll, this.message, this.reason, this.registryService, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.configMapReference != null) {
            sb.append("configMapReference:");
            sb.append(this.configMapReference + ",");
        }
        if (this.connectionState != null) {
            sb.append("connectionState:");
            sb.append(this.connectionState + ",");
        }
        if (this.latestImageRegistryPoll != null) {
            sb.append("latestImageRegistryPoll:");
            sb.append(this.latestImageRegistryPoll + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.reason != null) {
            sb.append("reason:");
            sb.append(this.reason + ",");
        }
        if (this.registryService != null) {
            sb.append("registryService:");
            sb.append(this.registryService + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RegistryServiceNested<N>
    extends RegistryServiceStatusFluent<RegistryServiceNested<N>>
    implements Nested<N> {
        RegistryServiceStatusBuilder builder;

        RegistryServiceNested(RegistryServiceStatus item) {
            this.builder = new RegistryServiceStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CatalogSourceStatusFluent.this.withRegistryService(this.builder.build());
        }

        public N endRegistryService() {
            return this.and();
        }
    }

    public class ConnectionStateNested<N>
    extends GRPCConnectionStateFluent<ConnectionStateNested<N>>
    implements Nested<N> {
        GRPCConnectionStateBuilder builder;

        ConnectionStateNested(GRPCConnectionState item) {
            this.builder = new GRPCConnectionStateBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CatalogSourceStatusFluent.this.withConnectionState(this.builder.build());
        }

        public N endConnectionState() {
            return this.and();
        }
    }

    public class ConfigMapReferenceNested<N>
    extends ConfigMapResourceReferenceFluent<ConfigMapReferenceNested<N>>
    implements Nested<N> {
        ConfigMapResourceReferenceBuilder builder;

        ConfigMapReferenceNested(ConfigMapResourceReference item) {
            this.builder = new ConfigMapResourceReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CatalogSourceStatusFluent.this.withConfigMapReference(this.builder.build());
        }

        public N endConfigMapReference() {
            return this.and();
        }
    }
}

