/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusDetails;
import io.fabric8.kubernetes.api.model.StatusDetailsBuilder;
import io.fabric8.kubernetes.api.model.StatusDetailsFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class StatusFluent<A extends StatusFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private Integer code;
    private StatusDetailsBuilder details;
    private String kind;
    private String message;
    private ListMetaBuilder metadata;
    private String reason;
    private String status;
    private Map<String, Object> additionalProperties;

    public StatusFluent() {
    }

    public StatusFluent(Status instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Status instance) {
        Status status = instance = instance != null ? instance : new Status();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withCode(instance.getCode());
            this.withDetails(instance.getDetails());
            this.withKind(instance.getKind());
            this.withMessage(instance.getMessage());
            this.withMetadata(instance.getMetadata());
            this.withReason(instance.getReason());
            this.withStatus(instance.getStatus());
            this.withApiVersion(instance.getApiVersion());
            this.withCode(instance.getCode());
            this.withDetails(instance.getDetails());
            this.withKind(instance.getKind());
            this.withMessage(instance.getMessage());
            this.withMetadata(instance.getMetadata());
            this.withReason(instance.getReason());
            this.withStatus(instance.getStatus());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public Integer getCode() {
        return this.code;
    }

    public A withCode(Integer code) {
        this.code = code;
        return (A)this;
    }

    public boolean hasCode() {
        return this.code != null;
    }

    public StatusDetails buildDetails() {
        return this.details != null ? this.details.build() : null;
    }

    public A withDetails(StatusDetails details) {
        this._visitables.remove(this.details);
        if (details != null) {
            this.details = new StatusDetailsBuilder(details);
            this._visitables.get("details").add(this.details);
        } else {
            this.details = null;
            this._visitables.get("details").remove(this.details);
        }
        return (A)this;
    }

    public boolean hasDetails() {
        return this.details != null;
    }

    public DetailsNested<A> withNewDetails() {
        return new DetailsNested(null);
    }

    public DetailsNested<A> withNewDetailsLike(StatusDetails item) {
        return new DetailsNested(item);
    }

    public DetailsNested<A> editDetails() {
        return this.withNewDetailsLike(Optional.ofNullable(this.buildDetails()).orElse(null));
    }

    public DetailsNested<A> editOrNewDetails() {
        return this.withNewDetailsLike(Optional.ofNullable(this.buildDetails()).orElse(new StatusDetailsBuilder().build()));
    }

    public DetailsNested<A> editOrNewDetailsLike(StatusDetails item) {
        return this.withNewDetailsLike(Optional.ofNullable(this.buildDetails()).orElse(item));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public ListMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ListMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ListMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ListMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public String getReason() {
        return this.reason;
    }

    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public String getStatus() {
        return this.status;
    }

    public A withStatus(String status) {
        this.status = status;
        return (A)this;
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatusFluent that = (StatusFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.code, that.code)) {
            return false;
        }
        if (!Objects.equals(this.details, that.details)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.reason, that.reason)) {
            return false;
        }
        if (!Objects.equals(this.status, that.status)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.code, this.details, this.kind, this.message, this.metadata, this.reason, this.status, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.code != null) {
            sb.append("code:");
            sb.append(this.code + ",");
        }
        if (this.details != null) {
            sb.append("details:");
            sb.append(this.details + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.reason != null) {
            sb.append("reason:");
            sb.append(this.reason + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends ListMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ListMetaBuilder builder;

        MetadataNested(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)StatusFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class DetailsNested<N>
    extends StatusDetailsFluent<DetailsNested<N>>
    implements Nested<N> {
        StatusDetailsBuilder builder;

        DetailsNested(StatusDetails item) {
            this.builder = new StatusDetailsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)StatusFluent.this.withDetails(this.builder.build());
        }

        public N endDetails() {
            return this.and();
        }
    }
}

