/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.authentication;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.authentication.BoundObjectReference;
import io.fabric8.kubernetes.api.model.authentication.BoundObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.authentication.BoundObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.authentication.TokenRequestSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class TokenRequestSpecFluent<A extends TokenRequestSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> audiences = new ArrayList<String>();
    private BoundObjectReferenceBuilder boundObjectRef;
    private Long expirationSeconds;
    private Map<String, Object> additionalProperties;

    public TokenRequestSpecFluent() {
    }

    public TokenRequestSpecFluent(TokenRequestSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TokenRequestSpec instance) {
        TokenRequestSpec tokenRequestSpec = instance = instance != null ? instance : new TokenRequestSpec();
        if (instance != null) {
            this.withAudiences(instance.getAudiences());
            this.withBoundObjectRef(instance.getBoundObjectRef());
            this.withExpirationSeconds(instance.getExpirationSeconds());
            this.withAudiences(instance.getAudiences());
            this.withBoundObjectRef(instance.getBoundObjectRef());
            this.withExpirationSeconds(instance.getExpirationSeconds());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(index, item);
        return (A)this;
    }

    public A setToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.set(index, item);
        return (A)this;
    }

    public A addToAudiences(String ... items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    public A addAllToAudiences(Collection<String> items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    public A removeFromAudiences(String ... items) {
        if (this.audiences == null) {
            return (A)this;
        }
        for (String item : items) {
            this.audiences.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromAudiences(Collection<String> items) {
        if (this.audiences == null) {
            return (A)this;
        }
        for (String item : items) {
            this.audiences.remove(item);
        }
        return (A)this;
    }

    public List<String> getAudiences() {
        return this.audiences;
    }

    public String getAudience(int index) {
        return this.audiences.get(index);
    }

    public String getFirstAudience() {
        return this.audiences.get(0);
    }

    public String getLastAudience() {
        return this.audiences.get(this.audiences.size() - 1);
    }

    public String getMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAudiences(List<String> audiences) {
        if (audiences != null) {
            this.audiences = new ArrayList<String>();
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        } else {
            this.audiences = null;
        }
        return (A)this;
    }

    public A withAudiences(String ... audiences) {
        if (this.audiences != null) {
            this.audiences.clear();
            this._visitables.remove("audiences");
        }
        if (audiences != null) {
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        }
        return (A)this;
    }

    public boolean hasAudiences() {
        return this.audiences != null && !this.audiences.isEmpty();
    }

    public BoundObjectReference buildBoundObjectRef() {
        return this.boundObjectRef != null ? this.boundObjectRef.build() : null;
    }

    public A withBoundObjectRef(BoundObjectReference boundObjectRef) {
        this._visitables.remove(this.boundObjectRef);
        if (boundObjectRef != null) {
            this.boundObjectRef = new BoundObjectReferenceBuilder(boundObjectRef);
            this._visitables.get("boundObjectRef").add(this.boundObjectRef);
        } else {
            this.boundObjectRef = null;
            this._visitables.get("boundObjectRef").remove(this.boundObjectRef);
        }
        return (A)this;
    }

    public boolean hasBoundObjectRef() {
        return this.boundObjectRef != null;
    }

    public A withNewBoundObjectRef(String apiVersion, String kind, String name, String uid) {
        return this.withBoundObjectRef(new BoundObjectReference(apiVersion, kind, name, uid));
    }

    public BoundObjectRefNested<A> withNewBoundObjectRef() {
        return new BoundObjectRefNested(null);
    }

    public BoundObjectRefNested<A> withNewBoundObjectRefLike(BoundObjectReference item) {
        return new BoundObjectRefNested(item);
    }

    public BoundObjectRefNested<A> editBoundObjectRef() {
        return this.withNewBoundObjectRefLike(Optional.ofNullable(this.buildBoundObjectRef()).orElse(null));
    }

    public BoundObjectRefNested<A> editOrNewBoundObjectRef() {
        return this.withNewBoundObjectRefLike(Optional.ofNullable(this.buildBoundObjectRef()).orElse(new BoundObjectReferenceBuilder().build()));
    }

    public BoundObjectRefNested<A> editOrNewBoundObjectRefLike(BoundObjectReference item) {
        return this.withNewBoundObjectRefLike(Optional.ofNullable(this.buildBoundObjectRef()).orElse(item));
    }

    public Long getExpirationSeconds() {
        return this.expirationSeconds;
    }

    public A withExpirationSeconds(Long expirationSeconds) {
        this.expirationSeconds = expirationSeconds;
        return (A)this;
    }

    public boolean hasExpirationSeconds() {
        return this.expirationSeconds != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TokenRequestSpecFluent that = (TokenRequestSpecFluent)o;
        if (!Objects.equals(this.audiences, that.audiences)) {
            return false;
        }
        if (!Objects.equals(this.boundObjectRef, that.boundObjectRef)) {
            return false;
        }
        if (!Objects.equals(this.expirationSeconds, that.expirationSeconds)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.audiences, this.boundObjectRef, this.expirationSeconds, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.audiences != null && !this.audiences.isEmpty()) {
            sb.append("audiences:");
            sb.append(this.audiences + ",");
        }
        if (this.boundObjectRef != null) {
            sb.append("boundObjectRef:");
            sb.append(this.boundObjectRef + ",");
        }
        if (this.expirationSeconds != null) {
            sb.append("expirationSeconds:");
            sb.append(this.expirationSeconds + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class BoundObjectRefNested<N>
    extends BoundObjectReferenceFluent<BoundObjectRefNested<N>>
    implements Nested<N> {
        BoundObjectReferenceBuilder builder;

        BoundObjectRefNested(BoundObjectReference item) {
            this.builder = new BoundObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)TokenRequestSpecFluent.this.withBoundObjectRef(this.builder.build());
        }

        public N endBoundObjectRef() {
            return this.and();
        }
    }
}

