/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceQuotaStatus;
import io.fabric8.openshift.api.model.ClusterResourceQuotaStatus;
import io.fabric8.openshift.api.model.ResourceQuotaStatusByNamespace;
import io.fabric8.openshift.api.model.ResourceQuotaStatusByNamespaceBuilder;
import io.fabric8.openshift.api.model.ResourceQuotaStatusByNamespaceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterResourceQuotaStatusFluent<A extends ClusterResourceQuotaStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ResourceQuotaStatusByNamespaceBuilder> namespaces = new ArrayList();
    private ResourceQuotaStatus total;
    private Map<String, Object> additionalProperties;

    public ClusterResourceQuotaStatusFluent() {
    }

    public ClusterResourceQuotaStatusFluent(ClusterResourceQuotaStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ClusterResourceQuotaStatus instance) {
        ClusterResourceQuotaStatus clusterResourceQuotaStatus = instance = instance != null ? instance : new ClusterResourceQuotaStatus();
        if (instance != null) {
            this.withNamespaces(instance.getNamespaces());
            this.withTotal(instance.getTotal());
            this.withNamespaces(instance.getNamespaces());
            this.withTotal(instance.getTotal());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToNamespaces(int index, ResourceQuotaStatusByNamespace item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList();
        }
        ResourceQuotaStatusByNamespaceBuilder builder = new ResourceQuotaStatusByNamespaceBuilder(item);
        if (index < 0 || index >= this.namespaces.size()) {
            this._visitables.get("namespaces").add(builder);
            this.namespaces.add(builder);
        } else {
            this._visitables.get("namespaces").add(index, builder);
            this.namespaces.add(index, builder);
        }
        return (A)this;
    }

    public A setToNamespaces(int index, ResourceQuotaStatusByNamespace item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList();
        }
        ResourceQuotaStatusByNamespaceBuilder builder = new ResourceQuotaStatusByNamespaceBuilder(item);
        if (index < 0 || index >= this.namespaces.size()) {
            this._visitables.get("namespaces").add(builder);
            this.namespaces.add(builder);
        } else {
            this._visitables.get("namespaces").set(index, builder);
            this.namespaces.set(index, builder);
        }
        return (A)this;
    }

    public A addToNamespaces(ResourceQuotaStatusByNamespace ... items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList();
        }
        for (ResourceQuotaStatusByNamespace item : items) {
            ResourceQuotaStatusByNamespaceBuilder builder = new ResourceQuotaStatusByNamespaceBuilder(item);
            this._visitables.get("namespaces").add(builder);
            this.namespaces.add(builder);
        }
        return (A)this;
    }

    public A addAllToNamespaces(Collection<ResourceQuotaStatusByNamespace> items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList();
        }
        for (ResourceQuotaStatusByNamespace item : items) {
            ResourceQuotaStatusByNamespaceBuilder builder = new ResourceQuotaStatusByNamespaceBuilder(item);
            this._visitables.get("namespaces").add(builder);
            this.namespaces.add(builder);
        }
        return (A)this;
    }

    public A removeFromNamespaces(ResourceQuotaStatusByNamespace ... items) {
        if (this.namespaces == null) {
            return (A)this;
        }
        for (ResourceQuotaStatusByNamespace item : items) {
            ResourceQuotaStatusByNamespaceBuilder builder = new ResourceQuotaStatusByNamespaceBuilder(item);
            this._visitables.get("namespaces").remove(builder);
            this.namespaces.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromNamespaces(Collection<ResourceQuotaStatusByNamespace> items) {
        if (this.namespaces == null) {
            return (A)this;
        }
        for (ResourceQuotaStatusByNamespace item : items) {
            ResourceQuotaStatusByNamespaceBuilder builder = new ResourceQuotaStatusByNamespaceBuilder(item);
            this._visitables.get("namespaces").remove(builder);
            this.namespaces.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromNamespaces(Predicate<ResourceQuotaStatusByNamespaceBuilder> predicate) {
        if (this.namespaces == null) {
            return (A)this;
        }
        Iterator<ResourceQuotaStatusByNamespaceBuilder> each = this.namespaces.iterator();
        Object visitables = this._visitables.get("namespaces");
        while (each.hasNext()) {
            ResourceQuotaStatusByNamespaceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ResourceQuotaStatusByNamespace> buildNamespaces() {
        return this.namespaces != null ? ClusterResourceQuotaStatusFluent.build(this.namespaces) : null;
    }

    public ResourceQuotaStatusByNamespace buildNamespace(int index) {
        return this.namespaces.get(index).build();
    }

    public ResourceQuotaStatusByNamespace buildFirstNamespace() {
        return this.namespaces.get(0).build();
    }

    public ResourceQuotaStatusByNamespace buildLastNamespace() {
        return this.namespaces.get(this.namespaces.size() - 1).build();
    }

    public ResourceQuotaStatusByNamespace buildMatchingNamespace(Predicate<ResourceQuotaStatusByNamespaceBuilder> predicate) {
        for (ResourceQuotaStatusByNamespaceBuilder item : this.namespaces) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingNamespace(Predicate<ResourceQuotaStatusByNamespaceBuilder> predicate) {
        for (ResourceQuotaStatusByNamespaceBuilder item : this.namespaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNamespaces(List<ResourceQuotaStatusByNamespace> namespaces) {
        if (this.namespaces != null) {
            this._visitables.get("namespaces").clear();
        }
        if (namespaces != null) {
            this.namespaces = new ArrayList();
            for (ResourceQuotaStatusByNamespace item : namespaces) {
                this.addToNamespaces(item);
            }
        } else {
            this.namespaces = null;
        }
        return (A)this;
    }

    public A withNamespaces(ResourceQuotaStatusByNamespace ... namespaces) {
        if (this.namespaces != null) {
            this.namespaces.clear();
            this._visitables.remove("namespaces");
        }
        if (namespaces != null) {
            for (ResourceQuotaStatusByNamespace item : namespaces) {
                this.addToNamespaces(item);
            }
        }
        return (A)this;
    }

    public boolean hasNamespaces() {
        return this.namespaces != null && !this.namespaces.isEmpty();
    }

    public NamespacesNested<A> addNewNamespace() {
        return new NamespacesNested(-1, null);
    }

    public NamespacesNested<A> addNewNamespaceLike(ResourceQuotaStatusByNamespace item) {
        return new NamespacesNested(-1, item);
    }

    public NamespacesNested<A> setNewNamespaceLike(int index, ResourceQuotaStatusByNamespace item) {
        return new NamespacesNested(index, item);
    }

    public NamespacesNested<A> editNamespace(int index) {
        if (this.namespaces.size() <= index) {
            throw new RuntimeException("Can't edit namespaces. Index exceeds size.");
        }
        return this.setNewNamespaceLike(index, this.buildNamespace(index));
    }

    public NamespacesNested<A> editFirstNamespace() {
        if (this.namespaces.size() == 0) {
            throw new RuntimeException("Can't edit first namespaces. The list is empty.");
        }
        return this.setNewNamespaceLike(0, this.buildNamespace(0));
    }

    public NamespacesNested<A> editLastNamespace() {
        int index = this.namespaces.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last namespaces. The list is empty.");
        }
        return this.setNewNamespaceLike(index, this.buildNamespace(index));
    }

    public NamespacesNested<A> editMatchingNamespace(Predicate<ResourceQuotaStatusByNamespaceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.namespaces.size(); ++i) {
            if (!predicate.test(this.namespaces.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching namespaces. No match found.");
        }
        return this.setNewNamespaceLike(index, this.buildNamespace(index));
    }

    public ResourceQuotaStatus getTotal() {
        return this.total;
    }

    public A withTotal(ResourceQuotaStatus total) {
        this.total = total;
        return (A)this;
    }

    public boolean hasTotal() {
        return this.total != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterResourceQuotaStatusFluent that = (ClusterResourceQuotaStatusFluent)o;
        if (!Objects.equals(this.namespaces, that.namespaces)) {
            return false;
        }
        if (!Objects.equals(this.total, that.total)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.namespaces, this.total, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.namespaces != null && !this.namespaces.isEmpty()) {
            sb.append("namespaces:");
            sb.append(this.namespaces + ",");
        }
        if (this.total != null) {
            sb.append("total:");
            sb.append(this.total + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NamespacesNested<N>
    extends ResourceQuotaStatusByNamespaceFluent<NamespacesNested<N>>
    implements Nested<N> {
        ResourceQuotaStatusByNamespaceBuilder builder;
        int index;

        NamespacesNested(int index, ResourceQuotaStatusByNamespace item) {
            this.index = index;
            this.builder = new ResourceQuotaStatusByNamespaceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterResourceQuotaStatusFluent.this.setToNamespaces(this.index, this.builder.build());
        }

        public N endNamespace() {
            return this.and();
        }
    }
}

