/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ClusterRoleBindingFluent<A extends ClusterRoleBindingFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private List<String> groupNames = new ArrayList<String>();
    private String kind;
    private ObjectMetaBuilder metadata;
    private ObjectReferenceBuilder roleRef;
    private ArrayList<ObjectReferenceBuilder> subjects = new ArrayList();
    private List<String> userNames = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public ClusterRoleBindingFluent() {
    }

    public ClusterRoleBindingFluent(ClusterRoleBinding instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ClusterRoleBinding instance) {
        ClusterRoleBinding clusterRoleBinding = instance = instance != null ? instance : new ClusterRoleBinding();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withGroupNames(instance.getGroupNames());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withRoleRef(instance.getRoleRef());
            this.withSubjects(instance.getSubjects());
            this.withUserNames(instance.getUserNames());
            this.withApiVersion(instance.getApiVersion());
            this.withGroupNames(instance.getGroupNames());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withRoleRef(instance.getRoleRef());
            this.withSubjects(instance.getSubjects());
            this.withUserNames(instance.getUserNames());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToGroupNames(int index, String item) {
        if (this.groupNames == null) {
            this.groupNames = new ArrayList<String>();
        }
        this.groupNames.add(index, item);
        return (A)this;
    }

    public A setToGroupNames(int index, String item) {
        if (this.groupNames == null) {
            this.groupNames = new ArrayList<String>();
        }
        this.groupNames.set(index, item);
        return (A)this;
    }

    public A addToGroupNames(String ... items) {
        if (this.groupNames == null) {
            this.groupNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.groupNames.add(item);
        }
        return (A)this;
    }

    public A addAllToGroupNames(Collection<String> items) {
        if (this.groupNames == null) {
            this.groupNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.groupNames.add(item);
        }
        return (A)this;
    }

    public A removeFromGroupNames(String ... items) {
        if (this.groupNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.groupNames.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromGroupNames(Collection<String> items) {
        if (this.groupNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.groupNames.remove(item);
        }
        return (A)this;
    }

    public List<String> getGroupNames() {
        return this.groupNames;
    }

    public String getGroupName(int index) {
        return this.groupNames.get(index);
    }

    public String getFirstGroupName() {
        return this.groupNames.get(0);
    }

    public String getLastGroupName() {
        return this.groupNames.get(this.groupNames.size() - 1);
    }

    public String getMatchingGroupName(Predicate<String> predicate) {
        for (String item : this.groupNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingGroupName(Predicate<String> predicate) {
        for (String item : this.groupNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withGroupNames(List<String> groupNames) {
        if (groupNames != null) {
            this.groupNames = new ArrayList<String>();
            for (String item : groupNames) {
                this.addToGroupNames(item);
            }
        } else {
            this.groupNames = null;
        }
        return (A)this;
    }

    public A withGroupNames(String ... groupNames) {
        if (this.groupNames != null) {
            this.groupNames.clear();
            this._visitables.remove("groupNames");
        }
        if (groupNames != null) {
            for (String item : groupNames) {
                this.addToGroupNames(item);
            }
        }
        return (A)this;
    }

    public boolean hasGroupNames() {
        return this.groupNames != null && !this.groupNames.isEmpty();
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public ObjectReference buildRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    public A withRoleRef(ObjectReference roleRef) {
        this._visitables.remove(this.roleRef);
        if (roleRef != null) {
            this.roleRef = new ObjectReferenceBuilder(roleRef);
            this._visitables.get("roleRef").add(this.roleRef);
        } else {
            this.roleRef = null;
            this._visitables.get("roleRef").remove(this.roleRef);
        }
        return (A)this;
    }

    public boolean hasRoleRef() {
        return this.roleRef != null;
    }

    public RoleRefNested<A> withNewRoleRef() {
        return new RoleRefNested(null);
    }

    public RoleRefNested<A> withNewRoleRefLike(ObjectReference item) {
        return new RoleRefNested(item);
    }

    public RoleRefNested<A> editRoleRef() {
        return this.withNewRoleRefLike(Optional.ofNullable(this.buildRoleRef()).orElse(null));
    }

    public RoleRefNested<A> editOrNewRoleRef() {
        return this.withNewRoleRefLike(Optional.ofNullable(this.buildRoleRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public RoleRefNested<A> editOrNewRoleRefLike(ObjectReference item) {
        return this.withNewRoleRefLike(Optional.ofNullable(this.buildRoleRef()).orElse(item));
    }

    public A addToSubjects(int index, ObjectReference item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.subjects.size()) {
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        } else {
            this._visitables.get("subjects").add(index, builder);
            this.subjects.add(index, builder);
        }
        return (A)this;
    }

    public A setToSubjects(int index, ObjectReference item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this.subjects.size()) {
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        } else {
            this._visitables.get("subjects").set(index, builder);
            this.subjects.set(index, builder);
        }
        return (A)this;
    }

    public A addToSubjects(ObjectReference ... items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    public A addAllToSubjects(Collection<ObjectReference> items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    public A removeFromSubjects(ObjectReference ... items) {
        if (this.subjects == null) {
            return (A)this;
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("subjects").remove(builder);
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSubjects(Collection<ObjectReference> items) {
        if (this.subjects == null) {
            return (A)this;
        }
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.get("subjects").remove(builder);
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSubjects(Predicate<ObjectReferenceBuilder> predicate) {
        if (this.subjects == null) {
            return (A)this;
        }
        Iterator<ObjectReferenceBuilder> each = this.subjects.iterator();
        Object visitables = this._visitables.get("subjects");
        while (each.hasNext()) {
            ObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ObjectReference> buildSubjects() {
        return this.subjects != null ? ClusterRoleBindingFluent.build(this.subjects) : null;
    }

    public ObjectReference buildSubject(int index) {
        return this.subjects.get(index).build();
    }

    public ObjectReference buildFirstSubject() {
        return this.subjects.get(0).build();
    }

    public ObjectReference buildLastSubject() {
        return this.subjects.get(this.subjects.size() - 1).build();
    }

    public ObjectReference buildMatchingSubject(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSubject(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSubjects(List<ObjectReference> subjects) {
        if (this.subjects != null) {
            this._visitables.get("subjects").clear();
        }
        if (subjects != null) {
            this.subjects = new ArrayList();
            for (ObjectReference item : subjects) {
                this.addToSubjects(item);
            }
        } else {
            this.subjects = null;
        }
        return (A)this;
    }

    public A withSubjects(ObjectReference ... subjects) {
        if (this.subjects != null) {
            this.subjects.clear();
            this._visitables.remove("subjects");
        }
        if (subjects != null) {
            for (ObjectReference item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    public boolean hasSubjects() {
        return this.subjects != null && !this.subjects.isEmpty();
    }

    public SubjectsNested<A> addNewSubject() {
        return new SubjectsNested(-1, null);
    }

    public SubjectsNested<A> addNewSubjectLike(ObjectReference item) {
        return new SubjectsNested(-1, item);
    }

    public SubjectsNested<A> setNewSubjectLike(int index, ObjectReference item) {
        return new SubjectsNested(index, item);
    }

    public SubjectsNested<A> editSubject(int index) {
        if (this.subjects.size() <= index) {
            throw new RuntimeException("Can't edit subjects. Index exceeds size.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public SubjectsNested<A> editFirstSubject() {
        if (this.subjects.size() == 0) {
            throw new RuntimeException("Can't edit first subjects. The list is empty.");
        }
        return this.setNewSubjectLike(0, this.buildSubject(0));
    }

    public SubjectsNested<A> editLastSubject() {
        int index = this.subjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subjects. The list is empty.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public SubjectsNested<A> editMatchingSubject(Predicate<ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subjects.size(); ++i) {
            if (!predicate.test(this.subjects.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subjects. No match found.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public A addToUserNames(int index, String item) {
        if (this.userNames == null) {
            this.userNames = new ArrayList<String>();
        }
        this.userNames.add(index, item);
        return (A)this;
    }

    public A setToUserNames(int index, String item) {
        if (this.userNames == null) {
            this.userNames = new ArrayList<String>();
        }
        this.userNames.set(index, item);
        return (A)this;
    }

    public A addToUserNames(String ... items) {
        if (this.userNames == null) {
            this.userNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.userNames.add(item);
        }
        return (A)this;
    }

    public A addAllToUserNames(Collection<String> items) {
        if (this.userNames == null) {
            this.userNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.userNames.add(item);
        }
        return (A)this;
    }

    public A removeFromUserNames(String ... items) {
        if (this.userNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.userNames.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromUserNames(Collection<String> items) {
        if (this.userNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.userNames.remove(item);
        }
        return (A)this;
    }

    public List<String> getUserNames() {
        return this.userNames;
    }

    public String getUserName(int index) {
        return this.userNames.get(index);
    }

    public String getFirstUserName() {
        return this.userNames.get(0);
    }

    public String getLastUserName() {
        return this.userNames.get(this.userNames.size() - 1);
    }

    public String getMatchingUserName(Predicate<String> predicate) {
        for (String item : this.userNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingUserName(Predicate<String> predicate) {
        for (String item : this.userNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUserNames(List<String> userNames) {
        if (userNames != null) {
            this.userNames = new ArrayList<String>();
            for (String item : userNames) {
                this.addToUserNames(item);
            }
        } else {
            this.userNames = null;
        }
        return (A)this;
    }

    public A withUserNames(String ... userNames) {
        if (this.userNames != null) {
            this.userNames.clear();
            this._visitables.remove("userNames");
        }
        if (userNames != null) {
            for (String item : userNames) {
                this.addToUserNames(item);
            }
        }
        return (A)this;
    }

    public boolean hasUserNames() {
        return this.userNames != null && !this.userNames.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterRoleBindingFluent that = (ClusterRoleBindingFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.groupNames, that.groupNames)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.roleRef, that.roleRef)) {
            return false;
        }
        if (!Objects.equals(this.subjects, that.subjects)) {
            return false;
        }
        if (!Objects.equals(this.userNames, that.userNames)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.groupNames, this.kind, this.metadata, this.roleRef, this.subjects, this.userNames, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.groupNames != null && !this.groupNames.isEmpty()) {
            sb.append("groupNames:");
            sb.append(this.groupNames + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.roleRef != null) {
            sb.append("roleRef:");
            sb.append(this.roleRef + ",");
        }
        if (this.subjects != null && !this.subjects.isEmpty()) {
            sb.append("subjects:");
            sb.append(this.subjects + ",");
        }
        if (this.userNames != null && !this.userNames.isEmpty()) {
            sb.append("userNames:");
            sb.append(this.userNames + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SubjectsNested<N>
    extends ObjectReferenceFluent<SubjectsNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;
        int index;

        SubjectsNested(int index, ObjectReference item) {
            this.index = index;
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterRoleBindingFluent.this.setToSubjects(this.index, this.builder.build());
        }

        public N endSubject() {
            return this.and();
        }
    }

    public class RoleRefNested<N>
    extends ObjectReferenceFluent<RoleRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        RoleRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterRoleBindingFluent.this.withRoleRef(this.builder.build());
        }

        public N endRoleRef() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ClusterRoleBindingFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

