/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.Identity;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IdentityFluent<A extends IdentityFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private Map<String, String> extra;
    private String kind;
    private ObjectMetaBuilder metadata;
    private String providerName;
    private String providerUserName;
    private ObjectReferenceBuilder user;
    private Map<String, Object> additionalProperties;

    public IdentityFluent() {
    }

    public IdentityFluent(Identity instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Identity instance) {
        Identity identity = instance = instance != null ? instance : new Identity();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withExtra(instance.getExtra());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withProviderName(instance.getProviderName());
            this.withProviderUserName(instance.getProviderUserName());
            this.withUser(instance.getUser());
            this.withApiVersion(instance.getApiVersion());
            this.withExtra(instance.getExtra());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withProviderName(instance.getProviderName());
            this.withProviderUserName(instance.getProviderUserName());
            this.withUser(instance.getUser());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToExtra(String key, String value) {
        if (this.extra == null && key != null && value != null) {
            this.extra = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.extra.put(key, value);
        }
        return (A)this;
    }

    public A addToExtra(Map<String, String> map) {
        if (this.extra == null && map != null) {
            this.extra = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.extra.putAll(map);
        }
        return (A)this;
    }

    public A removeFromExtra(String key) {
        if (this.extra == null) {
            return (A)this;
        }
        if (key != null && this.extra != null) {
            this.extra.remove(key);
        }
        return (A)this;
    }

    public A removeFromExtra(Map<String, String> map) {
        if (this.extra == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.extra == null) continue;
                this.extra.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getExtra() {
        return this.extra;
    }

    public <K, V> A withExtra(Map<String, String> extra) {
        this.extra = extra == null ? null : new LinkedHashMap<String, String>(extra);
        return (A)this;
    }

    public boolean hasExtra() {
        return this.extra != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public String getProviderName() {
        return this.providerName;
    }

    public A withProviderName(String providerName) {
        this.providerName = providerName;
        return (A)this;
    }

    public boolean hasProviderName() {
        return this.providerName != null;
    }

    public String getProviderUserName() {
        return this.providerUserName;
    }

    public A withProviderUserName(String providerUserName) {
        this.providerUserName = providerUserName;
        return (A)this;
    }

    public boolean hasProviderUserName() {
        return this.providerUserName != null;
    }

    public ObjectReference buildUser() {
        return this.user != null ? this.user.build() : null;
    }

    public A withUser(ObjectReference user) {
        this._visitables.remove(this.user);
        if (user != null) {
            this.user = new ObjectReferenceBuilder(user);
            this._visitables.get("user").add(this.user);
        } else {
            this.user = null;
            this._visitables.get("user").remove(this.user);
        }
        return (A)this;
    }

    public boolean hasUser() {
        return this.user != null;
    }

    public UserNested<A> withNewUser() {
        return new UserNested(null);
    }

    public UserNested<A> withNewUserLike(ObjectReference item) {
        return new UserNested(item);
    }

    public UserNested<A> editUser() {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(null));
    }

    public UserNested<A> editOrNewUser() {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(new ObjectReferenceBuilder().build()));
    }

    public UserNested<A> editOrNewUserLike(ObjectReference item) {
        return this.withNewUserLike(Optional.ofNullable(this.buildUser()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IdentityFluent that = (IdentityFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.extra, that.extra)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.providerName, that.providerName)) {
            return false;
        }
        if (!Objects.equals(this.providerUserName, that.providerUserName)) {
            return false;
        }
        if (!Objects.equals(this.user, that.user)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.extra, this.kind, this.metadata, this.providerName, this.providerUserName, this.user, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.extra != null && !this.extra.isEmpty()) {
            sb.append("extra:");
            sb.append(this.extra + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.providerName != null) {
            sb.append("providerName:");
            sb.append(this.providerName + ",");
        }
        if (this.providerUserName != null) {
            sb.append("providerUserName:");
            sb.append(this.providerUserName + ",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append(this.user + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UserNested<N>
    extends ObjectReferenceFluent<UserNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        UserNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IdentityFluent.this.withUser(this.builder.build());
        }

        public N endUser() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IdentityFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

