/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.openshift.api.model.RoutePort;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RoutePortFluent<A extends RoutePortFluent<A>>
extends BaseFluent<A> {
    private IntOrStringBuilder targetPort;
    private Map<String, Object> additionalProperties;

    public RoutePortFluent() {
    }

    public RoutePortFluent(RoutePort instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RoutePort instance) {
        RoutePort routePort = instance = instance != null ? instance : new RoutePort();
        if (instance != null) {
            this.withTargetPort(instance.getTargetPort());
            this.withTargetPort(instance.getTargetPort());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public IntOrString buildTargetPort() {
        return this.targetPort != null ? this.targetPort.build() : null;
    }

    public A withTargetPort(IntOrString targetPort) {
        this._visitables.remove(this.targetPort);
        if (targetPort != null) {
            this.targetPort = new IntOrStringBuilder(targetPort);
            this._visitables.get("targetPort").add(this.targetPort);
        } else {
            this.targetPort = null;
            this._visitables.get("targetPort").remove(this.targetPort);
        }
        return (A)this;
    }

    public boolean hasTargetPort() {
        return this.targetPort != null;
    }

    public A withNewTargetPort(Object value) {
        return this.withTargetPort(new IntOrString(value));
    }

    public TargetPortNested<A> withNewTargetPort() {
        return new TargetPortNested(null);
    }

    public TargetPortNested<A> withNewTargetPortLike(IntOrString item) {
        return new TargetPortNested(item);
    }

    public TargetPortNested<A> editTargetPort() {
        return this.withNewTargetPortLike(Optional.ofNullable(this.buildTargetPort()).orElse(null));
    }

    public TargetPortNested<A> editOrNewTargetPort() {
        return this.withNewTargetPortLike(Optional.ofNullable(this.buildTargetPort()).orElse(new IntOrStringBuilder().build()));
    }

    public TargetPortNested<A> editOrNewTargetPortLike(IntOrString item) {
        return this.withNewTargetPortLike(Optional.ofNullable(this.buildTargetPort()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RoutePortFluent that = (RoutePortFluent)o;
        if (!Objects.equals(this.targetPort, that.targetPort)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.targetPort, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.targetPort != null) {
            sb.append("targetPort:");
            sb.append(this.targetPort + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TargetPortNested<N>
    extends IntOrStringFluent<TargetPortNested<N>>
    implements Nested<N> {
        IntOrStringBuilder builder;

        TargetPortNested(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RoutePortFluent.this.withTargetPort(this.builder.build());
        }

        public N endTargetPort() {
            return this.and();
        }
    }
}

