/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.vsphere.v1.FailureDomain;
import io.fabric8.openshift.api.model.installer.vsphere.v1.Topology;
import io.fabric8.openshift.api.model.installer.vsphere.v1.TopologyBuilder;
import io.fabric8.openshift.api.model.installer.vsphere.v1.TopologyFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class FailureDomainFluent<A extends FailureDomainFluent<A>>
extends BaseFluent<A> {
    private String name;
    private String region;
    private String server;
    private TopologyBuilder topology;
    private String zone;
    private Map<String, Object> additionalProperties;

    public FailureDomainFluent() {
    }

    public FailureDomainFluent(FailureDomain instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(FailureDomain instance) {
        FailureDomain failureDomain = instance = instance != null ? instance : new FailureDomain();
        if (instance != null) {
            this.withName(instance.getName());
            this.withRegion(instance.getRegion());
            this.withServer(instance.getServer());
            this.withTopology(instance.getTopology());
            this.withZone(instance.getZone());
            this.withName(instance.getName());
            this.withRegion(instance.getRegion());
            this.withServer(instance.getServer());
            this.withTopology(instance.getTopology());
            this.withZone(instance.getZone());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getRegion() {
        return this.region;
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public String getServer() {
        return this.server;
    }

    public A withServer(String server) {
        this.server = server;
        return (A)this;
    }

    public boolean hasServer() {
        return this.server != null;
    }

    public Topology buildTopology() {
        return this.topology != null ? this.topology.build() : null;
    }

    public A withTopology(Topology topology) {
        this._visitables.remove(this.topology);
        if (topology != null) {
            this.topology = new TopologyBuilder(topology);
            this._visitables.get("topology").add(this.topology);
        } else {
            this.topology = null;
            this._visitables.get("topology").remove(this.topology);
        }
        return (A)this;
    }

    public boolean hasTopology() {
        return this.topology != null;
    }

    public TopologyNested<A> withNewTopology() {
        return new TopologyNested(null);
    }

    public TopologyNested<A> withNewTopologyLike(Topology item) {
        return new TopologyNested(item);
    }

    public TopologyNested<A> editTopology() {
        return this.withNewTopologyLike(Optional.ofNullable(this.buildTopology()).orElse(null));
    }

    public TopologyNested<A> editOrNewTopology() {
        return this.withNewTopologyLike(Optional.ofNullable(this.buildTopology()).orElse(new TopologyBuilder().build()));
    }

    public TopologyNested<A> editOrNewTopologyLike(Topology item) {
        return this.withNewTopologyLike(Optional.ofNullable(this.buildTopology()).orElse(item));
    }

    public String getZone() {
        return this.zone;
    }

    public A withZone(String zone) {
        this.zone = zone;
        return (A)this;
    }

    public boolean hasZone() {
        return this.zone != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FailureDomainFluent that = (FailureDomainFluent)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.server, that.server)) {
            return false;
        }
        if (!Objects.equals(this.topology, that.topology)) {
            return false;
        }
        if (!Objects.equals(this.zone, that.zone)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.region, this.server, this.topology, this.zone, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.server != null) {
            sb.append("server:");
            sb.append(this.server + ",");
        }
        if (this.topology != null) {
            sb.append("topology:");
            sb.append(this.topology + ",");
        }
        if (this.zone != null) {
            sb.append("zone:");
            sb.append(this.zone + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TopologyNested<N>
    extends TopologyFluent<TopologyNested<N>>
    implements Nested<N> {
        TopologyBuilder builder;

        TopologyNested(Topology item) {
            this.builder = new TopologyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)FailureDomainFluent.this.withTopology(this.builder.build());
        }

        public N endTopology() {
            return this.and();
        }
    }
}

