/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.ResourceAccessReview;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ResourceAccessReviewFluent<A extends ResourceAccessReviewFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private Object content;
    private Boolean isNonResourceURL;
    private String kind;
    private ObjectMetaBuilder metadata;
    private String namespace;
    private String path;
    private String resource;
    private String resourceAPIGroup;
    private String resourceAPIVersion;
    private String resourceName;
    private String verb;
    private Map<String, Object> additionalProperties;

    public ResourceAccessReviewFluent() {
    }

    public ResourceAccessReviewFluent(ResourceAccessReview instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ResourceAccessReview instance) {
        ResourceAccessReview resourceAccessReview = instance = instance != null ? instance : new ResourceAccessReview();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withContent(instance.getContent());
            this.withIsNonResourceURL(instance.getIsNonResourceURL());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withNamespace(instance.getNamespace());
            this.withPath(instance.getPath());
            this.withResource(instance.getResource());
            this.withResourceAPIGroup(instance.getResourceAPIGroup());
            this.withResourceAPIVersion(instance.getResourceAPIVersion());
            this.withResourceName(instance.getResourceName());
            this.withVerb(instance.getVerb());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public Object getContent() {
        return this.content;
    }

    public A withContent(Object content) {
        this.content = content;
        return (A)this;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public Boolean getIsNonResourceURL() {
        return this.isNonResourceURL;
    }

    public A withIsNonResourceURL(Boolean isNonResourceURL) {
        this.isNonResourceURL = isNonResourceURL;
        return (A)this;
    }

    public boolean hasIsNonResourceURL() {
        return this.isNonResourceURL != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public String getResource() {
        return this.resource;
    }

    public A withResource(String resource) {
        this.resource = resource;
        return (A)this;
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    public String getResourceAPIGroup() {
        return this.resourceAPIGroup;
    }

    public A withResourceAPIGroup(String resourceAPIGroup) {
        this.resourceAPIGroup = resourceAPIGroup;
        return (A)this;
    }

    public boolean hasResourceAPIGroup() {
        return this.resourceAPIGroup != null;
    }

    public String getResourceAPIVersion() {
        return this.resourceAPIVersion;
    }

    public A withResourceAPIVersion(String resourceAPIVersion) {
        this.resourceAPIVersion = resourceAPIVersion;
        return (A)this;
    }

    public boolean hasResourceAPIVersion() {
        return this.resourceAPIVersion != null;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public A withResourceName(String resourceName) {
        this.resourceName = resourceName;
        return (A)this;
    }

    public boolean hasResourceName() {
        return this.resourceName != null;
    }

    public String getVerb() {
        return this.verb;
    }

    public A withVerb(String verb) {
        this.verb = verb;
        return (A)this;
    }

    public boolean hasVerb() {
        return this.verb != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceAccessReviewFluent that = (ResourceAccessReviewFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.content, that.content)) {
            return false;
        }
        if (!Objects.equals(this.isNonResourceURL, that.isNonResourceURL)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.resource, that.resource)) {
            return false;
        }
        if (!Objects.equals(this.resourceAPIGroup, that.resourceAPIGroup)) {
            return false;
        }
        if (!Objects.equals(this.resourceAPIVersion, that.resourceAPIVersion)) {
            return false;
        }
        if (!Objects.equals(this.resourceName, that.resourceName)) {
            return false;
        }
        if (!Objects.equals(this.verb, that.verb)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.content, this.isNonResourceURL, this.kind, this.metadata, this.namespace, this.path, this.resource, this.resourceAPIGroup, this.resourceAPIVersion, this.resourceName, this.verb, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.content != null) {
            sb.append("content:");
            sb.append(this.content + ",");
        }
        if (this.isNonResourceURL != null) {
            sb.append("isNonResourceURL:");
            sb.append(this.isNonResourceURL + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.resource != null) {
            sb.append("resource:");
            sb.append(this.resource + ",");
        }
        if (this.resourceAPIGroup != null) {
            sb.append("resourceAPIGroup:");
            sb.append(this.resourceAPIGroup + ",");
        }
        if (this.resourceAPIVersion != null) {
            sb.append("resourceAPIVersion:");
            sb.append(this.resourceAPIVersion + ",");
        }
        if (this.resourceName != null) {
            sb.append("resourceName:");
            sb.append(this.resourceName + ",");
        }
        if (this.verb != null) {
            sb.append("verb:");
            sb.append(this.verb + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withIsNonResourceURL() {
        return this.withIsNonResourceURL(true);
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceAccessReviewFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

