/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.RouteHTTPHeaders;
import io.fabric8.openshift.api.model.RouteHTTPHeadersBuilder;
import io.fabric8.openshift.api.model.RouteHTTPHeadersFluent;
import io.fabric8.openshift.api.model.RoutePort;
import io.fabric8.openshift.api.model.RoutePortBuilder;
import io.fabric8.openshift.api.model.RoutePortFluent;
import io.fabric8.openshift.api.model.RouteSpec;
import io.fabric8.openshift.api.model.RouteTargetReference;
import io.fabric8.openshift.api.model.RouteTargetReferenceBuilder;
import io.fabric8.openshift.api.model.RouteTargetReferenceFluent;
import io.fabric8.openshift.api.model.TLSConfig;
import io.fabric8.openshift.api.model.TLSConfigBuilder;
import io.fabric8.openshift.api.model.TLSConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class RouteSpecFluent<A extends RouteSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<RouteTargetReferenceBuilder> alternateBackends = new ArrayList();
    private String host;
    private RouteHTTPHeadersBuilder httpHeaders;
    private String path;
    private RoutePortBuilder port;
    private String subdomain;
    private TLSConfigBuilder tls;
    private RouteTargetReferenceBuilder to;
    private String wildcardPolicy;
    private Map<String, Object> additionalProperties;

    public RouteSpecFluent() {
    }

    public RouteSpecFluent(RouteSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RouteSpec instance) {
        RouteSpec routeSpec = instance = instance != null ? instance : new RouteSpec();
        if (instance != null) {
            this.withAlternateBackends(instance.getAlternateBackends());
            this.withHost(instance.getHost());
            this.withHttpHeaders(instance.getHttpHeaders());
            this.withPath(instance.getPath());
            this.withPort(instance.getPort());
            this.withSubdomain(instance.getSubdomain());
            this.withTls(instance.getTls());
            this.withTo(instance.getTo());
            this.withWildcardPolicy(instance.getWildcardPolicy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAlternateBackends(int index, RouteTargetReference item) {
        if (this.alternateBackends == null) {
            this.alternateBackends = new ArrayList();
        }
        RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
        if (index < 0 || index >= this.alternateBackends.size()) {
            this._visitables.get("alternateBackends").add(builder);
            this.alternateBackends.add(builder);
        } else {
            this._visitables.get("alternateBackends").add(index, builder);
            this.alternateBackends.add(index, builder);
        }
        return (A)this;
    }

    public A setToAlternateBackends(int index, RouteTargetReference item) {
        if (this.alternateBackends == null) {
            this.alternateBackends = new ArrayList();
        }
        RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
        if (index < 0 || index >= this.alternateBackends.size()) {
            this._visitables.get("alternateBackends").add(builder);
            this.alternateBackends.add(builder);
        } else {
            this._visitables.get("alternateBackends").set(index, builder);
            this.alternateBackends.set(index, builder);
        }
        return (A)this;
    }

    public A addToAlternateBackends(RouteTargetReference ... items) {
        if (this.alternateBackends == null) {
            this.alternateBackends = new ArrayList();
        }
        for (RouteTargetReference item : items) {
            RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
            this._visitables.get("alternateBackends").add(builder);
            this.alternateBackends.add(builder);
        }
        return (A)this;
    }

    public A addAllToAlternateBackends(Collection<RouteTargetReference> items) {
        if (this.alternateBackends == null) {
            this.alternateBackends = new ArrayList();
        }
        for (RouteTargetReference item : items) {
            RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
            this._visitables.get("alternateBackends").add(builder);
            this.alternateBackends.add(builder);
        }
        return (A)this;
    }

    public A removeFromAlternateBackends(RouteTargetReference ... items) {
        if (this.alternateBackends == null) {
            return (A)this;
        }
        for (RouteTargetReference item : items) {
            RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
            this._visitables.get("alternateBackends").remove(builder);
            this.alternateBackends.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromAlternateBackends(Collection<RouteTargetReference> items) {
        if (this.alternateBackends == null) {
            return (A)this;
        }
        for (RouteTargetReference item : items) {
            RouteTargetReferenceBuilder builder = new RouteTargetReferenceBuilder(item);
            this._visitables.get("alternateBackends").remove(builder);
            this.alternateBackends.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromAlternateBackends(Predicate<RouteTargetReferenceBuilder> predicate) {
        if (this.alternateBackends == null) {
            return (A)this;
        }
        Iterator<RouteTargetReferenceBuilder> each = this.alternateBackends.iterator();
        Object visitables = this._visitables.get("alternateBackends");
        while (each.hasNext()) {
            RouteTargetReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<RouteTargetReference> buildAlternateBackends() {
        return this.alternateBackends != null ? RouteSpecFluent.build(this.alternateBackends) : null;
    }

    public RouteTargetReference buildAlternateBackend(int index) {
        return this.alternateBackends.get(index).build();
    }

    public RouteTargetReference buildFirstAlternateBackend() {
        return this.alternateBackends.get(0).build();
    }

    public RouteTargetReference buildLastAlternateBackend() {
        return this.alternateBackends.get(this.alternateBackends.size() - 1).build();
    }

    public RouteTargetReference buildMatchingAlternateBackend(Predicate<RouteTargetReferenceBuilder> predicate) {
        for (RouteTargetReferenceBuilder item : this.alternateBackends) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAlternateBackend(Predicate<RouteTargetReferenceBuilder> predicate) {
        for (RouteTargetReferenceBuilder item : this.alternateBackends) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAlternateBackends(List<RouteTargetReference> alternateBackends) {
        if (this.alternateBackends != null) {
            this._visitables.get("alternateBackends").clear();
        }
        if (alternateBackends != null) {
            this.alternateBackends = new ArrayList();
            for (RouteTargetReference item : alternateBackends) {
                this.addToAlternateBackends(item);
            }
        } else {
            this.alternateBackends = null;
        }
        return (A)this;
    }

    public A withAlternateBackends(RouteTargetReference ... alternateBackends) {
        if (this.alternateBackends != null) {
            this.alternateBackends.clear();
            this._visitables.remove("alternateBackends");
        }
        if (alternateBackends != null) {
            for (RouteTargetReference item : alternateBackends) {
                this.addToAlternateBackends(item);
            }
        }
        return (A)this;
    }

    public boolean hasAlternateBackends() {
        return this.alternateBackends != null && !this.alternateBackends.isEmpty();
    }

    public A addNewAlternateBackend(String kind, String name, Integer weight) {
        return this.addToAlternateBackends(new RouteTargetReference(kind, name, weight));
    }

    public AlternateBackendsNested<A> addNewAlternateBackend() {
        return new AlternateBackendsNested(-1, null);
    }

    public AlternateBackendsNested<A> addNewAlternateBackendLike(RouteTargetReference item) {
        return new AlternateBackendsNested(-1, item);
    }

    public AlternateBackendsNested<A> setNewAlternateBackendLike(int index, RouteTargetReference item) {
        return new AlternateBackendsNested(index, item);
    }

    public AlternateBackendsNested<A> editAlternateBackend(int index) {
        if (this.alternateBackends.size() <= index) {
            throw new RuntimeException("Can't edit alternateBackends. Index exceeds size.");
        }
        return this.setNewAlternateBackendLike(index, this.buildAlternateBackend(index));
    }

    public AlternateBackendsNested<A> editFirstAlternateBackend() {
        if (this.alternateBackends.size() == 0) {
            throw new RuntimeException("Can't edit first alternateBackends. The list is empty.");
        }
        return this.setNewAlternateBackendLike(0, this.buildAlternateBackend(0));
    }

    public AlternateBackendsNested<A> editLastAlternateBackend() {
        int index = this.alternateBackends.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last alternateBackends. The list is empty.");
        }
        return this.setNewAlternateBackendLike(index, this.buildAlternateBackend(index));
    }

    public AlternateBackendsNested<A> editMatchingAlternateBackend(Predicate<RouteTargetReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.alternateBackends.size(); ++i) {
            if (!predicate.test(this.alternateBackends.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching alternateBackends. No match found.");
        }
        return this.setNewAlternateBackendLike(index, this.buildAlternateBackend(index));
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public RouteHTTPHeaders buildHttpHeaders() {
        return this.httpHeaders != null ? this.httpHeaders.build() : null;
    }

    public A withHttpHeaders(RouteHTTPHeaders httpHeaders) {
        this._visitables.remove("httpHeaders");
        if (httpHeaders != null) {
            this.httpHeaders = new RouteHTTPHeadersBuilder(httpHeaders);
            this._visitables.get("httpHeaders").add(this.httpHeaders);
        } else {
            this.httpHeaders = null;
            this._visitables.get("httpHeaders").remove(this.httpHeaders);
        }
        return (A)this;
    }

    public boolean hasHttpHeaders() {
        return this.httpHeaders != null;
    }

    public HttpHeadersNested<A> withNewHttpHeaders() {
        return new HttpHeadersNested(null);
    }

    public HttpHeadersNested<A> withNewHttpHeadersLike(RouteHTTPHeaders item) {
        return new HttpHeadersNested(item);
    }

    public HttpHeadersNested<A> editHttpHeaders() {
        return this.withNewHttpHeadersLike(Optional.ofNullable(this.buildHttpHeaders()).orElse(null));
    }

    public HttpHeadersNested<A> editOrNewHttpHeaders() {
        return this.withNewHttpHeadersLike(Optional.ofNullable(this.buildHttpHeaders()).orElse(new RouteHTTPHeadersBuilder().build()));
    }

    public HttpHeadersNested<A> editOrNewHttpHeadersLike(RouteHTTPHeaders item) {
        return this.withNewHttpHeadersLike(Optional.ofNullable(this.buildHttpHeaders()).orElse(item));
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public RoutePort buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    public A withPort(RoutePort port) {
        this._visitables.remove("port");
        if (port != null) {
            this.port = new RoutePortBuilder(port);
            this._visitables.get("port").add(this.port);
        } else {
            this.port = null;
            this._visitables.get("port").remove(this.port);
        }
        return (A)this;
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public PortNested<A> withNewPort() {
        return new PortNested(null);
    }

    public PortNested<A> withNewPortLike(RoutePort item) {
        return new PortNested(item);
    }

    public PortNested<A> editPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(null));
    }

    public PortNested<A> editOrNewPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(new RoutePortBuilder().build()));
    }

    public PortNested<A> editOrNewPortLike(RoutePort item) {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(item));
    }

    public String getSubdomain() {
        return this.subdomain;
    }

    public A withSubdomain(String subdomain) {
        this.subdomain = subdomain;
        return (A)this;
    }

    public boolean hasSubdomain() {
        return this.subdomain != null;
    }

    public TLSConfig buildTls() {
        return this.tls != null ? this.tls.build() : null;
    }

    public A withTls(TLSConfig tls) {
        this._visitables.remove("tls");
        if (tls != null) {
            this.tls = new TLSConfigBuilder(tls);
            this._visitables.get("tls").add(this.tls);
        } else {
            this.tls = null;
            this._visitables.get("tls").remove(this.tls);
        }
        return (A)this;
    }

    public boolean hasTls() {
        return this.tls != null;
    }

    public TlsNested<A> withNewTls() {
        return new TlsNested(null);
    }

    public TlsNested<A> withNewTlsLike(TLSConfig item) {
        return new TlsNested(item);
    }

    public TlsNested<A> editTls() {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(null));
    }

    public TlsNested<A> editOrNewTls() {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(new TLSConfigBuilder().build()));
    }

    public TlsNested<A> editOrNewTlsLike(TLSConfig item) {
        return this.withNewTlsLike(Optional.ofNullable(this.buildTls()).orElse(item));
    }

    public RouteTargetReference buildTo() {
        return this.to != null ? this.to.build() : null;
    }

    public A withTo(RouteTargetReference to) {
        this._visitables.remove("to");
        if (to != null) {
            this.to = new RouteTargetReferenceBuilder(to);
            this._visitables.get("to").add(this.to);
        } else {
            this.to = null;
            this._visitables.get("to").remove(this.to);
        }
        return (A)this;
    }

    public boolean hasTo() {
        return this.to != null;
    }

    public A withNewTo(String kind, String name, Integer weight) {
        return this.withTo(new RouteTargetReference(kind, name, weight));
    }

    public ToNested<A> withNewTo() {
        return new ToNested(null);
    }

    public ToNested<A> withNewToLike(RouteTargetReference item) {
        return new ToNested(item);
    }

    public ToNested<A> editTo() {
        return this.withNewToLike(Optional.ofNullable(this.buildTo()).orElse(null));
    }

    public ToNested<A> editOrNewTo() {
        return this.withNewToLike(Optional.ofNullable(this.buildTo()).orElse(new RouteTargetReferenceBuilder().build()));
    }

    public ToNested<A> editOrNewToLike(RouteTargetReference item) {
        return this.withNewToLike(Optional.ofNullable(this.buildTo()).orElse(item));
    }

    public String getWildcardPolicy() {
        return this.wildcardPolicy;
    }

    public A withWildcardPolicy(String wildcardPolicy) {
        this.wildcardPolicy = wildcardPolicy;
        return (A)this;
    }

    public boolean hasWildcardPolicy() {
        return this.wildcardPolicy != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteSpecFluent that = (RouteSpecFluent)o;
        if (!Objects.equals(this.alternateBackends, that.alternateBackends)) {
            return false;
        }
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.httpHeaders, that.httpHeaders)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.subdomain, that.subdomain)) {
            return false;
        }
        if (!Objects.equals(this.tls, that.tls)) {
            return false;
        }
        if (!Objects.equals(this.to, that.to)) {
            return false;
        }
        if (!Objects.equals(this.wildcardPolicy, that.wildcardPolicy)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.alternateBackends, this.host, this.httpHeaders, this.path, this.port, this.subdomain, this.tls, this.to, this.wildcardPolicy, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.alternateBackends != null && !this.alternateBackends.isEmpty()) {
            sb.append("alternateBackends:");
            sb.append(this.alternateBackends + ",");
        }
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.httpHeaders != null) {
            sb.append("httpHeaders:");
            sb.append(this.httpHeaders + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.subdomain != null) {
            sb.append("subdomain:");
            sb.append(this.subdomain + ",");
        }
        if (this.tls != null) {
            sb.append("tls:");
            sb.append(this.tls + ",");
        }
        if (this.to != null) {
            sb.append("to:");
            sb.append(this.to + ",");
        }
        if (this.wildcardPolicy != null) {
            sb.append("wildcardPolicy:");
            sb.append(this.wildcardPolicy + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ToNested<N>
    extends RouteTargetReferenceFluent<ToNested<N>>
    implements Nested<N> {
        RouteTargetReferenceBuilder builder;

        ToNested(RouteTargetReference item) {
            this.builder = new RouteTargetReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RouteSpecFluent.this.withTo(this.builder.build());
        }

        public N endTo() {
            return this.and();
        }
    }

    public class TlsNested<N>
    extends TLSConfigFluent<TlsNested<N>>
    implements Nested<N> {
        TLSConfigBuilder builder;

        TlsNested(TLSConfig item) {
            this.builder = new TLSConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RouteSpecFluent.this.withTls(this.builder.build());
        }

        public N endTls() {
            return this.and();
        }
    }

    public class PortNested<N>
    extends RoutePortFluent<PortNested<N>>
    implements Nested<N> {
        RoutePortBuilder builder;

        PortNested(RoutePort item) {
            this.builder = new RoutePortBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RouteSpecFluent.this.withPort(this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }

    public class HttpHeadersNested<N>
    extends RouteHTTPHeadersFluent<HttpHeadersNested<N>>
    implements Nested<N> {
        RouteHTTPHeadersBuilder builder;

        HttpHeadersNested(RouteHTTPHeaders item) {
            this.builder = new RouteHTTPHeadersBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RouteSpecFluent.this.withHttpHeaders(this.builder.build());
        }

        public N endHttpHeaders() {
            return this.and();
        }
    }

    public class AlternateBackendsNested<N>
    extends RouteTargetReferenceFluent<AlternateBackendsNested<N>>
    implements Nested<N> {
        RouteTargetReferenceBuilder builder;
        int index;

        AlternateBackendsNested(int index, RouteTargetReference item) {
            this.index = index;
            this.builder = new RouteTargetReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RouteSpecFluent.this.setToAlternateBackends(this.index, this.builder.build());
        }

        public N endAlternateBackend() {
            return this.and();
        }
    }
}

