/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.openshift.api.model.config.v1.OIDCClientReference;
import io.fabric8.openshift.api.model.config.v1.OIDCClientReferenceBuilder;
import io.fabric8.openshift.api.model.config.v1.OIDCClientReferenceFluent;
import io.fabric8.openshift.api.model.config.v1.OIDCClientStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OIDCClientStatusFluent<A extends OIDCClientStatusFluent<A>>
extends BaseFluent<A> {
    private String componentName;
    private String componentNamespace;
    private List<Condition> conditions = new ArrayList<Condition>();
    private List<String> consumingUsers = new ArrayList<String>();
    private ArrayList<OIDCClientReferenceBuilder> currentOIDCClients = new ArrayList();
    private Map<String, Object> additionalProperties;

    public OIDCClientStatusFluent() {
    }

    public OIDCClientStatusFluent(OIDCClientStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(OIDCClientStatus instance) {
        OIDCClientStatus oIDCClientStatus = instance = instance != null ? instance : new OIDCClientStatus();
        if (instance != null) {
            this.withComponentName(instance.getComponentName());
            this.withComponentNamespace(instance.getComponentNamespace());
            this.withConditions(instance.getConditions());
            this.withConsumingUsers(instance.getConsumingUsers());
            this.withCurrentOIDCClients(instance.getCurrentOIDCClients());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getComponentName() {
        return this.componentName;
    }

    public A withComponentName(String componentName) {
        this.componentName = componentName;
        return (A)this;
    }

    public boolean hasComponentName() {
        return this.componentName != null;
    }

    public String getComponentNamespace() {
        return this.componentNamespace;
    }

    public A withComponentNamespace(String componentNamespace) {
        this.componentNamespace = componentNamespace;
        return (A)this;
    }

    public boolean hasComponentNamespace() {
        return this.componentNamespace != null;
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)this;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addToConsumingUsers(int index, String item) {
        if (this.consumingUsers == null) {
            this.consumingUsers = new ArrayList<String>();
        }
        this.consumingUsers.add(index, item);
        return (A)this;
    }

    public A setToConsumingUsers(int index, String item) {
        if (this.consumingUsers == null) {
            this.consumingUsers = new ArrayList<String>();
        }
        this.consumingUsers.set(index, item);
        return (A)this;
    }

    public A addToConsumingUsers(String ... items) {
        if (this.consumingUsers == null) {
            this.consumingUsers = new ArrayList<String>();
        }
        for (String item : items) {
            this.consumingUsers.add(item);
        }
        return (A)this;
    }

    public A addAllToConsumingUsers(Collection<String> items) {
        if (this.consumingUsers == null) {
            this.consumingUsers = new ArrayList<String>();
        }
        for (String item : items) {
            this.consumingUsers.add(item);
        }
        return (A)this;
    }

    public A removeFromConsumingUsers(String ... items) {
        if (this.consumingUsers == null) {
            return (A)this;
        }
        for (String item : items) {
            this.consumingUsers.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConsumingUsers(Collection<String> items) {
        if (this.consumingUsers == null) {
            return (A)this;
        }
        for (String item : items) {
            this.consumingUsers.remove(item);
        }
        return (A)this;
    }

    public List<String> getConsumingUsers() {
        return this.consumingUsers;
    }

    public String getConsumingUser(int index) {
        return this.consumingUsers.get(index);
    }

    public String getFirstConsumingUser() {
        return this.consumingUsers.get(0);
    }

    public String getLastConsumingUser() {
        return this.consumingUsers.get(this.consumingUsers.size() - 1);
    }

    public String getMatchingConsumingUser(Predicate<String> predicate) {
        for (String item : this.consumingUsers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingConsumingUser(Predicate<String> predicate) {
        for (String item : this.consumingUsers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConsumingUsers(List<String> consumingUsers) {
        if (consumingUsers != null) {
            this.consumingUsers = new ArrayList<String>();
            for (String item : consumingUsers) {
                this.addToConsumingUsers(item);
            }
        } else {
            this.consumingUsers = null;
        }
        return (A)this;
    }

    public A withConsumingUsers(String ... consumingUsers) {
        if (this.consumingUsers != null) {
            this.consumingUsers.clear();
            this._visitables.remove("consumingUsers");
        }
        if (consumingUsers != null) {
            for (String item : consumingUsers) {
                this.addToConsumingUsers(item);
            }
        }
        return (A)this;
    }

    public boolean hasConsumingUsers() {
        return this.consumingUsers != null && !this.consumingUsers.isEmpty();
    }

    public A addToCurrentOIDCClients(int index, OIDCClientReference item) {
        if (this.currentOIDCClients == null) {
            this.currentOIDCClients = new ArrayList();
        }
        OIDCClientReferenceBuilder builder = new OIDCClientReferenceBuilder(item);
        if (index < 0 || index >= this.currentOIDCClients.size()) {
            this._visitables.get("currentOIDCClients").add(builder);
            this.currentOIDCClients.add(builder);
        } else {
            this._visitables.get("currentOIDCClients").add(index, builder);
            this.currentOIDCClients.add(index, builder);
        }
        return (A)this;
    }

    public A setToCurrentOIDCClients(int index, OIDCClientReference item) {
        if (this.currentOIDCClients == null) {
            this.currentOIDCClients = new ArrayList();
        }
        OIDCClientReferenceBuilder builder = new OIDCClientReferenceBuilder(item);
        if (index < 0 || index >= this.currentOIDCClients.size()) {
            this._visitables.get("currentOIDCClients").add(builder);
            this.currentOIDCClients.add(builder);
        } else {
            this._visitables.get("currentOIDCClients").set(index, builder);
            this.currentOIDCClients.set(index, builder);
        }
        return (A)this;
    }

    public A addToCurrentOIDCClients(OIDCClientReference ... items) {
        if (this.currentOIDCClients == null) {
            this.currentOIDCClients = new ArrayList();
        }
        for (OIDCClientReference item : items) {
            OIDCClientReferenceBuilder builder = new OIDCClientReferenceBuilder(item);
            this._visitables.get("currentOIDCClients").add(builder);
            this.currentOIDCClients.add(builder);
        }
        return (A)this;
    }

    public A addAllToCurrentOIDCClients(Collection<OIDCClientReference> items) {
        if (this.currentOIDCClients == null) {
            this.currentOIDCClients = new ArrayList();
        }
        for (OIDCClientReference item : items) {
            OIDCClientReferenceBuilder builder = new OIDCClientReferenceBuilder(item);
            this._visitables.get("currentOIDCClients").add(builder);
            this.currentOIDCClients.add(builder);
        }
        return (A)this;
    }

    public A removeFromCurrentOIDCClients(OIDCClientReference ... items) {
        if (this.currentOIDCClients == null) {
            return (A)this;
        }
        for (OIDCClientReference item : items) {
            OIDCClientReferenceBuilder builder = new OIDCClientReferenceBuilder(item);
            this._visitables.get("currentOIDCClients").remove(builder);
            this.currentOIDCClients.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromCurrentOIDCClients(Collection<OIDCClientReference> items) {
        if (this.currentOIDCClients == null) {
            return (A)this;
        }
        for (OIDCClientReference item : items) {
            OIDCClientReferenceBuilder builder = new OIDCClientReferenceBuilder(item);
            this._visitables.get("currentOIDCClients").remove(builder);
            this.currentOIDCClients.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromCurrentOIDCClients(Predicate<OIDCClientReferenceBuilder> predicate) {
        if (this.currentOIDCClients == null) {
            return (A)this;
        }
        Iterator<OIDCClientReferenceBuilder> each = this.currentOIDCClients.iterator();
        Object visitables = this._visitables.get("currentOIDCClients");
        while (each.hasNext()) {
            OIDCClientReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<OIDCClientReference> buildCurrentOIDCClients() {
        return this.currentOIDCClients != null ? OIDCClientStatusFluent.build(this.currentOIDCClients) : null;
    }

    public OIDCClientReference buildCurrentOIDCClient(int index) {
        return this.currentOIDCClients.get(index).build();
    }

    public OIDCClientReference buildFirstCurrentOIDCClient() {
        return this.currentOIDCClients.get(0).build();
    }

    public OIDCClientReference buildLastCurrentOIDCClient() {
        return this.currentOIDCClients.get(this.currentOIDCClients.size() - 1).build();
    }

    public OIDCClientReference buildMatchingCurrentOIDCClient(Predicate<OIDCClientReferenceBuilder> predicate) {
        for (OIDCClientReferenceBuilder item : this.currentOIDCClients) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCurrentOIDCClient(Predicate<OIDCClientReferenceBuilder> predicate) {
        for (OIDCClientReferenceBuilder item : this.currentOIDCClients) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCurrentOIDCClients(List<OIDCClientReference> currentOIDCClients) {
        if (this.currentOIDCClients != null) {
            this._visitables.get("currentOIDCClients").clear();
        }
        if (currentOIDCClients != null) {
            this.currentOIDCClients = new ArrayList();
            for (OIDCClientReference item : currentOIDCClients) {
                this.addToCurrentOIDCClients(item);
            }
        } else {
            this.currentOIDCClients = null;
        }
        return (A)this;
    }

    public A withCurrentOIDCClients(OIDCClientReference ... currentOIDCClients) {
        if (this.currentOIDCClients != null) {
            this.currentOIDCClients.clear();
            this._visitables.remove("currentOIDCClients");
        }
        if (currentOIDCClients != null) {
            for (OIDCClientReference item : currentOIDCClients) {
                this.addToCurrentOIDCClients(item);
            }
        }
        return (A)this;
    }

    public boolean hasCurrentOIDCClients() {
        return this.currentOIDCClients != null && !this.currentOIDCClients.isEmpty();
    }

    public A addNewCurrentOIDCClient(String clientID, String issuerURL, String oidcProviderName) {
        return this.addToCurrentOIDCClients(new OIDCClientReference(clientID, issuerURL, oidcProviderName));
    }

    public CurrentOIDCClientsNested<A> addNewCurrentOIDCClient() {
        return new CurrentOIDCClientsNested(-1, null);
    }

    public CurrentOIDCClientsNested<A> addNewCurrentOIDCClientLike(OIDCClientReference item) {
        return new CurrentOIDCClientsNested(-1, item);
    }

    public CurrentOIDCClientsNested<A> setNewCurrentOIDCClientLike(int index, OIDCClientReference item) {
        return new CurrentOIDCClientsNested(index, item);
    }

    public CurrentOIDCClientsNested<A> editCurrentOIDCClient(int index) {
        if (this.currentOIDCClients.size() <= index) {
            throw new RuntimeException("Can't edit currentOIDCClients. Index exceeds size.");
        }
        return this.setNewCurrentOIDCClientLike(index, this.buildCurrentOIDCClient(index));
    }

    public CurrentOIDCClientsNested<A> editFirstCurrentOIDCClient() {
        if (this.currentOIDCClients.size() == 0) {
            throw new RuntimeException("Can't edit first currentOIDCClients. The list is empty.");
        }
        return this.setNewCurrentOIDCClientLike(0, this.buildCurrentOIDCClient(0));
    }

    public CurrentOIDCClientsNested<A> editLastCurrentOIDCClient() {
        int index = this.currentOIDCClients.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last currentOIDCClients. The list is empty.");
        }
        return this.setNewCurrentOIDCClientLike(index, this.buildCurrentOIDCClient(index));
    }

    public CurrentOIDCClientsNested<A> editMatchingCurrentOIDCClient(Predicate<OIDCClientReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.currentOIDCClients.size(); ++i) {
            if (!predicate.test(this.currentOIDCClients.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching currentOIDCClients. No match found.");
        }
        return this.setNewCurrentOIDCClientLike(index, this.buildCurrentOIDCClient(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OIDCClientStatusFluent that = (OIDCClientStatusFluent)o;
        if (!Objects.equals(this.componentName, that.componentName)) {
            return false;
        }
        if (!Objects.equals(this.componentNamespace, that.componentNamespace)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.consumingUsers, that.consumingUsers)) {
            return false;
        }
        if (!Objects.equals(this.currentOIDCClients, that.currentOIDCClients)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.componentName, this.componentNamespace, this.conditions, this.consumingUsers, this.currentOIDCClients, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.componentName != null) {
            sb.append("componentName:");
            sb.append(this.componentName + ",");
        }
        if (this.componentNamespace != null) {
            sb.append("componentNamespace:");
            sb.append(this.componentNamespace + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.consumingUsers != null && !this.consumingUsers.isEmpty()) {
            sb.append("consumingUsers:");
            sb.append(this.consumingUsers + ",");
        }
        if (this.currentOIDCClients != null && !this.currentOIDCClients.isEmpty()) {
            sb.append("currentOIDCClients:");
            sb.append(this.currentOIDCClients + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class CurrentOIDCClientsNested<N>
    extends OIDCClientReferenceFluent<CurrentOIDCClientsNested<N>>
    implements Nested<N> {
        OIDCClientReferenceBuilder builder;
        int index;

        CurrentOIDCClientsNested(int index, OIDCClientReference item) {
            this.index = index;
            this.builder = new OIDCClientReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)OIDCClientStatusFluent.this.setToCurrentOIDCClients(this.index, this.builder.build());
        }

        public N endCurrentOIDCClient() {
            return this.and();
        }
    }
}

