/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1beta1.Condition;
import io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.ConditionFluent;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineSetStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MachineSetStatusFluent<A extends MachineSetStatusFluent<A>>
extends BaseFluent<A> {
    private String authoritativeAPI;
    private Integer availableReplicas;
    private ArrayList<ConditionBuilder> conditions = new ArrayList();
    private String errorMessage;
    private String errorReason;
    private Integer fullyLabeledReplicas;
    private Long observedGeneration;
    private Integer readyReplicas;
    private Integer replicas;
    private Long synchronizedGeneration;
    private Map<String, Object> additionalProperties;

    public MachineSetStatusFluent() {
    }

    public MachineSetStatusFluent(MachineSetStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachineSetStatus instance) {
        MachineSetStatus machineSetStatus = instance = instance != null ? instance : new MachineSetStatus();
        if (instance != null) {
            this.withAuthoritativeAPI(instance.getAuthoritativeAPI());
            this.withAvailableReplicas(instance.getAvailableReplicas());
            this.withConditions(instance.getConditions());
            this.withErrorMessage(instance.getErrorMessage());
            this.withErrorReason(instance.getErrorReason());
            this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withReadyReplicas(instance.getReadyReplicas());
            this.withReplicas(instance.getReplicas());
            this.withSynchronizedGeneration(instance.getSynchronizedGeneration());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAuthoritativeAPI() {
        return this.authoritativeAPI;
    }

    public A withAuthoritativeAPI(String authoritativeAPI) {
        this.authoritativeAPI = authoritativeAPI;
        return (A)this;
    }

    public boolean hasAuthoritativeAPI() {
        return this.authoritativeAPI != null;
    }

    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    public A withAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return (A)this;
    }

    public boolean hasAvailableReplicas() {
        return this.availableReplicas != null;
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Condition> buildConditions() {
        return this.conditions != null ? MachineSetStatusFluent.build(this.conditions) : null;
    }

    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public A withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return (A)this;
    }

    public boolean hasErrorMessage() {
        return this.errorMessage != null;
    }

    public String getErrorReason() {
        return this.errorReason;
    }

    public A withErrorReason(String errorReason) {
        this.errorReason = errorReason;
        return (A)this;
    }

    public boolean hasErrorReason() {
        return this.errorReason != null;
    }

    public Integer getFullyLabeledReplicas() {
        return this.fullyLabeledReplicas;
    }

    public A withFullyLabeledReplicas(Integer fullyLabeledReplicas) {
        this.fullyLabeledReplicas = fullyLabeledReplicas;
        return (A)this;
    }

    public boolean hasFullyLabeledReplicas() {
        return this.fullyLabeledReplicas != null;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public A withReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return (A)this;
    }

    public boolean hasReadyReplicas() {
        return this.readyReplicas != null;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public Long getSynchronizedGeneration() {
        return this.synchronizedGeneration;
    }

    public A withSynchronizedGeneration(Long synchronizedGeneration) {
        this.synchronizedGeneration = synchronizedGeneration;
        return (A)this;
    }

    public boolean hasSynchronizedGeneration() {
        return this.synchronizedGeneration != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineSetStatusFluent that = (MachineSetStatusFluent)o;
        if (!Objects.equals(this.authoritativeAPI, that.authoritativeAPI)) {
            return false;
        }
        if (!Objects.equals(this.availableReplicas, that.availableReplicas)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.errorMessage, that.errorMessage)) {
            return false;
        }
        if (!Objects.equals(this.errorReason, that.errorReason)) {
            return false;
        }
        if (!Objects.equals(this.fullyLabeledReplicas, that.fullyLabeledReplicas)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.readyReplicas, that.readyReplicas)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.synchronizedGeneration, that.synchronizedGeneration)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.authoritativeAPI, this.availableReplicas, this.conditions, this.errorMessage, this.errorReason, this.fullyLabeledReplicas, this.observedGeneration, this.readyReplicas, this.replicas, this.synchronizedGeneration, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authoritativeAPI != null) {
            sb.append("authoritativeAPI:");
            sb.append(this.authoritativeAPI + ",");
        }
        if (this.availableReplicas != null) {
            sb.append("availableReplicas:");
            sb.append(this.availableReplicas + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.errorMessage != null) {
            sb.append("errorMessage:");
            sb.append(this.errorMessage + ",");
        }
        if (this.errorReason != null) {
            sb.append("errorReason:");
            sb.append(this.errorReason + ",");
        }
        if (this.fullyLabeledReplicas != null) {
            sb.append("fullyLabeledReplicas:");
            sb.append(this.fullyLabeledReplicas + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.readyReplicas != null) {
            sb.append("readyReplicas:");
            sb.append(this.readyReplicas + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.synchronizedGeneration != null) {
            sb.append("synchronizedGeneration:");
            sb.append(this.synchronizedGeneration + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends ConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionBuilder builder;
        int index;

        ConditionsNested(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineSetStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

