/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1beta1.DayOfMonthRange;
import io.fabric8.openshift.api.model.monitoring.v1beta1.DayOfMonthRangeBuilder;
import io.fabric8.openshift.api.model.monitoring.v1beta1.DayOfMonthRangeFluent;
import io.fabric8.openshift.api.model.monitoring.v1beta1.TimePeriod;
import io.fabric8.openshift.api.model.monitoring.v1beta1.TimeRange;
import io.fabric8.openshift.api.model.monitoring.v1beta1.TimeRangeBuilder;
import io.fabric8.openshift.api.model.monitoring.v1beta1.TimeRangeFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class TimePeriodFluent<A extends TimePeriodFluent<A>>
extends BaseFluent<A> {
    private ArrayList<DayOfMonthRangeBuilder> daysOfMonth = new ArrayList();
    private List<String> months = new ArrayList<String>();
    private ArrayList<TimeRangeBuilder> times = new ArrayList();
    private List<String> weekdays = new ArrayList<String>();
    private List<String> years = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public TimePeriodFluent() {
    }

    public TimePeriodFluent(TimePeriod instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(TimePeriod instance) {
        TimePeriod timePeriod = instance = instance != null ? instance : new TimePeriod();
        if (instance != null) {
            this.withDaysOfMonth(instance.getDaysOfMonth());
            this.withMonths(instance.getMonths());
            this.withTimes(instance.getTimes());
            this.withWeekdays(instance.getWeekdays());
            this.withYears(instance.getYears());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToDaysOfMonth(int index, DayOfMonthRange item) {
        if (this.daysOfMonth == null) {
            this.daysOfMonth = new ArrayList();
        }
        DayOfMonthRangeBuilder builder = new DayOfMonthRangeBuilder(item);
        if (index < 0 || index >= this.daysOfMonth.size()) {
            this._visitables.get("daysOfMonth").add(builder);
            this.daysOfMonth.add(builder);
        } else {
            this._visitables.get("daysOfMonth").add(index, builder);
            this.daysOfMonth.add(index, builder);
        }
        return (A)this;
    }

    public A setToDaysOfMonth(int index, DayOfMonthRange item) {
        if (this.daysOfMonth == null) {
            this.daysOfMonth = new ArrayList();
        }
        DayOfMonthRangeBuilder builder = new DayOfMonthRangeBuilder(item);
        if (index < 0 || index >= this.daysOfMonth.size()) {
            this._visitables.get("daysOfMonth").add(builder);
            this.daysOfMonth.add(builder);
        } else {
            this._visitables.get("daysOfMonth").set(index, builder);
            this.daysOfMonth.set(index, builder);
        }
        return (A)this;
    }

    public A addToDaysOfMonth(DayOfMonthRange ... items) {
        if (this.daysOfMonth == null) {
            this.daysOfMonth = new ArrayList();
        }
        for (DayOfMonthRange item : items) {
            DayOfMonthRangeBuilder builder = new DayOfMonthRangeBuilder(item);
            this._visitables.get("daysOfMonth").add(builder);
            this.daysOfMonth.add(builder);
        }
        return (A)this;
    }

    public A addAllToDaysOfMonth(Collection<DayOfMonthRange> items) {
        if (this.daysOfMonth == null) {
            this.daysOfMonth = new ArrayList();
        }
        for (DayOfMonthRange item : items) {
            DayOfMonthRangeBuilder builder = new DayOfMonthRangeBuilder(item);
            this._visitables.get("daysOfMonth").add(builder);
            this.daysOfMonth.add(builder);
        }
        return (A)this;
    }

    public A removeFromDaysOfMonth(DayOfMonthRange ... items) {
        if (this.daysOfMonth == null) {
            return (A)this;
        }
        for (DayOfMonthRange item : items) {
            DayOfMonthRangeBuilder builder = new DayOfMonthRangeBuilder(item);
            this._visitables.get("daysOfMonth").remove(builder);
            this.daysOfMonth.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromDaysOfMonth(Collection<DayOfMonthRange> items) {
        if (this.daysOfMonth == null) {
            return (A)this;
        }
        for (DayOfMonthRange item : items) {
            DayOfMonthRangeBuilder builder = new DayOfMonthRangeBuilder(item);
            this._visitables.get("daysOfMonth").remove(builder);
            this.daysOfMonth.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromDaysOfMonth(Predicate<DayOfMonthRangeBuilder> predicate) {
        if (this.daysOfMonth == null) {
            return (A)this;
        }
        Iterator<DayOfMonthRangeBuilder> each = this.daysOfMonth.iterator();
        Object visitables = this._visitables.get("daysOfMonth");
        while (each.hasNext()) {
            DayOfMonthRangeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DayOfMonthRange> buildDaysOfMonth() {
        return this.daysOfMonth != null ? TimePeriodFluent.build(this.daysOfMonth) : null;
    }

    public DayOfMonthRange buildDaysOfMonth(int index) {
        return this.daysOfMonth.get(index).build();
    }

    public DayOfMonthRange buildFirstDaysOfMonth() {
        return this.daysOfMonth.get(0).build();
    }

    public DayOfMonthRange buildLastDaysOfMonth() {
        return this.daysOfMonth.get(this.daysOfMonth.size() - 1).build();
    }

    public DayOfMonthRange buildMatchingDaysOfMonth(Predicate<DayOfMonthRangeBuilder> predicate) {
        for (DayOfMonthRangeBuilder item : this.daysOfMonth) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDaysOfMonth(Predicate<DayOfMonthRangeBuilder> predicate) {
        for (DayOfMonthRangeBuilder item : this.daysOfMonth) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDaysOfMonth(List<DayOfMonthRange> daysOfMonth) {
        if (this.daysOfMonth != null) {
            this._visitables.get("daysOfMonth").clear();
        }
        if (daysOfMonth != null) {
            this.daysOfMonth = new ArrayList();
            for (DayOfMonthRange item : daysOfMonth) {
                this.addToDaysOfMonth(item);
            }
        } else {
            this.daysOfMonth = null;
        }
        return (A)this;
    }

    public A withDaysOfMonth(DayOfMonthRange ... daysOfMonth) {
        if (this.daysOfMonth != null) {
            this.daysOfMonth.clear();
            this._visitables.remove("daysOfMonth");
        }
        if (daysOfMonth != null) {
            for (DayOfMonthRange item : daysOfMonth) {
                this.addToDaysOfMonth(item);
            }
        }
        return (A)this;
    }

    public boolean hasDaysOfMonth() {
        return this.daysOfMonth != null && !this.daysOfMonth.isEmpty();
    }

    public A addNewDaysOfMonth(Integer end, Integer start) {
        return this.addToDaysOfMonth(new DayOfMonthRange(end, start));
    }

    public DaysOfMonthNested<A> addNewDaysOfMonth() {
        return new DaysOfMonthNested(-1, null);
    }

    public DaysOfMonthNested<A> addNewDaysOfMonthLike(DayOfMonthRange item) {
        return new DaysOfMonthNested(-1, item);
    }

    public DaysOfMonthNested<A> setNewDaysOfMonthLike(int index, DayOfMonthRange item) {
        return new DaysOfMonthNested(index, item);
    }

    public DaysOfMonthNested<A> editDaysOfMonth(int index) {
        if (this.daysOfMonth.size() <= index) {
            throw new RuntimeException("Can't edit daysOfMonth. Index exceeds size.");
        }
        return this.setNewDaysOfMonthLike(index, this.buildDaysOfMonth(index));
    }

    public DaysOfMonthNested<A> editFirstDaysOfMonth() {
        if (this.daysOfMonth.size() == 0) {
            throw new RuntimeException("Can't edit first daysOfMonth. The list is empty.");
        }
        return this.setNewDaysOfMonthLike(0, this.buildDaysOfMonth(0));
    }

    public DaysOfMonthNested<A> editLastDaysOfMonth() {
        int index = this.daysOfMonth.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last daysOfMonth. The list is empty.");
        }
        return this.setNewDaysOfMonthLike(index, this.buildDaysOfMonth(index));
    }

    public DaysOfMonthNested<A> editMatchingDaysOfMonth(Predicate<DayOfMonthRangeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.daysOfMonth.size(); ++i) {
            if (!predicate.test(this.daysOfMonth.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching daysOfMonth. No match found.");
        }
        return this.setNewDaysOfMonthLike(index, this.buildDaysOfMonth(index));
    }

    public A addToMonths(int index, String item) {
        if (this.months == null) {
            this.months = new ArrayList<String>();
        }
        this.months.add(index, item);
        return (A)this;
    }

    public A setToMonths(int index, String item) {
        if (this.months == null) {
            this.months = new ArrayList<String>();
        }
        this.months.set(index, item);
        return (A)this;
    }

    public A addToMonths(String ... items) {
        if (this.months == null) {
            this.months = new ArrayList<String>();
        }
        for (String item : items) {
            this.months.add(item);
        }
        return (A)this;
    }

    public A addAllToMonths(Collection<String> items) {
        if (this.months == null) {
            this.months = new ArrayList<String>();
        }
        for (String item : items) {
            this.months.add(item);
        }
        return (A)this;
    }

    public A removeFromMonths(String ... items) {
        if (this.months == null) {
            return (A)this;
        }
        for (String item : items) {
            this.months.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromMonths(Collection<String> items) {
        if (this.months == null) {
            return (A)this;
        }
        for (String item : items) {
            this.months.remove(item);
        }
        return (A)this;
    }

    public List<String> getMonths() {
        return this.months;
    }

    public String getMonth(int index) {
        return this.months.get(index);
    }

    public String getFirstMonth() {
        return this.months.get(0);
    }

    public String getLastMonth() {
        return this.months.get(this.months.size() - 1);
    }

    public String getMatchingMonth(Predicate<String> predicate) {
        for (String item : this.months) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingMonth(Predicate<String> predicate) {
        for (String item : this.months) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMonths(List<String> months) {
        if (months != null) {
            this.months = new ArrayList<String>();
            for (String item : months) {
                this.addToMonths(item);
            }
        } else {
            this.months = null;
        }
        return (A)this;
    }

    public A withMonths(String ... months) {
        if (this.months != null) {
            this.months.clear();
            this._visitables.remove("months");
        }
        if (months != null) {
            for (String item : months) {
                this.addToMonths(item);
            }
        }
        return (A)this;
    }

    public boolean hasMonths() {
        return this.months != null && !this.months.isEmpty();
    }

    public A addToTimes(int index, TimeRange item) {
        if (this.times == null) {
            this.times = new ArrayList();
        }
        TimeRangeBuilder builder = new TimeRangeBuilder(item);
        if (index < 0 || index >= this.times.size()) {
            this._visitables.get("times").add(builder);
            this.times.add(builder);
        } else {
            this._visitables.get("times").add(index, builder);
            this.times.add(index, builder);
        }
        return (A)this;
    }

    public A setToTimes(int index, TimeRange item) {
        if (this.times == null) {
            this.times = new ArrayList();
        }
        TimeRangeBuilder builder = new TimeRangeBuilder(item);
        if (index < 0 || index >= this.times.size()) {
            this._visitables.get("times").add(builder);
            this.times.add(builder);
        } else {
            this._visitables.get("times").set(index, builder);
            this.times.set(index, builder);
        }
        return (A)this;
    }

    public A addToTimes(TimeRange ... items) {
        if (this.times == null) {
            this.times = new ArrayList();
        }
        for (TimeRange item : items) {
            TimeRangeBuilder builder = new TimeRangeBuilder(item);
            this._visitables.get("times").add(builder);
            this.times.add(builder);
        }
        return (A)this;
    }

    public A addAllToTimes(Collection<TimeRange> items) {
        if (this.times == null) {
            this.times = new ArrayList();
        }
        for (TimeRange item : items) {
            TimeRangeBuilder builder = new TimeRangeBuilder(item);
            this._visitables.get("times").add(builder);
            this.times.add(builder);
        }
        return (A)this;
    }

    public A removeFromTimes(TimeRange ... items) {
        if (this.times == null) {
            return (A)this;
        }
        for (TimeRange item : items) {
            TimeRangeBuilder builder = new TimeRangeBuilder(item);
            this._visitables.get("times").remove(builder);
            this.times.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTimes(Collection<TimeRange> items) {
        if (this.times == null) {
            return (A)this;
        }
        for (TimeRange item : items) {
            TimeRangeBuilder builder = new TimeRangeBuilder(item);
            this._visitables.get("times").remove(builder);
            this.times.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTimes(Predicate<TimeRangeBuilder> predicate) {
        if (this.times == null) {
            return (A)this;
        }
        Iterator<TimeRangeBuilder> each = this.times.iterator();
        Object visitables = this._visitables.get("times");
        while (each.hasNext()) {
            TimeRangeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<TimeRange> buildTimes() {
        return this.times != null ? TimePeriodFluent.build(this.times) : null;
    }

    public TimeRange buildTime(int index) {
        return this.times.get(index).build();
    }

    public TimeRange buildFirstTime() {
        return this.times.get(0).build();
    }

    public TimeRange buildLastTime() {
        return this.times.get(this.times.size() - 1).build();
    }

    public TimeRange buildMatchingTime(Predicate<TimeRangeBuilder> predicate) {
        for (TimeRangeBuilder item : this.times) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTime(Predicate<TimeRangeBuilder> predicate) {
        for (TimeRangeBuilder item : this.times) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTimes(List<TimeRange> times) {
        if (this.times != null) {
            this._visitables.get("times").clear();
        }
        if (times != null) {
            this.times = new ArrayList();
            for (TimeRange item : times) {
                this.addToTimes(item);
            }
        } else {
            this.times = null;
        }
        return (A)this;
    }

    public A withTimes(TimeRange ... times) {
        if (this.times != null) {
            this.times.clear();
            this._visitables.remove("times");
        }
        if (times != null) {
            for (TimeRange item : times) {
                this.addToTimes(item);
            }
        }
        return (A)this;
    }

    public boolean hasTimes() {
        return this.times != null && !this.times.isEmpty();
    }

    public A addNewTime(String endTime, String startTime) {
        return this.addToTimes(new TimeRange(endTime, startTime));
    }

    public TimesNested<A> addNewTime() {
        return new TimesNested(-1, null);
    }

    public TimesNested<A> addNewTimeLike(TimeRange item) {
        return new TimesNested(-1, item);
    }

    public TimesNested<A> setNewTimeLike(int index, TimeRange item) {
        return new TimesNested(index, item);
    }

    public TimesNested<A> editTime(int index) {
        if (this.times.size() <= index) {
            throw new RuntimeException("Can't edit times. Index exceeds size.");
        }
        return this.setNewTimeLike(index, this.buildTime(index));
    }

    public TimesNested<A> editFirstTime() {
        if (this.times.size() == 0) {
            throw new RuntimeException("Can't edit first times. The list is empty.");
        }
        return this.setNewTimeLike(0, this.buildTime(0));
    }

    public TimesNested<A> editLastTime() {
        int index = this.times.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last times. The list is empty.");
        }
        return this.setNewTimeLike(index, this.buildTime(index));
    }

    public TimesNested<A> editMatchingTime(Predicate<TimeRangeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.times.size(); ++i) {
            if (!predicate.test(this.times.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching times. No match found.");
        }
        return this.setNewTimeLike(index, this.buildTime(index));
    }

    public A addToWeekdays(int index, String item) {
        if (this.weekdays == null) {
            this.weekdays = new ArrayList<String>();
        }
        this.weekdays.add(index, item);
        return (A)this;
    }

    public A setToWeekdays(int index, String item) {
        if (this.weekdays == null) {
            this.weekdays = new ArrayList<String>();
        }
        this.weekdays.set(index, item);
        return (A)this;
    }

    public A addToWeekdays(String ... items) {
        if (this.weekdays == null) {
            this.weekdays = new ArrayList<String>();
        }
        for (String item : items) {
            this.weekdays.add(item);
        }
        return (A)this;
    }

    public A addAllToWeekdays(Collection<String> items) {
        if (this.weekdays == null) {
            this.weekdays = new ArrayList<String>();
        }
        for (String item : items) {
            this.weekdays.add(item);
        }
        return (A)this;
    }

    public A removeFromWeekdays(String ... items) {
        if (this.weekdays == null) {
            return (A)this;
        }
        for (String item : items) {
            this.weekdays.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromWeekdays(Collection<String> items) {
        if (this.weekdays == null) {
            return (A)this;
        }
        for (String item : items) {
            this.weekdays.remove(item);
        }
        return (A)this;
    }

    public List<String> getWeekdays() {
        return this.weekdays;
    }

    public String getWeekday(int index) {
        return this.weekdays.get(index);
    }

    public String getFirstWeekday() {
        return this.weekdays.get(0);
    }

    public String getLastWeekday() {
        return this.weekdays.get(this.weekdays.size() - 1);
    }

    public String getMatchingWeekday(Predicate<String> predicate) {
        for (String item : this.weekdays) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingWeekday(Predicate<String> predicate) {
        for (String item : this.weekdays) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withWeekdays(List<String> weekdays) {
        if (weekdays != null) {
            this.weekdays = new ArrayList<String>();
            for (String item : weekdays) {
                this.addToWeekdays(item);
            }
        } else {
            this.weekdays = null;
        }
        return (A)this;
    }

    public A withWeekdays(String ... weekdays) {
        if (this.weekdays != null) {
            this.weekdays.clear();
            this._visitables.remove("weekdays");
        }
        if (weekdays != null) {
            for (String item : weekdays) {
                this.addToWeekdays(item);
            }
        }
        return (A)this;
    }

    public boolean hasWeekdays() {
        return this.weekdays != null && !this.weekdays.isEmpty();
    }

    public A addToYears(int index, String item) {
        if (this.years == null) {
            this.years = new ArrayList<String>();
        }
        this.years.add(index, item);
        return (A)this;
    }

    public A setToYears(int index, String item) {
        if (this.years == null) {
            this.years = new ArrayList<String>();
        }
        this.years.set(index, item);
        return (A)this;
    }

    public A addToYears(String ... items) {
        if (this.years == null) {
            this.years = new ArrayList<String>();
        }
        for (String item : items) {
            this.years.add(item);
        }
        return (A)this;
    }

    public A addAllToYears(Collection<String> items) {
        if (this.years == null) {
            this.years = new ArrayList<String>();
        }
        for (String item : items) {
            this.years.add(item);
        }
        return (A)this;
    }

    public A removeFromYears(String ... items) {
        if (this.years == null) {
            return (A)this;
        }
        for (String item : items) {
            this.years.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromYears(Collection<String> items) {
        if (this.years == null) {
            return (A)this;
        }
        for (String item : items) {
            this.years.remove(item);
        }
        return (A)this;
    }

    public List<String> getYears() {
        return this.years;
    }

    public String getYear(int index) {
        return this.years.get(index);
    }

    public String getFirstYear() {
        return this.years.get(0);
    }

    public String getLastYear() {
        return this.years.get(this.years.size() - 1);
    }

    public String getMatchingYear(Predicate<String> predicate) {
        for (String item : this.years) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingYear(Predicate<String> predicate) {
        for (String item : this.years) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withYears(List<String> years) {
        if (years != null) {
            this.years = new ArrayList<String>();
            for (String item : years) {
                this.addToYears(item);
            }
        } else {
            this.years = null;
        }
        return (A)this;
    }

    public A withYears(String ... years) {
        if (this.years != null) {
            this.years.clear();
            this._visitables.remove("years");
        }
        if (years != null) {
            for (String item : years) {
                this.addToYears(item);
            }
        }
        return (A)this;
    }

    public boolean hasYears() {
        return this.years != null && !this.years.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TimePeriodFluent that = (TimePeriodFluent)o;
        if (!Objects.equals(this.daysOfMonth, that.daysOfMonth)) {
            return false;
        }
        if (!Objects.equals(this.months, that.months)) {
            return false;
        }
        if (!Objects.equals(this.times, that.times)) {
            return false;
        }
        if (!Objects.equals(this.weekdays, that.weekdays)) {
            return false;
        }
        if (!Objects.equals(this.years, that.years)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.daysOfMonth, this.months, this.times, this.weekdays, this.years, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.daysOfMonth != null && !this.daysOfMonth.isEmpty()) {
            sb.append("daysOfMonth:");
            sb.append(this.daysOfMonth + ",");
        }
        if (this.months != null && !this.months.isEmpty()) {
            sb.append("months:");
            sb.append(this.months + ",");
        }
        if (this.times != null && !this.times.isEmpty()) {
            sb.append("times:");
            sb.append(this.times + ",");
        }
        if (this.weekdays != null && !this.weekdays.isEmpty()) {
            sb.append("weekdays:");
            sb.append(this.weekdays + ",");
        }
        if (this.years != null && !this.years.isEmpty()) {
            sb.append("years:");
            sb.append(this.years + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TimesNested<N>
    extends TimeRangeFluent<TimesNested<N>>
    implements Nested<N> {
        TimeRangeBuilder builder;
        int index;

        TimesNested(int index, TimeRange item) {
            this.index = index;
            this.builder = new TimeRangeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)TimePeriodFluent.this.setToTimes(this.index, this.builder.build());
        }

        public N endTime() {
            return this.and();
        }
    }

    public class DaysOfMonthNested<N>
    extends DayOfMonthRangeFluent<DaysOfMonthNested<N>>
    implements Nested<N> {
        DayOfMonthRangeBuilder builder;
        int index;

        DaysOfMonthNested(int index, DayOfMonthRange item) {
            this.index = index;
            this.builder = new DayOfMonthRangeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)TimePeriodFluent.this.setToDaysOfMonth(this.index, this.builder.build());
        }

        public N endDaysOfMonth() {
            return this.and();
        }
    }
}

