/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.clusterapi.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.Bootstrap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class BootstrapFluent<A extends BootstrapFluent<A>>
extends BaseFluent<A> {
    private ObjectReferenceBuilder configRef;
    private String dataSecretName;
    private Map<String, Object> additionalProperties;

    public BootstrapFluent() {
    }

    public BootstrapFluent(Bootstrap instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Bootstrap instance) {
        Bootstrap bootstrap = instance = instance != null ? instance : new Bootstrap();
        if (instance != null) {
            this.withConfigRef(instance.getConfigRef());
            this.withDataSecretName(instance.getDataSecretName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ObjectReference buildConfigRef() {
        return this.configRef != null ? this.configRef.build() : null;
    }

    public A withConfigRef(ObjectReference configRef) {
        this._visitables.remove("configRef");
        if (configRef != null) {
            this.configRef = new ObjectReferenceBuilder(configRef);
            this._visitables.get("configRef").add(this.configRef);
        } else {
            this.configRef = null;
            this._visitables.get("configRef").remove(this.configRef);
        }
        return (A)this;
    }

    public boolean hasConfigRef() {
        return this.configRef != null;
    }

    public ConfigRefNested<A> withNewConfigRef() {
        return new ConfigRefNested(null);
    }

    public ConfigRefNested<A> withNewConfigRefLike(ObjectReference item) {
        return new ConfigRefNested(item);
    }

    public ConfigRefNested<A> editConfigRef() {
        return this.withNewConfigRefLike(Optional.ofNullable(this.buildConfigRef()).orElse(null));
    }

    public ConfigRefNested<A> editOrNewConfigRef() {
        return this.withNewConfigRefLike(Optional.ofNullable(this.buildConfigRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public ConfigRefNested<A> editOrNewConfigRefLike(ObjectReference item) {
        return this.withNewConfigRefLike(Optional.ofNullable(this.buildConfigRef()).orElse(item));
    }

    public String getDataSecretName() {
        return this.dataSecretName;
    }

    public A withDataSecretName(String dataSecretName) {
        this.dataSecretName = dataSecretName;
        return (A)this;
    }

    public boolean hasDataSecretName() {
        return this.dataSecretName != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BootstrapFluent that = (BootstrapFluent)o;
        if (!Objects.equals(this.configRef, that.configRef)) {
            return false;
        }
        if (!Objects.equals(this.dataSecretName, that.dataSecretName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.configRef, this.dataSecretName, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configRef != null) {
            sb.append("configRef:");
            sb.append(this.configRef + ",");
        }
        if (this.dataSecretName != null) {
            sb.append("dataSecretName:");
            sb.append(this.dataSecretName + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConfigRefNested<N>
    extends ObjectReferenceFluent<ConfigRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        ConfigRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BootstrapFluent.this.withConfigRef(this.builder.build());
        }

        public N endConfigRef() {
            return this.and();
        }
    }
}

