/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1alpha3;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceClaim;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceClaimBuilder;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.DeviceClaimFluent;
import io.fabric8.kubernetes.api.model.resource.v1alpha3.ResourceClaimSpec;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ResourceClaimSpecFluent<A extends ResourceClaimSpecFluent<A>>
extends BaseFluent<A> {
    private DeviceClaimBuilder devices;
    private Map<String, Object> additionalProperties;

    public ResourceClaimSpecFluent() {
    }

    public ResourceClaimSpecFluent(ResourceClaimSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ResourceClaimSpec instance) {
        ResourceClaimSpec resourceClaimSpec = instance = instance != null ? instance : new ResourceClaimSpec();
        if (instance != null) {
            this.withDevices(instance.getDevices());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public DeviceClaim buildDevices() {
        return this.devices != null ? this.devices.build() : null;
    }

    public A withDevices(DeviceClaim devices) {
        this._visitables.remove("devices");
        if (devices != null) {
            this.devices = new DeviceClaimBuilder(devices);
            this._visitables.get("devices").add(this.devices);
        } else {
            this.devices = null;
            this._visitables.get("devices").remove(this.devices);
        }
        return (A)this;
    }

    public boolean hasDevices() {
        return this.devices != null;
    }

    public DevicesNested<A> withNewDevices() {
        return new DevicesNested(null);
    }

    public DevicesNested<A> withNewDevicesLike(DeviceClaim item) {
        return new DevicesNested(item);
    }

    public DevicesNested<A> editDevices() {
        return this.withNewDevicesLike(Optional.ofNullable(this.buildDevices()).orElse(null));
    }

    public DevicesNested<A> editOrNewDevices() {
        return this.withNewDevicesLike(Optional.ofNullable(this.buildDevices()).orElse(new DeviceClaimBuilder().build()));
    }

    public DevicesNested<A> editOrNewDevicesLike(DeviceClaim item) {
        return this.withNewDevicesLike(Optional.ofNullable(this.buildDevices()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceClaimSpecFluent that = (ResourceClaimSpecFluent)o;
        if (!Objects.equals(this.devices, that.devices)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.devices, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.devices != null) {
            sb.append("devices:");
            sb.append(this.devices + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DevicesNested<N>
    extends DeviceClaimFluent<DevicesNested<N>>
    implements Nested<N> {
        DeviceClaimBuilder builder;

        DevicesNested(DeviceClaim item) {
            this.builder = new DeviceClaimBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ResourceClaimSpecFluent.this.withDevices(this.builder.build());
        }

        public N endDevices() {
            return this.and();
        }
    }
}

