/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.NamedCertificate;
import io.fabric8.openshift.api.model.config.v1.NamedCertificateBuilder;
import io.fabric8.openshift.api.model.config.v1.NamedCertificateFluent;
import io.fabric8.openshift.api.model.config.v1.ServingInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ServingInfoFluent<A extends ServingInfoFluent<A>>
extends BaseFluent<A> {
    private String bindAddress;
    private String bindNetwork;
    private String certFile;
    private List<String> cipherSuites = new ArrayList<String>();
    private String clientCA;
    private String keyFile;
    private String minTLSVersion;
    private ArrayList<NamedCertificateBuilder> namedCertificates = new ArrayList();
    private Map<String, Object> additionalProperties;

    public ServingInfoFluent() {
    }

    public ServingInfoFluent(ServingInfo instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ServingInfo instance) {
        ServingInfo servingInfo = instance = instance != null ? instance : new ServingInfo();
        if (instance != null) {
            this.withBindAddress(instance.getBindAddress());
            this.withBindNetwork(instance.getBindNetwork());
            this.withCertFile(instance.getCertFile());
            this.withCipherSuites(instance.getCipherSuites());
            this.withClientCA(instance.getClientCA());
            this.withKeyFile(instance.getKeyFile());
            this.withMinTLSVersion(instance.getMinTLSVersion());
            this.withNamedCertificates(instance.getNamedCertificates());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public A withBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
        return (A)this;
    }

    public boolean hasBindAddress() {
        return this.bindAddress != null;
    }

    public String getBindNetwork() {
        return this.bindNetwork;
    }

    public A withBindNetwork(String bindNetwork) {
        this.bindNetwork = bindNetwork;
        return (A)this;
    }

    public boolean hasBindNetwork() {
        return this.bindNetwork != null;
    }

    public String getCertFile() {
        return this.certFile;
    }

    public A withCertFile(String certFile) {
        this.certFile = certFile;
        return (A)this;
    }

    public boolean hasCertFile() {
        return this.certFile != null;
    }

    public A addToCipherSuites(int index, String item) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<String>();
        }
        this.cipherSuites.add(index, item);
        return (A)this;
    }

    public A setToCipherSuites(int index, String item) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<String>();
        }
        this.cipherSuites.set(index, item);
        return (A)this;
    }

    public A addToCipherSuites(String ... items) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<String>();
        }
        for (String item : items) {
            this.cipherSuites.add(item);
        }
        return (A)this;
    }

    public A addAllToCipherSuites(Collection<String> items) {
        if (this.cipherSuites == null) {
            this.cipherSuites = new ArrayList<String>();
        }
        for (String item : items) {
            this.cipherSuites.add(item);
        }
        return (A)this;
    }

    public A removeFromCipherSuites(String ... items) {
        if (this.cipherSuites == null) {
            return (A)this;
        }
        for (String item : items) {
            this.cipherSuites.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromCipherSuites(Collection<String> items) {
        if (this.cipherSuites == null) {
            return (A)this;
        }
        for (String item : items) {
            this.cipherSuites.remove(item);
        }
        return (A)this;
    }

    public List<String> getCipherSuites() {
        return this.cipherSuites;
    }

    public String getCipherSuite(int index) {
        return this.cipherSuites.get(index);
    }

    public String getFirstCipherSuite() {
        return this.cipherSuites.get(0);
    }

    public String getLastCipherSuite() {
        return this.cipherSuites.get(this.cipherSuites.size() - 1);
    }

    public String getMatchingCipherSuite(Predicate<String> predicate) {
        for (String item : this.cipherSuites) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCipherSuite(Predicate<String> predicate) {
        for (String item : this.cipherSuites) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCipherSuites(List<String> cipherSuites) {
        if (cipherSuites != null) {
            this.cipherSuites = new ArrayList<String>();
            for (String item : cipherSuites) {
                this.addToCipherSuites(item);
            }
        } else {
            this.cipherSuites = null;
        }
        return (A)this;
    }

    public A withCipherSuites(String ... cipherSuites) {
        if (this.cipherSuites != null) {
            this.cipherSuites.clear();
            this._visitables.remove("cipherSuites");
        }
        if (cipherSuites != null) {
            for (String item : cipherSuites) {
                this.addToCipherSuites(item);
            }
        }
        return (A)this;
    }

    public boolean hasCipherSuites() {
        return this.cipherSuites != null && !this.cipherSuites.isEmpty();
    }

    public String getClientCA() {
        return this.clientCA;
    }

    public A withClientCA(String clientCA) {
        this.clientCA = clientCA;
        return (A)this;
    }

    public boolean hasClientCA() {
        return this.clientCA != null;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public A withKeyFile(String keyFile) {
        this.keyFile = keyFile;
        return (A)this;
    }

    public boolean hasKeyFile() {
        return this.keyFile != null;
    }

    public String getMinTLSVersion() {
        return this.minTLSVersion;
    }

    public A withMinTLSVersion(String minTLSVersion) {
        this.minTLSVersion = minTLSVersion;
        return (A)this;
    }

    public boolean hasMinTLSVersion() {
        return this.minTLSVersion != null;
    }

    public A addToNamedCertificates(int index, NamedCertificate item) {
        if (this.namedCertificates == null) {
            this.namedCertificates = new ArrayList();
        }
        NamedCertificateBuilder builder = new NamedCertificateBuilder(item);
        if (index < 0 || index >= this.namedCertificates.size()) {
            this._visitables.get("namedCertificates").add(builder);
            this.namedCertificates.add(builder);
        } else {
            this._visitables.get("namedCertificates").add(index, builder);
            this.namedCertificates.add(index, builder);
        }
        return (A)this;
    }

    public A setToNamedCertificates(int index, NamedCertificate item) {
        if (this.namedCertificates == null) {
            this.namedCertificates = new ArrayList();
        }
        NamedCertificateBuilder builder = new NamedCertificateBuilder(item);
        if (index < 0 || index >= this.namedCertificates.size()) {
            this._visitables.get("namedCertificates").add(builder);
            this.namedCertificates.add(builder);
        } else {
            this._visitables.get("namedCertificates").set(index, builder);
            this.namedCertificates.set(index, builder);
        }
        return (A)this;
    }

    public A addToNamedCertificates(NamedCertificate ... items) {
        if (this.namedCertificates == null) {
            this.namedCertificates = new ArrayList();
        }
        for (NamedCertificate item : items) {
            NamedCertificateBuilder builder = new NamedCertificateBuilder(item);
            this._visitables.get("namedCertificates").add(builder);
            this.namedCertificates.add(builder);
        }
        return (A)this;
    }

    public A addAllToNamedCertificates(Collection<NamedCertificate> items) {
        if (this.namedCertificates == null) {
            this.namedCertificates = new ArrayList();
        }
        for (NamedCertificate item : items) {
            NamedCertificateBuilder builder = new NamedCertificateBuilder(item);
            this._visitables.get("namedCertificates").add(builder);
            this.namedCertificates.add(builder);
        }
        return (A)this;
    }

    public A removeFromNamedCertificates(NamedCertificate ... items) {
        if (this.namedCertificates == null) {
            return (A)this;
        }
        for (NamedCertificate item : items) {
            NamedCertificateBuilder builder = new NamedCertificateBuilder(item);
            this._visitables.get("namedCertificates").remove(builder);
            this.namedCertificates.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromNamedCertificates(Collection<NamedCertificate> items) {
        if (this.namedCertificates == null) {
            return (A)this;
        }
        for (NamedCertificate item : items) {
            NamedCertificateBuilder builder = new NamedCertificateBuilder(item);
            this._visitables.get("namedCertificates").remove(builder);
            this.namedCertificates.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromNamedCertificates(Predicate<NamedCertificateBuilder> predicate) {
        if (this.namedCertificates == null) {
            return (A)this;
        }
        Iterator<NamedCertificateBuilder> each = this.namedCertificates.iterator();
        Object visitables = this._visitables.get("namedCertificates");
        while (each.hasNext()) {
            NamedCertificateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NamedCertificate> buildNamedCertificates() {
        return this.namedCertificates != null ? ServingInfoFluent.build(this.namedCertificates) : null;
    }

    public NamedCertificate buildNamedCertificate(int index) {
        return this.namedCertificates.get(index).build();
    }

    public NamedCertificate buildFirstNamedCertificate() {
        return this.namedCertificates.get(0).build();
    }

    public NamedCertificate buildLastNamedCertificate() {
        return this.namedCertificates.get(this.namedCertificates.size() - 1).build();
    }

    public NamedCertificate buildMatchingNamedCertificate(Predicate<NamedCertificateBuilder> predicate) {
        for (NamedCertificateBuilder item : this.namedCertificates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingNamedCertificate(Predicate<NamedCertificateBuilder> predicate) {
        for (NamedCertificateBuilder item : this.namedCertificates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNamedCertificates(List<NamedCertificate> namedCertificates) {
        if (this.namedCertificates != null) {
            this._visitables.get("namedCertificates").clear();
        }
        if (namedCertificates != null) {
            this.namedCertificates = new ArrayList();
            for (NamedCertificate item : namedCertificates) {
                this.addToNamedCertificates(item);
            }
        } else {
            this.namedCertificates = null;
        }
        return (A)this;
    }

    public A withNamedCertificates(NamedCertificate ... namedCertificates) {
        if (this.namedCertificates != null) {
            this.namedCertificates.clear();
            this._visitables.remove("namedCertificates");
        }
        if (namedCertificates != null) {
            for (NamedCertificate item : namedCertificates) {
                this.addToNamedCertificates(item);
            }
        }
        return (A)this;
    }

    public boolean hasNamedCertificates() {
        return this.namedCertificates != null && !this.namedCertificates.isEmpty();
    }

    public NamedCertificatesNested<A> addNewNamedCertificate() {
        return new NamedCertificatesNested(-1, null);
    }

    public NamedCertificatesNested<A> addNewNamedCertificateLike(NamedCertificate item) {
        return new NamedCertificatesNested(-1, item);
    }

    public NamedCertificatesNested<A> setNewNamedCertificateLike(int index, NamedCertificate item) {
        return new NamedCertificatesNested(index, item);
    }

    public NamedCertificatesNested<A> editNamedCertificate(int index) {
        if (this.namedCertificates.size() <= index) {
            throw new RuntimeException("Can't edit namedCertificates. Index exceeds size.");
        }
        return this.setNewNamedCertificateLike(index, this.buildNamedCertificate(index));
    }

    public NamedCertificatesNested<A> editFirstNamedCertificate() {
        if (this.namedCertificates.size() == 0) {
            throw new RuntimeException("Can't edit first namedCertificates. The list is empty.");
        }
        return this.setNewNamedCertificateLike(0, this.buildNamedCertificate(0));
    }

    public NamedCertificatesNested<A> editLastNamedCertificate() {
        int index = this.namedCertificates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last namedCertificates. The list is empty.");
        }
        return this.setNewNamedCertificateLike(index, this.buildNamedCertificate(index));
    }

    public NamedCertificatesNested<A> editMatchingNamedCertificate(Predicate<NamedCertificateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.namedCertificates.size(); ++i) {
            if (!predicate.test(this.namedCertificates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching namedCertificates. No match found.");
        }
        return this.setNewNamedCertificateLike(index, this.buildNamedCertificate(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServingInfoFluent that = (ServingInfoFluent)o;
        if (!Objects.equals(this.bindAddress, that.bindAddress)) {
            return false;
        }
        if (!Objects.equals(this.bindNetwork, that.bindNetwork)) {
            return false;
        }
        if (!Objects.equals(this.certFile, that.certFile)) {
            return false;
        }
        if (!Objects.equals(this.cipherSuites, that.cipherSuites)) {
            return false;
        }
        if (!Objects.equals(this.clientCA, that.clientCA)) {
            return false;
        }
        if (!Objects.equals(this.keyFile, that.keyFile)) {
            return false;
        }
        if (!Objects.equals(this.minTLSVersion, that.minTLSVersion)) {
            return false;
        }
        if (!Objects.equals(this.namedCertificates, that.namedCertificates)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.bindAddress, this.bindNetwork, this.certFile, this.cipherSuites, this.clientCA, this.keyFile, this.minTLSVersion, this.namedCertificates, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bindAddress != null) {
            sb.append("bindAddress:");
            sb.append(this.bindAddress + ",");
        }
        if (this.bindNetwork != null) {
            sb.append("bindNetwork:");
            sb.append(this.bindNetwork + ",");
        }
        if (this.certFile != null) {
            sb.append("certFile:");
            sb.append(this.certFile + ",");
        }
        if (this.cipherSuites != null && !this.cipherSuites.isEmpty()) {
            sb.append("cipherSuites:");
            sb.append(this.cipherSuites + ",");
        }
        if (this.clientCA != null) {
            sb.append("clientCA:");
            sb.append(this.clientCA + ",");
        }
        if (this.keyFile != null) {
            sb.append("keyFile:");
            sb.append(this.keyFile + ",");
        }
        if (this.minTLSVersion != null) {
            sb.append("minTLSVersion:");
            sb.append(this.minTLSVersion + ",");
        }
        if (this.namedCertificates != null && !this.namedCertificates.isEmpty()) {
            sb.append("namedCertificates:");
            sb.append(this.namedCertificates + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NamedCertificatesNested<N>
    extends NamedCertificateFluent<NamedCertificatesNested<N>>
    implements Nested<N> {
        NamedCertificateBuilder builder;
        int index;

        NamedCertificatesNested(int index, NamedCertificate item) {
            this.index = index;
            this.builder = new NamedCertificateBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ServingInfoFluent.this.setToNamedCertificates(this.index, this.builder.build());
        }

        public N endNamedCertificate() {
            return this.and();
        }
    }
}

