/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.aws.v1.Metadata;
import io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint;
import io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder;
import io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class MetadataFluent<A extends MetadataFluent<A>>
extends BaseFluent<A> {
    private String clusterDomain;
    private String hostedZoneRole;
    private List<Map<String, String>> identifier = new ArrayList<Map<String, String>>();
    private String region;
    private ArrayList<ServiceEndpointBuilder> serviceEndpoints = new ArrayList();
    private Map<String, Object> additionalProperties;

    public MetadataFluent() {
    }

    public MetadataFluent(Metadata instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Metadata instance) {
        Metadata metadata = instance = instance != null ? instance : new Metadata();
        if (instance != null) {
            this.withClusterDomain(instance.getClusterDomain());
            this.withHostedZoneRole(instance.getHostedZoneRole());
            this.withIdentifier(instance.getIdentifier());
            this.withRegion(instance.getRegion());
            this.withServiceEndpoints(instance.getServiceEndpoints());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getClusterDomain() {
        return this.clusterDomain;
    }

    public A withClusterDomain(String clusterDomain) {
        this.clusterDomain = clusterDomain;
        return (A)this;
    }

    public boolean hasClusterDomain() {
        return this.clusterDomain != null;
    }

    public String getHostedZoneRole() {
        return this.hostedZoneRole;
    }

    public A withHostedZoneRole(String hostedZoneRole) {
        this.hostedZoneRole = hostedZoneRole;
        return (A)this;
    }

    public boolean hasHostedZoneRole() {
        return this.hostedZoneRole != null;
    }

    public A addToIdentifier(int index, Map<String, String> item) {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Map<String, String>>();
        }
        this.identifier.add(index, item);
        return (A)this;
    }

    public A setToIdentifier(int index, Map<String, String> item) {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Map<String, String>>();
        }
        this.identifier.set(index, item);
        return (A)this;
    }

    public A addToIdentifier(Map<String, String> ... items) {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Map<String, String>>();
        }
        for (Map<String, String> item : items) {
            this.identifier.add(item);
        }
        return (A)this;
    }

    public A addAllToIdentifier(Collection<Map<String, String>> items) {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Map<String, String>>();
        }
        for (Map<String, String> item : items) {
            this.identifier.add(item);
        }
        return (A)this;
    }

    public A removeFromIdentifier(Map<String, String> ... items) {
        if (this.identifier == null) {
            return (A)this;
        }
        for (Map<String, String> item : items) {
            this.identifier.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromIdentifier(Collection<Map<String, String>> items) {
        if (this.identifier == null) {
            return (A)this;
        }
        for (Map<String, String> item : items) {
            this.identifier.remove(item);
        }
        return (A)this;
    }

    public List<Map<String, String>> getIdentifier() {
        return this.identifier;
    }

    public Map<String, String> getIdentifier(int index) {
        return this.identifier.get(index);
    }

    public Map<String, String> getFirstIdentifier() {
        return this.identifier.get(0);
    }

    public Map<String, String> getLastIdentifier() {
        return this.identifier.get(this.identifier.size() - 1);
    }

    public Map<String, String> getMatchingIdentifier(Predicate<Map<String, String>> predicate) {
        for (Map<String, String> item : this.identifier) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingIdentifier(Predicate<Map<String, String>> predicate) {
        for (Map<String, String> item : this.identifier) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public <K, V> A withIdentifier(List<Map<String, String>> identifier) {
        if (identifier != null) {
            this.identifier = new ArrayList<Map<String, String>>();
            for (Map<String, String> item : identifier) {
                this.addToIdentifier(item);
            }
        } else {
            this.identifier = null;
        }
        return (A)this;
    }

    public A withIdentifier(Map<String, String> ... identifier) {
        if (this.identifier != null) {
            this.identifier.clear();
            this._visitables.remove("identifier");
        }
        if (identifier != null) {
            for (Map<String, String> item : identifier) {
                this.addToIdentifier(item);
            }
        }
        return (A)this;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public String getRegion() {
        return this.region;
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public A addToServiceEndpoints(int index, ServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
        if (index < 0 || index >= this.serviceEndpoints.size()) {
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        } else {
            this._visitables.get("serviceEndpoints").add(index, builder);
            this.serviceEndpoints.add(index, builder);
        }
        return (A)this;
    }

    public A setToServiceEndpoints(int index, ServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
        if (index < 0 || index >= this.serviceEndpoints.size()) {
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        } else {
            this._visitables.get("serviceEndpoints").set(index, builder);
            this.serviceEndpoints.set(index, builder);
        }
        return (A)this;
    }

    public A addToServiceEndpoints(ServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        for (ServiceEndpoint item : items) {
            ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)this;
    }

    public A addAllToServiceEndpoints(Collection<ServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        for (ServiceEndpoint item : items) {
            ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)this;
    }

    public A removeFromServiceEndpoints(ServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        for (ServiceEndpoint item : items) {
            ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").remove(builder);
            this.serviceEndpoints.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromServiceEndpoints(Collection<ServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        for (ServiceEndpoint item : items) {
            ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").remove(builder);
            this.serviceEndpoints.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromServiceEndpoints(Predicate<ServiceEndpointBuilder> predicate) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        Iterator<ServiceEndpointBuilder> each = this.serviceEndpoints.iterator();
        Object visitables = this._visitables.get("serviceEndpoints");
        while (each.hasNext()) {
            ServiceEndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ServiceEndpoint> buildServiceEndpoints() {
        return this.serviceEndpoints != null ? MetadataFluent.build(this.serviceEndpoints) : null;
    }

    public ServiceEndpoint buildServiceEndpoint(int index) {
        return this.serviceEndpoints.get(index).build();
    }

    public ServiceEndpoint buildFirstServiceEndpoint() {
        return this.serviceEndpoints.get(0).build();
    }

    public ServiceEndpoint buildLastServiceEndpoint() {
        return this.serviceEndpoints.get(this.serviceEndpoints.size() - 1).build();
    }

    public ServiceEndpoint buildMatchingServiceEndpoint(Predicate<ServiceEndpointBuilder> predicate) {
        for (ServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingServiceEndpoint(Predicate<ServiceEndpointBuilder> predicate) {
        for (ServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServiceEndpoints(List<ServiceEndpoint> serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this._visitables.get("serviceEndpoints").clear();
        }
        if (serviceEndpoints != null) {
            this.serviceEndpoints = new ArrayList();
            for (ServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        } else {
            this.serviceEndpoints = null;
        }
        return (A)this;
    }

    public A withServiceEndpoints(ServiceEndpoint ... serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this.serviceEndpoints.clear();
            this._visitables.remove("serviceEndpoints");
        }
        if (serviceEndpoints != null) {
            for (ServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        }
        return (A)this;
    }

    public boolean hasServiceEndpoints() {
        return this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty();
    }

    public A addNewServiceEndpoint(String name, String url) {
        return this.addToServiceEndpoints(new ServiceEndpoint(name, url));
    }

    public ServiceEndpointsNested<A> addNewServiceEndpoint() {
        return new ServiceEndpointsNested(-1, null);
    }

    public ServiceEndpointsNested<A> addNewServiceEndpointLike(ServiceEndpoint item) {
        return new ServiceEndpointsNested(-1, item);
    }

    public ServiceEndpointsNested<A> setNewServiceEndpointLike(int index, ServiceEndpoint item) {
        return new ServiceEndpointsNested(index, item);
    }

    public ServiceEndpointsNested<A> editServiceEndpoint(int index) {
        if (this.serviceEndpoints.size() <= index) {
            throw new RuntimeException("Can't edit serviceEndpoints. Index exceeds size.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public ServiceEndpointsNested<A> editFirstServiceEndpoint() {
        if (this.serviceEndpoints.size() == 0) {
            throw new RuntimeException("Can't edit first serviceEndpoints. The list is empty.");
        }
        return this.setNewServiceEndpointLike(0, this.buildServiceEndpoint(0));
    }

    public ServiceEndpointsNested<A> editLastServiceEndpoint() {
        int index = this.serviceEndpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last serviceEndpoints. The list is empty.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<ServiceEndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.serviceEndpoints.size(); ++i) {
            if (!predicate.test(this.serviceEndpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching serviceEndpoints. No match found.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MetadataFluent that = (MetadataFluent)o;
        if (!Objects.equals(this.clusterDomain, that.clusterDomain)) {
            return false;
        }
        if (!Objects.equals(this.hostedZoneRole, that.hostedZoneRole)) {
            return false;
        }
        if (!Objects.equals(this.identifier, that.identifier)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.serviceEndpoints, that.serviceEndpoints)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clusterDomain, this.hostedZoneRole, this.identifier, this.region, this.serviceEndpoints, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterDomain != null) {
            sb.append("clusterDomain:");
            sb.append(this.clusterDomain + ",");
        }
        if (this.hostedZoneRole != null) {
            sb.append("hostedZoneRole:");
            sb.append(this.hostedZoneRole + ",");
        }
        if (this.identifier != null && !this.identifier.isEmpty()) {
            sb.append("identifier:");
            sb.append(this.identifier + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty()) {
            sb.append("serviceEndpoints:");
            sb.append(this.serviceEndpoints + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ServiceEndpointsNested<N>
    extends ServiceEndpointFluent<ServiceEndpointsNested<N>>
    implements Nested<N> {
        ServiceEndpointBuilder builder;
        int index;

        ServiceEndpointsNested(int index, ServiceEndpoint item) {
            this.index = index;
            this.builder = new ServiceEndpointBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MetadataFluent.this.setToServiceEndpoints(this.index, this.builder.build());
        }

        public N endServiceEndpoint() {
            return this.and();
        }
    }
}

