/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.machine.v1.AlibabaCloudMachineProviderConfig;
import io.fabric8.openshift.api.model.machine.v1.AlibabaResourceReference;
import io.fabric8.openshift.api.model.machine.v1.AlibabaResourceReferenceBuilder;
import io.fabric8.openshift.api.model.machine.v1.AlibabaResourceReferenceFluent;
import io.fabric8.openshift.api.model.machine.v1.BandwidthProperties;
import io.fabric8.openshift.api.model.machine.v1.BandwidthPropertiesBuilder;
import io.fabric8.openshift.api.model.machine.v1.BandwidthPropertiesFluent;
import io.fabric8.openshift.api.model.machine.v1.DataDiskProperties;
import io.fabric8.openshift.api.model.machine.v1.DataDiskPropertiesBuilder;
import io.fabric8.openshift.api.model.machine.v1.DataDiskPropertiesFluent;
import io.fabric8.openshift.api.model.machine.v1.SystemDiskProperties;
import io.fabric8.openshift.api.model.machine.v1.SystemDiskPropertiesBuilder;
import io.fabric8.openshift.api.model.machine.v1.SystemDiskPropertiesFluent;
import io.fabric8.openshift.api.model.machine.v1.Tag;
import io.fabric8.openshift.api.model.machine.v1.TagBuilder;
import io.fabric8.openshift.api.model.machine.v1.TagFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class AlibabaCloudMachineProviderConfigFluent<A extends AlibabaCloudMachineProviderConfigFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private BandwidthPropertiesBuilder bandwidth;
    private LocalObjectReferenceBuilder credentialsSecret;
    private ArrayList<DataDiskPropertiesBuilder> dataDisk = new ArrayList();
    private String imageId;
    private String instanceType;
    private String kind;
    private ObjectMetaBuilder metadata;
    private String ramRoleName;
    private String regionId;
    private AlibabaResourceReferenceBuilder resourceGroup;
    private ArrayList<AlibabaResourceReferenceBuilder> securityGroups = new ArrayList();
    private SystemDiskPropertiesBuilder systemDisk;
    private ArrayList<TagBuilder> tag = new ArrayList();
    private String tenancy;
    private LocalObjectReferenceBuilder userDataSecret;
    private AlibabaResourceReferenceBuilder vSwitch;
    private String vpcId;
    private String zoneId;
    private Map<String, Object> additionalProperties;

    public AlibabaCloudMachineProviderConfigFluent() {
    }

    public AlibabaCloudMachineProviderConfigFluent(AlibabaCloudMachineProviderConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AlibabaCloudMachineProviderConfig instance) {
        AlibabaCloudMachineProviderConfig alibabaCloudMachineProviderConfig = instance = instance != null ? instance : new AlibabaCloudMachineProviderConfig();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withBandwidth(instance.getBandwidth());
            this.withCredentialsSecret(instance.getCredentialsSecret());
            this.withDataDisk(instance.getDataDisk());
            this.withImageId(instance.getImageId());
            this.withInstanceType(instance.getInstanceType());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withRamRoleName(instance.getRamRoleName());
            this.withRegionId(instance.getRegionId());
            this.withResourceGroup(instance.getResourceGroup());
            this.withSecurityGroups(instance.getSecurityGroups());
            this.withSystemDisk(instance.getSystemDisk());
            this.withTag(instance.getTag());
            this.withTenancy(instance.getTenancy());
            this.withUserDataSecret(instance.getUserDataSecret());
            this.withVSwitch(instance.getVSwitch());
            this.withVpcId(instance.getVpcId());
            this.withZoneId(instance.getZoneId());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public BandwidthProperties buildBandwidth() {
        return this.bandwidth != null ? this.bandwidth.build() : null;
    }

    public A withBandwidth(BandwidthProperties bandwidth) {
        this._visitables.remove("bandwidth");
        if (bandwidth != null) {
            this.bandwidth = new BandwidthPropertiesBuilder(bandwidth);
            this._visitables.get("bandwidth").add(this.bandwidth);
        } else {
            this.bandwidth = null;
            this._visitables.get("bandwidth").remove(this.bandwidth);
        }
        return (A)this;
    }

    public boolean hasBandwidth() {
        return this.bandwidth != null;
    }

    public A withNewBandwidth(Long internetMaxBandwidthIn, Long internetMaxBandwidthOut) {
        return this.withBandwidth(new BandwidthProperties(internetMaxBandwidthIn, internetMaxBandwidthOut));
    }

    public BandwidthNested<A> withNewBandwidth() {
        return new BandwidthNested(null);
    }

    public BandwidthNested<A> withNewBandwidthLike(BandwidthProperties item) {
        return new BandwidthNested(item);
    }

    public BandwidthNested<A> editBandwidth() {
        return this.withNewBandwidthLike(Optional.ofNullable(this.buildBandwidth()).orElse(null));
    }

    public BandwidthNested<A> editOrNewBandwidth() {
        return this.withNewBandwidthLike(Optional.ofNullable(this.buildBandwidth()).orElse(new BandwidthPropertiesBuilder().build()));
    }

    public BandwidthNested<A> editOrNewBandwidthLike(BandwidthProperties item) {
        return this.withNewBandwidthLike(Optional.ofNullable(this.buildBandwidth()).orElse(item));
    }

    public LocalObjectReference buildCredentialsSecret() {
        return this.credentialsSecret != null ? this.credentialsSecret.build() : null;
    }

    public A withCredentialsSecret(LocalObjectReference credentialsSecret) {
        this._visitables.remove("credentialsSecret");
        if (credentialsSecret != null) {
            this.credentialsSecret = new LocalObjectReferenceBuilder(credentialsSecret);
            this._visitables.get("credentialsSecret").add(this.credentialsSecret);
        } else {
            this.credentialsSecret = null;
            this._visitables.get("credentialsSecret").remove(this.credentialsSecret);
        }
        return (A)this;
    }

    public boolean hasCredentialsSecret() {
        return this.credentialsSecret != null;
    }

    public A withNewCredentialsSecret(String name) {
        return this.withCredentialsSecret(new LocalObjectReference(name));
    }

    public CredentialsSecretNested<A> withNewCredentialsSecret() {
        return new CredentialsSecretNested(null);
    }

    public CredentialsSecretNested<A> withNewCredentialsSecretLike(LocalObjectReference item) {
        return new CredentialsSecretNested(item);
    }

    public CredentialsSecretNested<A> editCredentialsSecret() {
        return this.withNewCredentialsSecretLike(Optional.ofNullable(this.buildCredentialsSecret()).orElse(null));
    }

    public CredentialsSecretNested<A> editOrNewCredentialsSecret() {
        return this.withNewCredentialsSecretLike(Optional.ofNullable(this.buildCredentialsSecret()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public CredentialsSecretNested<A> editOrNewCredentialsSecretLike(LocalObjectReference item) {
        return this.withNewCredentialsSecretLike(Optional.ofNullable(this.buildCredentialsSecret()).orElse(item));
    }

    public A addToDataDisk(int index, DataDiskProperties item) {
        if (this.dataDisk == null) {
            this.dataDisk = new ArrayList();
        }
        DataDiskPropertiesBuilder builder = new DataDiskPropertiesBuilder(item);
        if (index < 0 || index >= this.dataDisk.size()) {
            this._visitables.get("dataDisk").add(builder);
            this.dataDisk.add(builder);
        } else {
            this._visitables.get("dataDisk").add(index, builder);
            this.dataDisk.add(index, builder);
        }
        return (A)this;
    }

    public A setToDataDisk(int index, DataDiskProperties item) {
        if (this.dataDisk == null) {
            this.dataDisk = new ArrayList();
        }
        DataDiskPropertiesBuilder builder = new DataDiskPropertiesBuilder(item);
        if (index < 0 || index >= this.dataDisk.size()) {
            this._visitables.get("dataDisk").add(builder);
            this.dataDisk.add(builder);
        } else {
            this._visitables.get("dataDisk").set(index, builder);
            this.dataDisk.set(index, builder);
        }
        return (A)this;
    }

    public A addToDataDisk(DataDiskProperties ... items) {
        if (this.dataDisk == null) {
            this.dataDisk = new ArrayList();
        }
        for (DataDiskProperties item : items) {
            DataDiskPropertiesBuilder builder = new DataDiskPropertiesBuilder(item);
            this._visitables.get("dataDisk").add(builder);
            this.dataDisk.add(builder);
        }
        return (A)this;
    }

    public A addAllToDataDisk(Collection<DataDiskProperties> items) {
        if (this.dataDisk == null) {
            this.dataDisk = new ArrayList();
        }
        for (DataDiskProperties item : items) {
            DataDiskPropertiesBuilder builder = new DataDiskPropertiesBuilder(item);
            this._visitables.get("dataDisk").add(builder);
            this.dataDisk.add(builder);
        }
        return (A)this;
    }

    public A removeFromDataDisk(DataDiskProperties ... items) {
        if (this.dataDisk == null) {
            return (A)this;
        }
        for (DataDiskProperties item : items) {
            DataDiskPropertiesBuilder builder = new DataDiskPropertiesBuilder(item);
            this._visitables.get("dataDisk").remove(builder);
            this.dataDisk.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromDataDisk(Collection<DataDiskProperties> items) {
        if (this.dataDisk == null) {
            return (A)this;
        }
        for (DataDiskProperties item : items) {
            DataDiskPropertiesBuilder builder = new DataDiskPropertiesBuilder(item);
            this._visitables.get("dataDisk").remove(builder);
            this.dataDisk.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromDataDisk(Predicate<DataDiskPropertiesBuilder> predicate) {
        if (this.dataDisk == null) {
            return (A)this;
        }
        Iterator<DataDiskPropertiesBuilder> each = this.dataDisk.iterator();
        Object visitables = this._visitables.get("dataDisk");
        while (each.hasNext()) {
            DataDiskPropertiesBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<DataDiskProperties> buildDataDisk() {
        return this.dataDisk != null ? AlibabaCloudMachineProviderConfigFluent.build(this.dataDisk) : null;
    }

    public DataDiskProperties buildDataDisk(int index) {
        return this.dataDisk.get(index).build();
    }

    public DataDiskProperties buildFirstDataDisk() {
        return this.dataDisk.get(0).build();
    }

    public DataDiskProperties buildLastDataDisk() {
        return this.dataDisk.get(this.dataDisk.size() - 1).build();
    }

    public DataDiskProperties buildMatchingDataDisk(Predicate<DataDiskPropertiesBuilder> predicate) {
        for (DataDiskPropertiesBuilder item : this.dataDisk) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDataDisk(Predicate<DataDiskPropertiesBuilder> predicate) {
        for (DataDiskPropertiesBuilder item : this.dataDisk) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDataDisk(List<DataDiskProperties> dataDisk) {
        if (this.dataDisk != null) {
            this._visitables.get("dataDisk").clear();
        }
        if (dataDisk != null) {
            this.dataDisk = new ArrayList();
            for (DataDiskProperties item : dataDisk) {
                this.addToDataDisk(item);
            }
        } else {
            this.dataDisk = null;
        }
        return (A)this;
    }

    public A withDataDisk(DataDiskProperties ... dataDisk) {
        if (this.dataDisk != null) {
            this.dataDisk.clear();
            this._visitables.remove("dataDisk");
        }
        if (dataDisk != null) {
            for (DataDiskProperties item : dataDisk) {
                this.addToDataDisk(item);
            }
        }
        return (A)this;
    }

    public boolean hasDataDisk() {
        return this.dataDisk != null && !this.dataDisk.isEmpty();
    }

    public DataDiskNested<A> addNewDataDisk() {
        return new DataDiskNested(-1, null);
    }

    public DataDiskNested<A> addNewDataDiskLike(DataDiskProperties item) {
        return new DataDiskNested(-1, item);
    }

    public DataDiskNested<A> setNewDataDiskLike(int index, DataDiskProperties item) {
        return new DataDiskNested(index, item);
    }

    public DataDiskNested<A> editDataDisk(int index) {
        if (this.dataDisk.size() <= index) {
            throw new RuntimeException("Can't edit dataDisk. Index exceeds size.");
        }
        return this.setNewDataDiskLike(index, this.buildDataDisk(index));
    }

    public DataDiskNested<A> editFirstDataDisk() {
        if (this.dataDisk.size() == 0) {
            throw new RuntimeException("Can't edit first dataDisk. The list is empty.");
        }
        return this.setNewDataDiskLike(0, this.buildDataDisk(0));
    }

    public DataDiskNested<A> editLastDataDisk() {
        int index = this.dataDisk.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dataDisk. The list is empty.");
        }
        return this.setNewDataDiskLike(index, this.buildDataDisk(index));
    }

    public DataDiskNested<A> editMatchingDataDisk(Predicate<DataDiskPropertiesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dataDisk.size(); ++i) {
            if (!predicate.test(this.dataDisk.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dataDisk. No match found.");
        }
        return this.setNewDataDiskLike(index, this.buildDataDisk(index));
    }

    public String getImageId() {
        return this.imageId;
    }

    public A withImageId(String imageId) {
        this.imageId = imageId;
        return (A)this;
    }

    public boolean hasImageId() {
        return this.imageId != null;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public A withInstanceType(String instanceType) {
        this.instanceType = instanceType;
        return (A)this;
    }

    public boolean hasInstanceType() {
        return this.instanceType != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public String getRamRoleName() {
        return this.ramRoleName;
    }

    public A withRamRoleName(String ramRoleName) {
        this.ramRoleName = ramRoleName;
        return (A)this;
    }

    public boolean hasRamRoleName() {
        return this.ramRoleName != null;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public A withRegionId(String regionId) {
        this.regionId = regionId;
        return (A)this;
    }

    public boolean hasRegionId() {
        return this.regionId != null;
    }

    public AlibabaResourceReference buildResourceGroup() {
        return this.resourceGroup != null ? this.resourceGroup.build() : null;
    }

    public A withResourceGroup(AlibabaResourceReference resourceGroup) {
        this._visitables.remove("resourceGroup");
        if (resourceGroup != null) {
            this.resourceGroup = new AlibabaResourceReferenceBuilder(resourceGroup);
            this._visitables.get("resourceGroup").add(this.resourceGroup);
        } else {
            this.resourceGroup = null;
            this._visitables.get("resourceGroup").remove(this.resourceGroup);
        }
        return (A)this;
    }

    public boolean hasResourceGroup() {
        return this.resourceGroup != null;
    }

    public ResourceGroupNested<A> withNewResourceGroup() {
        return new ResourceGroupNested(null);
    }

    public ResourceGroupNested<A> withNewResourceGroupLike(AlibabaResourceReference item) {
        return new ResourceGroupNested(item);
    }

    public ResourceGroupNested<A> editResourceGroup() {
        return this.withNewResourceGroupLike(Optional.ofNullable(this.buildResourceGroup()).orElse(null));
    }

    public ResourceGroupNested<A> editOrNewResourceGroup() {
        return this.withNewResourceGroupLike(Optional.ofNullable(this.buildResourceGroup()).orElse(new AlibabaResourceReferenceBuilder().build()));
    }

    public ResourceGroupNested<A> editOrNewResourceGroupLike(AlibabaResourceReference item) {
        return this.withNewResourceGroupLike(Optional.ofNullable(this.buildResourceGroup()).orElse(item));
    }

    public A addToSecurityGroups(int index, AlibabaResourceReference item) {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList();
        }
        AlibabaResourceReferenceBuilder builder = new AlibabaResourceReferenceBuilder(item);
        if (index < 0 || index >= this.securityGroups.size()) {
            this._visitables.get("securityGroups").add(builder);
            this.securityGroups.add(builder);
        } else {
            this._visitables.get("securityGroups").add(index, builder);
            this.securityGroups.add(index, builder);
        }
        return (A)this;
    }

    public A setToSecurityGroups(int index, AlibabaResourceReference item) {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList();
        }
        AlibabaResourceReferenceBuilder builder = new AlibabaResourceReferenceBuilder(item);
        if (index < 0 || index >= this.securityGroups.size()) {
            this._visitables.get("securityGroups").add(builder);
            this.securityGroups.add(builder);
        } else {
            this._visitables.get("securityGroups").set(index, builder);
            this.securityGroups.set(index, builder);
        }
        return (A)this;
    }

    public A addToSecurityGroups(AlibabaResourceReference ... items) {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList();
        }
        for (AlibabaResourceReference item : items) {
            AlibabaResourceReferenceBuilder builder = new AlibabaResourceReferenceBuilder(item);
            this._visitables.get("securityGroups").add(builder);
            this.securityGroups.add(builder);
        }
        return (A)this;
    }

    public A addAllToSecurityGroups(Collection<AlibabaResourceReference> items) {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList();
        }
        for (AlibabaResourceReference item : items) {
            AlibabaResourceReferenceBuilder builder = new AlibabaResourceReferenceBuilder(item);
            this._visitables.get("securityGroups").add(builder);
            this.securityGroups.add(builder);
        }
        return (A)this;
    }

    public A removeFromSecurityGroups(AlibabaResourceReference ... items) {
        if (this.securityGroups == null) {
            return (A)this;
        }
        for (AlibabaResourceReference item : items) {
            AlibabaResourceReferenceBuilder builder = new AlibabaResourceReferenceBuilder(item);
            this._visitables.get("securityGroups").remove(builder);
            this.securityGroups.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromSecurityGroups(Collection<AlibabaResourceReference> items) {
        if (this.securityGroups == null) {
            return (A)this;
        }
        for (AlibabaResourceReference item : items) {
            AlibabaResourceReferenceBuilder builder = new AlibabaResourceReferenceBuilder(item);
            this._visitables.get("securityGroups").remove(builder);
            this.securityGroups.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromSecurityGroups(Predicate<AlibabaResourceReferenceBuilder> predicate) {
        if (this.securityGroups == null) {
            return (A)this;
        }
        Iterator<AlibabaResourceReferenceBuilder> each = this.securityGroups.iterator();
        Object visitables = this._visitables.get("securityGroups");
        while (each.hasNext()) {
            AlibabaResourceReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<AlibabaResourceReference> buildSecurityGroups() {
        return this.securityGroups != null ? AlibabaCloudMachineProviderConfigFluent.build(this.securityGroups) : null;
    }

    public AlibabaResourceReference buildSecurityGroup(int index) {
        return this.securityGroups.get(index).build();
    }

    public AlibabaResourceReference buildFirstSecurityGroup() {
        return this.securityGroups.get(0).build();
    }

    public AlibabaResourceReference buildLastSecurityGroup() {
        return this.securityGroups.get(this.securityGroups.size() - 1).build();
    }

    public AlibabaResourceReference buildMatchingSecurityGroup(Predicate<AlibabaResourceReferenceBuilder> predicate) {
        for (AlibabaResourceReferenceBuilder item : this.securityGroups) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSecurityGroup(Predicate<AlibabaResourceReferenceBuilder> predicate) {
        for (AlibabaResourceReferenceBuilder item : this.securityGroups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSecurityGroups(List<AlibabaResourceReference> securityGroups) {
        if (this.securityGroups != null) {
            this._visitables.get("securityGroups").clear();
        }
        if (securityGroups != null) {
            this.securityGroups = new ArrayList();
            for (AlibabaResourceReference item : securityGroups) {
                this.addToSecurityGroups(item);
            }
        } else {
            this.securityGroups = null;
        }
        return (A)this;
    }

    public A withSecurityGroups(AlibabaResourceReference ... securityGroups) {
        if (this.securityGroups != null) {
            this.securityGroups.clear();
            this._visitables.remove("securityGroups");
        }
        if (securityGroups != null) {
            for (AlibabaResourceReference item : securityGroups) {
                this.addToSecurityGroups(item);
            }
        }
        return (A)this;
    }

    public boolean hasSecurityGroups() {
        return this.securityGroups != null && !this.securityGroups.isEmpty();
    }

    public SecurityGroupsNested<A> addNewSecurityGroup() {
        return new SecurityGroupsNested(-1, null);
    }

    public SecurityGroupsNested<A> addNewSecurityGroupLike(AlibabaResourceReference item) {
        return new SecurityGroupsNested(-1, item);
    }

    public SecurityGroupsNested<A> setNewSecurityGroupLike(int index, AlibabaResourceReference item) {
        return new SecurityGroupsNested(index, item);
    }

    public SecurityGroupsNested<A> editSecurityGroup(int index) {
        if (this.securityGroups.size() <= index) {
            throw new RuntimeException("Can't edit securityGroups. Index exceeds size.");
        }
        return this.setNewSecurityGroupLike(index, this.buildSecurityGroup(index));
    }

    public SecurityGroupsNested<A> editFirstSecurityGroup() {
        if (this.securityGroups.size() == 0) {
            throw new RuntimeException("Can't edit first securityGroups. The list is empty.");
        }
        return this.setNewSecurityGroupLike(0, this.buildSecurityGroup(0));
    }

    public SecurityGroupsNested<A> editLastSecurityGroup() {
        int index = this.securityGroups.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last securityGroups. The list is empty.");
        }
        return this.setNewSecurityGroupLike(index, this.buildSecurityGroup(index));
    }

    public SecurityGroupsNested<A> editMatchingSecurityGroup(Predicate<AlibabaResourceReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.securityGroups.size(); ++i) {
            if (!predicate.test(this.securityGroups.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching securityGroups. No match found.");
        }
        return this.setNewSecurityGroupLike(index, this.buildSecurityGroup(index));
    }

    public SystemDiskProperties buildSystemDisk() {
        return this.systemDisk != null ? this.systemDisk.build() : null;
    }

    public A withSystemDisk(SystemDiskProperties systemDisk) {
        this._visitables.remove("systemDisk");
        if (systemDisk != null) {
            this.systemDisk = new SystemDiskPropertiesBuilder(systemDisk);
            this._visitables.get("systemDisk").add(this.systemDisk);
        } else {
            this.systemDisk = null;
            this._visitables.get("systemDisk").remove(this.systemDisk);
        }
        return (A)this;
    }

    public boolean hasSystemDisk() {
        return this.systemDisk != null;
    }

    public A withNewSystemDisk(String category, String name, String performanceLevel, Long size) {
        return this.withSystemDisk(new SystemDiskProperties(category, name, performanceLevel, size));
    }

    public SystemDiskNested<A> withNewSystemDisk() {
        return new SystemDiskNested(null);
    }

    public SystemDiskNested<A> withNewSystemDiskLike(SystemDiskProperties item) {
        return new SystemDiskNested(item);
    }

    public SystemDiskNested<A> editSystemDisk() {
        return this.withNewSystemDiskLike(Optional.ofNullable(this.buildSystemDisk()).orElse(null));
    }

    public SystemDiskNested<A> editOrNewSystemDisk() {
        return this.withNewSystemDiskLike(Optional.ofNullable(this.buildSystemDisk()).orElse(new SystemDiskPropertiesBuilder().build()));
    }

    public SystemDiskNested<A> editOrNewSystemDiskLike(SystemDiskProperties item) {
        return this.withNewSystemDiskLike(Optional.ofNullable(this.buildSystemDisk()).orElse(item));
    }

    public A addToTag(int index, Tag item) {
        if (this.tag == null) {
            this.tag = new ArrayList();
        }
        TagBuilder builder = new TagBuilder(item);
        if (index < 0 || index >= this.tag.size()) {
            this._visitables.get("tag").add(builder);
            this.tag.add(builder);
        } else {
            this._visitables.get("tag").add(index, builder);
            this.tag.add(index, builder);
        }
        return (A)this;
    }

    public A setToTag(int index, Tag item) {
        if (this.tag == null) {
            this.tag = new ArrayList();
        }
        TagBuilder builder = new TagBuilder(item);
        if (index < 0 || index >= this.tag.size()) {
            this._visitables.get("tag").add(builder);
            this.tag.add(builder);
        } else {
            this._visitables.get("tag").set(index, builder);
            this.tag.set(index, builder);
        }
        return (A)this;
    }

    public A addToTag(Tag ... items) {
        if (this.tag == null) {
            this.tag = new ArrayList();
        }
        for (Tag item : items) {
            TagBuilder builder = new TagBuilder(item);
            this._visitables.get("tag").add(builder);
            this.tag.add(builder);
        }
        return (A)this;
    }

    public A addAllToTag(Collection<Tag> items) {
        if (this.tag == null) {
            this.tag = new ArrayList();
        }
        for (Tag item : items) {
            TagBuilder builder = new TagBuilder(item);
            this._visitables.get("tag").add(builder);
            this.tag.add(builder);
        }
        return (A)this;
    }

    public A removeFromTag(Tag ... items) {
        if (this.tag == null) {
            return (A)this;
        }
        for (Tag item : items) {
            TagBuilder builder = new TagBuilder(item);
            this._visitables.get("tag").remove(builder);
            this.tag.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromTag(Collection<Tag> items) {
        if (this.tag == null) {
            return (A)this;
        }
        for (Tag item : items) {
            TagBuilder builder = new TagBuilder(item);
            this._visitables.get("tag").remove(builder);
            this.tag.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromTag(Predicate<TagBuilder> predicate) {
        if (this.tag == null) {
            return (A)this;
        }
        Iterator<TagBuilder> each = this.tag.iterator();
        Object visitables = this._visitables.get("tag");
        while (each.hasNext()) {
            TagBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Tag> buildTag() {
        return this.tag != null ? AlibabaCloudMachineProviderConfigFluent.build(this.tag) : null;
    }

    public Tag buildTag(int index) {
        return this.tag.get(index).build();
    }

    public Tag buildFirstTag() {
        return this.tag.get(0).build();
    }

    public Tag buildLastTag() {
        return this.tag.get(this.tag.size() - 1).build();
    }

    public Tag buildMatchingTag(Predicate<TagBuilder> predicate) {
        for (TagBuilder item : this.tag) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTag(Predicate<TagBuilder> predicate) {
        for (TagBuilder item : this.tag) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTag(List<Tag> tag) {
        if (this.tag != null) {
            this._visitables.get("tag").clear();
        }
        if (tag != null) {
            this.tag = new ArrayList();
            for (Tag item : tag) {
                this.addToTag(item);
            }
        } else {
            this.tag = null;
        }
        return (A)this;
    }

    public A withTag(Tag ... tag) {
        if (this.tag != null) {
            this.tag.clear();
            this._visitables.remove("tag");
        }
        if (tag != null) {
            for (Tag item : tag) {
                this.addToTag(item);
            }
        }
        return (A)this;
    }

    public boolean hasTag() {
        return this.tag != null && !this.tag.isEmpty();
    }

    public A addNewTag(String key, String value) {
        return this.addToTag(new Tag(key, value));
    }

    public TagNested<A> addNewTag() {
        return new TagNested(-1, null);
    }

    public TagNested<A> addNewTagLike(Tag item) {
        return new TagNested(-1, item);
    }

    public TagNested<A> setNewTagLike(int index, Tag item) {
        return new TagNested(index, item);
    }

    public TagNested<A> editTag(int index) {
        if (this.tag.size() <= index) {
            throw new RuntimeException("Can't edit tag. Index exceeds size.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    public TagNested<A> editFirstTag() {
        if (this.tag.size() == 0) {
            throw new RuntimeException("Can't edit first tag. The list is empty.");
        }
        return this.setNewTagLike(0, this.buildTag(0));
    }

    public TagNested<A> editLastTag() {
        int index = this.tag.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tag. The list is empty.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    public TagNested<A> editMatchingTag(Predicate<TagBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tag.size(); ++i) {
            if (!predicate.test(this.tag.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tag. No match found.");
        }
        return this.setNewTagLike(index, this.buildTag(index));
    }

    public String getTenancy() {
        return this.tenancy;
    }

    public A withTenancy(String tenancy) {
        this.tenancy = tenancy;
        return (A)this;
    }

    public boolean hasTenancy() {
        return this.tenancy != null;
    }

    public LocalObjectReference buildUserDataSecret() {
        return this.userDataSecret != null ? this.userDataSecret.build() : null;
    }

    public A withUserDataSecret(LocalObjectReference userDataSecret) {
        this._visitables.remove("userDataSecret");
        if (userDataSecret != null) {
            this.userDataSecret = new LocalObjectReferenceBuilder(userDataSecret);
            this._visitables.get("userDataSecret").add(this.userDataSecret);
        } else {
            this.userDataSecret = null;
            this._visitables.get("userDataSecret").remove(this.userDataSecret);
        }
        return (A)this;
    }

    public boolean hasUserDataSecret() {
        return this.userDataSecret != null;
    }

    public A withNewUserDataSecret(String name) {
        return this.withUserDataSecret(new LocalObjectReference(name));
    }

    public UserDataSecretNested<A> withNewUserDataSecret() {
        return new UserDataSecretNested(null);
    }

    public UserDataSecretNested<A> withNewUserDataSecretLike(LocalObjectReference item) {
        return new UserDataSecretNested(item);
    }

    public UserDataSecretNested<A> editUserDataSecret() {
        return this.withNewUserDataSecretLike(Optional.ofNullable(this.buildUserDataSecret()).orElse(null));
    }

    public UserDataSecretNested<A> editOrNewUserDataSecret() {
        return this.withNewUserDataSecretLike(Optional.ofNullable(this.buildUserDataSecret()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public UserDataSecretNested<A> editOrNewUserDataSecretLike(LocalObjectReference item) {
        return this.withNewUserDataSecretLike(Optional.ofNullable(this.buildUserDataSecret()).orElse(item));
    }

    public AlibabaResourceReference buildVSwitch() {
        return this.vSwitch != null ? this.vSwitch.build() : null;
    }

    public A withVSwitch(AlibabaResourceReference vSwitch) {
        this._visitables.remove("vSwitch");
        if (vSwitch != null) {
            this.vSwitch = new AlibabaResourceReferenceBuilder(vSwitch);
            this._visitables.get("vSwitch").add(this.vSwitch);
        } else {
            this.vSwitch = null;
            this._visitables.get("vSwitch").remove(this.vSwitch);
        }
        return (A)this;
    }

    public boolean hasVSwitch() {
        return this.vSwitch != null;
    }

    public VSwitchNested<A> withNewVSwitch() {
        return new VSwitchNested(null);
    }

    public VSwitchNested<A> withNewVSwitchLike(AlibabaResourceReference item) {
        return new VSwitchNested(item);
    }

    public VSwitchNested<A> editVSwitch() {
        return this.withNewVSwitchLike(Optional.ofNullable(this.buildVSwitch()).orElse(null));
    }

    public VSwitchNested<A> editOrNewVSwitch() {
        return this.withNewVSwitchLike(Optional.ofNullable(this.buildVSwitch()).orElse(new AlibabaResourceReferenceBuilder().build()));
    }

    public VSwitchNested<A> editOrNewVSwitchLike(AlibabaResourceReference item) {
        return this.withNewVSwitchLike(Optional.ofNullable(this.buildVSwitch()).orElse(item));
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public A withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return (A)this;
    }

    public boolean hasVpcId() {
        return this.vpcId != null;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public A withZoneId(String zoneId) {
        this.zoneId = zoneId;
        return (A)this;
    }

    public boolean hasZoneId() {
        return this.zoneId != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlibabaCloudMachineProviderConfigFluent that = (AlibabaCloudMachineProviderConfigFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.bandwidth, that.bandwidth)) {
            return false;
        }
        if (!Objects.equals(this.credentialsSecret, that.credentialsSecret)) {
            return false;
        }
        if (!Objects.equals(this.dataDisk, that.dataDisk)) {
            return false;
        }
        if (!Objects.equals(this.imageId, that.imageId)) {
            return false;
        }
        if (!Objects.equals(this.instanceType, that.instanceType)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.ramRoleName, that.ramRoleName)) {
            return false;
        }
        if (!Objects.equals(this.regionId, that.regionId)) {
            return false;
        }
        if (!Objects.equals(this.resourceGroup, that.resourceGroup)) {
            return false;
        }
        if (!Objects.equals(this.securityGroups, that.securityGroups)) {
            return false;
        }
        if (!Objects.equals(this.systemDisk, that.systemDisk)) {
            return false;
        }
        if (!Objects.equals(this.tag, that.tag)) {
            return false;
        }
        if (!Objects.equals(this.tenancy, that.tenancy)) {
            return false;
        }
        if (!Objects.equals(this.userDataSecret, that.userDataSecret)) {
            return false;
        }
        if (!Objects.equals(this.vSwitch, that.vSwitch)) {
            return false;
        }
        if (!Objects.equals(this.vpcId, that.vpcId)) {
            return false;
        }
        if (!Objects.equals(this.zoneId, that.zoneId)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.bandwidth, this.credentialsSecret, this.dataDisk, this.imageId, this.instanceType, this.kind, this.metadata, this.ramRoleName, this.regionId, this.resourceGroup, this.securityGroups, this.systemDisk, this.tag, this.tenancy, this.userDataSecret, this.vSwitch, this.vpcId, this.zoneId, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.bandwidth != null) {
            sb.append("bandwidth:");
            sb.append(this.bandwidth + ",");
        }
        if (this.credentialsSecret != null) {
            sb.append("credentialsSecret:");
            sb.append(this.credentialsSecret + ",");
        }
        if (this.dataDisk != null && !this.dataDisk.isEmpty()) {
            sb.append("dataDisk:");
            sb.append(this.dataDisk + ",");
        }
        if (this.imageId != null) {
            sb.append("imageId:");
            sb.append(this.imageId + ",");
        }
        if (this.instanceType != null) {
            sb.append("instanceType:");
            sb.append(this.instanceType + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.ramRoleName != null) {
            sb.append("ramRoleName:");
            sb.append(this.ramRoleName + ",");
        }
        if (this.regionId != null) {
            sb.append("regionId:");
            sb.append(this.regionId + ",");
        }
        if (this.resourceGroup != null) {
            sb.append("resourceGroup:");
            sb.append(this.resourceGroup + ",");
        }
        if (this.securityGroups != null && !this.securityGroups.isEmpty()) {
            sb.append("securityGroups:");
            sb.append(this.securityGroups + ",");
        }
        if (this.systemDisk != null) {
            sb.append("systemDisk:");
            sb.append(this.systemDisk + ",");
        }
        if (this.tag != null && !this.tag.isEmpty()) {
            sb.append("tag:");
            sb.append(this.tag + ",");
        }
        if (this.tenancy != null) {
            sb.append("tenancy:");
            sb.append(this.tenancy + ",");
        }
        if (this.userDataSecret != null) {
            sb.append("userDataSecret:");
            sb.append(this.userDataSecret + ",");
        }
        if (this.vSwitch != null) {
            sb.append("vSwitch:");
            sb.append(this.vSwitch + ",");
        }
        if (this.vpcId != null) {
            sb.append("vpcId:");
            sb.append(this.vpcId + ",");
        }
        if (this.zoneId != null) {
            sb.append("zoneId:");
            sb.append(this.zoneId + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class VSwitchNested<N>
    extends AlibabaResourceReferenceFluent<VSwitchNested<N>>
    implements Nested<N> {
        AlibabaResourceReferenceBuilder builder;

        VSwitchNested(AlibabaResourceReference item) {
            this.builder = new AlibabaResourceReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlibabaCloudMachineProviderConfigFluent.this.withVSwitch(this.builder.build());
        }

        public N endVSwitch() {
            return this.and();
        }
    }

    public class UserDataSecretNested<N>
    extends LocalObjectReferenceFluent<UserDataSecretNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        UserDataSecretNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlibabaCloudMachineProviderConfigFluent.this.withUserDataSecret(this.builder.build());
        }

        public N endUserDataSecret() {
            return this.and();
        }
    }

    public class TagNested<N>
    extends TagFluent<TagNested<N>>
    implements Nested<N> {
        TagBuilder builder;
        int index;

        TagNested(int index, Tag item) {
            this.index = index;
            this.builder = new TagBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlibabaCloudMachineProviderConfigFluent.this.setToTag(this.index, this.builder.build());
        }

        public N endTag() {
            return this.and();
        }
    }

    public class SystemDiskNested<N>
    extends SystemDiskPropertiesFluent<SystemDiskNested<N>>
    implements Nested<N> {
        SystemDiskPropertiesBuilder builder;

        SystemDiskNested(SystemDiskProperties item) {
            this.builder = new SystemDiskPropertiesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlibabaCloudMachineProviderConfigFluent.this.withSystemDisk(this.builder.build());
        }

        public N endSystemDisk() {
            return this.and();
        }
    }

    public class SecurityGroupsNested<N>
    extends AlibabaResourceReferenceFluent<SecurityGroupsNested<N>>
    implements Nested<N> {
        AlibabaResourceReferenceBuilder builder;
        int index;

        SecurityGroupsNested(int index, AlibabaResourceReference item) {
            this.index = index;
            this.builder = new AlibabaResourceReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlibabaCloudMachineProviderConfigFluent.this.setToSecurityGroups(this.index, this.builder.build());
        }

        public N endSecurityGroup() {
            return this.and();
        }
    }

    public class ResourceGroupNested<N>
    extends AlibabaResourceReferenceFluent<ResourceGroupNested<N>>
    implements Nested<N> {
        AlibabaResourceReferenceBuilder builder;

        ResourceGroupNested(AlibabaResourceReference item) {
            this.builder = new AlibabaResourceReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlibabaCloudMachineProviderConfigFluent.this.withResourceGroup(this.builder.build());
        }

        public N endResourceGroup() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlibabaCloudMachineProviderConfigFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class DataDiskNested<N>
    extends DataDiskPropertiesFluent<DataDiskNested<N>>
    implements Nested<N> {
        DataDiskPropertiesBuilder builder;
        int index;

        DataDiskNested(int index, DataDiskProperties item) {
            this.index = index;
            this.builder = new DataDiskPropertiesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlibabaCloudMachineProviderConfigFluent.this.setToDataDisk(this.index, this.builder.build());
        }

        public N endDataDisk() {
            return this.and();
        }
    }

    public class CredentialsSecretNested<N>
    extends LocalObjectReferenceFluent<CredentialsSecretNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        CredentialsSecretNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlibabaCloudMachineProviderConfigFluent.this.withCredentialsSecret(this.builder.build());
        }

        public N endCredentialsSecret() {
            return this.and();
        }
    }

    public class BandwidthNested<N>
    extends BandwidthPropertiesFluent<BandwidthNested<N>>
    implements Nested<N> {
        BandwidthPropertiesBuilder builder;

        BandwidthNested(BandwidthProperties item) {
            this.builder = new BandwidthPropertiesBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlibabaCloudMachineProviderConfigFluent.this.withBandwidth(this.builder.build());
        }

        public N endBandwidth() {
            return this.and();
        }
    }
}

