/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1alpha1.BlockDeviceStorage;
import io.fabric8.openshift.api.model.machine.v1alpha1.BlockDeviceVolume;
import io.fabric8.openshift.api.model.machine.v1alpha1.BlockDeviceVolumeBuilder;
import io.fabric8.openshift.api.model.machine.v1alpha1.BlockDeviceVolumeFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class BlockDeviceStorageFluent<A extends BlockDeviceStorageFluent<A>>
extends BaseFluent<A> {
    private String type;
    private BlockDeviceVolumeBuilder volume;
    private Map<String, Object> additionalProperties;

    public BlockDeviceStorageFluent() {
    }

    public BlockDeviceStorageFluent(BlockDeviceStorage instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(BlockDeviceStorage instance) {
        BlockDeviceStorage blockDeviceStorage = instance = instance != null ? instance : new BlockDeviceStorage();
        if (instance != null) {
            this.withType(instance.getType());
            this.withVolume(instance.getVolume());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public BlockDeviceVolume buildVolume() {
        return this.volume != null ? this.volume.build() : null;
    }

    public A withVolume(BlockDeviceVolume volume) {
        this._visitables.remove("volume");
        if (volume != null) {
            this.volume = new BlockDeviceVolumeBuilder(volume);
            this._visitables.get("volume").add(this.volume);
        } else {
            this.volume = null;
            this._visitables.get("volume").remove(this.volume);
        }
        return (A)this;
    }

    public boolean hasVolume() {
        return this.volume != null;
    }

    public A withNewVolume(String availabilityZone, String type) {
        return this.withVolume(new BlockDeviceVolume(availabilityZone, type));
    }

    public VolumeNested<A> withNewVolume() {
        return new VolumeNested(null);
    }

    public VolumeNested<A> withNewVolumeLike(BlockDeviceVolume item) {
        return new VolumeNested(item);
    }

    public VolumeNested<A> editVolume() {
        return this.withNewVolumeLike(Optional.ofNullable(this.buildVolume()).orElse(null));
    }

    public VolumeNested<A> editOrNewVolume() {
        return this.withNewVolumeLike(Optional.ofNullable(this.buildVolume()).orElse(new BlockDeviceVolumeBuilder().build()));
    }

    public VolumeNested<A> editOrNewVolumeLike(BlockDeviceVolume item) {
        return this.withNewVolumeLike(Optional.ofNullable(this.buildVolume()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BlockDeviceStorageFluent that = (BlockDeviceStorageFluent)o;
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.volume, that.volume)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.volume, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.volume != null) {
            sb.append("volume:");
            sb.append(this.volume + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class VolumeNested<N>
    extends BlockDeviceVolumeFluent<VolumeNested<N>>
    implements Nested<N> {
        BlockDeviceVolumeBuilder builder;

        VolumeNested(BlockDeviceVolume item) {
            this.builder = new BlockDeviceVolumeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BlockDeviceStorageFluent.this.withVolume(this.builder.build());
        }

        public N endVolume() {
            return this.and();
        }
    }
}

