/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1beta1.SecurityProfile;
import io.fabric8.openshift.api.model.machine.v1beta1.SecuritySettings;
import io.fabric8.openshift.api.model.machine.v1beta1.SecuritySettingsBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.SecuritySettingsFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SecurityProfileFluent<A extends SecurityProfileFluent<A>>
extends BaseFluent<A> {
    private Boolean encryptionAtHost;
    private SecuritySettingsBuilder settings;
    private Map<String, Object> additionalProperties;

    public SecurityProfileFluent() {
    }

    public SecurityProfileFluent(SecurityProfile instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(SecurityProfile instance) {
        SecurityProfile securityProfile = instance = instance != null ? instance : new SecurityProfile();
        if (instance != null) {
            this.withEncryptionAtHost(instance.getEncryptionAtHost());
            this.withSettings(instance.getSettings());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getEncryptionAtHost() {
        return this.encryptionAtHost;
    }

    public A withEncryptionAtHost(Boolean encryptionAtHost) {
        this.encryptionAtHost = encryptionAtHost;
        return (A)this;
    }

    public boolean hasEncryptionAtHost() {
        return this.encryptionAtHost != null;
    }

    public SecuritySettings buildSettings() {
        return this.settings != null ? this.settings.build() : null;
    }

    public A withSettings(SecuritySettings settings) {
        this._visitables.remove("settings");
        if (settings != null) {
            this.settings = new SecuritySettingsBuilder(settings);
            this._visitables.get("settings").add(this.settings);
        } else {
            this.settings = null;
            this._visitables.get("settings").remove(this.settings);
        }
        return (A)this;
    }

    public boolean hasSettings() {
        return this.settings != null;
    }

    public SettingsNested<A> withNewSettings() {
        return new SettingsNested(null);
    }

    public SettingsNested<A> withNewSettingsLike(SecuritySettings item) {
        return new SettingsNested(item);
    }

    public SettingsNested<A> editSettings() {
        return this.withNewSettingsLike(Optional.ofNullable(this.buildSettings()).orElse(null));
    }

    public SettingsNested<A> editOrNewSettings() {
        return this.withNewSettingsLike(Optional.ofNullable(this.buildSettings()).orElse(new SecuritySettingsBuilder().build()));
    }

    public SettingsNested<A> editOrNewSettingsLike(SecuritySettings item) {
        return this.withNewSettingsLike(Optional.ofNullable(this.buildSettings()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecurityProfileFluent that = (SecurityProfileFluent)o;
        if (!Objects.equals(this.encryptionAtHost, that.encryptionAtHost)) {
            return false;
        }
        if (!Objects.equals(this.settings, that.settings)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.encryptionAtHost, this.settings, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.encryptionAtHost != null) {
            sb.append("encryptionAtHost:");
            sb.append(this.encryptionAtHost + ",");
        }
        if (this.settings != null) {
            sb.append("settings:");
            sb.append(this.settings + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEncryptionAtHost() {
        return this.withEncryptionAtHost(true);
    }

    public class SettingsNested<N>
    extends SecuritySettingsFluent<SettingsNested<N>>
    implements Nested<N> {
        SecuritySettingsBuilder builder;

        SettingsNested(SecuritySettings item) {
            this.builder = new SecuritySettingsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SecurityProfileFluent.this.withSettings(this.builder.build());
        }

        public N endSettings() {
            return this.and();
        }
    }
}

