/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineOSBuildSpec;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineOSConfigReference;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineOSConfigReferenceBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineOSConfigReferenceFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.RenderedMachineConfigReference;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.RenderedMachineConfigReferenceBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.RenderedMachineConfigReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MachineOSBuildSpecFluent<A extends MachineOSBuildSpecFluent<A>>
extends BaseFluent<A> {
    private Long configGeneration;
    private RenderedMachineConfigReferenceBuilder desiredConfig;
    private MachineOSConfigReferenceBuilder machineOSConfig;
    private String renderedImagePushspec;
    private Long version;
    private Map<String, Object> additionalProperties;

    public MachineOSBuildSpecFluent() {
    }

    public MachineOSBuildSpecFluent(MachineOSBuildSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachineOSBuildSpec instance) {
        MachineOSBuildSpec machineOSBuildSpec = instance = instance != null ? instance : new MachineOSBuildSpec();
        if (instance != null) {
            this.withConfigGeneration(instance.getConfigGeneration());
            this.withDesiredConfig(instance.getDesiredConfig());
            this.withMachineOSConfig(instance.getMachineOSConfig());
            this.withRenderedImagePushspec(instance.getRenderedImagePushspec());
            this.withVersion(instance.getVersion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Long getConfigGeneration() {
        return this.configGeneration;
    }

    public A withConfigGeneration(Long configGeneration) {
        this.configGeneration = configGeneration;
        return (A)this;
    }

    public boolean hasConfigGeneration() {
        return this.configGeneration != null;
    }

    public RenderedMachineConfigReference buildDesiredConfig() {
        return this.desiredConfig != null ? this.desiredConfig.build() : null;
    }

    public A withDesiredConfig(RenderedMachineConfigReference desiredConfig) {
        this._visitables.remove("desiredConfig");
        if (desiredConfig != null) {
            this.desiredConfig = new RenderedMachineConfigReferenceBuilder(desiredConfig);
            this._visitables.get("desiredConfig").add(this.desiredConfig);
        } else {
            this.desiredConfig = null;
            this._visitables.get("desiredConfig").remove(this.desiredConfig);
        }
        return (A)this;
    }

    public boolean hasDesiredConfig() {
        return this.desiredConfig != null;
    }

    public A withNewDesiredConfig(String name) {
        return this.withDesiredConfig(new RenderedMachineConfigReference(name));
    }

    public DesiredConfigNested<A> withNewDesiredConfig() {
        return new DesiredConfigNested(null);
    }

    public DesiredConfigNested<A> withNewDesiredConfigLike(RenderedMachineConfigReference item) {
        return new DesiredConfigNested(item);
    }

    public DesiredConfigNested<A> editDesiredConfig() {
        return this.withNewDesiredConfigLike(Optional.ofNullable(this.buildDesiredConfig()).orElse(null));
    }

    public DesiredConfigNested<A> editOrNewDesiredConfig() {
        return this.withNewDesiredConfigLike(Optional.ofNullable(this.buildDesiredConfig()).orElse(new RenderedMachineConfigReferenceBuilder().build()));
    }

    public DesiredConfigNested<A> editOrNewDesiredConfigLike(RenderedMachineConfigReference item) {
        return this.withNewDesiredConfigLike(Optional.ofNullable(this.buildDesiredConfig()).orElse(item));
    }

    public MachineOSConfigReference buildMachineOSConfig() {
        return this.machineOSConfig != null ? this.machineOSConfig.build() : null;
    }

    public A withMachineOSConfig(MachineOSConfigReference machineOSConfig) {
        this._visitables.remove("machineOSConfig");
        if (machineOSConfig != null) {
            this.machineOSConfig = new MachineOSConfigReferenceBuilder(machineOSConfig);
            this._visitables.get("machineOSConfig").add(this.machineOSConfig);
        } else {
            this.machineOSConfig = null;
            this._visitables.get("machineOSConfig").remove(this.machineOSConfig);
        }
        return (A)this;
    }

    public boolean hasMachineOSConfig() {
        return this.machineOSConfig != null;
    }

    public A withNewMachineOSConfig(String name) {
        return this.withMachineOSConfig(new MachineOSConfigReference(name));
    }

    public MachineOSConfigNested<A> withNewMachineOSConfig() {
        return new MachineOSConfigNested(null);
    }

    public MachineOSConfigNested<A> withNewMachineOSConfigLike(MachineOSConfigReference item) {
        return new MachineOSConfigNested(item);
    }

    public MachineOSConfigNested<A> editMachineOSConfig() {
        return this.withNewMachineOSConfigLike(Optional.ofNullable(this.buildMachineOSConfig()).orElse(null));
    }

    public MachineOSConfigNested<A> editOrNewMachineOSConfig() {
        return this.withNewMachineOSConfigLike(Optional.ofNullable(this.buildMachineOSConfig()).orElse(new MachineOSConfigReferenceBuilder().build()));
    }

    public MachineOSConfigNested<A> editOrNewMachineOSConfigLike(MachineOSConfigReference item) {
        return this.withNewMachineOSConfigLike(Optional.ofNullable(this.buildMachineOSConfig()).orElse(item));
    }

    public String getRenderedImagePushspec() {
        return this.renderedImagePushspec;
    }

    public A withRenderedImagePushspec(String renderedImagePushspec) {
        this.renderedImagePushspec = renderedImagePushspec;
        return (A)this;
    }

    public boolean hasRenderedImagePushspec() {
        return this.renderedImagePushspec != null;
    }

    public Long getVersion() {
        return this.version;
    }

    public A withVersion(Long version) {
        this.version = version;
        return (A)this;
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineOSBuildSpecFluent that = (MachineOSBuildSpecFluent)o;
        if (!Objects.equals(this.configGeneration, that.configGeneration)) {
            return false;
        }
        if (!Objects.equals(this.desiredConfig, that.desiredConfig)) {
            return false;
        }
        if (!Objects.equals(this.machineOSConfig, that.machineOSConfig)) {
            return false;
        }
        if (!Objects.equals(this.renderedImagePushspec, that.renderedImagePushspec)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.configGeneration, this.desiredConfig, this.machineOSConfig, this.renderedImagePushspec, this.version, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configGeneration != null) {
            sb.append("configGeneration:");
            sb.append(this.configGeneration + ",");
        }
        if (this.desiredConfig != null) {
            sb.append("desiredConfig:");
            sb.append(this.desiredConfig + ",");
        }
        if (this.machineOSConfig != null) {
            sb.append("machineOSConfig:");
            sb.append(this.machineOSConfig + ",");
        }
        if (this.renderedImagePushspec != null) {
            sb.append("renderedImagePushspec:");
            sb.append(this.renderedImagePushspec + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MachineOSConfigNested<N>
    extends MachineOSConfigReferenceFluent<MachineOSConfigNested<N>>
    implements Nested<N> {
        MachineOSConfigReferenceBuilder builder;

        MachineOSConfigNested(MachineOSConfigReference item) {
            this.builder = new MachineOSConfigReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineOSBuildSpecFluent.this.withMachineOSConfig(this.builder.build());
        }

        public N endMachineOSConfig() {
            return this.and();
        }
    }

    public class DesiredConfigNested<N>
    extends RenderedMachineConfigReferenceFluent<DesiredConfigNested<N>>
    implements Nested<N> {
        RenderedMachineConfigReferenceBuilder builder;

        DesiredConfigNested(RenderedMachineConfigReference item) {
            this.builder = new RenderedMachineConfigReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)MachineOSBuildSpecFluent.this.withDesiredConfig(this.builder.build());
        }

        public N endDesiredConfig() {
            return this.and();
        }
    }
}

