/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeFluent;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluent;
import io.fabric8.kubernetes.api.model.apps.StatefulSetPersistentVolumeClaimRetentionPolicy;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerConfigMatcherStrategy;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerConfigMatcherStrategyBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerConfigMatcherStrategyFluent;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerConfiguration;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerConfigurationBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerConfigurationFluent;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerSpec;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerWebSpec;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerWebSpecBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerWebSpecFluent;
import io.fabric8.openshift.api.model.monitoring.v1.EmbeddedObjectMetadata;
import io.fabric8.openshift.api.model.monitoring.v1.EmbeddedObjectMetadataBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.EmbeddedObjectMetadataFluent;
import io.fabric8.openshift.api.model.monitoring.v1.HostAlias;
import io.fabric8.openshift.api.model.monitoring.v1.HostAliasBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.HostAliasFluent;
import io.fabric8.openshift.api.model.monitoring.v1.PodDNSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.PodDNSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.PodDNSConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.StorageSpec;
import io.fabric8.openshift.api.model.monitoring.v1.StorageSpecBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.StorageSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class AlertmanagerSpecFluent<A extends AlertmanagerSpecFluent<A>>
extends BaseFluent<A> {
    private List<String> additionalPeers = new ArrayList<String>();
    private Affinity affinity;
    private AlertmanagerConfigMatcherStrategyBuilder alertmanagerConfigMatcherStrategy;
    private LabelSelectorBuilder alertmanagerConfigNamespaceSelector;
    private LabelSelectorBuilder alertmanagerConfigSelector;
    private AlertmanagerConfigurationBuilder alertmanagerConfiguration;
    private Boolean automountServiceAccountToken;
    private String baseImage;
    private String clusterAdvertiseAddress;
    private String clusterGossipInterval;
    private String clusterLabel;
    private String clusterPeerTimeout;
    private String clusterPushpullInterval;
    private List<String> configMaps = new ArrayList<String>();
    private String configSecret;
    private ArrayList<ContainerBuilder> containers = new ArrayList();
    private PodDNSConfigBuilder dnsConfig;
    private String dnsPolicy;
    private List<String> enableFeatures = new ArrayList<String>();
    private String externalUrl;
    private Boolean forceEnableClusterMode;
    private ArrayList<HostAliasBuilder> hostAliases = new ArrayList();
    private String image;
    private String imagePullPolicy;
    private ArrayList<LocalObjectReferenceBuilder> imagePullSecrets = new ArrayList();
    private ArrayList<ContainerBuilder> initContainers = new ArrayList();
    private Boolean listenLocal;
    private String logFormat;
    private String logLevel;
    private Long minReadySeconds;
    private Map<String, String> nodeSelector;
    private Boolean paused;
    private StatefulSetPersistentVolumeClaimRetentionPolicy persistentVolumeClaimRetentionPolicy;
    private EmbeddedObjectMetadataBuilder podMetadata;
    private String portName;
    private String priorityClassName;
    private Integer replicas;
    private ResourceRequirementsBuilder resources;
    private String retention;
    private String routePrefix;
    private List<String> secrets = new ArrayList<String>();
    private PodSecurityContext securityContext;
    private String serviceAccountName;
    private String sha;
    private StorageSpecBuilder storage;
    private String tag;
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private List<TopologySpreadConstraint> topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
    private String version;
    private ArrayList<VolumeMountBuilder> volumeMounts = new ArrayList();
    private ArrayList<VolumeBuilder> volumes = new ArrayList();
    private AlertmanagerWebSpecBuilder web;
    private Map<String, Object> additionalProperties;

    public AlertmanagerSpecFluent() {
    }

    public AlertmanagerSpecFluent(AlertmanagerSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AlertmanagerSpec instance) {
        AlertmanagerSpec alertmanagerSpec = instance = instance != null ? instance : new AlertmanagerSpec();
        if (instance != null) {
            this.withAdditionalPeers(instance.getAdditionalPeers());
            this.withAffinity(instance.getAffinity());
            this.withAlertmanagerConfigMatcherStrategy(instance.getAlertmanagerConfigMatcherStrategy());
            this.withAlertmanagerConfigNamespaceSelector(instance.getAlertmanagerConfigNamespaceSelector());
            this.withAlertmanagerConfigSelector(instance.getAlertmanagerConfigSelector());
            this.withAlertmanagerConfiguration(instance.getAlertmanagerConfiguration());
            this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
            this.withBaseImage(instance.getBaseImage());
            this.withClusterAdvertiseAddress(instance.getClusterAdvertiseAddress());
            this.withClusterGossipInterval(instance.getClusterGossipInterval());
            this.withClusterLabel(instance.getClusterLabel());
            this.withClusterPeerTimeout(instance.getClusterPeerTimeout());
            this.withClusterPushpullInterval(instance.getClusterPushpullInterval());
            this.withConfigMaps(instance.getConfigMaps());
            this.withConfigSecret(instance.getConfigSecret());
            this.withContainers(instance.getContainers());
            this.withDnsConfig(instance.getDnsConfig());
            this.withDnsPolicy(instance.getDnsPolicy());
            this.withEnableFeatures(instance.getEnableFeatures());
            this.withExternalUrl(instance.getExternalUrl());
            this.withForceEnableClusterMode(instance.getForceEnableClusterMode());
            this.withHostAliases(instance.getHostAliases());
            this.withImage(instance.getImage());
            this.withImagePullPolicy(instance.getImagePullPolicy());
            this.withImagePullSecrets(instance.getImagePullSecrets());
            this.withInitContainers(instance.getInitContainers());
            this.withListenLocal(instance.getListenLocal());
            this.withLogFormat(instance.getLogFormat());
            this.withLogLevel(instance.getLogLevel());
            this.withMinReadySeconds(instance.getMinReadySeconds());
            this.withNodeSelector(instance.getNodeSelector());
            this.withPaused(instance.getPaused());
            this.withPersistentVolumeClaimRetentionPolicy(instance.getPersistentVolumeClaimRetentionPolicy());
            this.withPodMetadata(instance.getPodMetadata());
            this.withPortName(instance.getPortName());
            this.withPriorityClassName(instance.getPriorityClassName());
            this.withReplicas(instance.getReplicas());
            this.withResources(instance.getResources());
            this.withRetention(instance.getRetention());
            this.withRoutePrefix(instance.getRoutePrefix());
            this.withSecrets(instance.getSecrets());
            this.withSecurityContext(instance.getSecurityContext());
            this.withServiceAccountName(instance.getServiceAccountName());
            this.withSha(instance.getSha());
            this.withStorage(instance.getStorage());
            this.withTag(instance.getTag());
            this.withTolerations(instance.getTolerations());
            this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
            this.withVersion(instance.getVersion());
            this.withVolumeMounts(instance.getVolumeMounts());
            this.withVolumes(instance.getVolumes());
            this.withWeb(instance.getWeb());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAdditionalPeers(int index, String item) {
        if (this.additionalPeers == null) {
            this.additionalPeers = new ArrayList<String>();
        }
        this.additionalPeers.add(index, item);
        return (A)this;
    }

    public A setToAdditionalPeers(int index, String item) {
        if (this.additionalPeers == null) {
            this.additionalPeers = new ArrayList<String>();
        }
        this.additionalPeers.set(index, item);
        return (A)this;
    }

    public A addToAdditionalPeers(String ... items) {
        if (this.additionalPeers == null) {
            this.additionalPeers = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalPeers.add(item);
        }
        return (A)this;
    }

    public A addAllToAdditionalPeers(Collection<String> items) {
        if (this.additionalPeers == null) {
            this.additionalPeers = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalPeers.add(item);
        }
        return (A)this;
    }

    public A removeFromAdditionalPeers(String ... items) {
        if (this.additionalPeers == null) {
            return (A)this;
        }
        for (String item : items) {
            this.additionalPeers.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromAdditionalPeers(Collection<String> items) {
        if (this.additionalPeers == null) {
            return (A)this;
        }
        for (String item : items) {
            this.additionalPeers.remove(item);
        }
        return (A)this;
    }

    public List<String> getAdditionalPeers() {
        return this.additionalPeers;
    }

    public String getAdditionalPeer(int index) {
        return this.additionalPeers.get(index);
    }

    public String getFirstAdditionalPeer() {
        return this.additionalPeers.get(0);
    }

    public String getLastAdditionalPeer() {
        return this.additionalPeers.get(this.additionalPeers.size() - 1);
    }

    public String getMatchingAdditionalPeer(Predicate<String> predicate) {
        for (String item : this.additionalPeers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAdditionalPeer(Predicate<String> predicate) {
        for (String item : this.additionalPeers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAdditionalPeers(List<String> additionalPeers) {
        if (additionalPeers != null) {
            this.additionalPeers = new ArrayList<String>();
            for (String item : additionalPeers) {
                this.addToAdditionalPeers(item);
            }
        } else {
            this.additionalPeers = null;
        }
        return (A)this;
    }

    public A withAdditionalPeers(String ... additionalPeers) {
        if (this.additionalPeers != null) {
            this.additionalPeers.clear();
            this._visitables.remove("additionalPeers");
        }
        if (additionalPeers != null) {
            for (String item : additionalPeers) {
                this.addToAdditionalPeers(item);
            }
        }
        return (A)this;
    }

    public boolean hasAdditionalPeers() {
        return this.additionalPeers != null && !this.additionalPeers.isEmpty();
    }

    public Affinity getAffinity() {
        return this.affinity;
    }

    public A withAffinity(Affinity affinity) {
        this.affinity = affinity;
        return (A)this;
    }

    public boolean hasAffinity() {
        return this.affinity != null;
    }

    public AlertmanagerConfigMatcherStrategy buildAlertmanagerConfigMatcherStrategy() {
        return this.alertmanagerConfigMatcherStrategy != null ? this.alertmanagerConfigMatcherStrategy.build() : null;
    }

    public A withAlertmanagerConfigMatcherStrategy(AlertmanagerConfigMatcherStrategy alertmanagerConfigMatcherStrategy) {
        this._visitables.remove("alertmanagerConfigMatcherStrategy");
        if (alertmanagerConfigMatcherStrategy != null) {
            this.alertmanagerConfigMatcherStrategy = new AlertmanagerConfigMatcherStrategyBuilder(alertmanagerConfigMatcherStrategy);
            this._visitables.get("alertmanagerConfigMatcherStrategy").add(this.alertmanagerConfigMatcherStrategy);
        } else {
            this.alertmanagerConfigMatcherStrategy = null;
            this._visitables.get("alertmanagerConfigMatcherStrategy").remove(this.alertmanagerConfigMatcherStrategy);
        }
        return (A)this;
    }

    public boolean hasAlertmanagerConfigMatcherStrategy() {
        return this.alertmanagerConfigMatcherStrategy != null;
    }

    public A withNewAlertmanagerConfigMatcherStrategy(String type) {
        return this.withAlertmanagerConfigMatcherStrategy(new AlertmanagerConfigMatcherStrategy(type));
    }

    public AlertmanagerConfigMatcherStrategyNested<A> withNewAlertmanagerConfigMatcherStrategy() {
        return new AlertmanagerConfigMatcherStrategyNested(null);
    }

    public AlertmanagerConfigMatcherStrategyNested<A> withNewAlertmanagerConfigMatcherStrategyLike(AlertmanagerConfigMatcherStrategy item) {
        return new AlertmanagerConfigMatcherStrategyNested(item);
    }

    public AlertmanagerConfigMatcherStrategyNested<A> editAlertmanagerConfigMatcherStrategy() {
        return this.withNewAlertmanagerConfigMatcherStrategyLike(Optional.ofNullable(this.buildAlertmanagerConfigMatcherStrategy()).orElse(null));
    }

    public AlertmanagerConfigMatcherStrategyNested<A> editOrNewAlertmanagerConfigMatcherStrategy() {
        return this.withNewAlertmanagerConfigMatcherStrategyLike(Optional.ofNullable(this.buildAlertmanagerConfigMatcherStrategy()).orElse(new AlertmanagerConfigMatcherStrategyBuilder().build()));
    }

    public AlertmanagerConfigMatcherStrategyNested<A> editOrNewAlertmanagerConfigMatcherStrategyLike(AlertmanagerConfigMatcherStrategy item) {
        return this.withNewAlertmanagerConfigMatcherStrategyLike(Optional.ofNullable(this.buildAlertmanagerConfigMatcherStrategy()).orElse(item));
    }

    public LabelSelector buildAlertmanagerConfigNamespaceSelector() {
        return this.alertmanagerConfigNamespaceSelector != null ? this.alertmanagerConfigNamespaceSelector.build() : null;
    }

    public A withAlertmanagerConfigNamespaceSelector(LabelSelector alertmanagerConfigNamespaceSelector) {
        this._visitables.remove("alertmanagerConfigNamespaceSelector");
        if (alertmanagerConfigNamespaceSelector != null) {
            this.alertmanagerConfigNamespaceSelector = new LabelSelectorBuilder(alertmanagerConfigNamespaceSelector);
            this._visitables.get("alertmanagerConfigNamespaceSelector").add(this.alertmanagerConfigNamespaceSelector);
        } else {
            this.alertmanagerConfigNamespaceSelector = null;
            this._visitables.get("alertmanagerConfigNamespaceSelector").remove(this.alertmanagerConfigNamespaceSelector);
        }
        return (A)this;
    }

    public boolean hasAlertmanagerConfigNamespaceSelector() {
        return this.alertmanagerConfigNamespaceSelector != null;
    }

    public AlertmanagerConfigNamespaceSelectorNested<A> withNewAlertmanagerConfigNamespaceSelector() {
        return new AlertmanagerConfigNamespaceSelectorNested(null);
    }

    public AlertmanagerConfigNamespaceSelectorNested<A> withNewAlertmanagerConfigNamespaceSelectorLike(LabelSelector item) {
        return new AlertmanagerConfigNamespaceSelectorNested(item);
    }

    public AlertmanagerConfigNamespaceSelectorNested<A> editAlertmanagerConfigNamespaceSelector() {
        return this.withNewAlertmanagerConfigNamespaceSelectorLike(Optional.ofNullable(this.buildAlertmanagerConfigNamespaceSelector()).orElse(null));
    }

    public AlertmanagerConfigNamespaceSelectorNested<A> editOrNewAlertmanagerConfigNamespaceSelector() {
        return this.withNewAlertmanagerConfigNamespaceSelectorLike(Optional.ofNullable(this.buildAlertmanagerConfigNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public AlertmanagerConfigNamespaceSelectorNested<A> editOrNewAlertmanagerConfigNamespaceSelectorLike(LabelSelector item) {
        return this.withNewAlertmanagerConfigNamespaceSelectorLike(Optional.ofNullable(this.buildAlertmanagerConfigNamespaceSelector()).orElse(item));
    }

    public LabelSelector buildAlertmanagerConfigSelector() {
        return this.alertmanagerConfigSelector != null ? this.alertmanagerConfigSelector.build() : null;
    }

    public A withAlertmanagerConfigSelector(LabelSelector alertmanagerConfigSelector) {
        this._visitables.remove("alertmanagerConfigSelector");
        if (alertmanagerConfigSelector != null) {
            this.alertmanagerConfigSelector = new LabelSelectorBuilder(alertmanagerConfigSelector);
            this._visitables.get("alertmanagerConfigSelector").add(this.alertmanagerConfigSelector);
        } else {
            this.alertmanagerConfigSelector = null;
            this._visitables.get("alertmanagerConfigSelector").remove(this.alertmanagerConfigSelector);
        }
        return (A)this;
    }

    public boolean hasAlertmanagerConfigSelector() {
        return this.alertmanagerConfigSelector != null;
    }

    public AlertmanagerConfigSelectorNested<A> withNewAlertmanagerConfigSelector() {
        return new AlertmanagerConfigSelectorNested(null);
    }

    public AlertmanagerConfigSelectorNested<A> withNewAlertmanagerConfigSelectorLike(LabelSelector item) {
        return new AlertmanagerConfigSelectorNested(item);
    }

    public AlertmanagerConfigSelectorNested<A> editAlertmanagerConfigSelector() {
        return this.withNewAlertmanagerConfigSelectorLike(Optional.ofNullable(this.buildAlertmanagerConfigSelector()).orElse(null));
    }

    public AlertmanagerConfigSelectorNested<A> editOrNewAlertmanagerConfigSelector() {
        return this.withNewAlertmanagerConfigSelectorLike(Optional.ofNullable(this.buildAlertmanagerConfigSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public AlertmanagerConfigSelectorNested<A> editOrNewAlertmanagerConfigSelectorLike(LabelSelector item) {
        return this.withNewAlertmanagerConfigSelectorLike(Optional.ofNullable(this.buildAlertmanagerConfigSelector()).orElse(item));
    }

    public AlertmanagerConfiguration buildAlertmanagerConfiguration() {
        return this.alertmanagerConfiguration != null ? this.alertmanagerConfiguration.build() : null;
    }

    public A withAlertmanagerConfiguration(AlertmanagerConfiguration alertmanagerConfiguration) {
        this._visitables.remove("alertmanagerConfiguration");
        if (alertmanagerConfiguration != null) {
            this.alertmanagerConfiguration = new AlertmanagerConfigurationBuilder(alertmanagerConfiguration);
            this._visitables.get("alertmanagerConfiguration").add(this.alertmanagerConfiguration);
        } else {
            this.alertmanagerConfiguration = null;
            this._visitables.get("alertmanagerConfiguration").remove(this.alertmanagerConfiguration);
        }
        return (A)this;
    }

    public boolean hasAlertmanagerConfiguration() {
        return this.alertmanagerConfiguration != null;
    }

    public AlertmanagerConfigurationNested<A> withNewAlertmanagerConfiguration() {
        return new AlertmanagerConfigurationNested(null);
    }

    public AlertmanagerConfigurationNested<A> withNewAlertmanagerConfigurationLike(AlertmanagerConfiguration item) {
        return new AlertmanagerConfigurationNested(item);
    }

    public AlertmanagerConfigurationNested<A> editAlertmanagerConfiguration() {
        return this.withNewAlertmanagerConfigurationLike(Optional.ofNullable(this.buildAlertmanagerConfiguration()).orElse(null));
    }

    public AlertmanagerConfigurationNested<A> editOrNewAlertmanagerConfiguration() {
        return this.withNewAlertmanagerConfigurationLike(Optional.ofNullable(this.buildAlertmanagerConfiguration()).orElse(new AlertmanagerConfigurationBuilder().build()));
    }

    public AlertmanagerConfigurationNested<A> editOrNewAlertmanagerConfigurationLike(AlertmanagerConfiguration item) {
        return this.withNewAlertmanagerConfigurationLike(Optional.ofNullable(this.buildAlertmanagerConfiguration()).orElse(item));
    }

    public Boolean getAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
        return (A)this;
    }

    public boolean hasAutomountServiceAccountToken() {
        return this.automountServiceAccountToken != null;
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public A withBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return (A)this;
    }

    public boolean hasBaseImage() {
        return this.baseImage != null;
    }

    public String getClusterAdvertiseAddress() {
        return this.clusterAdvertiseAddress;
    }

    public A withClusterAdvertiseAddress(String clusterAdvertiseAddress) {
        this.clusterAdvertiseAddress = clusterAdvertiseAddress;
        return (A)this;
    }

    public boolean hasClusterAdvertiseAddress() {
        return this.clusterAdvertiseAddress != null;
    }

    public String getClusterGossipInterval() {
        return this.clusterGossipInterval;
    }

    public A withClusterGossipInterval(String clusterGossipInterval) {
        this.clusterGossipInterval = clusterGossipInterval;
        return (A)this;
    }

    public boolean hasClusterGossipInterval() {
        return this.clusterGossipInterval != null;
    }

    public String getClusterLabel() {
        return this.clusterLabel;
    }

    public A withClusterLabel(String clusterLabel) {
        this.clusterLabel = clusterLabel;
        return (A)this;
    }

    public boolean hasClusterLabel() {
        return this.clusterLabel != null;
    }

    public String getClusterPeerTimeout() {
        return this.clusterPeerTimeout;
    }

    public A withClusterPeerTimeout(String clusterPeerTimeout) {
        this.clusterPeerTimeout = clusterPeerTimeout;
        return (A)this;
    }

    public boolean hasClusterPeerTimeout() {
        return this.clusterPeerTimeout != null;
    }

    public String getClusterPushpullInterval() {
        return this.clusterPushpullInterval;
    }

    public A withClusterPushpullInterval(String clusterPushpullInterval) {
        this.clusterPushpullInterval = clusterPushpullInterval;
        return (A)this;
    }

    public boolean hasClusterPushpullInterval() {
        return this.clusterPushpullInterval != null;
    }

    public A addToConfigMaps(int index, String item) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList<String>();
        }
        this.configMaps.add(index, item);
        return (A)this;
    }

    public A setToConfigMaps(int index, String item) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList<String>();
        }
        this.configMaps.set(index, item);
        return (A)this;
    }

    public A addToConfigMaps(String ... items) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList<String>();
        }
        for (String item : items) {
            this.configMaps.add(item);
        }
        return (A)this;
    }

    public A addAllToConfigMaps(Collection<String> items) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList<String>();
        }
        for (String item : items) {
            this.configMaps.add(item);
        }
        return (A)this;
    }

    public A removeFromConfigMaps(String ... items) {
        if (this.configMaps == null) {
            return (A)this;
        }
        for (String item : items) {
            this.configMaps.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromConfigMaps(Collection<String> items) {
        if (this.configMaps == null) {
            return (A)this;
        }
        for (String item : items) {
            this.configMaps.remove(item);
        }
        return (A)this;
    }

    public List<String> getConfigMaps() {
        return this.configMaps;
    }

    public String getConfigMap(int index) {
        return this.configMaps.get(index);
    }

    public String getFirstConfigMap() {
        return this.configMaps.get(0);
    }

    public String getLastConfigMap() {
        return this.configMaps.get(this.configMaps.size() - 1);
    }

    public String getMatchingConfigMap(Predicate<String> predicate) {
        for (String item : this.configMaps) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingConfigMap(Predicate<String> predicate) {
        for (String item : this.configMaps) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConfigMaps(List<String> configMaps) {
        if (configMaps != null) {
            this.configMaps = new ArrayList<String>();
            for (String item : configMaps) {
                this.addToConfigMaps(item);
            }
        } else {
            this.configMaps = null;
        }
        return (A)this;
    }

    public A withConfigMaps(String ... configMaps) {
        if (this.configMaps != null) {
            this.configMaps.clear();
            this._visitables.remove("configMaps");
        }
        if (configMaps != null) {
            for (String item : configMaps) {
                this.addToConfigMaps(item);
            }
        }
        return (A)this;
    }

    public boolean hasConfigMaps() {
        return this.configMaps != null && !this.configMaps.isEmpty();
    }

    public String getConfigSecret() {
        return this.configSecret;
    }

    public A withConfigSecret(String configSecret) {
        this.configSecret = configSecret;
        return (A)this;
    }

    public boolean hasConfigSecret() {
        return this.configSecret != null;
    }

    public A addToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.containers.size()) {
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        } else {
            this._visitables.get("containers").add(index, builder);
            this.containers.add(index, builder);
        }
        return (A)this;
    }

    public A setToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.containers.size()) {
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        } else {
            this._visitables.get("containers").set(index, builder);
            this.containers.set(index, builder);
        }
        return (A)this;
    }

    public A addToContainers(Container ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    public A addAllToContainers(Collection<Container> items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    public A removeFromContainers(Container ... items) {
        if (this.containers == null) {
            return (A)this;
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("containers").remove(builder);
            this.containers.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromContainers(Collection<Container> items) {
        if (this.containers == null) {
            return (A)this;
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("containers").remove(builder);
            this.containers.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate) {
        if (this.containers == null) {
            return (A)this;
        }
        Iterator<ContainerBuilder> each = this.containers.iterator();
        Object visitables = this._visitables.get("containers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Container> buildContainers() {
        return this.containers != null ? AlertmanagerSpecFluent.build(this.containers) : null;
    }

    public Container buildContainer(int index) {
        return this.containers.get(index).build();
    }

    public Container buildFirstContainer() {
        return this.containers.get(0).build();
    }

    public Container buildLastContainer() {
        return this.containers.get(this.containers.size() - 1).build();
    }

    public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withContainers(List<Container> containers) {
        if (this.containers != null) {
            this._visitables.get("containers").clear();
        }
        if (containers != null) {
            this.containers = new ArrayList();
            for (Container item : containers) {
                this.addToContainers(item);
            }
        } else {
            this.containers = null;
        }
        return (A)this;
    }

    public A withContainers(Container ... containers) {
        if (this.containers != null) {
            this.containers.clear();
            this._visitables.remove("containers");
        }
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)this;
    }

    public boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    public ContainersNested<A> addNewContainer() {
        return new ContainersNested(-1, null);
    }

    public ContainersNested<A> addNewContainerLike(Container item) {
        return new ContainersNested(-1, item);
    }

    public ContainersNested<A> setNewContainerLike(int index, Container item) {
        return new ContainersNested(index, item);
    }

    public ContainersNested<A> editContainer(int index) {
        if (this.containers.size() <= index) {
            throw new RuntimeException("Can't edit containers. Index exceeds size.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public ContainersNested<A> editFirstContainer() {
        if (this.containers.size() == 0) {
            throw new RuntimeException("Can't edit first containers. The list is empty.");
        }
        return this.setNewContainerLike(0, this.buildContainer(0));
    }

    public ContainersNested<A> editLastContainer() {
        int index = this.containers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containers. The list is empty.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            if (!predicate.test(this.containers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containers. No match found.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public PodDNSConfig buildDnsConfig() {
        return this.dnsConfig != null ? this.dnsConfig.build() : null;
    }

    public A withDnsConfig(PodDNSConfig dnsConfig) {
        this._visitables.remove("dnsConfig");
        if (dnsConfig != null) {
            this.dnsConfig = new PodDNSConfigBuilder(dnsConfig);
            this._visitables.get("dnsConfig").add(this.dnsConfig);
        } else {
            this.dnsConfig = null;
            this._visitables.get("dnsConfig").remove(this.dnsConfig);
        }
        return (A)this;
    }

    public boolean hasDnsConfig() {
        return this.dnsConfig != null;
    }

    public DnsConfigNested<A> withNewDnsConfig() {
        return new DnsConfigNested(null);
    }

    public DnsConfigNested<A> withNewDnsConfigLike(PodDNSConfig item) {
        return new DnsConfigNested(item);
    }

    public DnsConfigNested<A> editDnsConfig() {
        return this.withNewDnsConfigLike(Optional.ofNullable(this.buildDnsConfig()).orElse(null));
    }

    public DnsConfigNested<A> editOrNewDnsConfig() {
        return this.withNewDnsConfigLike(Optional.ofNullable(this.buildDnsConfig()).orElse(new PodDNSConfigBuilder().build()));
    }

    public DnsConfigNested<A> editOrNewDnsConfigLike(PodDNSConfig item) {
        return this.withNewDnsConfigLike(Optional.ofNullable(this.buildDnsConfig()).orElse(item));
    }

    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    public A withDnsPolicy(String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
        return (A)this;
    }

    public boolean hasDnsPolicy() {
        return this.dnsPolicy != null;
    }

    public A addToEnableFeatures(int index, String item) {
        if (this.enableFeatures == null) {
            this.enableFeatures = new ArrayList<String>();
        }
        this.enableFeatures.add(index, item);
        return (A)this;
    }

    public A setToEnableFeatures(int index, String item) {
        if (this.enableFeatures == null) {
            this.enableFeatures = new ArrayList<String>();
        }
        this.enableFeatures.set(index, item);
        return (A)this;
    }

    public A addToEnableFeatures(String ... items) {
        if (this.enableFeatures == null) {
            this.enableFeatures = new ArrayList<String>();
        }
        for (String item : items) {
            this.enableFeatures.add(item);
        }
        return (A)this;
    }

    public A addAllToEnableFeatures(Collection<String> items) {
        if (this.enableFeatures == null) {
            this.enableFeatures = new ArrayList<String>();
        }
        for (String item : items) {
            this.enableFeatures.add(item);
        }
        return (A)this;
    }

    public A removeFromEnableFeatures(String ... items) {
        if (this.enableFeatures == null) {
            return (A)this;
        }
        for (String item : items) {
            this.enableFeatures.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromEnableFeatures(Collection<String> items) {
        if (this.enableFeatures == null) {
            return (A)this;
        }
        for (String item : items) {
            this.enableFeatures.remove(item);
        }
        return (A)this;
    }

    public List<String> getEnableFeatures() {
        return this.enableFeatures;
    }

    public String getEnableFeature(int index) {
        return this.enableFeatures.get(index);
    }

    public String getFirstEnableFeature() {
        return this.enableFeatures.get(0);
    }

    public String getLastEnableFeature() {
        return this.enableFeatures.get(this.enableFeatures.size() - 1);
    }

    public String getMatchingEnableFeature(Predicate<String> predicate) {
        for (String item : this.enableFeatures) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingEnableFeature(Predicate<String> predicate) {
        for (String item : this.enableFeatures) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnableFeatures(List<String> enableFeatures) {
        if (enableFeatures != null) {
            this.enableFeatures = new ArrayList<String>();
            for (String item : enableFeatures) {
                this.addToEnableFeatures(item);
            }
        } else {
            this.enableFeatures = null;
        }
        return (A)this;
    }

    public A withEnableFeatures(String ... enableFeatures) {
        if (this.enableFeatures != null) {
            this.enableFeatures.clear();
            this._visitables.remove("enableFeatures");
        }
        if (enableFeatures != null) {
            for (String item : enableFeatures) {
                this.addToEnableFeatures(item);
            }
        }
        return (A)this;
    }

    public boolean hasEnableFeatures() {
        return this.enableFeatures != null && !this.enableFeatures.isEmpty();
    }

    public String getExternalUrl() {
        return this.externalUrl;
    }

    public A withExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
        return (A)this;
    }

    public boolean hasExternalUrl() {
        return this.externalUrl != null;
    }

    public Boolean getForceEnableClusterMode() {
        return this.forceEnableClusterMode;
    }

    public A withForceEnableClusterMode(Boolean forceEnableClusterMode) {
        this.forceEnableClusterMode = forceEnableClusterMode;
        return (A)this;
    }

    public boolean hasForceEnableClusterMode() {
        return this.forceEnableClusterMode != null;
    }

    public A addToHostAliases(int index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        HostAliasBuilder builder = new HostAliasBuilder(item);
        if (index < 0 || index >= this.hostAliases.size()) {
            this._visitables.get("hostAliases").add(builder);
            this.hostAliases.add(builder);
        } else {
            this._visitables.get("hostAliases").add(index, builder);
            this.hostAliases.add(index, builder);
        }
        return (A)this;
    }

    public A setToHostAliases(int index, HostAlias item) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        HostAliasBuilder builder = new HostAliasBuilder(item);
        if (index < 0 || index >= this.hostAliases.size()) {
            this._visitables.get("hostAliases").add(builder);
            this.hostAliases.add(builder);
        } else {
            this._visitables.get("hostAliases").set(index, builder);
            this.hostAliases.set(index, builder);
        }
        return (A)this;
    }

    public A addToHostAliases(HostAlias ... items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get("hostAliases").add(builder);
            this.hostAliases.add(builder);
        }
        return (A)this;
    }

    public A addAllToHostAliases(Collection<HostAlias> items) {
        if (this.hostAliases == null) {
            this.hostAliases = new ArrayList();
        }
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get("hostAliases").add(builder);
            this.hostAliases.add(builder);
        }
        return (A)this;
    }

    public A removeFromHostAliases(HostAlias ... items) {
        if (this.hostAliases == null) {
            return (A)this;
        }
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get("hostAliases").remove(builder);
            this.hostAliases.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromHostAliases(Collection<HostAlias> items) {
        if (this.hostAliases == null) {
            return (A)this;
        }
        for (HostAlias item : items) {
            HostAliasBuilder builder = new HostAliasBuilder(item);
            this._visitables.get("hostAliases").remove(builder);
            this.hostAliases.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromHostAliases(Predicate<HostAliasBuilder> predicate) {
        if (this.hostAliases == null) {
            return (A)this;
        }
        Iterator<HostAliasBuilder> each = this.hostAliases.iterator();
        Object visitables = this._visitables.get("hostAliases");
        while (each.hasNext()) {
            HostAliasBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<HostAlias> buildHostAliases() {
        return this.hostAliases != null ? AlertmanagerSpecFluent.build(this.hostAliases) : null;
    }

    public HostAlias buildHostAlias(int index) {
        return this.hostAliases.get(index).build();
    }

    public HostAlias buildFirstHostAlias() {
        return this.hostAliases.get(0).build();
    }

    public HostAlias buildLastHostAlias() {
        return this.hostAliases.get(this.hostAliases.size() - 1).build();
    }

    public HostAlias buildMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        for (HostAliasBuilder item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        for (HostAliasBuilder item : this.hostAliases) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHostAliases(List<HostAlias> hostAliases) {
        if (this.hostAliases != null) {
            this._visitables.get("hostAliases").clear();
        }
        if (hostAliases != null) {
            this.hostAliases = new ArrayList();
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        } else {
            this.hostAliases = null;
        }
        return (A)this;
    }

    public A withHostAliases(HostAlias ... hostAliases) {
        if (this.hostAliases != null) {
            this.hostAliases.clear();
            this._visitables.remove("hostAliases");
        }
        if (hostAliases != null) {
            for (HostAlias item : hostAliases) {
                this.addToHostAliases(item);
            }
        }
        return (A)this;
    }

    public boolean hasHostAliases() {
        return this.hostAliases != null && !this.hostAliases.isEmpty();
    }

    public HostAliasesNested<A> addNewHostAlias() {
        return new HostAliasesNested(-1, null);
    }

    public HostAliasesNested<A> addNewHostAliasLike(HostAlias item) {
        return new HostAliasesNested(-1, item);
    }

    public HostAliasesNested<A> setNewHostAliasLike(int index, HostAlias item) {
        return new HostAliasesNested(index, item);
    }

    public HostAliasesNested<A> editHostAlias(int index) {
        if (this.hostAliases.size() <= index) {
            throw new RuntimeException("Can't edit hostAliases. Index exceeds size.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    public HostAliasesNested<A> editFirstHostAlias() {
        if (this.hostAliases.size() == 0) {
            throw new RuntimeException("Can't edit first hostAliases. The list is empty.");
        }
        return this.setNewHostAliasLike(0, this.buildHostAlias(0));
    }

    public HostAliasesNested<A> editLastHostAlias() {
        int index = this.hostAliases.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last hostAliases. The list is empty.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    public HostAliasesNested<A> editMatchingHostAlias(Predicate<HostAliasBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.hostAliases.size(); ++i) {
            if (!predicate.test(this.hostAliases.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching hostAliases. No match found.");
        }
        return this.setNewHostAliasLike(index, this.buildHostAlias(index));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public A withImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (A)this;
    }

    public boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    public A addToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        } else {
            this._visitables.get("imagePullSecrets").add(index, builder);
            this.imagePullSecrets.add(index, builder);
        }
        return (A)this;
    }

    public A setToImagePullSecrets(int index, LocalObjectReference item) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
        if (index < 0 || index >= this.imagePullSecrets.size()) {
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        } else {
            this._visitables.get("imagePullSecrets").set(index, builder);
            this.imagePullSecrets.set(index, builder);
        }
        return (A)this;
    }

    public A addToImagePullSecrets(LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    public A addAllToImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList();
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").add(builder);
            this.imagePullSecrets.add(builder);
        }
        return (A)this;
    }

    public A removeFromImagePullSecrets(LocalObjectReference ... items) {
        if (this.imagePullSecrets == null) {
            return (A)this;
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").remove(builder);
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromImagePullSecrets(Collection<LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {
            return (A)this;
        }
        for (LocalObjectReference item : items) {
            LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
            this._visitables.get("imagePullSecrets").remove(builder);
            this.imagePullSecrets.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromImagePullSecrets(Predicate<LocalObjectReferenceBuilder> predicate) {
        if (this.imagePullSecrets == null) {
            return (A)this;
        }
        Iterator<LocalObjectReferenceBuilder> each = this.imagePullSecrets.iterator();
        Object visitables = this._visitables.get("imagePullSecrets");
        while (each.hasNext()) {
            LocalObjectReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<LocalObjectReference> buildImagePullSecrets() {
        return this.imagePullSecrets != null ? AlertmanagerSpecFluent.build(this.imagePullSecrets) : null;
    }

    public LocalObjectReference buildImagePullSecret(int index) {
        return this.imagePullSecrets.get(index).build();
    }

    public LocalObjectReference buildFirstImagePullSecret() {
        return this.imagePullSecrets.get(0).build();
    }

    public LocalObjectReference buildLastImagePullSecret() {
        return this.imagePullSecrets.get(this.imagePullSecrets.size() - 1).build();
    }

    public LocalObjectReference buildMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        for (LocalObjectReferenceBuilder item : this.imagePullSecrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this._visitables.get("imagePullSecrets").clear();
        }
        if (imagePullSecrets != null) {
            this.imagePullSecrets = new ArrayList();
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        } else {
            this.imagePullSecrets = null;
        }
        return (A)this;
    }

    public A withImagePullSecrets(LocalObjectReference ... imagePullSecrets) {
        if (this.imagePullSecrets != null) {
            this.imagePullSecrets.clear();
            this._visitables.remove("imagePullSecrets");
        }
        if (imagePullSecrets != null) {
            for (LocalObjectReference item : imagePullSecrets) {
                this.addToImagePullSecrets(item);
            }
        }
        return (A)this;
    }

    public boolean hasImagePullSecrets() {
        return this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty();
    }

    public A addNewImagePullSecret(String name) {
        return this.addToImagePullSecrets(new LocalObjectReference(name));
    }

    public ImagePullSecretsNested<A> addNewImagePullSecret() {
        return new ImagePullSecretsNested(-1, null);
    }

    public ImagePullSecretsNested<A> addNewImagePullSecretLike(LocalObjectReference item) {
        return new ImagePullSecretsNested(-1, item);
    }

    public ImagePullSecretsNested<A> setNewImagePullSecretLike(int index, LocalObjectReference item) {
        return new ImagePullSecretsNested(index, item);
    }

    public ImagePullSecretsNested<A> editImagePullSecret(int index) {
        if (this.imagePullSecrets.size() <= index) {
            throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    public ImagePullSecretsNested<A> editFirstImagePullSecret() {
        if (this.imagePullSecrets.size() == 0) {
            throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(0, this.buildImagePullSecret(0));
    }

    public ImagePullSecretsNested<A> editLastImagePullSecret() {
        int index = this.imagePullSecrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    public ImagePullSecretsNested<A> editMatchingImagePullSecret(Predicate<LocalObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imagePullSecrets.size(); ++i) {
            if (!predicate.test(this.imagePullSecrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
        }
        return this.setNewImagePullSecretLike(index, this.buildImagePullSecret(index));
    }

    public A addToInitContainers(int index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.initContainers.size()) {
            this._visitables.get("initContainers").add(builder);
            this.initContainers.add(builder);
        } else {
            this._visitables.get("initContainers").add(index, builder);
            this.initContainers.add(index, builder);
        }
        return (A)this;
    }

    public A setToInitContainers(int index, Container item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.initContainers.size()) {
            this._visitables.get("initContainers").add(builder);
            this.initContainers.add(builder);
        } else {
            this._visitables.get("initContainers").set(index, builder);
            this.initContainers.set(index, builder);
        }
        return (A)this;
    }

    public A addToInitContainers(Container ... items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    public A addAllToInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)this;
    }

    public A removeFromInitContainers(Container ... items) {
        if (this.initContainers == null) {
            return (A)this;
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("initContainers").remove(builder);
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromInitContainers(Collection<Container> items) {
        if (this.initContainers == null) {
            return (A)this;
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get("initContainers").remove(builder);
            this.initContainers.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
        if (this.initContainers == null) {
            return (A)this;
        }
        Iterator<ContainerBuilder> each = this.initContainers.iterator();
        Object visitables = this._visitables.get("initContainers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Container> buildInitContainers() {
        return this.initContainers != null ? AlertmanagerSpecFluent.build(this.initContainers) : null;
    }

    public Container buildInitContainer(int index) {
        return this.initContainers.get(index).build();
    }

    public Container buildFirstInitContainer() {
        return this.initContainers.get(0).build();
    }

    public Container buildLastInitContainer() {
        return this.initContainers.get(this.initContainers.size() - 1).build();
    }

    public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withInitContainers(List<Container> initContainers) {
        if (this.initContainers != null) {
            this._visitables.get("initContainers").clear();
        }
        if (initContainers != null) {
            this.initContainers = new ArrayList();
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        } else {
            this.initContainers = null;
        }
        return (A)this;
    }

    public A withInitContainers(Container ... initContainers) {
        if (this.initContainers != null) {
            this.initContainers.clear();
            this._visitables.remove("initContainers");
        }
        if (initContainers != null) {
            for (Container item : initContainers) {
                this.addToInitContainers(item);
            }
        }
        return (A)this;
    }

    public boolean hasInitContainers() {
        return this.initContainers != null && !this.initContainers.isEmpty();
    }

    public InitContainersNested<A> addNewInitContainer() {
        return new InitContainersNested(-1, null);
    }

    public InitContainersNested<A> addNewInitContainerLike(Container item) {
        return new InitContainersNested(-1, item);
    }

    public InitContainersNested<A> setNewInitContainerLike(int index, Container item) {
        return new InitContainersNested(index, item);
    }

    public InitContainersNested<A> editInitContainer(int index) {
        if (this.initContainers.size() <= index) {
            throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public InitContainersNested<A> editFirstInitContainer() {
        if (this.initContainers.size() == 0) {
            throw new RuntimeException("Can't edit first initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(0, this.buildInitContainer(0));
    }

    public InitContainersNested<A> editLastInitContainer() {
        int index = this.initContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainers.size(); ++i) {
            if (!predicate.test(this.initContainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainers. No match found.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public Boolean getListenLocal() {
        return this.listenLocal;
    }

    public A withListenLocal(Boolean listenLocal) {
        this.listenLocal = listenLocal;
        return (A)this;
    }

    public boolean hasListenLocal() {
        return this.listenLocal != null;
    }

    public String getLogFormat() {
        return this.logFormat;
    }

    public A withLogFormat(String logFormat) {
        this.logFormat = logFormat;
        return (A)this;
    }

    public boolean hasLogFormat() {
        return this.logFormat != null;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)this;
    }

    public boolean hasLogLevel() {
        return this.logLevel != null;
    }

    public Long getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public A withMinReadySeconds(Long minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    public boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)this;
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public Boolean getPaused() {
        return this.paused;
    }

    public A withPaused(Boolean paused) {
        this.paused = paused;
        return (A)this;
    }

    public boolean hasPaused() {
        return this.paused != null;
    }

    public StatefulSetPersistentVolumeClaimRetentionPolicy getPersistentVolumeClaimRetentionPolicy() {
        return this.persistentVolumeClaimRetentionPolicy;
    }

    public A withPersistentVolumeClaimRetentionPolicy(StatefulSetPersistentVolumeClaimRetentionPolicy persistentVolumeClaimRetentionPolicy) {
        this.persistentVolumeClaimRetentionPolicy = persistentVolumeClaimRetentionPolicy;
        return (A)this;
    }

    public boolean hasPersistentVolumeClaimRetentionPolicy() {
        return this.persistentVolumeClaimRetentionPolicy != null;
    }

    public A withNewPersistentVolumeClaimRetentionPolicy(String whenDeleted, String whenScaled) {
        return this.withPersistentVolumeClaimRetentionPolicy(new StatefulSetPersistentVolumeClaimRetentionPolicy(whenDeleted, whenScaled));
    }

    public EmbeddedObjectMetadata buildPodMetadata() {
        return this.podMetadata != null ? this.podMetadata.build() : null;
    }

    public A withPodMetadata(EmbeddedObjectMetadata podMetadata) {
        this._visitables.remove("podMetadata");
        if (podMetadata != null) {
            this.podMetadata = new EmbeddedObjectMetadataBuilder(podMetadata);
            this._visitables.get("podMetadata").add(this.podMetadata);
        } else {
            this.podMetadata = null;
            this._visitables.get("podMetadata").remove(this.podMetadata);
        }
        return (A)this;
    }

    public boolean hasPodMetadata() {
        return this.podMetadata != null;
    }

    public PodMetadataNested<A> withNewPodMetadata() {
        return new PodMetadataNested(null);
    }

    public PodMetadataNested<A> withNewPodMetadataLike(EmbeddedObjectMetadata item) {
        return new PodMetadataNested(item);
    }

    public PodMetadataNested<A> editPodMetadata() {
        return this.withNewPodMetadataLike(Optional.ofNullable(this.buildPodMetadata()).orElse(null));
    }

    public PodMetadataNested<A> editOrNewPodMetadata() {
        return this.withNewPodMetadataLike(Optional.ofNullable(this.buildPodMetadata()).orElse(new EmbeddedObjectMetadataBuilder().build()));
    }

    public PodMetadataNested<A> editOrNewPodMetadataLike(EmbeddedObjectMetadata item) {
        return this.withNewPodMetadataLike(Optional.ofNullable(this.buildPodMetadata()).orElse(item));
    }

    public String getPortName() {
        return this.portName;
    }

    public A withPortName(String portName) {
        this.portName = portName;
        return (A)this;
    }

    public boolean hasPortName() {
        return this.portName != null;
    }

    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    public A withPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
        return (A)this;
    }

    public boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(ResourceRequirements resources) {
        this._visitables.remove("resources");
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get("resources").remove(this.resources);
        }
        return (A)this;
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public String getRetention() {
        return this.retention;
    }

    public A withRetention(String retention) {
        this.retention = retention;
        return (A)this;
    }

    public boolean hasRetention() {
        return this.retention != null;
    }

    public String getRoutePrefix() {
        return this.routePrefix;
    }

    public A withRoutePrefix(String routePrefix) {
        this.routePrefix = routePrefix;
        return (A)this;
    }

    public boolean hasRoutePrefix() {
        return this.routePrefix != null;
    }

    public A addToSecrets(int index, String item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        this.secrets.add(index, item);
        return (A)this;
    }

    public A setToSecrets(int index, String item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        this.secrets.set(index, item);
        return (A)this;
    }

    public A addToSecrets(String ... items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.secrets.add(item);
        }
        return (A)this;
    }

    public A addAllToSecrets(Collection<String> items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<String>();
        }
        for (String item : items) {
            this.secrets.add(item);
        }
        return (A)this;
    }

    public A removeFromSecrets(String ... items) {
        if (this.secrets == null) {
            return (A)this;
        }
        for (String item : items) {
            this.secrets.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromSecrets(Collection<String> items) {
        if (this.secrets == null) {
            return (A)this;
        }
        for (String item : items) {
            this.secrets.remove(item);
        }
        return (A)this;
    }

    public List<String> getSecrets() {
        return this.secrets;
    }

    public String getSecret(int index) {
        return this.secrets.get(index);
    }

    public String getFirstSecret() {
        return this.secrets.get(0);
    }

    public String getLastSecret() {
        return this.secrets.get(this.secrets.size() - 1);
    }

    public String getMatchingSecret(Predicate<String> predicate) {
        for (String item : this.secrets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingSecret(Predicate<String> predicate) {
        for (String item : this.secrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSecrets(List<String> secrets) {
        if (secrets != null) {
            this.secrets = new ArrayList<String>();
            for (String item : secrets) {
                this.addToSecrets(item);
            }
        } else {
            this.secrets = null;
        }
        return (A)this;
    }

    public A withSecrets(String ... secrets) {
        if (this.secrets != null) {
            this.secrets.clear();
            this._visitables.remove("secrets");
        }
        if (secrets != null) {
            for (String item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    public boolean hasSecrets() {
        return this.secrets != null && !this.secrets.isEmpty();
    }

    public PodSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public A withSecurityContext(PodSecurityContext securityContext) {
        this.securityContext = securityContext;
        return (A)this;
    }

    public boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)this;
    }

    public boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public String getSha() {
        return this.sha;
    }

    public A withSha(String sha) {
        this.sha = sha;
        return (A)this;
    }

    public boolean hasSha() {
        return this.sha != null;
    }

    public StorageSpec buildStorage() {
        return this.storage != null ? this.storage.build() : null;
    }

    public A withStorage(StorageSpec storage) {
        this._visitables.remove("storage");
        if (storage != null) {
            this.storage = new StorageSpecBuilder(storage);
            this._visitables.get("storage").add(this.storage);
        } else {
            this.storage = null;
            this._visitables.get("storage").remove(this.storage);
        }
        return (A)this;
    }

    public boolean hasStorage() {
        return this.storage != null;
    }

    public StorageNested<A> withNewStorage() {
        return new StorageNested(null);
    }

    public StorageNested<A> withNewStorageLike(StorageSpec item) {
        return new StorageNested(item);
    }

    public StorageNested<A> editStorage() {
        return this.withNewStorageLike(Optional.ofNullable(this.buildStorage()).orElse(null));
    }

    public StorageNested<A> editOrNewStorage() {
        return this.withNewStorageLike(Optional.ofNullable(this.buildStorage()).orElse(new StorageSpecBuilder().build()));
    }

    public StorageNested<A> editOrNewStorageLike(StorageSpec item) {
        return this.withNewStorageLike(Optional.ofNullable(this.buildStorage()).orElse(item));
    }

    public String getTag() {
        return this.tag;
    }

    public A withTag(String tag) {
        this.tag = tag;
        return (A)this;
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)this;
    }

    public A setToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.set(index, item);
        return (A)this;
    }

    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    public A removeFromTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            return (A)this;
        }
        for (Toleration item : items) {
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            return (A)this;
        }
        for (Toleration item : items) {
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTolerations(List<Toleration> tolerations) {
        if (tolerations != null) {
            this.tolerations = new ArrayList<Toleration>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
            this._visitables.remove("tolerations");
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    public boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public A addToTopologySpreadConstraints(int index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.add(index, item);
        return (A)this;
    }

    public A setToTopologySpreadConstraints(int index, TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        this.topologySpreadConstraints.set(index, item);
        return (A)this;
    }

    public A addToTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.add(item);
        }
        return (A)this;
    }

    public A addAllToTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.add(item);
        }
        return (A)this;
    }

    public A removeFromTopologySpreadConstraints(TopologySpreadConstraint ... items) {
        if (this.topologySpreadConstraints == null) {
            return (A)this;
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromTopologySpreadConstraints(Collection<TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {
            return (A)this;
        }
        for (TopologySpreadConstraint item : items) {
            this.topologySpreadConstraints.remove(item);
        }
        return (A)this;
    }

    public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
        return this.topologySpreadConstraints;
    }

    public TopologySpreadConstraint getTopologySpreadConstraint(int index) {
        return this.topologySpreadConstraints.get(index);
    }

    public TopologySpreadConstraint getFirstTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(0);
    }

    public TopologySpreadConstraint getLastTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(this.topologySpreadConstraints.size() - 1);
    }

    public TopologySpreadConstraint getMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraint> predicate) {
        for (TopologySpreadConstraint item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
        if (topologySpreadConstraints != null) {
            this.topologySpreadConstraints = new ArrayList<TopologySpreadConstraint>();
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        } else {
            this.topologySpreadConstraints = null;
        }
        return (A)this;
    }

    public A withTopologySpreadConstraints(TopologySpreadConstraint ... topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this.topologySpreadConstraints.clear();
            this._visitables.remove("topologySpreadConstraints");
        }
        if (topologySpreadConstraints != null) {
            for (TopologySpreadConstraint item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        }
        return (A)this;
    }

    public boolean hasTopologySpreadConstraints() {
        return this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty();
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public A addToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        VolumeMountBuilder builder = new VolumeMountBuilder(item);
        if (index < 0 || index >= this.volumeMounts.size()) {
            this._visitables.get("volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        } else {
            this._visitables.get("volumeMounts").add(index, builder);
            this.volumeMounts.add(index, builder);
        }
        return (A)this;
    }

    public A setToVolumeMounts(int index, VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        VolumeMountBuilder builder = new VolumeMountBuilder(item);
        if (index < 0 || index >= this.volumeMounts.size()) {
            this._visitables.get("volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        } else {
            this._visitables.get("volumeMounts").set(index, builder);
            this.volumeMounts.set(index, builder);
        }
        return (A)this;
    }

    public A addToVolumeMounts(VolumeMount ... items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)this;
    }

    public A addAllToVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)this;
    }

    public A removeFromVolumeMounts(VolumeMount ... items) {
        if (this.volumeMounts == null) {
            return (A)this;
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").remove(builder);
            this.volumeMounts.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {
            return (A)this;
        }
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").remove(builder);
            this.volumeMounts.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromVolumeMounts(Predicate<VolumeMountBuilder> predicate) {
        if (this.volumeMounts == null) {
            return (A)this;
        }
        Iterator<VolumeMountBuilder> each = this.volumeMounts.iterator();
        Object visitables = this._visitables.get("volumeMounts");
        while (each.hasNext()) {
            VolumeMountBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<VolumeMount> buildVolumeMounts() {
        return this.volumeMounts != null ? AlertmanagerSpecFluent.build(this.volumeMounts) : null;
    }

    public VolumeMount buildVolumeMount(int index) {
        return this.volumeMounts.get(index).build();
    }

    public VolumeMount buildFirstVolumeMount() {
        return this.volumeMounts.get(0).build();
    }

    public VolumeMount buildLastVolumeMount() {
        return this.volumeMounts.get(this.volumeMounts.size() - 1).build();
    }

    public VolumeMount buildMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.volumeMounts != null) {
            this._visitables.get("volumeMounts").clear();
        }
        if (volumeMounts != null) {
            this.volumeMounts = new ArrayList();
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        } else {
            this.volumeMounts = null;
        }
        return (A)this;
    }

    public A withVolumeMounts(VolumeMount ... volumeMounts) {
        if (this.volumeMounts != null) {
            this.volumeMounts.clear();
            this._visitables.remove("volumeMounts");
        }
        if (volumeMounts != null) {
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (A)this;
    }

    public boolean hasVolumeMounts() {
        return this.volumeMounts != null && !this.volumeMounts.isEmpty();
    }

    public VolumeMountsNested<A> addNewVolumeMount() {
        return new VolumeMountsNested(-1, null);
    }

    public VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item) {
        return new VolumeMountsNested(-1, item);
    }

    public VolumeMountsNested<A> setNewVolumeMountLike(int index, VolumeMount item) {
        return new VolumeMountsNested(index, item);
    }

    public VolumeMountsNested<A> editVolumeMount(int index) {
        if (this.volumeMounts.size() <= index) {
            throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public VolumeMountsNested<A> editFirstVolumeMount() {
        if (this.volumeMounts.size() == 0) {
            throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(0, this.buildVolumeMount(0));
    }

    public VolumeMountsNested<A> editLastVolumeMount() {
        int index = this.volumeMounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeMounts.size(); ++i) {
            if (!predicate.test(this.volumeMounts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public A addToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get("volumes").add(index, builder);
            this.volumes.add(index, builder);
        }
        return (A)this;
    }

    public A setToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get("volumes").set(index, builder);
            this.volumes.set(index, builder);
        }
        return (A)this;
    }

    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    public A removeFromVolumes(Volume ... items) {
        if (this.volumes == null) {
            return (A)this;
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").remove(builder);
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            return (A)this;
        }
        for (Volume item : items) {
            VolumeBuilder builder = new VolumeBuilder(item);
            this._visitables.get("volumes").remove(builder);
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
        if (this.volumes == null) {
            return (A)this;
        }
        Iterator<VolumeBuilder> each = this.volumes.iterator();
        Object visitables = this._visitables.get("volumes");
        while (each.hasNext()) {
            VolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<Volume> buildVolumes() {
        return this.volumes != null ? AlertmanagerSpecFluent.build(this.volumes) : null;
    }

    public Volume buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    public Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    public Volume buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get("volumes").clear();
        }
        if (volumes != null) {
            this.volumes = new ArrayList();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
            this._visitables.remove("volumes");
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    public boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public VolumesNested<A> addNewVolume() {
        return new VolumesNested(-1, null);
    }

    public VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNested(-1, item);
    }

    public VolumesNested<A> setNewVolumeLike(int index, Volume item) {
        return new VolumesNested(index, item);
    }

    public VolumesNested<A> editVolume(int index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    public VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public AlertmanagerWebSpec buildWeb() {
        return this.web != null ? this.web.build() : null;
    }

    public A withWeb(AlertmanagerWebSpec web) {
        this._visitables.remove("web");
        if (web != null) {
            this.web = new AlertmanagerWebSpecBuilder(web);
            this._visitables.get("web").add(this.web);
        } else {
            this.web = null;
            this._visitables.get("web").remove(this.web);
        }
        return (A)this;
    }

    public boolean hasWeb() {
        return this.web != null;
    }

    public WebNested<A> withNewWeb() {
        return new WebNested(null);
    }

    public WebNested<A> withNewWebLike(AlertmanagerWebSpec item) {
        return new WebNested(item);
    }

    public WebNested<A> editWeb() {
        return this.withNewWebLike(Optional.ofNullable(this.buildWeb()).orElse(null));
    }

    public WebNested<A> editOrNewWeb() {
        return this.withNewWebLike(Optional.ofNullable(this.buildWeb()).orElse(new AlertmanagerWebSpecBuilder().build()));
    }

    public WebNested<A> editOrNewWebLike(AlertmanagerWebSpec item) {
        return this.withNewWebLike(Optional.ofNullable(this.buildWeb()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlertmanagerSpecFluent that = (AlertmanagerSpecFluent)o;
        if (!Objects.equals(this.additionalPeers, that.additionalPeers)) {
            return false;
        }
        if (!Objects.equals(this.affinity, that.affinity)) {
            return false;
        }
        if (!Objects.equals(this.alertmanagerConfigMatcherStrategy, that.alertmanagerConfigMatcherStrategy)) {
            return false;
        }
        if (!Objects.equals(this.alertmanagerConfigNamespaceSelector, that.alertmanagerConfigNamespaceSelector)) {
            return false;
        }
        if (!Objects.equals(this.alertmanagerConfigSelector, that.alertmanagerConfigSelector)) {
            return false;
        }
        if (!Objects.equals(this.alertmanagerConfiguration, that.alertmanagerConfiguration)) {
            return false;
        }
        if (!Objects.equals(this.automountServiceAccountToken, that.automountServiceAccountToken)) {
            return false;
        }
        if (!Objects.equals(this.baseImage, that.baseImage)) {
            return false;
        }
        if (!Objects.equals(this.clusterAdvertiseAddress, that.clusterAdvertiseAddress)) {
            return false;
        }
        if (!Objects.equals(this.clusterGossipInterval, that.clusterGossipInterval)) {
            return false;
        }
        if (!Objects.equals(this.clusterLabel, that.clusterLabel)) {
            return false;
        }
        if (!Objects.equals(this.clusterPeerTimeout, that.clusterPeerTimeout)) {
            return false;
        }
        if (!Objects.equals(this.clusterPushpullInterval, that.clusterPushpullInterval)) {
            return false;
        }
        if (!Objects.equals(this.configMaps, that.configMaps)) {
            return false;
        }
        if (!Objects.equals(this.configSecret, that.configSecret)) {
            return false;
        }
        if (!Objects.equals(this.containers, that.containers)) {
            return false;
        }
        if (!Objects.equals(this.dnsConfig, that.dnsConfig)) {
            return false;
        }
        if (!Objects.equals(this.dnsPolicy, that.dnsPolicy)) {
            return false;
        }
        if (!Objects.equals(this.enableFeatures, that.enableFeatures)) {
            return false;
        }
        if (!Objects.equals(this.externalUrl, that.externalUrl)) {
            return false;
        }
        if (!Objects.equals(this.forceEnableClusterMode, that.forceEnableClusterMode)) {
            return false;
        }
        if (!Objects.equals(this.hostAliases, that.hostAliases)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.imagePullPolicy, that.imagePullPolicy)) {
            return false;
        }
        if (!Objects.equals(this.imagePullSecrets, that.imagePullSecrets)) {
            return false;
        }
        if (!Objects.equals(this.initContainers, that.initContainers)) {
            return false;
        }
        if (!Objects.equals(this.listenLocal, that.listenLocal)) {
            return false;
        }
        if (!Objects.equals(this.logFormat, that.logFormat)) {
            return false;
        }
        if (!Objects.equals(this.logLevel, that.logLevel)) {
            return false;
        }
        if (!Objects.equals(this.minReadySeconds, that.minReadySeconds)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.paused, that.paused)) {
            return false;
        }
        if (!Objects.equals(this.persistentVolumeClaimRetentionPolicy, that.persistentVolumeClaimRetentionPolicy)) {
            return false;
        }
        if (!Objects.equals(this.podMetadata, that.podMetadata)) {
            return false;
        }
        if (!Objects.equals(this.portName, that.portName)) {
            return false;
        }
        if (!Objects.equals(this.priorityClassName, that.priorityClassName)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals(this.retention, that.retention)) {
            return false;
        }
        if (!Objects.equals(this.routePrefix, that.routePrefix)) {
            return false;
        }
        if (!Objects.equals(this.secrets, that.secrets)) {
            return false;
        }
        if (!Objects.equals(this.securityContext, that.securityContext)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountName, that.serviceAccountName)) {
            return false;
        }
        if (!Objects.equals(this.sha, that.sha)) {
            return false;
        }
        if (!Objects.equals(this.storage, that.storage)) {
            return false;
        }
        if (!Objects.equals(this.tag, that.tag)) {
            return false;
        }
        if (!Objects.equals(this.tolerations, that.tolerations)) {
            return false;
        }
        if (!Objects.equals(this.topologySpreadConstraints, that.topologySpreadConstraints)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        if (!Objects.equals(this.volumeMounts, that.volumeMounts)) {
            return false;
        }
        if (!Objects.equals(this.volumes, that.volumes)) {
            return false;
        }
        if (!Objects.equals(this.web, that.web)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.additionalPeers, this.affinity, this.alertmanagerConfigMatcherStrategy, this.alertmanagerConfigNamespaceSelector, this.alertmanagerConfigSelector, this.alertmanagerConfiguration, this.automountServiceAccountToken, this.baseImage, this.clusterAdvertiseAddress, this.clusterGossipInterval, this.clusterLabel, this.clusterPeerTimeout, this.clusterPushpullInterval, this.configMaps, this.configSecret, this.containers, this.dnsConfig, this.dnsPolicy, this.enableFeatures, this.externalUrl, this.forceEnableClusterMode, this.hostAliases, this.image, this.imagePullPolicy, this.imagePullSecrets, this.initContainers, this.listenLocal, this.logFormat, this.logLevel, this.minReadySeconds, this.nodeSelector, this.paused, this.persistentVolumeClaimRetentionPolicy, this.podMetadata, this.portName, this.priorityClassName, this.replicas, this.resources, this.retention, this.routePrefix, this.secrets, this.securityContext, this.serviceAccountName, this.sha, this.storage, this.tag, this.tolerations, this.topologySpreadConstraints, this.version, this.volumeMounts, this.volumes, this.web, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.additionalPeers != null && !this.additionalPeers.isEmpty()) {
            sb.append("additionalPeers:");
            sb.append(this.additionalPeers + ",");
        }
        if (this.affinity != null) {
            sb.append("affinity:");
            sb.append(this.affinity + ",");
        }
        if (this.alertmanagerConfigMatcherStrategy != null) {
            sb.append("alertmanagerConfigMatcherStrategy:");
            sb.append(this.alertmanagerConfigMatcherStrategy + ",");
        }
        if (this.alertmanagerConfigNamespaceSelector != null) {
            sb.append("alertmanagerConfigNamespaceSelector:");
            sb.append(this.alertmanagerConfigNamespaceSelector + ",");
        }
        if (this.alertmanagerConfigSelector != null) {
            sb.append("alertmanagerConfigSelector:");
            sb.append(this.alertmanagerConfigSelector + ",");
        }
        if (this.alertmanagerConfiguration != null) {
            sb.append("alertmanagerConfiguration:");
            sb.append(this.alertmanagerConfiguration + ",");
        }
        if (this.automountServiceAccountToken != null) {
            sb.append("automountServiceAccountToken:");
            sb.append(this.automountServiceAccountToken + ",");
        }
        if (this.baseImage != null) {
            sb.append("baseImage:");
            sb.append(this.baseImage + ",");
        }
        if (this.clusterAdvertiseAddress != null) {
            sb.append("clusterAdvertiseAddress:");
            sb.append(this.clusterAdvertiseAddress + ",");
        }
        if (this.clusterGossipInterval != null) {
            sb.append("clusterGossipInterval:");
            sb.append(this.clusterGossipInterval + ",");
        }
        if (this.clusterLabel != null) {
            sb.append("clusterLabel:");
            sb.append(this.clusterLabel + ",");
        }
        if (this.clusterPeerTimeout != null) {
            sb.append("clusterPeerTimeout:");
            sb.append(this.clusterPeerTimeout + ",");
        }
        if (this.clusterPushpullInterval != null) {
            sb.append("clusterPushpullInterval:");
            sb.append(this.clusterPushpullInterval + ",");
        }
        if (this.configMaps != null && !this.configMaps.isEmpty()) {
            sb.append("configMaps:");
            sb.append(this.configMaps + ",");
        }
        if (this.configSecret != null) {
            sb.append("configSecret:");
            sb.append(this.configSecret + ",");
        }
        if (this.containers != null && !this.containers.isEmpty()) {
            sb.append("containers:");
            sb.append(this.containers + ",");
        }
        if (this.dnsConfig != null) {
            sb.append("dnsConfig:");
            sb.append(this.dnsConfig + ",");
        }
        if (this.dnsPolicy != null) {
            sb.append("dnsPolicy:");
            sb.append(this.dnsPolicy + ",");
        }
        if (this.enableFeatures != null && !this.enableFeatures.isEmpty()) {
            sb.append("enableFeatures:");
            sb.append(this.enableFeatures + ",");
        }
        if (this.externalUrl != null) {
            sb.append("externalUrl:");
            sb.append(this.externalUrl + ",");
        }
        if (this.forceEnableClusterMode != null) {
            sb.append("forceEnableClusterMode:");
            sb.append(this.forceEnableClusterMode + ",");
        }
        if (this.hostAliases != null && !this.hostAliases.isEmpty()) {
            sb.append("hostAliases:");
            sb.append(this.hostAliases + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.imagePullPolicy != null) {
            sb.append("imagePullPolicy:");
            sb.append(this.imagePullPolicy + ",");
        }
        if (this.imagePullSecrets != null && !this.imagePullSecrets.isEmpty()) {
            sb.append("imagePullSecrets:");
            sb.append(this.imagePullSecrets + ",");
        }
        if (this.initContainers != null && !this.initContainers.isEmpty()) {
            sb.append("initContainers:");
            sb.append(this.initContainers + ",");
        }
        if (this.listenLocal != null) {
            sb.append("listenLocal:");
            sb.append(this.listenLocal + ",");
        }
        if (this.logFormat != null) {
            sb.append("logFormat:");
            sb.append(this.logFormat + ",");
        }
        if (this.logLevel != null) {
            sb.append("logLevel:");
            sb.append(this.logLevel + ",");
        }
        if (this.minReadySeconds != null) {
            sb.append("minReadySeconds:");
            sb.append(this.minReadySeconds + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.paused != null) {
            sb.append("paused:");
            sb.append(this.paused + ",");
        }
        if (this.persistentVolumeClaimRetentionPolicy != null) {
            sb.append("persistentVolumeClaimRetentionPolicy:");
            sb.append(this.persistentVolumeClaimRetentionPolicy + ",");
        }
        if (this.podMetadata != null) {
            sb.append("podMetadata:");
            sb.append(this.podMetadata + ",");
        }
        if (this.portName != null) {
            sb.append("portName:");
            sb.append(this.portName + ",");
        }
        if (this.priorityClassName != null) {
            sb.append("priorityClassName:");
            sb.append(this.priorityClassName + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.retention != null) {
            sb.append("retention:");
            sb.append(this.retention + ",");
        }
        if (this.routePrefix != null) {
            sb.append("routePrefix:");
            sb.append(this.routePrefix + ",");
        }
        if (this.secrets != null && !this.secrets.isEmpty()) {
            sb.append("secrets:");
            sb.append(this.secrets + ",");
        }
        if (this.securityContext != null) {
            sb.append("securityContext:");
            sb.append(this.securityContext + ",");
        }
        if (this.serviceAccountName != null) {
            sb.append("serviceAccountName:");
            sb.append(this.serviceAccountName + ",");
        }
        if (this.sha != null) {
            sb.append("sha:");
            sb.append(this.sha + ",");
        }
        if (this.storage != null) {
            sb.append("storage:");
            sb.append(this.storage + ",");
        }
        if (this.tag != null) {
            sb.append("tag:");
            sb.append(this.tag + ",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(this.tolerations + ",");
        }
        if (this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty()) {
            sb.append("topologySpreadConstraints:");
            sb.append(this.topologySpreadConstraints + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.volumeMounts != null && !this.volumeMounts.isEmpty()) {
            sb.append("volumeMounts:");
            sb.append(this.volumeMounts + ",");
        }
        if (this.volumes != null && !this.volumes.isEmpty()) {
            sb.append("volumes:");
            sb.append(this.volumes + ",");
        }
        if (this.web != null) {
            sb.append("web:");
            sb.append(this.web + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAutomountServiceAccountToken() {
        return this.withAutomountServiceAccountToken(true);
    }

    public A withForceEnableClusterMode() {
        return this.withForceEnableClusterMode(true);
    }

    public A withListenLocal() {
        return this.withListenLocal(true);
    }

    public A withPaused() {
        return this.withPaused(true);
    }

    public class WebNested<N>
    extends AlertmanagerWebSpecFluent<WebNested<N>>
    implements Nested<N> {
        AlertmanagerWebSpecBuilder builder;

        WebNested(AlertmanagerWebSpec item) {
            this.builder = new AlertmanagerWebSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluent.this.withWeb(this.builder.build());
        }

        public N endWeb() {
            return this.and();
        }
    }

    public class VolumesNested<N>
    extends VolumeFluent<VolumesNested<N>>
    implements Nested<N> {
        VolumeBuilder builder;
        int index;

        VolumesNested(int index, Volume item) {
            this.index = index;
            this.builder = new VolumeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluent.this.setToVolumes(this.index, this.builder.build());
        }

        public N endVolume() {
            return this.and();
        }
    }

    public class VolumeMountsNested<N>
    extends VolumeMountFluent<VolumeMountsNested<N>>
    implements Nested<N> {
        VolumeMountBuilder builder;
        int index;

        VolumeMountsNested(int index, VolumeMount item) {
            this.index = index;
            this.builder = new VolumeMountBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluent.this.setToVolumeMounts(this.index, this.builder.build());
        }

        public N endVolumeMount() {
            return this.and();
        }
    }

    public class StorageNested<N>
    extends StorageSpecFluent<StorageNested<N>>
    implements Nested<N> {
        StorageSpecBuilder builder;

        StorageNested(StorageSpec item) {
            this.builder = new StorageSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluent.this.withStorage(this.builder.build());
        }

        public N endStorage() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }

    public class PodMetadataNested<N>
    extends EmbeddedObjectMetadataFluent<PodMetadataNested<N>>
    implements Nested<N> {
        EmbeddedObjectMetadataBuilder builder;

        PodMetadataNested(EmbeddedObjectMetadata item) {
            this.builder = new EmbeddedObjectMetadataBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluent.this.withPodMetadata(this.builder.build());
        }

        public N endPodMetadata() {
            return this.and();
        }
    }

    public class InitContainersNested<N>
    extends ContainerFluent<InitContainersNested<N>>
    implements Nested<N> {
        ContainerBuilder builder;
        int index;

        InitContainersNested(int index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluent.this.setToInitContainers(this.index, this.builder.build());
        }

        public N endInitContainer() {
            return this.and();
        }
    }

    public class ImagePullSecretsNested<N>
    extends LocalObjectReferenceFluent<ImagePullSecretsNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;
        int index;

        ImagePullSecretsNested(int index, LocalObjectReference item) {
            this.index = index;
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluent.this.setToImagePullSecrets(this.index, this.builder.build());
        }

        public N endImagePullSecret() {
            return this.and();
        }
    }

    public class HostAliasesNested<N>
    extends HostAliasFluent<HostAliasesNested<N>>
    implements Nested<N> {
        HostAliasBuilder builder;
        int index;

        HostAliasesNested(int index, HostAlias item) {
            this.index = index;
            this.builder = new HostAliasBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluent.this.setToHostAliases(this.index, this.builder.build());
        }

        public N endHostAlias() {
            return this.and();
        }
    }

    public class DnsConfigNested<N>
    extends PodDNSConfigFluent<DnsConfigNested<N>>
    implements Nested<N> {
        PodDNSConfigBuilder builder;

        DnsConfigNested(PodDNSConfig item) {
            this.builder = new PodDNSConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluent.this.withDnsConfig(this.builder.build());
        }

        public N endDnsConfig() {
            return this.and();
        }
    }

    public class ContainersNested<N>
    extends ContainerFluent<ContainersNested<N>>
    implements Nested<N> {
        ContainerBuilder builder;
        int index;

        ContainersNested(int index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluent.this.setToContainers(this.index, this.builder.build());
        }

        public N endContainer() {
            return this.and();
        }
    }

    public class AlertmanagerConfigurationNested<N>
    extends AlertmanagerConfigurationFluent<AlertmanagerConfigurationNested<N>>
    implements Nested<N> {
        AlertmanagerConfigurationBuilder builder;

        AlertmanagerConfigurationNested(AlertmanagerConfiguration item) {
            this.builder = new AlertmanagerConfigurationBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluent.this.withAlertmanagerConfiguration(this.builder.build());
        }

        public N endAlertmanagerConfiguration() {
            return this.and();
        }
    }

    public class AlertmanagerConfigSelectorNested<N>
    extends LabelSelectorFluent<AlertmanagerConfigSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        AlertmanagerConfigSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluent.this.withAlertmanagerConfigSelector(this.builder.build());
        }

        public N endAlertmanagerConfigSelector() {
            return this.and();
        }
    }

    public class AlertmanagerConfigNamespaceSelectorNested<N>
    extends LabelSelectorFluent<AlertmanagerConfigNamespaceSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        AlertmanagerConfigNamespaceSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluent.this.withAlertmanagerConfigNamespaceSelector(this.builder.build());
        }

        public N endAlertmanagerConfigNamespaceSelector() {
            return this.and();
        }
    }

    public class AlertmanagerConfigMatcherStrategyNested<N>
    extends AlertmanagerConfigMatcherStrategyFluent<AlertmanagerConfigMatcherStrategyNested<N>>
    implements Nested<N> {
        AlertmanagerConfigMatcherStrategyBuilder builder;

        AlertmanagerConfigMatcherStrategyNested(AlertmanagerConfigMatcherStrategy item) {
            this.builder = new AlertmanagerConfigMatcherStrategyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AlertmanagerSpecFluent.this.withAlertmanagerConfigMatcherStrategy(this.builder.build());
        }

        public N endAlertmanagerConfigMatcherStrategy() {
            return this.and();
        }
    }
}

