/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.IBMCloudPlatformStatus;
import io.fabric8.openshift.api.model.config.v1.IBMCloudServiceEndpoint;
import io.fabric8.openshift.api.model.config.v1.IBMCloudServiceEndpointBuilder;
import io.fabric8.openshift.api.model.config.v1.IBMCloudServiceEndpointFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class IBMCloudPlatformStatusFluent<A extends IBMCloudPlatformStatusFluent<A>>
extends BaseFluent<A> {
    private String cisInstanceCRN;
    private String dnsInstanceCRN;
    private String location;
    private String providerType;
    private String resourceGroupName;
    private ArrayList<IBMCloudServiceEndpointBuilder> serviceEndpoints = new ArrayList();
    private Map<String, Object> additionalProperties;

    public IBMCloudPlatformStatusFluent() {
    }

    public IBMCloudPlatformStatusFluent(IBMCloudPlatformStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IBMCloudPlatformStatus instance) {
        IBMCloudPlatformStatus iBMCloudPlatformStatus = instance = instance != null ? instance : new IBMCloudPlatformStatus();
        if (instance != null) {
            this.withCisInstanceCRN(instance.getCisInstanceCRN());
            this.withDnsInstanceCRN(instance.getDnsInstanceCRN());
            this.withLocation(instance.getLocation());
            this.withProviderType(instance.getProviderType());
            this.withResourceGroupName(instance.getResourceGroupName());
            this.withServiceEndpoints(instance.getServiceEndpoints());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getCisInstanceCRN() {
        return this.cisInstanceCRN;
    }

    public A withCisInstanceCRN(String cisInstanceCRN) {
        this.cisInstanceCRN = cisInstanceCRN;
        return (A)this;
    }

    public boolean hasCisInstanceCRN() {
        return this.cisInstanceCRN != null;
    }

    public String getDnsInstanceCRN() {
        return this.dnsInstanceCRN;
    }

    public A withDnsInstanceCRN(String dnsInstanceCRN) {
        this.dnsInstanceCRN = dnsInstanceCRN;
        return (A)this;
    }

    public boolean hasDnsInstanceCRN() {
        return this.dnsInstanceCRN != null;
    }

    public String getLocation() {
        return this.location;
    }

    public A withLocation(String location) {
        this.location = location;
        return (A)this;
    }

    public boolean hasLocation() {
        return this.location != null;
    }

    public String getProviderType() {
        return this.providerType;
    }

    public A withProviderType(String providerType) {
        this.providerType = providerType;
        return (A)this;
    }

    public boolean hasProviderType() {
        return this.providerType != null;
    }

    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    public A withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return (A)this;
    }

    public boolean hasResourceGroupName() {
        return this.resourceGroupName != null;
    }

    public A addToServiceEndpoints(int index, IBMCloudServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        IBMCloudServiceEndpointBuilder builder = new IBMCloudServiceEndpointBuilder(item);
        if (index < 0 || index >= this.serviceEndpoints.size()) {
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        } else {
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(index, builder);
        }
        return (A)this;
    }

    public A setToServiceEndpoints(int index, IBMCloudServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        IBMCloudServiceEndpointBuilder builder = new IBMCloudServiceEndpointBuilder(item);
        if (index < 0 || index >= this.serviceEndpoints.size()) {
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        } else {
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.set(index, builder);
        }
        return (A)this;
    }

    public A addToServiceEndpoints(IBMCloudServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        for (IBMCloudServiceEndpoint item : items) {
            IBMCloudServiceEndpointBuilder builder = new IBMCloudServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)this;
    }

    public A addAllToServiceEndpoints(Collection<IBMCloudServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        for (IBMCloudServiceEndpoint item : items) {
            IBMCloudServiceEndpointBuilder builder = new IBMCloudServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)this;
    }

    public A removeFromServiceEndpoints(IBMCloudServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        for (IBMCloudServiceEndpoint item : items) {
            IBMCloudServiceEndpointBuilder builder = new IBMCloudServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").remove(builder);
            this.serviceEndpoints.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromServiceEndpoints(Collection<IBMCloudServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        for (IBMCloudServiceEndpoint item : items) {
            IBMCloudServiceEndpointBuilder builder = new IBMCloudServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").remove(builder);
            this.serviceEndpoints.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromServiceEndpoints(Predicate<IBMCloudServiceEndpointBuilder> predicate) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        Iterator<IBMCloudServiceEndpointBuilder> each = this.serviceEndpoints.iterator();
        Object visitables = this._visitables.get("serviceEndpoints");
        while (each.hasNext()) {
            IBMCloudServiceEndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<IBMCloudServiceEndpoint> buildServiceEndpoints() {
        return this.serviceEndpoints != null ? IBMCloudPlatformStatusFluent.build(this.serviceEndpoints) : null;
    }

    public IBMCloudServiceEndpoint buildServiceEndpoint(int index) {
        return this.serviceEndpoints.get(index).build();
    }

    public IBMCloudServiceEndpoint buildFirstServiceEndpoint() {
        return this.serviceEndpoints.get(0).build();
    }

    public IBMCloudServiceEndpoint buildLastServiceEndpoint() {
        return this.serviceEndpoints.get(this.serviceEndpoints.size() - 1).build();
    }

    public IBMCloudServiceEndpoint buildMatchingServiceEndpoint(Predicate<IBMCloudServiceEndpointBuilder> predicate) {
        for (IBMCloudServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingServiceEndpoint(Predicate<IBMCloudServiceEndpointBuilder> predicate) {
        for (IBMCloudServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withServiceEndpoints(List<IBMCloudServiceEndpoint> serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this._visitables.get("serviceEndpoints").clear();
        }
        if (serviceEndpoints != null) {
            this.serviceEndpoints = new ArrayList();
            for (IBMCloudServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        } else {
            this.serviceEndpoints = null;
        }
        return (A)this;
    }

    public A withServiceEndpoints(IBMCloudServiceEndpoint ... serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this.serviceEndpoints.clear();
            this._visitables.remove("serviceEndpoints");
        }
        if (serviceEndpoints != null) {
            for (IBMCloudServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        }
        return (A)this;
    }

    public boolean hasServiceEndpoints() {
        return this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty();
    }

    public A addNewServiceEndpoint(String name, String url) {
        return this.addToServiceEndpoints(new IBMCloudServiceEndpoint(name, url));
    }

    public ServiceEndpointsNested<A> addNewServiceEndpoint() {
        return new ServiceEndpointsNested(-1, null);
    }

    public ServiceEndpointsNested<A> addNewServiceEndpointLike(IBMCloudServiceEndpoint item) {
        return new ServiceEndpointsNested(-1, item);
    }

    public ServiceEndpointsNested<A> setNewServiceEndpointLike(int index, IBMCloudServiceEndpoint item) {
        return new ServiceEndpointsNested(index, item);
    }

    public ServiceEndpointsNested<A> editServiceEndpoint(int index) {
        if (this.serviceEndpoints.size() <= index) {
            throw new RuntimeException("Can't edit serviceEndpoints. Index exceeds size.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public ServiceEndpointsNested<A> editFirstServiceEndpoint() {
        if (this.serviceEndpoints.size() == 0) {
            throw new RuntimeException("Can't edit first serviceEndpoints. The list is empty.");
        }
        return this.setNewServiceEndpointLike(0, this.buildServiceEndpoint(0));
    }

    public ServiceEndpointsNested<A> editLastServiceEndpoint() {
        int index = this.serviceEndpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last serviceEndpoints. The list is empty.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<IBMCloudServiceEndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.serviceEndpoints.size(); ++i) {
            if (!predicate.test(this.serviceEndpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching serviceEndpoints. No match found.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IBMCloudPlatformStatusFluent that = (IBMCloudPlatformStatusFluent)o;
        if (!Objects.equals(this.cisInstanceCRN, that.cisInstanceCRN)) {
            return false;
        }
        if (!Objects.equals(this.dnsInstanceCRN, that.dnsInstanceCRN)) {
            return false;
        }
        if (!Objects.equals(this.location, that.location)) {
            return false;
        }
        if (!Objects.equals(this.providerType, that.providerType)) {
            return false;
        }
        if (!Objects.equals(this.resourceGroupName, that.resourceGroupName)) {
            return false;
        }
        if (!Objects.equals(this.serviceEndpoints, that.serviceEndpoints)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cisInstanceCRN, this.dnsInstanceCRN, this.location, this.providerType, this.resourceGroupName, this.serviceEndpoints, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cisInstanceCRN != null) {
            sb.append("cisInstanceCRN:");
            sb.append(this.cisInstanceCRN + ",");
        }
        if (this.dnsInstanceCRN != null) {
            sb.append("dnsInstanceCRN:");
            sb.append(this.dnsInstanceCRN + ",");
        }
        if (this.location != null) {
            sb.append("location:");
            sb.append(this.location + ",");
        }
        if (this.providerType != null) {
            sb.append("providerType:");
            sb.append(this.providerType + ",");
        }
        if (this.resourceGroupName != null) {
            sb.append("resourceGroupName:");
            sb.append(this.resourceGroupName + ",");
        }
        if (this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty()) {
            sb.append("serviceEndpoints:");
            sb.append(String.valueOf(this.serviceEndpoints) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ServiceEndpointsNested<N>
    extends IBMCloudServiceEndpointFluent<ServiceEndpointsNested<N>>
    implements Nested<N> {
        IBMCloudServiceEndpointBuilder builder;
        int index;

        ServiceEndpointsNested(int index, IBMCloudServiceEndpoint item) {
            this.index = index;
            this.builder = new IBMCloudServiceEndpointBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IBMCloudPlatformStatusFluent.this.setToServiceEndpoints(this.index, this.builder.build());
        }

        public N endServiceEndpoint() {
            return this.and();
        }
    }
}

