/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.gcp.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.gcp.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.gcp.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.installer.gcp.v1.MachinePoolFluent;
import io.fabric8.openshift.api.model.installer.gcp.v1.Platform;
import io.fabric8.openshift.api.model.installer.gcp.v1.UserLabel;
import io.fabric8.openshift.api.model.installer.gcp.v1.UserLabelBuilder;
import io.fabric8.openshift.api.model.installer.gcp.v1.UserLabelFluent;
import io.fabric8.openshift.api.model.installer.gcp.v1.UserTag;
import io.fabric8.openshift.api.model.installer.gcp.v1.UserTagBuilder;
import io.fabric8.openshift.api.model.installer.gcp.v1.UserTagFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PlatformFluent<A extends PlatformFluent<A>>
extends BaseFluent<A> {
    private String computeSubnet;
    private String controlPlaneSubnet;
    private MachinePoolBuilder defaultMachinePlatform;
    private String network;
    private String networkProjectID;
    private String projectID;
    private String region;
    private ArrayList<UserLabelBuilder> userLabels = new ArrayList();
    private String userProvisionedDNS;
    private ArrayList<UserTagBuilder> userTags = new ArrayList();
    private Map<String, Object> additionalProperties;

    public PlatformFluent() {
    }

    public PlatformFluent(Platform instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Platform instance) {
        Platform platform = instance = instance != null ? instance : new Platform();
        if (instance != null) {
            this.withComputeSubnet(instance.getComputeSubnet());
            this.withControlPlaneSubnet(instance.getControlPlaneSubnet());
            this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
            this.withNetwork(instance.getNetwork());
            this.withNetworkProjectID(instance.getNetworkProjectID());
            this.withProjectID(instance.getProjectID());
            this.withRegion(instance.getRegion());
            this.withUserLabels(instance.getUserLabels());
            this.withUserProvisionedDNS(instance.getUserProvisionedDNS());
            this.withUserTags(instance.getUserTags());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getComputeSubnet() {
        return this.computeSubnet;
    }

    public A withComputeSubnet(String computeSubnet) {
        this.computeSubnet = computeSubnet;
        return (A)this;
    }

    public boolean hasComputeSubnet() {
        return this.computeSubnet != null;
    }

    public String getControlPlaneSubnet() {
        return this.controlPlaneSubnet;
    }

    public A withControlPlaneSubnet(String controlPlaneSubnet) {
        this.controlPlaneSubnet = controlPlaneSubnet;
        return (A)this;
    }

    public boolean hasControlPlaneSubnet() {
        return this.controlPlaneSubnet != null;
    }

    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.remove("defaultMachinePlatform");
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);
        } else {
            this.defaultMachinePlatform = null;
            this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
        }
        return (A)this;
    }

    public boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNested(null);
    }

    public DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNested(item);
    }

    public DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(null));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(new MachinePoolBuilder().build()));
    }

    public DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(Optional.ofNullable(this.buildDefaultMachinePlatform()).orElse(item));
    }

    public String getNetwork() {
        return this.network;
    }

    public A withNetwork(String network) {
        this.network = network;
        return (A)this;
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public String getNetworkProjectID() {
        return this.networkProjectID;
    }

    public A withNetworkProjectID(String networkProjectID) {
        this.networkProjectID = networkProjectID;
        return (A)this;
    }

    public boolean hasNetworkProjectID() {
        return this.networkProjectID != null;
    }

    public String getProjectID() {
        return this.projectID;
    }

    public A withProjectID(String projectID) {
        this.projectID = projectID;
        return (A)this;
    }

    public boolean hasProjectID() {
        return this.projectID != null;
    }

    public String getRegion() {
        return this.region;
    }

    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    public boolean hasRegion() {
        return this.region != null;
    }

    public A addToUserLabels(int index, UserLabel item) {
        if (this.userLabels == null) {
            this.userLabels = new ArrayList();
        }
        UserLabelBuilder builder = new UserLabelBuilder(item);
        if (index < 0 || index >= this.userLabels.size()) {
            this._visitables.get("userLabels").add(builder);
            this.userLabels.add(builder);
        } else {
            this._visitables.get("userLabels").add(builder);
            this.userLabels.add(index, builder);
        }
        return (A)this;
    }

    public A setToUserLabels(int index, UserLabel item) {
        if (this.userLabels == null) {
            this.userLabels = new ArrayList();
        }
        UserLabelBuilder builder = new UserLabelBuilder(item);
        if (index < 0 || index >= this.userLabels.size()) {
            this._visitables.get("userLabels").add(builder);
            this.userLabels.add(builder);
        } else {
            this._visitables.get("userLabels").add(builder);
            this.userLabels.set(index, builder);
        }
        return (A)this;
    }

    public A addToUserLabels(UserLabel ... items) {
        if (this.userLabels == null) {
            this.userLabels = new ArrayList();
        }
        for (UserLabel item : items) {
            UserLabelBuilder builder = new UserLabelBuilder(item);
            this._visitables.get("userLabels").add(builder);
            this.userLabels.add(builder);
        }
        return (A)this;
    }

    public A addAllToUserLabels(Collection<UserLabel> items) {
        if (this.userLabels == null) {
            this.userLabels = new ArrayList();
        }
        for (UserLabel item : items) {
            UserLabelBuilder builder = new UserLabelBuilder(item);
            this._visitables.get("userLabels").add(builder);
            this.userLabels.add(builder);
        }
        return (A)this;
    }

    public A removeFromUserLabels(UserLabel ... items) {
        if (this.userLabels == null) {
            return (A)this;
        }
        for (UserLabel item : items) {
            UserLabelBuilder builder = new UserLabelBuilder(item);
            this._visitables.get("userLabels").remove(builder);
            this.userLabels.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromUserLabels(Collection<UserLabel> items) {
        if (this.userLabels == null) {
            return (A)this;
        }
        for (UserLabel item : items) {
            UserLabelBuilder builder = new UserLabelBuilder(item);
            this._visitables.get("userLabels").remove(builder);
            this.userLabels.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromUserLabels(Predicate<UserLabelBuilder> predicate) {
        if (this.userLabels == null) {
            return (A)this;
        }
        Iterator<UserLabelBuilder> each = this.userLabels.iterator();
        Object visitables = this._visitables.get("userLabels");
        while (each.hasNext()) {
            UserLabelBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<UserLabel> buildUserLabels() {
        return this.userLabels != null ? PlatformFluent.build(this.userLabels) : null;
    }

    public UserLabel buildUserLabel(int index) {
        return this.userLabels.get(index).build();
    }

    public UserLabel buildFirstUserLabel() {
        return this.userLabels.get(0).build();
    }

    public UserLabel buildLastUserLabel() {
        return this.userLabels.get(this.userLabels.size() - 1).build();
    }

    public UserLabel buildMatchingUserLabel(Predicate<UserLabelBuilder> predicate) {
        for (UserLabelBuilder item : this.userLabels) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingUserLabel(Predicate<UserLabelBuilder> predicate) {
        for (UserLabelBuilder item : this.userLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUserLabels(List<UserLabel> userLabels) {
        if (this.userLabels != null) {
            this._visitables.get("userLabels").clear();
        }
        if (userLabels != null) {
            this.userLabels = new ArrayList();
            for (UserLabel item : userLabels) {
                this.addToUserLabels(item);
            }
        } else {
            this.userLabels = null;
        }
        return (A)this;
    }

    public A withUserLabels(UserLabel ... userLabels) {
        if (this.userLabels != null) {
            this.userLabels.clear();
            this._visitables.remove("userLabels");
        }
        if (userLabels != null) {
            for (UserLabel item : userLabels) {
                this.addToUserLabels(item);
            }
        }
        return (A)this;
    }

    public boolean hasUserLabels() {
        return this.userLabels != null && !this.userLabels.isEmpty();
    }

    public A addNewUserLabel(String key, String value) {
        return this.addToUserLabels(new UserLabel(key, value));
    }

    public UserLabelsNested<A> addNewUserLabel() {
        return new UserLabelsNested(-1, null);
    }

    public UserLabelsNested<A> addNewUserLabelLike(UserLabel item) {
        return new UserLabelsNested(-1, item);
    }

    public UserLabelsNested<A> setNewUserLabelLike(int index, UserLabel item) {
        return new UserLabelsNested(index, item);
    }

    public UserLabelsNested<A> editUserLabel(int index) {
        if (this.userLabels.size() <= index) {
            throw new RuntimeException("Can't edit userLabels. Index exceeds size.");
        }
        return this.setNewUserLabelLike(index, this.buildUserLabel(index));
    }

    public UserLabelsNested<A> editFirstUserLabel() {
        if (this.userLabels.size() == 0) {
            throw new RuntimeException("Can't edit first userLabels. The list is empty.");
        }
        return this.setNewUserLabelLike(0, this.buildUserLabel(0));
    }

    public UserLabelsNested<A> editLastUserLabel() {
        int index = this.userLabels.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last userLabels. The list is empty.");
        }
        return this.setNewUserLabelLike(index, this.buildUserLabel(index));
    }

    public UserLabelsNested<A> editMatchingUserLabel(Predicate<UserLabelBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.userLabels.size(); ++i) {
            if (!predicate.test(this.userLabels.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching userLabels. No match found.");
        }
        return this.setNewUserLabelLike(index, this.buildUserLabel(index));
    }

    public String getUserProvisionedDNS() {
        return this.userProvisionedDNS;
    }

    public A withUserProvisionedDNS(String userProvisionedDNS) {
        this.userProvisionedDNS = userProvisionedDNS;
        return (A)this;
    }

    public boolean hasUserProvisionedDNS() {
        return this.userProvisionedDNS != null;
    }

    public A addToUserTags(int index, UserTag item) {
        if (this.userTags == null) {
            this.userTags = new ArrayList();
        }
        UserTagBuilder builder = new UserTagBuilder(item);
        if (index < 0 || index >= this.userTags.size()) {
            this._visitables.get("userTags").add(builder);
            this.userTags.add(builder);
        } else {
            this._visitables.get("userTags").add(builder);
            this.userTags.add(index, builder);
        }
        return (A)this;
    }

    public A setToUserTags(int index, UserTag item) {
        if (this.userTags == null) {
            this.userTags = new ArrayList();
        }
        UserTagBuilder builder = new UserTagBuilder(item);
        if (index < 0 || index >= this.userTags.size()) {
            this._visitables.get("userTags").add(builder);
            this.userTags.add(builder);
        } else {
            this._visitables.get("userTags").add(builder);
            this.userTags.set(index, builder);
        }
        return (A)this;
    }

    public A addToUserTags(UserTag ... items) {
        if (this.userTags == null) {
            this.userTags = new ArrayList();
        }
        for (UserTag item : items) {
            UserTagBuilder builder = new UserTagBuilder(item);
            this._visitables.get("userTags").add(builder);
            this.userTags.add(builder);
        }
        return (A)this;
    }

    public A addAllToUserTags(Collection<UserTag> items) {
        if (this.userTags == null) {
            this.userTags = new ArrayList();
        }
        for (UserTag item : items) {
            UserTagBuilder builder = new UserTagBuilder(item);
            this._visitables.get("userTags").add(builder);
            this.userTags.add(builder);
        }
        return (A)this;
    }

    public A removeFromUserTags(UserTag ... items) {
        if (this.userTags == null) {
            return (A)this;
        }
        for (UserTag item : items) {
            UserTagBuilder builder = new UserTagBuilder(item);
            this._visitables.get("userTags").remove(builder);
            this.userTags.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromUserTags(Collection<UserTag> items) {
        if (this.userTags == null) {
            return (A)this;
        }
        for (UserTag item : items) {
            UserTagBuilder builder = new UserTagBuilder(item);
            this._visitables.get("userTags").remove(builder);
            this.userTags.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromUserTags(Predicate<UserTagBuilder> predicate) {
        if (this.userTags == null) {
            return (A)this;
        }
        Iterator<UserTagBuilder> each = this.userTags.iterator();
        Object visitables = this._visitables.get("userTags");
        while (each.hasNext()) {
            UserTagBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<UserTag> buildUserTags() {
        return this.userTags != null ? PlatformFluent.build(this.userTags) : null;
    }

    public UserTag buildUserTag(int index) {
        return this.userTags.get(index).build();
    }

    public UserTag buildFirstUserTag() {
        return this.userTags.get(0).build();
    }

    public UserTag buildLastUserTag() {
        return this.userTags.get(this.userTags.size() - 1).build();
    }

    public UserTag buildMatchingUserTag(Predicate<UserTagBuilder> predicate) {
        for (UserTagBuilder item : this.userTags) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingUserTag(Predicate<UserTagBuilder> predicate) {
        for (UserTagBuilder item : this.userTags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withUserTags(List<UserTag> userTags) {
        if (this.userTags != null) {
            this._visitables.get("userTags").clear();
        }
        if (userTags != null) {
            this.userTags = new ArrayList();
            for (UserTag item : userTags) {
                this.addToUserTags(item);
            }
        } else {
            this.userTags = null;
        }
        return (A)this;
    }

    public A withUserTags(UserTag ... userTags) {
        if (this.userTags != null) {
            this.userTags.clear();
            this._visitables.remove("userTags");
        }
        if (userTags != null) {
            for (UserTag item : userTags) {
                this.addToUserTags(item);
            }
        }
        return (A)this;
    }

    public boolean hasUserTags() {
        return this.userTags != null && !this.userTags.isEmpty();
    }

    public A addNewUserTag(String key, String parentID, String value) {
        return this.addToUserTags(new UserTag(key, parentID, value));
    }

    public UserTagsNested<A> addNewUserTag() {
        return new UserTagsNested(-1, null);
    }

    public UserTagsNested<A> addNewUserTagLike(UserTag item) {
        return new UserTagsNested(-1, item);
    }

    public UserTagsNested<A> setNewUserTagLike(int index, UserTag item) {
        return new UserTagsNested(index, item);
    }

    public UserTagsNested<A> editUserTag(int index) {
        if (this.userTags.size() <= index) {
            throw new RuntimeException("Can't edit userTags. Index exceeds size.");
        }
        return this.setNewUserTagLike(index, this.buildUserTag(index));
    }

    public UserTagsNested<A> editFirstUserTag() {
        if (this.userTags.size() == 0) {
            throw new RuntimeException("Can't edit first userTags. The list is empty.");
        }
        return this.setNewUserTagLike(0, this.buildUserTag(0));
    }

    public UserTagsNested<A> editLastUserTag() {
        int index = this.userTags.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last userTags. The list is empty.");
        }
        return this.setNewUserTagLike(index, this.buildUserTag(index));
    }

    public UserTagsNested<A> editMatchingUserTag(Predicate<UserTagBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.userTags.size(); ++i) {
            if (!predicate.test(this.userTags.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching userTags. No match found.");
        }
        return this.setNewUserTagLike(index, this.buildUserTag(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformFluent that = (PlatformFluent)o;
        if (!Objects.equals(this.computeSubnet, that.computeSubnet)) {
            return false;
        }
        if (!Objects.equals(this.controlPlaneSubnet, that.controlPlaneSubnet)) {
            return false;
        }
        if (!Objects.equals(this.defaultMachinePlatform, that.defaultMachinePlatform)) {
            return false;
        }
        if (!Objects.equals(this.network, that.network)) {
            return false;
        }
        if (!Objects.equals(this.networkProjectID, that.networkProjectID)) {
            return false;
        }
        if (!Objects.equals(this.projectID, that.projectID)) {
            return false;
        }
        if (!Objects.equals(this.region, that.region)) {
            return false;
        }
        if (!Objects.equals(this.userLabels, that.userLabels)) {
            return false;
        }
        if (!Objects.equals(this.userProvisionedDNS, that.userProvisionedDNS)) {
            return false;
        }
        if (!Objects.equals(this.userTags, that.userTags)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.computeSubnet, this.controlPlaneSubnet, this.defaultMachinePlatform, this.network, this.networkProjectID, this.projectID, this.region, this.userLabels, this.userProvisionedDNS, this.userTags, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.computeSubnet != null) {
            sb.append("computeSubnet:");
            sb.append(this.computeSubnet + ",");
        }
        if (this.controlPlaneSubnet != null) {
            sb.append("controlPlaneSubnet:");
            sb.append(this.controlPlaneSubnet + ",");
        }
        if (this.defaultMachinePlatform != null) {
            sb.append("defaultMachinePlatform:");
            sb.append(String.valueOf(this.defaultMachinePlatform) + ",");
        }
        if (this.network != null) {
            sb.append("network:");
            sb.append(this.network + ",");
        }
        if (this.networkProjectID != null) {
            sb.append("networkProjectID:");
            sb.append(this.networkProjectID + ",");
        }
        if (this.projectID != null) {
            sb.append("projectID:");
            sb.append(this.projectID + ",");
        }
        if (this.region != null) {
            sb.append("region:");
            sb.append(this.region + ",");
        }
        if (this.userLabels != null && !this.userLabels.isEmpty()) {
            sb.append("userLabels:");
            sb.append(String.valueOf(this.userLabels) + ",");
        }
        if (this.userProvisionedDNS != null) {
            sb.append("userProvisionedDNS:");
            sb.append(this.userProvisionedDNS + ",");
        }
        if (this.userTags != null && !this.userTags.isEmpty()) {
            sb.append("userTags:");
            sb.append(String.valueOf(this.userTags) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UserTagsNested<N>
    extends UserTagFluent<UserTagsNested<N>>
    implements Nested<N> {
        UserTagBuilder builder;
        int index;

        UserTagsNested(int index, UserTag item) {
            this.index = index;
            this.builder = new UserTagBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PlatformFluent.this.setToUserTags(this.index, this.builder.build());
        }

        public N endUserTag() {
            return this.and();
        }
    }

    public class UserLabelsNested<N>
    extends UserLabelFluent<UserLabelsNested<N>>
    implements Nested<N> {
        UserLabelBuilder builder;
        int index;

        UserLabelsNested(int index, UserLabel item) {
            this.index = index;
            this.builder = new UserLabelBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PlatformFluent.this.setToUserLabels(this.index, this.builder.build());
        }

        public N endUserLabel() {
            return this.and();
        }
    }

    public class DefaultMachinePlatformNested<N>
    extends MachinePoolFluent<DefaultMachinePlatformNested<N>>
    implements Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNested(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PlatformFluent.this.withDefaultMachinePlatform(this.builder.build());
        }

        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

