/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1beta1.ConfidentialVM;
import io.fabric8.openshift.api.model.machine.v1beta1.UEFISettings;
import io.fabric8.openshift.api.model.machine.v1beta1.UEFISettingsBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.UEFISettingsFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ConfidentialVMFluent<A extends ConfidentialVMFluent<A>>
extends BaseFluent<A> {
    private UEFISettingsBuilder uefiSettings;
    private Map<String, Object> additionalProperties;

    public ConfidentialVMFluent() {
    }

    public ConfidentialVMFluent(ConfidentialVM instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ConfidentialVM instance) {
        ConfidentialVM confidentialVM = instance = instance != null ? instance : new ConfidentialVM();
        if (instance != null) {
            this.withUefiSettings(instance.getUefiSettings());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public UEFISettings buildUefiSettings() {
        return this.uefiSettings != null ? this.uefiSettings.build() : null;
    }

    public A withUefiSettings(UEFISettings uefiSettings) {
        this._visitables.remove("uefiSettings");
        if (uefiSettings != null) {
            this.uefiSettings = new UEFISettingsBuilder(uefiSettings);
            this._visitables.get("uefiSettings").add(this.uefiSettings);
        } else {
            this.uefiSettings = null;
            this._visitables.get("uefiSettings").remove(this.uefiSettings);
        }
        return (A)this;
    }

    public boolean hasUefiSettings() {
        return this.uefiSettings != null;
    }

    public A withNewUefiSettings(String secureBoot, String virtualizedTrustedPlatformModule) {
        return this.withUefiSettings(new UEFISettings(secureBoot, virtualizedTrustedPlatformModule));
    }

    public UefiSettingsNested<A> withNewUefiSettings() {
        return new UefiSettingsNested(null);
    }

    public UefiSettingsNested<A> withNewUefiSettingsLike(UEFISettings item) {
        return new UefiSettingsNested(item);
    }

    public UefiSettingsNested<A> editUefiSettings() {
        return this.withNewUefiSettingsLike(Optional.ofNullable(this.buildUefiSettings()).orElse(null));
    }

    public UefiSettingsNested<A> editOrNewUefiSettings() {
        return this.withNewUefiSettingsLike(Optional.ofNullable(this.buildUefiSettings()).orElse(new UEFISettingsBuilder().build()));
    }

    public UefiSettingsNested<A> editOrNewUefiSettingsLike(UEFISettings item) {
        return this.withNewUefiSettingsLike(Optional.ofNullable(this.buildUefiSettings()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfidentialVMFluent that = (ConfidentialVMFluent)o;
        if (!Objects.equals(this.uefiSettings, that.uefiSettings)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.uefiSettings, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.uefiSettings != null) {
            sb.append("uefiSettings:");
            sb.append(String.valueOf(this.uefiSettings) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class UefiSettingsNested<N>
    extends UEFISettingsFluent<UefiSettingsNested<N>>
    implements Nested<N> {
        UEFISettingsBuilder builder;

        UefiSettingsNested(UEFISettings item) {
            this.builder = new UEFISettingsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ConfidentialVMFluent.this.withUefiSettings(this.builder.build());
        }

        public N endUefiSettings() {
            return this.and();
        }
    }
}

