/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfiguration.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.openshift.api.model.config.v1.DNS;
import io.fabric8.openshift.api.model.config.v1.Infrastructure;
import io.fabric8.openshift.api.model.config.v1.ProxyStatus;
import io.fabric8.openshift.api.model.machineconfiguration.v1.ControllerConfigSpec;
import io.fabric8.openshift.api.model.machineconfiguration.v1.ImageRegistryBundle;
import io.fabric8.openshift.api.model.machineconfiguration.v1.ImageRegistryBundleBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1.ImageRegistryBundleFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1.NetworkInfo;
import io.fabric8.openshift.api.model.machineconfiguration.v1.NetworkInfoBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1.NetworkInfoFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ControllerConfigSpecFluent<A extends ControllerConfigSpecFluent<A>>
extends BaseFluent<A> {
    private String additionalTrustBundle;
    private String baseOSContainerImage;
    private String baseOSExtensionsContainerImage;
    private String cloudProviderCAData;
    private String cloudProviderConfig;
    private String clusterDNSIP;
    private DNS dns;
    private String etcdDiscoveryDomain;
    private ArrayList<ImageRegistryBundleBuilder> imageRegistryBundleData = new ArrayList();
    private ArrayList<ImageRegistryBundleBuilder> imageRegistryBundleUserData = new ArrayList();
    private Map<String, String> images;
    private Infrastructure infra;
    private String internalRegistryPullSecret;
    private String ipFamilies;
    private String kubeAPIServerServingCAData;
    private NetworkInfoBuilder network;
    private String networkType;
    private String osImageURL;
    private String platform;
    private ProxyStatus proxy;
    private ObjectReferenceBuilder pullSecret;
    private String releaseImage;
    private String rootCAData;
    private Map<String, Object> additionalProperties;

    public ControllerConfigSpecFluent() {
    }

    public ControllerConfigSpecFluent(ControllerConfigSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ControllerConfigSpec instance) {
        ControllerConfigSpec controllerConfigSpec = instance = instance != null ? instance : new ControllerConfigSpec();
        if (instance != null) {
            this.withAdditionalTrustBundle(instance.getAdditionalTrustBundle());
            this.withBaseOSContainerImage(instance.getBaseOSContainerImage());
            this.withBaseOSExtensionsContainerImage(instance.getBaseOSExtensionsContainerImage());
            this.withCloudProviderCAData(instance.getCloudProviderCAData());
            this.withCloudProviderConfig(instance.getCloudProviderConfig());
            this.withClusterDNSIP(instance.getClusterDNSIP());
            this.withDns(instance.getDns());
            this.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain());
            this.withImageRegistryBundleData(instance.getImageRegistryBundleData());
            this.withImageRegistryBundleUserData(instance.getImageRegistryBundleUserData());
            this.withImages(instance.getImages());
            this.withInfra(instance.getInfra());
            this.withInternalRegistryPullSecret(instance.getInternalRegistryPullSecret());
            this.withIpFamilies(instance.getIpFamilies());
            this.withKubeAPIServerServingCAData(instance.getKubeAPIServerServingCAData());
            this.withNetwork(instance.getNetwork());
            this.withNetworkType(instance.getNetworkType());
            this.withOsImageURL(instance.getOsImageURL());
            this.withPlatform(instance.getPlatform());
            this.withProxy(instance.getProxy());
            this.withPullSecret(instance.getPullSecret());
            this.withReleaseImage(instance.getReleaseImage());
            this.withRootCAData(instance.getRootCAData());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAdditionalTrustBundle() {
        return this.additionalTrustBundle;
    }

    public A withAdditionalTrustBundle(String additionalTrustBundle) {
        this.additionalTrustBundle = additionalTrustBundle;
        return (A)this;
    }

    public boolean hasAdditionalTrustBundle() {
        return this.additionalTrustBundle != null;
    }

    public String getBaseOSContainerImage() {
        return this.baseOSContainerImage;
    }

    public A withBaseOSContainerImage(String baseOSContainerImage) {
        this.baseOSContainerImage = baseOSContainerImage;
        return (A)this;
    }

    public boolean hasBaseOSContainerImage() {
        return this.baseOSContainerImage != null;
    }

    public String getBaseOSExtensionsContainerImage() {
        return this.baseOSExtensionsContainerImage;
    }

    public A withBaseOSExtensionsContainerImage(String baseOSExtensionsContainerImage) {
        this.baseOSExtensionsContainerImage = baseOSExtensionsContainerImage;
        return (A)this;
    }

    public boolean hasBaseOSExtensionsContainerImage() {
        return this.baseOSExtensionsContainerImage != null;
    }

    public String getCloudProviderCAData() {
        return this.cloudProviderCAData;
    }

    public A withCloudProviderCAData(String cloudProviderCAData) {
        this.cloudProviderCAData = cloudProviderCAData;
        return (A)this;
    }

    public boolean hasCloudProviderCAData() {
        return this.cloudProviderCAData != null;
    }

    public String getCloudProviderConfig() {
        return this.cloudProviderConfig;
    }

    public A withCloudProviderConfig(String cloudProviderConfig) {
        this.cloudProviderConfig = cloudProviderConfig;
        return (A)this;
    }

    public boolean hasCloudProviderConfig() {
        return this.cloudProviderConfig != null;
    }

    public String getClusterDNSIP() {
        return this.clusterDNSIP;
    }

    public A withClusterDNSIP(String clusterDNSIP) {
        this.clusterDNSIP = clusterDNSIP;
        return (A)this;
    }

    public boolean hasClusterDNSIP() {
        return this.clusterDNSIP != null;
    }

    public DNS getDns() {
        return this.dns;
    }

    public A withDns(DNS dns) {
        this.dns = dns;
        return (A)this;
    }

    public boolean hasDns() {
        return this.dns != null;
    }

    public String getEtcdDiscoveryDomain() {
        return this.etcdDiscoveryDomain;
    }

    public A withEtcdDiscoveryDomain(String etcdDiscoveryDomain) {
        this.etcdDiscoveryDomain = etcdDiscoveryDomain;
        return (A)this;
    }

    public boolean hasEtcdDiscoveryDomain() {
        return this.etcdDiscoveryDomain != null;
    }

    public A addToImageRegistryBundleData(int index, ImageRegistryBundle item) {
        if (this.imageRegistryBundleData == null) {
            this.imageRegistryBundleData = new ArrayList();
        }
        ImageRegistryBundleBuilder builder = new ImageRegistryBundleBuilder(item);
        if (index < 0 || index >= this.imageRegistryBundleData.size()) {
            this._visitables.get("imageRegistryBundleData").add(builder);
            this.imageRegistryBundleData.add(builder);
        } else {
            this._visitables.get("imageRegistryBundleData").add(builder);
            this.imageRegistryBundleData.add(index, builder);
        }
        return (A)this;
    }

    public A setToImageRegistryBundleData(int index, ImageRegistryBundle item) {
        if (this.imageRegistryBundleData == null) {
            this.imageRegistryBundleData = new ArrayList();
        }
        ImageRegistryBundleBuilder builder = new ImageRegistryBundleBuilder(item);
        if (index < 0 || index >= this.imageRegistryBundleData.size()) {
            this._visitables.get("imageRegistryBundleData").add(builder);
            this.imageRegistryBundleData.add(builder);
        } else {
            this._visitables.get("imageRegistryBundleData").add(builder);
            this.imageRegistryBundleData.set(index, builder);
        }
        return (A)this;
    }

    public A addToImageRegistryBundleData(ImageRegistryBundle ... items) {
        if (this.imageRegistryBundleData == null) {
            this.imageRegistryBundleData = new ArrayList();
        }
        for (ImageRegistryBundle item : items) {
            ImageRegistryBundleBuilder builder = new ImageRegistryBundleBuilder(item);
            this._visitables.get("imageRegistryBundleData").add(builder);
            this.imageRegistryBundleData.add(builder);
        }
        return (A)this;
    }

    public A addAllToImageRegistryBundleData(Collection<ImageRegistryBundle> items) {
        if (this.imageRegistryBundleData == null) {
            this.imageRegistryBundleData = new ArrayList();
        }
        for (ImageRegistryBundle item : items) {
            ImageRegistryBundleBuilder builder = new ImageRegistryBundleBuilder(item);
            this._visitables.get("imageRegistryBundleData").add(builder);
            this.imageRegistryBundleData.add(builder);
        }
        return (A)this;
    }

    public A removeFromImageRegistryBundleData(ImageRegistryBundle ... items) {
        if (this.imageRegistryBundleData == null) {
            return (A)this;
        }
        for (ImageRegistryBundle item : items) {
            ImageRegistryBundleBuilder builder = new ImageRegistryBundleBuilder(item);
            this._visitables.get("imageRegistryBundleData").remove(builder);
            this.imageRegistryBundleData.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromImageRegistryBundleData(Collection<ImageRegistryBundle> items) {
        if (this.imageRegistryBundleData == null) {
            return (A)this;
        }
        for (ImageRegistryBundle item : items) {
            ImageRegistryBundleBuilder builder = new ImageRegistryBundleBuilder(item);
            this._visitables.get("imageRegistryBundleData").remove(builder);
            this.imageRegistryBundleData.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromImageRegistryBundleData(Predicate<ImageRegistryBundleBuilder> predicate) {
        if (this.imageRegistryBundleData == null) {
            return (A)this;
        }
        Iterator<ImageRegistryBundleBuilder> each = this.imageRegistryBundleData.iterator();
        Object visitables = this._visitables.get("imageRegistryBundleData");
        while (each.hasNext()) {
            ImageRegistryBundleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ImageRegistryBundle> buildImageRegistryBundleData() {
        return this.imageRegistryBundleData != null ? ControllerConfigSpecFluent.build(this.imageRegistryBundleData) : null;
    }

    public ImageRegistryBundle buildImageRegistryBundleDatum(int index) {
        return this.imageRegistryBundleData.get(index).build();
    }

    public ImageRegistryBundle buildFirstImageRegistryBundleDatum() {
        return this.imageRegistryBundleData.get(0).build();
    }

    public ImageRegistryBundle buildLastImageRegistryBundleDatum() {
        return this.imageRegistryBundleData.get(this.imageRegistryBundleData.size() - 1).build();
    }

    public ImageRegistryBundle buildMatchingImageRegistryBundleDatum(Predicate<ImageRegistryBundleBuilder> predicate) {
        for (ImageRegistryBundleBuilder item : this.imageRegistryBundleData) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingImageRegistryBundleDatum(Predicate<ImageRegistryBundleBuilder> predicate) {
        for (ImageRegistryBundleBuilder item : this.imageRegistryBundleData) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withImageRegistryBundleData(List<ImageRegistryBundle> imageRegistryBundleData) {
        if (this.imageRegistryBundleData != null) {
            this._visitables.get("imageRegistryBundleData").clear();
        }
        if (imageRegistryBundleData != null) {
            this.imageRegistryBundleData = new ArrayList();
            for (ImageRegistryBundle item : imageRegistryBundleData) {
                this.addToImageRegistryBundleData(item);
            }
        } else {
            this.imageRegistryBundleData = null;
        }
        return (A)this;
    }

    public A withImageRegistryBundleData(ImageRegistryBundle ... imageRegistryBundleData) {
        if (this.imageRegistryBundleData != null) {
            this.imageRegistryBundleData.clear();
            this._visitables.remove("imageRegistryBundleData");
        }
        if (imageRegistryBundleData != null) {
            for (ImageRegistryBundle item : imageRegistryBundleData) {
                this.addToImageRegistryBundleData(item);
            }
        }
        return (A)this;
    }

    public boolean hasImageRegistryBundleData() {
        return this.imageRegistryBundleData != null && !this.imageRegistryBundleData.isEmpty();
    }

    public A addNewImageRegistryBundleDatum(String data, String file) {
        return this.addToImageRegistryBundleData(new ImageRegistryBundle(data, file));
    }

    public ImageRegistryBundleDataNested<A> addNewImageRegistryBundleDatum() {
        return new ImageRegistryBundleDataNested(-1, null);
    }

    public ImageRegistryBundleDataNested<A> addNewImageRegistryBundleDatumLike(ImageRegistryBundle item) {
        return new ImageRegistryBundleDataNested(-1, item);
    }

    public ImageRegistryBundleDataNested<A> setNewImageRegistryBundleDatumLike(int index, ImageRegistryBundle item) {
        return new ImageRegistryBundleDataNested(index, item);
    }

    public ImageRegistryBundleDataNested<A> editImageRegistryBundleDatum(int index) {
        if (this.imageRegistryBundleData.size() <= index) {
            throw new RuntimeException("Can't edit imageRegistryBundleData. Index exceeds size.");
        }
        return this.setNewImageRegistryBundleDatumLike(index, this.buildImageRegistryBundleDatum(index));
    }

    public ImageRegistryBundleDataNested<A> editFirstImageRegistryBundleDatum() {
        if (this.imageRegistryBundleData.size() == 0) {
            throw new RuntimeException("Can't edit first imageRegistryBundleData. The list is empty.");
        }
        return this.setNewImageRegistryBundleDatumLike(0, this.buildImageRegistryBundleDatum(0));
    }

    public ImageRegistryBundleDataNested<A> editLastImageRegistryBundleDatum() {
        int index = this.imageRegistryBundleData.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imageRegistryBundleData. The list is empty.");
        }
        return this.setNewImageRegistryBundleDatumLike(index, this.buildImageRegistryBundleDatum(index));
    }

    public ImageRegistryBundleDataNested<A> editMatchingImageRegistryBundleDatum(Predicate<ImageRegistryBundleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imageRegistryBundleData.size(); ++i) {
            if (!predicate.test(this.imageRegistryBundleData.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imageRegistryBundleData. No match found.");
        }
        return this.setNewImageRegistryBundleDatumLike(index, this.buildImageRegistryBundleDatum(index));
    }

    public A addToImageRegistryBundleUserData(int index, ImageRegistryBundle item) {
        if (this.imageRegistryBundleUserData == null) {
            this.imageRegistryBundleUserData = new ArrayList();
        }
        ImageRegistryBundleBuilder builder = new ImageRegistryBundleBuilder(item);
        if (index < 0 || index >= this.imageRegistryBundleUserData.size()) {
            this._visitables.get("imageRegistryBundleUserData").add(builder);
            this.imageRegistryBundleUserData.add(builder);
        } else {
            this._visitables.get("imageRegistryBundleUserData").add(builder);
            this.imageRegistryBundleUserData.add(index, builder);
        }
        return (A)this;
    }

    public A setToImageRegistryBundleUserData(int index, ImageRegistryBundle item) {
        if (this.imageRegistryBundleUserData == null) {
            this.imageRegistryBundleUserData = new ArrayList();
        }
        ImageRegistryBundleBuilder builder = new ImageRegistryBundleBuilder(item);
        if (index < 0 || index >= this.imageRegistryBundleUserData.size()) {
            this._visitables.get("imageRegistryBundleUserData").add(builder);
            this.imageRegistryBundleUserData.add(builder);
        } else {
            this._visitables.get("imageRegistryBundleUserData").add(builder);
            this.imageRegistryBundleUserData.set(index, builder);
        }
        return (A)this;
    }

    public A addToImageRegistryBundleUserData(ImageRegistryBundle ... items) {
        if (this.imageRegistryBundleUserData == null) {
            this.imageRegistryBundleUserData = new ArrayList();
        }
        for (ImageRegistryBundle item : items) {
            ImageRegistryBundleBuilder builder = new ImageRegistryBundleBuilder(item);
            this._visitables.get("imageRegistryBundleUserData").add(builder);
            this.imageRegistryBundleUserData.add(builder);
        }
        return (A)this;
    }

    public A addAllToImageRegistryBundleUserData(Collection<ImageRegistryBundle> items) {
        if (this.imageRegistryBundleUserData == null) {
            this.imageRegistryBundleUserData = new ArrayList();
        }
        for (ImageRegistryBundle item : items) {
            ImageRegistryBundleBuilder builder = new ImageRegistryBundleBuilder(item);
            this._visitables.get("imageRegistryBundleUserData").add(builder);
            this.imageRegistryBundleUserData.add(builder);
        }
        return (A)this;
    }

    public A removeFromImageRegistryBundleUserData(ImageRegistryBundle ... items) {
        if (this.imageRegistryBundleUserData == null) {
            return (A)this;
        }
        for (ImageRegistryBundle item : items) {
            ImageRegistryBundleBuilder builder = new ImageRegistryBundleBuilder(item);
            this._visitables.get("imageRegistryBundleUserData").remove(builder);
            this.imageRegistryBundleUserData.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromImageRegistryBundleUserData(Collection<ImageRegistryBundle> items) {
        if (this.imageRegistryBundleUserData == null) {
            return (A)this;
        }
        for (ImageRegistryBundle item : items) {
            ImageRegistryBundleBuilder builder = new ImageRegistryBundleBuilder(item);
            this._visitables.get("imageRegistryBundleUserData").remove(builder);
            this.imageRegistryBundleUserData.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromImageRegistryBundleUserData(Predicate<ImageRegistryBundleBuilder> predicate) {
        if (this.imageRegistryBundleUserData == null) {
            return (A)this;
        }
        Iterator<ImageRegistryBundleBuilder> each = this.imageRegistryBundleUserData.iterator();
        Object visitables = this._visitables.get("imageRegistryBundleUserData");
        while (each.hasNext()) {
            ImageRegistryBundleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<ImageRegistryBundle> buildImageRegistryBundleUserData() {
        return this.imageRegistryBundleUserData != null ? ControllerConfigSpecFluent.build(this.imageRegistryBundleUserData) : null;
    }

    public ImageRegistryBundle buildImageRegistryBundleUserDatum(int index) {
        return this.imageRegistryBundleUserData.get(index).build();
    }

    public ImageRegistryBundle buildFirstImageRegistryBundleUserDatum() {
        return this.imageRegistryBundleUserData.get(0).build();
    }

    public ImageRegistryBundle buildLastImageRegistryBundleUserDatum() {
        return this.imageRegistryBundleUserData.get(this.imageRegistryBundleUserData.size() - 1).build();
    }

    public ImageRegistryBundle buildMatchingImageRegistryBundleUserDatum(Predicate<ImageRegistryBundleBuilder> predicate) {
        for (ImageRegistryBundleBuilder item : this.imageRegistryBundleUserData) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingImageRegistryBundleUserDatum(Predicate<ImageRegistryBundleBuilder> predicate) {
        for (ImageRegistryBundleBuilder item : this.imageRegistryBundleUserData) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withImageRegistryBundleUserData(List<ImageRegistryBundle> imageRegistryBundleUserData) {
        if (this.imageRegistryBundleUserData != null) {
            this._visitables.get("imageRegistryBundleUserData").clear();
        }
        if (imageRegistryBundleUserData != null) {
            this.imageRegistryBundleUserData = new ArrayList();
            for (ImageRegistryBundle item : imageRegistryBundleUserData) {
                this.addToImageRegistryBundleUserData(item);
            }
        } else {
            this.imageRegistryBundleUserData = null;
        }
        return (A)this;
    }

    public A withImageRegistryBundleUserData(ImageRegistryBundle ... imageRegistryBundleUserData) {
        if (this.imageRegistryBundleUserData != null) {
            this.imageRegistryBundleUserData.clear();
            this._visitables.remove("imageRegistryBundleUserData");
        }
        if (imageRegistryBundleUserData != null) {
            for (ImageRegistryBundle item : imageRegistryBundleUserData) {
                this.addToImageRegistryBundleUserData(item);
            }
        }
        return (A)this;
    }

    public boolean hasImageRegistryBundleUserData() {
        return this.imageRegistryBundleUserData != null && !this.imageRegistryBundleUserData.isEmpty();
    }

    public A addNewImageRegistryBundleUserDatum(String data, String file) {
        return this.addToImageRegistryBundleUserData(new ImageRegistryBundle(data, file));
    }

    public ImageRegistryBundleUserDataNested<A> addNewImageRegistryBundleUserDatum() {
        return new ImageRegistryBundleUserDataNested(-1, null);
    }

    public ImageRegistryBundleUserDataNested<A> addNewImageRegistryBundleUserDatumLike(ImageRegistryBundle item) {
        return new ImageRegistryBundleUserDataNested(-1, item);
    }

    public ImageRegistryBundleUserDataNested<A> setNewImageRegistryBundleUserDatumLike(int index, ImageRegistryBundle item) {
        return new ImageRegistryBundleUserDataNested(index, item);
    }

    public ImageRegistryBundleUserDataNested<A> editImageRegistryBundleUserDatum(int index) {
        if (this.imageRegistryBundleUserData.size() <= index) {
            throw new RuntimeException("Can't edit imageRegistryBundleUserData. Index exceeds size.");
        }
        return this.setNewImageRegistryBundleUserDatumLike(index, this.buildImageRegistryBundleUserDatum(index));
    }

    public ImageRegistryBundleUserDataNested<A> editFirstImageRegistryBundleUserDatum() {
        if (this.imageRegistryBundleUserData.size() == 0) {
            throw new RuntimeException("Can't edit first imageRegistryBundleUserData. The list is empty.");
        }
        return this.setNewImageRegistryBundleUserDatumLike(0, this.buildImageRegistryBundleUserDatum(0));
    }

    public ImageRegistryBundleUserDataNested<A> editLastImageRegistryBundleUserDatum() {
        int index = this.imageRegistryBundleUserData.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imageRegistryBundleUserData. The list is empty.");
        }
        return this.setNewImageRegistryBundleUserDatumLike(index, this.buildImageRegistryBundleUserDatum(index));
    }

    public ImageRegistryBundleUserDataNested<A> editMatchingImageRegistryBundleUserDatum(Predicate<ImageRegistryBundleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imageRegistryBundleUserData.size(); ++i) {
            if (!predicate.test(this.imageRegistryBundleUserData.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imageRegistryBundleUserData. No match found.");
        }
        return this.setNewImageRegistryBundleUserDatumLike(index, this.buildImageRegistryBundleUserDatum(index));
    }

    public A addToImages(String key, String value) {
        if (this.images == null && key != null && value != null) {
            this.images = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.images.put(key, value);
        }
        return (A)this;
    }

    public A addToImages(Map<String, String> map) {
        if (this.images == null && map != null) {
            this.images = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.images.putAll(map);
        }
        return (A)this;
    }

    public A removeFromImages(String key) {
        if (this.images == null) {
            return (A)this;
        }
        if (key != null && this.images != null) {
            this.images.remove(key);
        }
        return (A)this;
    }

    public A removeFromImages(Map<String, String> map) {
        if (this.images == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.images == null) continue;
                this.images.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getImages() {
        return this.images;
    }

    public <K, V> A withImages(Map<String, String> images) {
        this.images = images == null ? null : new LinkedHashMap<String, String>(images);
        return (A)this;
    }

    public boolean hasImages() {
        return this.images != null;
    }

    public Infrastructure getInfra() {
        return this.infra;
    }

    public A withInfra(Infrastructure infra) {
        this.infra = infra;
        return (A)this;
    }

    public boolean hasInfra() {
        return this.infra != null;
    }

    public String getInternalRegistryPullSecret() {
        return this.internalRegistryPullSecret;
    }

    public A withInternalRegistryPullSecret(String internalRegistryPullSecret) {
        this.internalRegistryPullSecret = internalRegistryPullSecret;
        return (A)this;
    }

    public boolean hasInternalRegistryPullSecret() {
        return this.internalRegistryPullSecret != null;
    }

    public String getIpFamilies() {
        return this.ipFamilies;
    }

    public A withIpFamilies(String ipFamilies) {
        this.ipFamilies = ipFamilies;
        return (A)this;
    }

    public boolean hasIpFamilies() {
        return this.ipFamilies != null;
    }

    public String getKubeAPIServerServingCAData() {
        return this.kubeAPIServerServingCAData;
    }

    public A withKubeAPIServerServingCAData(String kubeAPIServerServingCAData) {
        this.kubeAPIServerServingCAData = kubeAPIServerServingCAData;
        return (A)this;
    }

    public boolean hasKubeAPIServerServingCAData() {
        return this.kubeAPIServerServingCAData != null;
    }

    public NetworkInfo buildNetwork() {
        return this.network != null ? this.network.build() : null;
    }

    public A withNetwork(NetworkInfo network) {
        this._visitables.remove("network");
        if (network != null) {
            this.network = new NetworkInfoBuilder(network);
            this._visitables.get("network").add(this.network);
        } else {
            this.network = null;
            this._visitables.get("network").remove(this.network);
        }
        return (A)this;
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public NetworkNested<A> withNewNetwork() {
        return new NetworkNested(null);
    }

    public NetworkNested<A> withNewNetworkLike(NetworkInfo item) {
        return new NetworkNested(item);
    }

    public NetworkNested<A> editNetwork() {
        return this.withNewNetworkLike(Optional.ofNullable(this.buildNetwork()).orElse(null));
    }

    public NetworkNested<A> editOrNewNetwork() {
        return this.withNewNetworkLike(Optional.ofNullable(this.buildNetwork()).orElse(new NetworkInfoBuilder().build()));
    }

    public NetworkNested<A> editOrNewNetworkLike(NetworkInfo item) {
        return this.withNewNetworkLike(Optional.ofNullable(this.buildNetwork()).orElse(item));
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public A withNetworkType(String networkType) {
        this.networkType = networkType;
        return (A)this;
    }

    public boolean hasNetworkType() {
        return this.networkType != null;
    }

    public String getOsImageURL() {
        return this.osImageURL;
    }

    public A withOsImageURL(String osImageURL) {
        this.osImageURL = osImageURL;
        return (A)this;
    }

    public boolean hasOsImageURL() {
        return this.osImageURL != null;
    }

    public String getPlatform() {
        return this.platform;
    }

    public A withPlatform(String platform) {
        this.platform = platform;
        return (A)this;
    }

    public boolean hasPlatform() {
        return this.platform != null;
    }

    public ProxyStatus getProxy() {
        return this.proxy;
    }

    public A withProxy(ProxyStatus proxy) {
        this.proxy = proxy;
        return (A)this;
    }

    public boolean hasProxy() {
        return this.proxy != null;
    }

    public A withNewProxy(String httpProxy, String httpsProxy, String noProxy) {
        return this.withProxy(new ProxyStatus(httpProxy, httpsProxy, noProxy));
    }

    public ObjectReference buildPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    public A withPullSecret(ObjectReference pullSecret) {
        this._visitables.remove("pullSecret");
        if (pullSecret != null) {
            this.pullSecret = new ObjectReferenceBuilder(pullSecret);
            this._visitables.get("pullSecret").add(this.pullSecret);
        } else {
            this.pullSecret = null;
            this._visitables.get("pullSecret").remove(this.pullSecret);
        }
        return (A)this;
    }

    public boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    public PullSecretNested<A> withNewPullSecret() {
        return new PullSecretNested(null);
    }

    public PullSecretNested<A> withNewPullSecretLike(ObjectReference item) {
        return new PullSecretNested(item);
    }

    public PullSecretNested<A> editPullSecret() {
        return this.withNewPullSecretLike(Optional.ofNullable(this.buildPullSecret()).orElse(null));
    }

    public PullSecretNested<A> editOrNewPullSecret() {
        return this.withNewPullSecretLike(Optional.ofNullable(this.buildPullSecret()).orElse(new ObjectReferenceBuilder().build()));
    }

    public PullSecretNested<A> editOrNewPullSecretLike(ObjectReference item) {
        return this.withNewPullSecretLike(Optional.ofNullable(this.buildPullSecret()).orElse(item));
    }

    public String getReleaseImage() {
        return this.releaseImage;
    }

    public A withReleaseImage(String releaseImage) {
        this.releaseImage = releaseImage;
        return (A)this;
    }

    public boolean hasReleaseImage() {
        return this.releaseImage != null;
    }

    public String getRootCAData() {
        return this.rootCAData;
    }

    public A withRootCAData(String rootCAData) {
        this.rootCAData = rootCAData;
        return (A)this;
    }

    public boolean hasRootCAData() {
        return this.rootCAData != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ControllerConfigSpecFluent that = (ControllerConfigSpecFluent)o;
        if (!Objects.equals(this.additionalTrustBundle, that.additionalTrustBundle)) {
            return false;
        }
        if (!Objects.equals(this.baseOSContainerImage, that.baseOSContainerImage)) {
            return false;
        }
        if (!Objects.equals(this.baseOSExtensionsContainerImage, that.baseOSExtensionsContainerImage)) {
            return false;
        }
        if (!Objects.equals(this.cloudProviderCAData, that.cloudProviderCAData)) {
            return false;
        }
        if (!Objects.equals(this.cloudProviderConfig, that.cloudProviderConfig)) {
            return false;
        }
        if (!Objects.equals(this.clusterDNSIP, that.clusterDNSIP)) {
            return false;
        }
        if (!Objects.equals(this.dns, that.dns)) {
            return false;
        }
        if (!Objects.equals(this.etcdDiscoveryDomain, that.etcdDiscoveryDomain)) {
            return false;
        }
        if (!Objects.equals(this.imageRegistryBundleData, that.imageRegistryBundleData)) {
            return false;
        }
        if (!Objects.equals(this.imageRegistryBundleUserData, that.imageRegistryBundleUserData)) {
            return false;
        }
        if (!Objects.equals(this.images, that.images)) {
            return false;
        }
        if (!Objects.equals(this.infra, that.infra)) {
            return false;
        }
        if (!Objects.equals(this.internalRegistryPullSecret, that.internalRegistryPullSecret)) {
            return false;
        }
        if (!Objects.equals(this.ipFamilies, that.ipFamilies)) {
            return false;
        }
        if (!Objects.equals(this.kubeAPIServerServingCAData, that.kubeAPIServerServingCAData)) {
            return false;
        }
        if (!Objects.equals(this.network, that.network)) {
            return false;
        }
        if (!Objects.equals(this.networkType, that.networkType)) {
            return false;
        }
        if (!Objects.equals(this.osImageURL, that.osImageURL)) {
            return false;
        }
        if (!Objects.equals(this.platform, that.platform)) {
            return false;
        }
        if (!Objects.equals(this.proxy, that.proxy)) {
            return false;
        }
        if (!Objects.equals(this.pullSecret, that.pullSecret)) {
            return false;
        }
        if (!Objects.equals(this.releaseImage, that.releaseImage)) {
            return false;
        }
        if (!Objects.equals(this.rootCAData, that.rootCAData)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.additionalTrustBundle, this.baseOSContainerImage, this.baseOSExtensionsContainerImage, this.cloudProviderCAData, this.cloudProviderConfig, this.clusterDNSIP, this.dns, this.etcdDiscoveryDomain, this.imageRegistryBundleData, this.imageRegistryBundleUserData, this.images, this.infra, this.internalRegistryPullSecret, this.ipFamilies, this.kubeAPIServerServingCAData, this.network, this.networkType, this.osImageURL, this.platform, this.proxy, this.pullSecret, this.releaseImage, this.rootCAData, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.additionalTrustBundle != null) {
            sb.append("additionalTrustBundle:");
            sb.append(this.additionalTrustBundle + ",");
        }
        if (this.baseOSContainerImage != null) {
            sb.append("baseOSContainerImage:");
            sb.append(this.baseOSContainerImage + ",");
        }
        if (this.baseOSExtensionsContainerImage != null) {
            sb.append("baseOSExtensionsContainerImage:");
            sb.append(this.baseOSExtensionsContainerImage + ",");
        }
        if (this.cloudProviderCAData != null) {
            sb.append("cloudProviderCAData:");
            sb.append(this.cloudProviderCAData + ",");
        }
        if (this.cloudProviderConfig != null) {
            sb.append("cloudProviderConfig:");
            sb.append(this.cloudProviderConfig + ",");
        }
        if (this.clusterDNSIP != null) {
            sb.append("clusterDNSIP:");
            sb.append(this.clusterDNSIP + ",");
        }
        if (this.dns != null) {
            sb.append("dns:");
            sb.append(String.valueOf(this.dns) + ",");
        }
        if (this.etcdDiscoveryDomain != null) {
            sb.append("etcdDiscoveryDomain:");
            sb.append(this.etcdDiscoveryDomain + ",");
        }
        if (this.imageRegistryBundleData != null && !this.imageRegistryBundleData.isEmpty()) {
            sb.append("imageRegistryBundleData:");
            sb.append(String.valueOf(this.imageRegistryBundleData) + ",");
        }
        if (this.imageRegistryBundleUserData != null && !this.imageRegistryBundleUserData.isEmpty()) {
            sb.append("imageRegistryBundleUserData:");
            sb.append(String.valueOf(this.imageRegistryBundleUserData) + ",");
        }
        if (this.images != null && !this.images.isEmpty()) {
            sb.append("images:");
            sb.append(String.valueOf(this.images) + ",");
        }
        if (this.infra != null) {
            sb.append("infra:");
            sb.append(String.valueOf(this.infra) + ",");
        }
        if (this.internalRegistryPullSecret != null) {
            sb.append("internalRegistryPullSecret:");
            sb.append(this.internalRegistryPullSecret + ",");
        }
        if (this.ipFamilies != null) {
            sb.append("ipFamilies:");
            sb.append(this.ipFamilies + ",");
        }
        if (this.kubeAPIServerServingCAData != null) {
            sb.append("kubeAPIServerServingCAData:");
            sb.append(this.kubeAPIServerServingCAData + ",");
        }
        if (this.network != null) {
            sb.append("network:");
            sb.append(String.valueOf(this.network) + ",");
        }
        if (this.networkType != null) {
            sb.append("networkType:");
            sb.append(this.networkType + ",");
        }
        if (this.osImageURL != null) {
            sb.append("osImageURL:");
            sb.append(this.osImageURL + ",");
        }
        if (this.platform != null) {
            sb.append("platform:");
            sb.append(this.platform + ",");
        }
        if (this.proxy != null) {
            sb.append("proxy:");
            sb.append(String.valueOf(this.proxy) + ",");
        }
        if (this.pullSecret != null) {
            sb.append("pullSecret:");
            sb.append(String.valueOf(this.pullSecret) + ",");
        }
        if (this.releaseImage != null) {
            sb.append("releaseImage:");
            sb.append(this.releaseImage + ",");
        }
        if (this.rootCAData != null) {
            sb.append("rootCAData:");
            sb.append(this.rootCAData + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PullSecretNested<N>
    extends ObjectReferenceFluent<PullSecretNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        PullSecretNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ControllerConfigSpecFluent.this.withPullSecret(this.builder.build());
        }

        public N endPullSecret() {
            return this.and();
        }
    }

    public class NetworkNested<N>
    extends NetworkInfoFluent<NetworkNested<N>>
    implements Nested<N> {
        NetworkInfoBuilder builder;

        NetworkNested(NetworkInfo item) {
            this.builder = new NetworkInfoBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ControllerConfigSpecFluent.this.withNetwork(this.builder.build());
        }

        public N endNetwork() {
            return this.and();
        }
    }

    public class ImageRegistryBundleUserDataNested<N>
    extends ImageRegistryBundleFluent<ImageRegistryBundleUserDataNested<N>>
    implements Nested<N> {
        ImageRegistryBundleBuilder builder;
        int index;

        ImageRegistryBundleUserDataNested(int index, ImageRegistryBundle item) {
            this.index = index;
            this.builder = new ImageRegistryBundleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ControllerConfigSpecFluent.this.setToImageRegistryBundleUserData(this.index, this.builder.build());
        }

        public N endImageRegistryBundleUserDatum() {
            return this.and();
        }
    }

    public class ImageRegistryBundleDataNested<N>
    extends ImageRegistryBundleFluent<ImageRegistryBundleDataNested<N>>
    implements Nested<N> {
        ImageRegistryBundleBuilder builder;
        int index;

        ImageRegistryBundleDataNested(int index, ImageRegistryBundle item) {
            this.index = index;
            this.builder = new ImageRegistryBundleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ControllerConfigSpecFluent.this.setToImageRegistryBundleData(this.index, this.builder.build());
        }

        public N endImageRegistryBundleDatum() {
            return this.and();
        }
    }
}

