/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.openshift.api.model.config.v1.ConfigMapNameReference;
import io.fabric8.openshift.api.model.config.v1.TLSSecurityProfile;
import io.fabric8.openshift.api.model.operator.v1.ClientTLS;
import io.fabric8.openshift.api.model.operator.v1.ClientTLSBuilder;
import io.fabric8.openshift.api.model.operator.v1.ClientTLSFluent;
import io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategy;
import io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyBuilder;
import io.fabric8.openshift.api.model.operator.v1.EndpointPublishingStrategyFluent;
import io.fabric8.openshift.api.model.operator.v1.HTTPCompressionPolicy;
import io.fabric8.openshift.api.model.operator.v1.HTTPCompressionPolicyBuilder;
import io.fabric8.openshift.api.model.operator.v1.HTTPCompressionPolicyFluent;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeaders;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeadersBuilder;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerHTTPHeadersFluent;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerLogging;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerLoggingBuilder;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerLoggingFluent;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerSpec;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerTuningOptions;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerTuningOptionsBuilder;
import io.fabric8.openshift.api.model.operator.v1.IngressControllerTuningOptionsFluent;
import io.fabric8.openshift.api.model.operator.v1.NodePlacement;
import io.fabric8.openshift.api.model.operator.v1.NodePlacementBuilder;
import io.fabric8.openshift.api.model.operator.v1.NodePlacementFluent;
import io.fabric8.openshift.api.model.operator.v1.RouteAdmissionPolicy;
import io.fabric8.openshift.api.model.operator.v1.RouteAdmissionPolicyBuilder;
import io.fabric8.openshift.api.model.operator.v1.RouteAdmissionPolicyFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IngressControllerSpecFluent<A extends IngressControllerSpecFluent<A>>
extends BaseFluent<A> {
    private ClientTLSBuilder clientTLS;
    private LocalObjectReferenceBuilder defaultCertificate;
    private String domain;
    private EndpointPublishingStrategyBuilder endpointPublishingStrategy;
    private HTTPCompressionPolicyBuilder httpCompression;
    private String httpEmptyRequestsPolicy;
    private ConfigMapNameReference httpErrorCodePages;
    private IngressControllerHTTPHeadersBuilder httpHeaders;
    private String idleConnectionTerminationPolicy;
    private IngressControllerLoggingBuilder logging;
    private LabelSelectorBuilder namespaceSelector;
    private NodePlacementBuilder nodePlacement;
    private Integer replicas;
    private RouteAdmissionPolicyBuilder routeAdmission;
    private LabelSelectorBuilder routeSelector;
    private TLSSecurityProfile tlsSecurityProfile;
    private IngressControllerTuningOptionsBuilder tuningOptions;
    private Object unsupportedConfigOverrides;
    private Map<String, Object> additionalProperties;

    public IngressControllerSpecFluent() {
    }

    public IngressControllerSpecFluent(IngressControllerSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IngressControllerSpec instance) {
        IngressControllerSpec ingressControllerSpec = instance = instance != null ? instance : new IngressControllerSpec();
        if (instance != null) {
            this.withClientTLS(instance.getClientTLS());
            this.withDefaultCertificate(instance.getDefaultCertificate());
            this.withDomain(instance.getDomain());
            this.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy());
            this.withHttpCompression(instance.getHttpCompression());
            this.withHttpEmptyRequestsPolicy(instance.getHttpEmptyRequestsPolicy());
            this.withHttpErrorCodePages(instance.getHttpErrorCodePages());
            this.withHttpHeaders(instance.getHttpHeaders());
            this.withIdleConnectionTerminationPolicy(instance.getIdleConnectionTerminationPolicy());
            this.withLogging(instance.getLogging());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withNodePlacement(instance.getNodePlacement());
            this.withReplicas(instance.getReplicas());
            this.withRouteAdmission(instance.getRouteAdmission());
            this.withRouteSelector(instance.getRouteSelector());
            this.withTlsSecurityProfile(instance.getTlsSecurityProfile());
            this.withTuningOptions(instance.getTuningOptions());
            this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ClientTLS buildClientTLS() {
        return this.clientTLS != null ? this.clientTLS.build() : null;
    }

    public A withClientTLS(ClientTLS clientTLS) {
        this._visitables.remove("clientTLS");
        if (clientTLS != null) {
            this.clientTLS = new ClientTLSBuilder(clientTLS);
            this._visitables.get("clientTLS").add(this.clientTLS);
        } else {
            this.clientTLS = null;
            this._visitables.get("clientTLS").remove(this.clientTLS);
        }
        return (A)this;
    }

    public boolean hasClientTLS() {
        return this.clientTLS != null;
    }

    public ClientTLSNested<A> withNewClientTLS() {
        return new ClientTLSNested(null);
    }

    public ClientTLSNested<A> withNewClientTLSLike(ClientTLS item) {
        return new ClientTLSNested(item);
    }

    public ClientTLSNested<A> editClientTLS() {
        return this.withNewClientTLSLike(Optional.ofNullable(this.buildClientTLS()).orElse(null));
    }

    public ClientTLSNested<A> editOrNewClientTLS() {
        return this.withNewClientTLSLike(Optional.ofNullable(this.buildClientTLS()).orElse(new ClientTLSBuilder().build()));
    }

    public ClientTLSNested<A> editOrNewClientTLSLike(ClientTLS item) {
        return this.withNewClientTLSLike(Optional.ofNullable(this.buildClientTLS()).orElse(item));
    }

    public LocalObjectReference buildDefaultCertificate() {
        return this.defaultCertificate != null ? this.defaultCertificate.build() : null;
    }

    public A withDefaultCertificate(LocalObjectReference defaultCertificate) {
        this._visitables.remove("defaultCertificate");
        if (defaultCertificate != null) {
            this.defaultCertificate = new LocalObjectReferenceBuilder(defaultCertificate);
            this._visitables.get("defaultCertificate").add(this.defaultCertificate);
        } else {
            this.defaultCertificate = null;
            this._visitables.get("defaultCertificate").remove(this.defaultCertificate);
        }
        return (A)this;
    }

    public boolean hasDefaultCertificate() {
        return this.defaultCertificate != null;
    }

    public A withNewDefaultCertificate(String name) {
        return this.withDefaultCertificate(new LocalObjectReference(name));
    }

    public DefaultCertificateNested<A> withNewDefaultCertificate() {
        return new DefaultCertificateNested(null);
    }

    public DefaultCertificateNested<A> withNewDefaultCertificateLike(LocalObjectReference item) {
        return new DefaultCertificateNested(item);
    }

    public DefaultCertificateNested<A> editDefaultCertificate() {
        return this.withNewDefaultCertificateLike(Optional.ofNullable(this.buildDefaultCertificate()).orElse(null));
    }

    public DefaultCertificateNested<A> editOrNewDefaultCertificate() {
        return this.withNewDefaultCertificateLike(Optional.ofNullable(this.buildDefaultCertificate()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public DefaultCertificateNested<A> editOrNewDefaultCertificateLike(LocalObjectReference item) {
        return this.withNewDefaultCertificateLike(Optional.ofNullable(this.buildDefaultCertificate()).orElse(item));
    }

    public String getDomain() {
        return this.domain;
    }

    public A withDomain(String domain) {
        this.domain = domain;
        return (A)this;
    }

    public boolean hasDomain() {
        return this.domain != null;
    }

    public EndpointPublishingStrategy buildEndpointPublishingStrategy() {
        return this.endpointPublishingStrategy != null ? this.endpointPublishingStrategy.build() : null;
    }

    public A withEndpointPublishingStrategy(EndpointPublishingStrategy endpointPublishingStrategy) {
        this._visitables.remove("endpointPublishingStrategy");
        if (endpointPublishingStrategy != null) {
            this.endpointPublishingStrategy = new EndpointPublishingStrategyBuilder(endpointPublishingStrategy);
            this._visitables.get("endpointPublishingStrategy").add(this.endpointPublishingStrategy);
        } else {
            this.endpointPublishingStrategy = null;
            this._visitables.get("endpointPublishingStrategy").remove(this.endpointPublishingStrategy);
        }
        return (A)this;
    }

    public boolean hasEndpointPublishingStrategy() {
        return this.endpointPublishingStrategy != null;
    }

    public EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategy() {
        return new EndpointPublishingStrategyNested(null);
    }

    public EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item) {
        return new EndpointPublishingStrategyNested(item);
    }

    public EndpointPublishingStrategyNested<A> editEndpointPublishingStrategy() {
        return this.withNewEndpointPublishingStrategyLike(Optional.ofNullable(this.buildEndpointPublishingStrategy()).orElse(null));
    }

    public EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategy() {
        return this.withNewEndpointPublishingStrategyLike(Optional.ofNullable(this.buildEndpointPublishingStrategy()).orElse(new EndpointPublishingStrategyBuilder().build()));
    }

    public EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item) {
        return this.withNewEndpointPublishingStrategyLike(Optional.ofNullable(this.buildEndpointPublishingStrategy()).orElse(item));
    }

    public HTTPCompressionPolicy buildHttpCompression() {
        return this.httpCompression != null ? this.httpCompression.build() : null;
    }

    public A withHttpCompression(HTTPCompressionPolicy httpCompression) {
        this._visitables.remove("httpCompression");
        if (httpCompression != null) {
            this.httpCompression = new HTTPCompressionPolicyBuilder(httpCompression);
            this._visitables.get("httpCompression").add(this.httpCompression);
        } else {
            this.httpCompression = null;
            this._visitables.get("httpCompression").remove(this.httpCompression);
        }
        return (A)this;
    }

    public boolean hasHttpCompression() {
        return this.httpCompression != null;
    }

    public HttpCompressionNested<A> withNewHttpCompression() {
        return new HttpCompressionNested(null);
    }

    public HttpCompressionNested<A> withNewHttpCompressionLike(HTTPCompressionPolicy item) {
        return new HttpCompressionNested(item);
    }

    public HttpCompressionNested<A> editHttpCompression() {
        return this.withNewHttpCompressionLike(Optional.ofNullable(this.buildHttpCompression()).orElse(null));
    }

    public HttpCompressionNested<A> editOrNewHttpCompression() {
        return this.withNewHttpCompressionLike(Optional.ofNullable(this.buildHttpCompression()).orElse(new HTTPCompressionPolicyBuilder().build()));
    }

    public HttpCompressionNested<A> editOrNewHttpCompressionLike(HTTPCompressionPolicy item) {
        return this.withNewHttpCompressionLike(Optional.ofNullable(this.buildHttpCompression()).orElse(item));
    }

    public String getHttpEmptyRequestsPolicy() {
        return this.httpEmptyRequestsPolicy;
    }

    public A withHttpEmptyRequestsPolicy(String httpEmptyRequestsPolicy) {
        this.httpEmptyRequestsPolicy = httpEmptyRequestsPolicy;
        return (A)this;
    }

    public boolean hasHttpEmptyRequestsPolicy() {
        return this.httpEmptyRequestsPolicy != null;
    }

    public ConfigMapNameReference getHttpErrorCodePages() {
        return this.httpErrorCodePages;
    }

    public A withHttpErrorCodePages(ConfigMapNameReference httpErrorCodePages) {
        this.httpErrorCodePages = httpErrorCodePages;
        return (A)this;
    }

    public boolean hasHttpErrorCodePages() {
        return this.httpErrorCodePages != null;
    }

    public A withNewHttpErrorCodePages(String name) {
        return this.withHttpErrorCodePages(new ConfigMapNameReference(name));
    }

    public IngressControllerHTTPHeaders buildHttpHeaders() {
        return this.httpHeaders != null ? this.httpHeaders.build() : null;
    }

    public A withHttpHeaders(IngressControllerHTTPHeaders httpHeaders) {
        this._visitables.remove("httpHeaders");
        if (httpHeaders != null) {
            this.httpHeaders = new IngressControllerHTTPHeadersBuilder(httpHeaders);
            this._visitables.get("httpHeaders").add(this.httpHeaders);
        } else {
            this.httpHeaders = null;
            this._visitables.get("httpHeaders").remove(this.httpHeaders);
        }
        return (A)this;
    }

    public boolean hasHttpHeaders() {
        return this.httpHeaders != null;
    }

    public HttpHeadersNested<A> withNewHttpHeaders() {
        return new HttpHeadersNested(null);
    }

    public HttpHeadersNested<A> withNewHttpHeadersLike(IngressControllerHTTPHeaders item) {
        return new HttpHeadersNested(item);
    }

    public HttpHeadersNested<A> editHttpHeaders() {
        return this.withNewHttpHeadersLike(Optional.ofNullable(this.buildHttpHeaders()).orElse(null));
    }

    public HttpHeadersNested<A> editOrNewHttpHeaders() {
        return this.withNewHttpHeadersLike(Optional.ofNullable(this.buildHttpHeaders()).orElse(new IngressControllerHTTPHeadersBuilder().build()));
    }

    public HttpHeadersNested<A> editOrNewHttpHeadersLike(IngressControllerHTTPHeaders item) {
        return this.withNewHttpHeadersLike(Optional.ofNullable(this.buildHttpHeaders()).orElse(item));
    }

    public String getIdleConnectionTerminationPolicy() {
        return this.idleConnectionTerminationPolicy;
    }

    public A withIdleConnectionTerminationPolicy(String idleConnectionTerminationPolicy) {
        this.idleConnectionTerminationPolicy = idleConnectionTerminationPolicy;
        return (A)this;
    }

    public boolean hasIdleConnectionTerminationPolicy() {
        return this.idleConnectionTerminationPolicy != null;
    }

    public IngressControllerLogging buildLogging() {
        return this.logging != null ? this.logging.build() : null;
    }

    public A withLogging(IngressControllerLogging logging) {
        this._visitables.remove("logging");
        if (logging != null) {
            this.logging = new IngressControllerLoggingBuilder(logging);
            this._visitables.get("logging").add(this.logging);
        } else {
            this.logging = null;
            this._visitables.get("logging").remove(this.logging);
        }
        return (A)this;
    }

    public boolean hasLogging() {
        return this.logging != null;
    }

    public LoggingNested<A> withNewLogging() {
        return new LoggingNested(null);
    }

    public LoggingNested<A> withNewLoggingLike(IngressControllerLogging item) {
        return new LoggingNested(item);
    }

    public LoggingNested<A> editLogging() {
        return this.withNewLoggingLike(Optional.ofNullable(this.buildLogging()).orElse(null));
    }

    public LoggingNested<A> editOrNewLogging() {
        return this.withNewLoggingLike(Optional.ofNullable(this.buildLogging()).orElse(new IngressControllerLoggingBuilder().build()));
    }

    public LoggingNested<A> editOrNewLoggingLike(IngressControllerLogging item) {
        return this.withNewLoggingLike(Optional.ofNullable(this.buildLogging()).orElse(item));
    }

    public LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    public A withNamespaceSelector(LabelSelector namespaceSelector) {
        this._visitables.remove("namespaceSelector");
        if (namespaceSelector != null) {
            this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
            this._visitables.get("namespaceSelector").add(this.namespaceSelector);
        } else {
            this.namespaceSelector = null;
            this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
        }
        return (A)this;
    }

    public boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNested(null);
    }

    public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
        return new NamespaceSelectorNested(item);
    }

    public NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(null));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
        return this.withNewNamespaceSelectorLike(Optional.ofNullable(this.buildNamespaceSelector()).orElse(item));
    }

    public NodePlacement buildNodePlacement() {
        return this.nodePlacement != null ? this.nodePlacement.build() : null;
    }

    public A withNodePlacement(NodePlacement nodePlacement) {
        this._visitables.remove("nodePlacement");
        if (nodePlacement != null) {
            this.nodePlacement = new NodePlacementBuilder(nodePlacement);
            this._visitables.get("nodePlacement").add(this.nodePlacement);
        } else {
            this.nodePlacement = null;
            this._visitables.get("nodePlacement").remove(this.nodePlacement);
        }
        return (A)this;
    }

    public boolean hasNodePlacement() {
        return this.nodePlacement != null;
    }

    public NodePlacementNested<A> withNewNodePlacement() {
        return new NodePlacementNested(null);
    }

    public NodePlacementNested<A> withNewNodePlacementLike(NodePlacement item) {
        return new NodePlacementNested(item);
    }

    public NodePlacementNested<A> editNodePlacement() {
        return this.withNewNodePlacementLike(Optional.ofNullable(this.buildNodePlacement()).orElse(null));
    }

    public NodePlacementNested<A> editOrNewNodePlacement() {
        return this.withNewNodePlacementLike(Optional.ofNullable(this.buildNodePlacement()).orElse(new NodePlacementBuilder().build()));
    }

    public NodePlacementNested<A> editOrNewNodePlacementLike(NodePlacement item) {
        return this.withNewNodePlacementLike(Optional.ofNullable(this.buildNodePlacement()).orElse(item));
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    public boolean hasReplicas() {
        return this.replicas != null;
    }

    public RouteAdmissionPolicy buildRouteAdmission() {
        return this.routeAdmission != null ? this.routeAdmission.build() : null;
    }

    public A withRouteAdmission(RouteAdmissionPolicy routeAdmission) {
        this._visitables.remove("routeAdmission");
        if (routeAdmission != null) {
            this.routeAdmission = new RouteAdmissionPolicyBuilder(routeAdmission);
            this._visitables.get("routeAdmission").add(this.routeAdmission);
        } else {
            this.routeAdmission = null;
            this._visitables.get("routeAdmission").remove(this.routeAdmission);
        }
        return (A)this;
    }

    public boolean hasRouteAdmission() {
        return this.routeAdmission != null;
    }

    public A withNewRouteAdmission(String namespaceOwnership, String wildcardPolicy) {
        return this.withRouteAdmission(new RouteAdmissionPolicy(namespaceOwnership, wildcardPolicy));
    }

    public RouteAdmissionNested<A> withNewRouteAdmission() {
        return new RouteAdmissionNested(null);
    }

    public RouteAdmissionNested<A> withNewRouteAdmissionLike(RouteAdmissionPolicy item) {
        return new RouteAdmissionNested(item);
    }

    public RouteAdmissionNested<A> editRouteAdmission() {
        return this.withNewRouteAdmissionLike(Optional.ofNullable(this.buildRouteAdmission()).orElse(null));
    }

    public RouteAdmissionNested<A> editOrNewRouteAdmission() {
        return this.withNewRouteAdmissionLike(Optional.ofNullable(this.buildRouteAdmission()).orElse(new RouteAdmissionPolicyBuilder().build()));
    }

    public RouteAdmissionNested<A> editOrNewRouteAdmissionLike(RouteAdmissionPolicy item) {
        return this.withNewRouteAdmissionLike(Optional.ofNullable(this.buildRouteAdmission()).orElse(item));
    }

    public LabelSelector buildRouteSelector() {
        return this.routeSelector != null ? this.routeSelector.build() : null;
    }

    public A withRouteSelector(LabelSelector routeSelector) {
        this._visitables.remove("routeSelector");
        if (routeSelector != null) {
            this.routeSelector = new LabelSelectorBuilder(routeSelector);
            this._visitables.get("routeSelector").add(this.routeSelector);
        } else {
            this.routeSelector = null;
            this._visitables.get("routeSelector").remove(this.routeSelector);
        }
        return (A)this;
    }

    public boolean hasRouteSelector() {
        return this.routeSelector != null;
    }

    public RouteSelectorNested<A> withNewRouteSelector() {
        return new RouteSelectorNested(null);
    }

    public RouteSelectorNested<A> withNewRouteSelectorLike(LabelSelector item) {
        return new RouteSelectorNested(item);
    }

    public RouteSelectorNested<A> editRouteSelector() {
        return this.withNewRouteSelectorLike(Optional.ofNullable(this.buildRouteSelector()).orElse(null));
    }

    public RouteSelectorNested<A> editOrNewRouteSelector() {
        return this.withNewRouteSelectorLike(Optional.ofNullable(this.buildRouteSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public RouteSelectorNested<A> editOrNewRouteSelectorLike(LabelSelector item) {
        return this.withNewRouteSelectorLike(Optional.ofNullable(this.buildRouteSelector()).orElse(item));
    }

    public TLSSecurityProfile getTlsSecurityProfile() {
        return this.tlsSecurityProfile;
    }

    public A withTlsSecurityProfile(TLSSecurityProfile tlsSecurityProfile) {
        this.tlsSecurityProfile = tlsSecurityProfile;
        return (A)this;
    }

    public boolean hasTlsSecurityProfile() {
        return this.tlsSecurityProfile != null;
    }

    public IngressControllerTuningOptions buildTuningOptions() {
        return this.tuningOptions != null ? this.tuningOptions.build() : null;
    }

    public A withTuningOptions(IngressControllerTuningOptions tuningOptions) {
        this._visitables.remove("tuningOptions");
        if (tuningOptions != null) {
            this.tuningOptions = new IngressControllerTuningOptionsBuilder(tuningOptions);
            this._visitables.get("tuningOptions").add(this.tuningOptions);
        } else {
            this.tuningOptions = null;
            this._visitables.get("tuningOptions").remove(this.tuningOptions);
        }
        return (A)this;
    }

    public boolean hasTuningOptions() {
        return this.tuningOptions != null;
    }

    public TuningOptionsNested<A> withNewTuningOptions() {
        return new TuningOptionsNested(null);
    }

    public TuningOptionsNested<A> withNewTuningOptionsLike(IngressControllerTuningOptions item) {
        return new TuningOptionsNested(item);
    }

    public TuningOptionsNested<A> editTuningOptions() {
        return this.withNewTuningOptionsLike(Optional.ofNullable(this.buildTuningOptions()).orElse(null));
    }

    public TuningOptionsNested<A> editOrNewTuningOptions() {
        return this.withNewTuningOptionsLike(Optional.ofNullable(this.buildTuningOptions()).orElse(new IngressControllerTuningOptionsBuilder().build()));
    }

    public TuningOptionsNested<A> editOrNewTuningOptionsLike(IngressControllerTuningOptions item) {
        return this.withNewTuningOptionsLike(Optional.ofNullable(this.buildTuningOptions()).orElse(item));
    }

    public Object getUnsupportedConfigOverrides() {
        return this.unsupportedConfigOverrides;
    }

    public A withUnsupportedConfigOverrides(Object unsupportedConfigOverrides) {
        this.unsupportedConfigOverrides = unsupportedConfigOverrides;
        return (A)this;
    }

    public boolean hasUnsupportedConfigOverrides() {
        return this.unsupportedConfigOverrides != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressControllerSpecFluent that = (IngressControllerSpecFluent)o;
        if (!Objects.equals(this.clientTLS, that.clientTLS)) {
            return false;
        }
        if (!Objects.equals(this.defaultCertificate, that.defaultCertificate)) {
            return false;
        }
        if (!Objects.equals(this.domain, that.domain)) {
            return false;
        }
        if (!Objects.equals(this.endpointPublishingStrategy, that.endpointPublishingStrategy)) {
            return false;
        }
        if (!Objects.equals(this.httpCompression, that.httpCompression)) {
            return false;
        }
        if (!Objects.equals(this.httpEmptyRequestsPolicy, that.httpEmptyRequestsPolicy)) {
            return false;
        }
        if (!Objects.equals(this.httpErrorCodePages, that.httpErrorCodePages)) {
            return false;
        }
        if (!Objects.equals(this.httpHeaders, that.httpHeaders)) {
            return false;
        }
        if (!Objects.equals(this.idleConnectionTerminationPolicy, that.idleConnectionTerminationPolicy)) {
            return false;
        }
        if (!Objects.equals(this.logging, that.logging)) {
            return false;
        }
        if (!Objects.equals(this.namespaceSelector, that.namespaceSelector)) {
            return false;
        }
        if (!Objects.equals(this.nodePlacement, that.nodePlacement)) {
            return false;
        }
        if (!Objects.equals(this.replicas, that.replicas)) {
            return false;
        }
        if (!Objects.equals(this.routeAdmission, that.routeAdmission)) {
            return false;
        }
        if (!Objects.equals(this.routeSelector, that.routeSelector)) {
            return false;
        }
        if (!Objects.equals(this.tlsSecurityProfile, that.tlsSecurityProfile)) {
            return false;
        }
        if (!Objects.equals(this.tuningOptions, that.tuningOptions)) {
            return false;
        }
        if (!Objects.equals(this.unsupportedConfigOverrides, that.unsupportedConfigOverrides)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clientTLS, this.defaultCertificate, this.domain, this.endpointPublishingStrategy, this.httpCompression, this.httpEmptyRequestsPolicy, this.httpErrorCodePages, this.httpHeaders, this.idleConnectionTerminationPolicy, this.logging, this.namespaceSelector, this.nodePlacement, this.replicas, this.routeAdmission, this.routeSelector, this.tlsSecurityProfile, this.tuningOptions, this.unsupportedConfigOverrides, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientTLS != null) {
            sb.append("clientTLS:");
            sb.append(String.valueOf(this.clientTLS) + ",");
        }
        if (this.defaultCertificate != null) {
            sb.append("defaultCertificate:");
            sb.append(String.valueOf(this.defaultCertificate) + ",");
        }
        if (this.domain != null) {
            sb.append("domain:");
            sb.append(this.domain + ",");
        }
        if (this.endpointPublishingStrategy != null) {
            sb.append("endpointPublishingStrategy:");
            sb.append(String.valueOf(this.endpointPublishingStrategy) + ",");
        }
        if (this.httpCompression != null) {
            sb.append("httpCompression:");
            sb.append(String.valueOf(this.httpCompression) + ",");
        }
        if (this.httpEmptyRequestsPolicy != null) {
            sb.append("httpEmptyRequestsPolicy:");
            sb.append(this.httpEmptyRequestsPolicy + ",");
        }
        if (this.httpErrorCodePages != null) {
            sb.append("httpErrorCodePages:");
            sb.append(String.valueOf(this.httpErrorCodePages) + ",");
        }
        if (this.httpHeaders != null) {
            sb.append("httpHeaders:");
            sb.append(String.valueOf(this.httpHeaders) + ",");
        }
        if (this.idleConnectionTerminationPolicy != null) {
            sb.append("idleConnectionTerminationPolicy:");
            sb.append(this.idleConnectionTerminationPolicy + ",");
        }
        if (this.logging != null) {
            sb.append("logging:");
            sb.append(String.valueOf(this.logging) + ",");
        }
        if (this.namespaceSelector != null) {
            sb.append("namespaceSelector:");
            sb.append(String.valueOf(this.namespaceSelector) + ",");
        }
        if (this.nodePlacement != null) {
            sb.append("nodePlacement:");
            sb.append(String.valueOf(this.nodePlacement) + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.routeAdmission != null) {
            sb.append("routeAdmission:");
            sb.append(String.valueOf(this.routeAdmission) + ",");
        }
        if (this.routeSelector != null) {
            sb.append("routeSelector:");
            sb.append(String.valueOf(this.routeSelector) + ",");
        }
        if (this.tlsSecurityProfile != null) {
            sb.append("tlsSecurityProfile:");
            sb.append(String.valueOf(this.tlsSecurityProfile) + ",");
        }
        if (this.tuningOptions != null) {
            sb.append("tuningOptions:");
            sb.append(String.valueOf(this.tuningOptions) + ",");
        }
        if (this.unsupportedConfigOverrides != null) {
            sb.append("unsupportedConfigOverrides:");
            sb.append(String.valueOf(this.unsupportedConfigOverrides) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TuningOptionsNested<N>
    extends IngressControllerTuningOptionsFluent<TuningOptionsNested<N>>
    implements Nested<N> {
        IngressControllerTuningOptionsBuilder builder;

        TuningOptionsNested(IngressControllerTuningOptions item) {
            this.builder = new IngressControllerTuningOptionsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressControllerSpecFluent.this.withTuningOptions(this.builder.build());
        }

        public N endTuningOptions() {
            return this.and();
        }
    }

    public class RouteSelectorNested<N>
    extends LabelSelectorFluent<RouteSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        RouteSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressControllerSpecFluent.this.withRouteSelector(this.builder.build());
        }

        public N endRouteSelector() {
            return this.and();
        }
    }

    public class RouteAdmissionNested<N>
    extends RouteAdmissionPolicyFluent<RouteAdmissionNested<N>>
    implements Nested<N> {
        RouteAdmissionPolicyBuilder builder;

        RouteAdmissionNested(RouteAdmissionPolicy item) {
            this.builder = new RouteAdmissionPolicyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressControllerSpecFluent.this.withRouteAdmission(this.builder.build());
        }

        public N endRouteAdmission() {
            return this.and();
        }
    }

    public class NodePlacementNested<N>
    extends NodePlacementFluent<NodePlacementNested<N>>
    implements Nested<N> {
        NodePlacementBuilder builder;

        NodePlacementNested(NodePlacement item) {
            this.builder = new NodePlacementBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressControllerSpecFluent.this.withNodePlacement(this.builder.build());
        }

        public N endNodePlacement() {
            return this.and();
        }
    }

    public class NamespaceSelectorNested<N>
    extends LabelSelectorFluent<NamespaceSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        NamespaceSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressControllerSpecFluent.this.withNamespaceSelector(this.builder.build());
        }

        public N endNamespaceSelector() {
            return this.and();
        }
    }

    public class LoggingNested<N>
    extends IngressControllerLoggingFluent<LoggingNested<N>>
    implements Nested<N> {
        IngressControllerLoggingBuilder builder;

        LoggingNested(IngressControllerLogging item) {
            this.builder = new IngressControllerLoggingBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressControllerSpecFluent.this.withLogging(this.builder.build());
        }

        public N endLogging() {
            return this.and();
        }
    }

    public class HttpHeadersNested<N>
    extends IngressControllerHTTPHeadersFluent<HttpHeadersNested<N>>
    implements Nested<N> {
        IngressControllerHTTPHeadersBuilder builder;

        HttpHeadersNested(IngressControllerHTTPHeaders item) {
            this.builder = new IngressControllerHTTPHeadersBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressControllerSpecFluent.this.withHttpHeaders(this.builder.build());
        }

        public N endHttpHeaders() {
            return this.and();
        }
    }

    public class HttpCompressionNested<N>
    extends HTTPCompressionPolicyFluent<HttpCompressionNested<N>>
    implements Nested<N> {
        HTTPCompressionPolicyBuilder builder;

        HttpCompressionNested(HTTPCompressionPolicy item) {
            this.builder = new HTTPCompressionPolicyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressControllerSpecFluent.this.withHttpCompression(this.builder.build());
        }

        public N endHttpCompression() {
            return this.and();
        }
    }

    public class EndpointPublishingStrategyNested<N>
    extends EndpointPublishingStrategyFluent<EndpointPublishingStrategyNested<N>>
    implements Nested<N> {
        EndpointPublishingStrategyBuilder builder;

        EndpointPublishingStrategyNested(EndpointPublishingStrategy item) {
            this.builder = new EndpointPublishingStrategyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressControllerSpecFluent.this.withEndpointPublishingStrategy(this.builder.build());
        }

        public N endEndpointPublishingStrategy() {
            return this.and();
        }
    }

    public class DefaultCertificateNested<N>
    extends LocalObjectReferenceFluent<DefaultCertificateNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        DefaultCertificateNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressControllerSpecFluent.this.withDefaultCertificate(this.builder.build());
        }

        public N endDefaultCertificate() {
            return this.and();
        }
    }

    public class ClientTLSNested<N>
    extends ClientTLSFluent<ClientTLSNested<N>>
    implements Nested<N> {
        ClientTLSBuilder builder;

        ClientTLSNested(ClientTLS item) {
            this.builder = new ClientTLSBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)IngressControllerSpecFluent.this.withClientTLS(this.builder.build());
        }

        public N endClientTLS() {
            return this.and();
        }
    }
}

