/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.internal;

import com.squareup.okhttp.mockwebserver.MockResponse;
import com.squareup.okhttp.ws.WebSocketListener;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.internal.WebSocketSession;

public class SimpleResponse
implements ServerResponse {
    private final int statusCode;
    private final String body;
    private final WebSocketSession webSocketSession;
    private final boolean repeatable;

    public SimpleResponse(boolean repeatable, int statusCode, String body, WebSocketSession webSocketSession) {
        this.statusCode = statusCode;
        this.body = body;
        this.webSocketSession = webSocketSession;
        this.repeatable = repeatable;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getBody() {
        return this.body;
    }

    @Override
    public MockResponse toMockResponse() {
        MockResponse mockResponse = new MockResponse();
        if (this.webSocketSession != null) {
            mockResponse.withWebSocketUpgrade((WebSocketListener)this.webSocketSession);
        } else {
            mockResponse.setBody(this.body);
            mockResponse.setResponseCode(this.statusCode);
        }
        return mockResponse;
    }

    public WebSocketSession getWebSocketSession() {
        return this.webSocketSession;
    }

    @Override
    public boolean isRepeatable() {
        return this.repeatable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleResponse that = (SimpleResponse)o;
        if (this.statusCode != that.statusCode) {
            return false;
        }
        if (this.repeatable != that.repeatable) {
            return false;
        }
        if (this.body != null ? !this.body.equals(that.body) : that.body != null) {
            return false;
        }
        return this.webSocketSession != null ? this.webSocketSession.equals(that.webSocketSession) : that.webSocketSession == null;
    }

    public int hashCode() {
        int result = this.statusCode;
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 31 * result + (this.webSocketSession != null ? this.webSocketSession.hashCode() : 0);
        result = 31 * result + (this.repeatable ? 1 : 0);
        return result;
    }
}

