/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.fabric8.mockwebserver.crud;

public class Value {

    private static final String ANY = "*";

    private final String val;

    public Value(String value) {
        this.val = value;
    }

    @Override
    // TODO: There's a BUG here, equals({val: "*"} is true but might have different hashCode
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }

        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        if (ANY.equals(val)) {
            return true;
        }

        Value key = (Value) o;

        if (ANY.equals(key.val)) {
            return true;
        }
        return val != null ? val.equals(key.val) : key.val == null;
    }

    @Override
    public int hashCode() {
        return val != null ? val.hashCode() : 0;
    }

    @Override
    public String toString() {
        return val;
    }
}
