/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.internal;

import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.internal.WebSocketSession;
import io.fabric8.mockwebserver.utils.ResponseProvider;
import io.fabric8.mockwebserver.utils.ResponseProviders;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.WebSocketListener;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.RecordedRequest;

public class SimpleResponse
implements ServerResponse {
    private static final String HTTP_HEADER_SEC_WEBSOCKET_PROTOCOL = "sec-websocket-protocol";
    private final ResponseProvider<String> bodyProvider;
    private final WebSocketSession webSocketSession;
    private final boolean repeatable;
    private final long responseDelay;
    private final TimeUnit responseDelayUnit;

    public SimpleResponse(boolean repeatable, int statusCode, String body, WebSocketSession webSocketSession) {
        this(repeatable, ResponseProviders.of(statusCode, body), webSocketSession);
    }

    public SimpleResponse(boolean repeatable, ResponseProvider<String> bodyProvider, WebSocketSession webSocketSession) {
        this(repeatable, bodyProvider, webSocketSession, 0L, TimeUnit.MILLISECONDS);
    }

    public SimpleResponse(boolean repeatable, int statusCode, String body, WebSocketSession webSocketSession, long responseDelay, TimeUnit responseDelayUnit) {
        this(repeatable, ResponseProviders.of(statusCode, body), webSocketSession, responseDelay, responseDelayUnit);
    }

    public SimpleResponse(boolean repeatable, ResponseProvider<String> bodyProvider, WebSocketSession webSocketSession, long responseDelay, TimeUnit responseDelayUnit) {
        this.bodyProvider = bodyProvider;
        this.webSocketSession = webSocketSession;
        this.repeatable = repeatable;
        this.responseDelay = responseDelay;
        this.responseDelayUnit = responseDelayUnit;
    }

    public ResponseProvider<String> getBodyProvider() {
        return this.bodyProvider;
    }

    @Override
    public MockResponse toMockResponse(RecordedRequest request) {
        MockResponse mockResponse = new MockResponse();
        mockResponse.setHeaders(this.bodyProvider.getHeaders());
        mockResponse.setResponseCode(this.bodyProvider.getStatusCode(request));
        if (this.webSocketSession != null) {
            mockResponse.withWebSocketUpgrade((WebSocketListener)this.webSocketSession);
            String requestWebsocketProtocol = request.getHeaders().get(HTTP_HEADER_SEC_WEBSOCKET_PROTOCOL);
            if (requestWebsocketProtocol != null && mockResponse.getHeaders().get(HTTP_HEADER_SEC_WEBSOCKET_PROTOCOL) == null) {
                mockResponse.addHeader(HTTP_HEADER_SEC_WEBSOCKET_PROTOCOL, (Object)requestWebsocketProtocol);
            }
        } else {
            mockResponse.setBody((String)this.bodyProvider.getBody(request));
        }
        if (this.responseDelay > 0L) {
            mockResponse.setBodyDelay(this.responseDelay, this.responseDelayUnit);
        }
        return mockResponse;
    }

    public WebSocketSession getWebSocketSession() {
        return this.webSocketSession;
    }

    @Override
    public boolean isRepeatable() {
        return this.repeatable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleResponse that = (SimpleResponse)o;
        return this.repeatable == that.repeatable && this.responseDelay == that.responseDelay && Objects.equals(this.bodyProvider, that.bodyProvider) && Objects.equals((Object)this.webSocketSession, (Object)that.webSocketSession) && this.responseDelayUnit == that.responseDelayUnit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bodyProvider, this.webSocketSession, this.repeatable, this.responseDelay, this.responseDelayUnit});
    }
}

