/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.http;

import io.fabric8.mockwebserver.http.ByteString;
import io.fabric8.mockwebserver.http.Response;
import io.fabric8.mockwebserver.http.WebSocket;
import java.nio.charset.StandardCharsets;

public abstract class WebSocketListener {
    public void onBeforeAccept(WebSocket webSocket, Response response) {
    }

    public void onOpen(WebSocket webSocket, Response response) {
    }

    public void onMessage(WebSocket webSocket, String text) {
    }

    @Deprecated
    public void onMessage(WebSocket webSocket, ByteString bytes) {
        this.onMessage(webSocket, bytes.utf8());
    }

    public void onMessage(WebSocket webSocket, byte[] bytes) {
        this.onMessage(webSocket, new String(bytes, StandardCharsets.UTF_8));
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
    }

    public void onFailure(WebSocket webSocket, Throwable error, Response response) {
    }
}

