/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.crud;

import io.fabric8.mockwebserver.crud.Attribute;
import io.fabric8.mockwebserver.crud.Key;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class AttributeSet {
    final Map<Key, Attribute> attributes;

    public static AttributeSet merge(AttributeSet ... attributeSets) {
        HashMap<Key, Attribute> all = new HashMap<Key, Attribute>();
        if (attributeSets != null) {
            for (AttributeSet f : attributeSets) {
                if (f == null || f.attributes == null) continue;
                all.putAll(f.attributes);
            }
        }
        return new AttributeSet(all);
    }

    public static AttributeSet map(Attribute ... attributes) {
        HashMap<Key, Attribute> all = new HashMap<Key, Attribute>();
        if (attributes != null) {
            for (Attribute a : attributes) {
                all.put(a.getKey(), a);
            }
        }
        return new AttributeSet(all);
    }

    public AttributeSet(Attribute ... attributes) {
        this(Arrays.asList(attributes));
    }

    public AttributeSet(Collection<Attribute> attributes) {
        this(AttributeSet.map((Attribute[])attributes.toArray(new Attribute[0])).attributes);
    }

    public AttributeSet(Map<Key, Attribute> attributes) {
        this.attributes = attributes;
    }

    public AttributeSet add(Attribute ... attr) {
        HashMap<Key, Attribute> all = new HashMap<Key, Attribute>(this.attributes);
        for (Attribute a : attr) {
            all.put(a.getKey(), a);
        }
        return new AttributeSet(all);
    }

    public boolean containsKey(String key) {
        return this.containsKey(new Key(key));
    }

    public boolean containsKey(Key key) {
        return this.attributes.containsKey(key);
    }

    public boolean matches(AttributeSet candidate) {
        return candidate.attributes.values().stream().allMatch(this::satisfiesAttribute);
    }

    private boolean satisfiesAttribute(Attribute c) {
        switch (c.getType()) {
            case EXISTS: {
                return this.attributes.containsKey(c.getKey());
            }
            case NOT_EXISTS: {
                return !this.attributes.containsKey(c.getKey());
            }
            case IN: {
                if (this.attributes.containsKey(c.getKey())) {
                    if (this.attributes.get(c.getKey()).getValues().size() > 1) {
                        throw new IllegalArgumentException("Attribute " + c.getKey() + " has multiple values, can't use IN operation");
                    }
                    return c.getValues().contains(this.attributes.get(c.getKey()).getValues().iterator().next());
                }
                return false;
            }
            case NOT_IN: {
                if (this.attributes.containsKey(c.getKey())) {
                    if (this.attributes.get(c.getKey()).getValues().size() > 1) {
                        throw new IllegalArgumentException("Attribute " + c.getKey() + " has multiple values, can't use NOT_IN operation");
                    }
                    return !c.getValues().contains(this.attributes.get(c.getKey()).getValues().iterator().next());
                }
                return true;
            }
            case WITHOUT: {
                return !this.attributes.containsValue(c);
            }
        }
        return this.attributes.containsValue(c);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeSet that = (AttributeSet)o;
        return Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.attributes);
    }

    public Attribute getAttribute(String key) {
        return this.attributes.get(new Key(key));
    }

    public String toString() {
        return "{attributes: " + this.attributes + "}";
    }
}

