/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.mockwebserver.crud;

import io.fabric8.mockwebserver.crud.AttributeType;
import io.fabric8.mockwebserver.crud.Key;
import io.fabric8.mockwebserver.crud.Value;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Attribute
implements Comparable<Attribute> {
    private final Key key;
    private final List<Value> values;
    private final AttributeType type;

    public Attribute(Key key, List<Value> values, AttributeType type) {
        this.key = key;
        this.values = values;
        this.type = type;
    }

    public Attribute(Key key, Value value, AttributeType type) {
        this(key, Collections.singletonList(value), type);
    }

    public Attribute(String key, String value, AttributeType type) {
        this(new Key(key), new Value(value), type);
    }

    public Attribute(String key, List<String> values, AttributeType type) {
        this(new Key(key), values.stream().map(Value::new).collect(Collectors.toList()), type);
    }

    public Attribute(Key key, Value value) {
        this(key, value, AttributeType.WITH);
    }

    public Attribute(String key, String value) {
        this(new Key(key), new Value(value));
    }

    public Key getKey() {
        return this.key;
    }

    public List<Value> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        return Objects.equals(this.key, attribute.key) && Objects.equals(this.values, attribute.values);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.values);
    }

    public String toString() {
        return "{key:" + String.valueOf(this.key) + ", values:" + String.valueOf(this.values) + "}";
    }

    public AttributeType getType() {
        return this.type;
    }

    @Override
    public int compareTo(Attribute o) {
        return this.key.compareTo(o.key);
    }
}

