package io.fabric8.openclustermanagement.api.model.agent.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ProxyConfigFluent<A extends ProxyConfigFluent<A>> extends BaseFluent<A>{
  public ProxyConfigFluent() {
  }
  
  public ProxyConfigFluent(ProxyConfig instance) {
    this.copyInstance(instance);
  }
  private String httpProxy;
  private String httpsProxy;
  private String noProxy;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ProxyConfig instance) {
    instance = (instance != null ? instance : new ProxyConfig());
    if (instance != null) {
          this.withHttpProxy(instance.getHttpProxy());
          this.withHttpsProxy(instance.getHttpsProxy());
          this.withNoProxy(instance.getNoProxy());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getHttpProxy() {
    return this.httpProxy;
  }
  
  public A withHttpProxy(String httpProxy) {
    this.httpProxy = httpProxy;
    return (A) this;
  }
  
  public boolean hasHttpProxy() {
    return this.httpProxy != null;
  }
  
  public String getHttpsProxy() {
    return this.httpsProxy;
  }
  
  public A withHttpsProxy(String httpsProxy) {
    this.httpsProxy = httpsProxy;
    return (A) this;
  }
  
  public boolean hasHttpsProxy() {
    return this.httpsProxy != null;
  }
  
  public String getNoProxy() {
    return this.noProxy;
  }
  
  public A withNoProxy(String noProxy) {
    this.noProxy = noProxy;
    return (A) this;
  }
  
  public boolean hasNoProxy() {
    return this.noProxy != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProxyConfigFluent that = (ProxyConfigFluent) o;
    if (!java.util.Objects.equals(httpProxy, that.httpProxy)) return false;
    if (!java.util.Objects.equals(httpsProxy, that.httpsProxy)) return false;
    if (!java.util.Objects.equals(noProxy, that.noProxy)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(httpProxy,  httpsProxy,  noProxy,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (httpProxy != null) { sb.append("httpProxy:"); sb.append(httpProxy + ","); }
    if (httpsProxy != null) { sb.append("httpsProxy:"); sb.append(httpsProxy + ","); }
    if (noProxy != null) { sb.append("noProxy:"); sb.append(noProxy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}