package io.fabric8.openclustermanagement.api.model.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ChannelSpecBuilder extends ChannelSpecFluent<ChannelSpecBuilder> implements VisitableBuilder<ChannelSpec,ChannelSpecBuilder>{
  public ChannelSpecBuilder() {
    this(new ChannelSpec());
  }
  
  public ChannelSpecBuilder(ChannelSpecFluent<?> fluent) {
    this(fluent, new ChannelSpec());
  }
  
  public ChannelSpecBuilder(ChannelSpecFluent<?> fluent,ChannelSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ChannelSpecBuilder(ChannelSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ChannelSpecFluent<?> fluent;
  
  public ChannelSpec build() {
    ChannelSpec buildable = new ChannelSpec(fluent.buildConfigMapRef(),fluent.buildGates(),fluent.getInsecureSkipVerify(),fluent.getPathname(),fluent.buildSecretRef(),fluent.getSourceNamespaces(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}