package io.fabric8.openclustermanagement.api.model.apps.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ChannelSpecFluent<A extends ChannelSpecFluent<A>> extends BaseFluent<A>{
  public ChannelSpecFluent() {
  }
  
  public ChannelSpecFluent(ChannelSpec instance) {
    this.copyInstance(instance);
  }
  private ObjectReferenceBuilder configMapRef;
  private ChannelGateBuilder gates;
  private Boolean insecureSkipVerify;
  private String pathname;
  private ObjectReferenceBuilder secretRef;
  private List<String> sourceNamespaces = new ArrayList<String>();
  private String type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ChannelSpec instance) {
    instance = (instance != null ? instance : new ChannelSpec());
    if (instance != null) {
          this.withConfigMapRef(instance.getConfigMapRef());
          this.withGates(instance.getGates());
          this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
          this.withPathname(instance.getPathname());
          this.withSecretRef(instance.getSecretRef());
          this.withSourceNamespaces(instance.getSourceNamespaces());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ObjectReference buildConfigMapRef() {
    return this.configMapRef != null ? this.configMapRef.build() : null;
  }
  
  public A withConfigMapRef(ObjectReference configMapRef) {
    this._visitables.remove("configMapRef");
    if (configMapRef != null) {
        this.configMapRef = new ObjectReferenceBuilder(configMapRef);
        this._visitables.get("configMapRef").add(this.configMapRef);
    } else {
        this.configMapRef = null;
        this._visitables.get("configMapRef").remove(this.configMapRef);
    }
    return (A) this;
  }
  
  public boolean hasConfigMapRef() {
    return this.configMapRef != null;
  }
  
  public ConfigMapRefNested<A> withNewConfigMapRef() {
    return new ConfigMapRefNested(null);
  }
  
  public ConfigMapRefNested<A> withNewConfigMapRefLike(ObjectReference item) {
    return new ConfigMapRefNested(item);
  }
  
  public ConfigMapRefNested<A> editConfigMapRef() {
    return withNewConfigMapRefLike(java.util.Optional.ofNullable(buildConfigMapRef()).orElse(null));
  }
  
  public ConfigMapRefNested<A> editOrNewConfigMapRef() {
    return withNewConfigMapRefLike(java.util.Optional.ofNullable(buildConfigMapRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public ConfigMapRefNested<A> editOrNewConfigMapRefLike(ObjectReference item) {
    return withNewConfigMapRefLike(java.util.Optional.ofNullable(buildConfigMapRef()).orElse(item));
  }
  
  public ChannelGate buildGates() {
    return this.gates != null ? this.gates.build() : null;
  }
  
  public A withGates(ChannelGate gates) {
    this._visitables.remove("gates");
    if (gates != null) {
        this.gates = new ChannelGateBuilder(gates);
        this._visitables.get("gates").add(this.gates);
    } else {
        this.gates = null;
        this._visitables.get("gates").remove(this.gates);
    }
    return (A) this;
  }
  
  public boolean hasGates() {
    return this.gates != null;
  }
  
  public GatesNested<A> withNewGates() {
    return new GatesNested(null);
  }
  
  public GatesNested<A> withNewGatesLike(ChannelGate item) {
    return new GatesNested(item);
  }
  
  public GatesNested<A> editGates() {
    return withNewGatesLike(java.util.Optional.ofNullable(buildGates()).orElse(null));
  }
  
  public GatesNested<A> editOrNewGates() {
    return withNewGatesLike(java.util.Optional.ofNullable(buildGates()).orElse(new ChannelGateBuilder().build()));
  }
  
  public GatesNested<A> editOrNewGatesLike(ChannelGate item) {
    return withNewGatesLike(java.util.Optional.ofNullable(buildGates()).orElse(item));
  }
  
  public Boolean getInsecureSkipVerify() {
    return this.insecureSkipVerify;
  }
  
  public A withInsecureSkipVerify(Boolean insecureSkipVerify) {
    this.insecureSkipVerify = insecureSkipVerify;
    return (A) this;
  }
  
  public boolean hasInsecureSkipVerify() {
    return this.insecureSkipVerify != null;
  }
  
  public String getPathname() {
    return this.pathname;
  }
  
  public A withPathname(String pathname) {
    this.pathname = pathname;
    return (A) this;
  }
  
  public boolean hasPathname() {
    return this.pathname != null;
  }
  
  public ObjectReference buildSecretRef() {
    return this.secretRef != null ? this.secretRef.build() : null;
  }
  
  public A withSecretRef(ObjectReference secretRef) {
    this._visitables.remove("secretRef");
    if (secretRef != null) {
        this.secretRef = new ObjectReferenceBuilder(secretRef);
        this._visitables.get("secretRef").add(this.secretRef);
    } else {
        this.secretRef = null;
        this._visitables.get("secretRef").remove(this.secretRef);
    }
    return (A) this;
  }
  
  public boolean hasSecretRef() {
    return this.secretRef != null;
  }
  
  public SecretRefNested<A> withNewSecretRef() {
    return new SecretRefNested(null);
  }
  
  public SecretRefNested<A> withNewSecretRefLike(ObjectReference item) {
    return new SecretRefNested(item);
  }
  
  public SecretRefNested<A> editSecretRef() {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(null));
  }
  
  public SecretRefNested<A> editOrNewSecretRef() {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public SecretRefNested<A> editOrNewSecretRefLike(ObjectReference item) {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(item));
  }
  
  public A addToSourceNamespaces(int index,String item) {
    if (this.sourceNamespaces == null) {this.sourceNamespaces = new ArrayList<String>();}
    this.sourceNamespaces.add(index, item);
    return (A)this;
  }
  
  public A setToSourceNamespaces(int index,String item) {
    if (this.sourceNamespaces == null) {this.sourceNamespaces = new ArrayList<String>();}
    this.sourceNamespaces.set(index, item); return (A)this;
  }
  
  public A addToSourceNamespaces(java.lang.String... items) {
    if (this.sourceNamespaces == null) {this.sourceNamespaces = new ArrayList<String>();}
    for (String item : items) {this.sourceNamespaces.add(item);} return (A)this;
  }
  
  public A addAllToSourceNamespaces(Collection<String> items) {
    if (this.sourceNamespaces == null) {this.sourceNamespaces = new ArrayList<String>();}
    for (String item : items) {this.sourceNamespaces.add(item);} return (A)this;
  }
  
  public A removeFromSourceNamespaces(java.lang.String... items) {
    if (this.sourceNamespaces == null) return (A)this;
    for (String item : items) { this.sourceNamespaces.remove(item);} return (A)this;
  }
  
  public A removeAllFromSourceNamespaces(Collection<String> items) {
    if (this.sourceNamespaces == null) return (A)this;
    for (String item : items) { this.sourceNamespaces.remove(item);} return (A)this;
  }
  
  public List<String> getSourceNamespaces() {
    return this.sourceNamespaces;
  }
  
  public String getSourceNamespace(int index) {
    return this.sourceNamespaces.get(index);
  }
  
  public String getFirstSourceNamespace() {
    return this.sourceNamespaces.get(0);
  }
  
  public String getLastSourceNamespace() {
    return this.sourceNamespaces.get(sourceNamespaces.size() - 1);
  }
  
  public String getMatchingSourceNamespace(Predicate<String> predicate) {
      for (String item : sourceNamespaces) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingSourceNamespace(Predicate<String> predicate) {
      for (String item : sourceNamespaces) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSourceNamespaces(List<String> sourceNamespaces) {
    if (sourceNamespaces != null) {
        this.sourceNamespaces = new ArrayList();
        for (String item : sourceNamespaces) {
          this.addToSourceNamespaces(item);
        }
    } else {
      this.sourceNamespaces = null;
    }
    return (A) this;
  }
  
  public A withSourceNamespaces(java.lang.String... sourceNamespaces) {
    if (this.sourceNamespaces != null) {
        this.sourceNamespaces.clear();
        _visitables.remove("sourceNamespaces");
    }
    if (sourceNamespaces != null) {
      for (String item : sourceNamespaces) {
        this.addToSourceNamespaces(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSourceNamespaces() {
    return this.sourceNamespaces != null && !this.sourceNamespaces.isEmpty();
  }
  
  public String getType() {
    return this.type;
  }
  
  public A withType(String type) {
    this.type = type;
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ChannelSpecFluent that = (ChannelSpecFluent) o;
    if (!java.util.Objects.equals(configMapRef, that.configMapRef)) return false;
    if (!java.util.Objects.equals(gates, that.gates)) return false;
    if (!java.util.Objects.equals(insecureSkipVerify, that.insecureSkipVerify)) return false;
    if (!java.util.Objects.equals(pathname, that.pathname)) return false;
    if (!java.util.Objects.equals(secretRef, that.secretRef)) return false;
    if (!java.util.Objects.equals(sourceNamespaces, that.sourceNamespaces)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(configMapRef,  gates,  insecureSkipVerify,  pathname,  secretRef,  sourceNamespaces,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (configMapRef != null) { sb.append("configMapRef:"); sb.append(configMapRef + ","); }
    if (gates != null) { sb.append("gates:"); sb.append(gates + ","); }
    if (insecureSkipVerify != null) { sb.append("insecureSkipVerify:"); sb.append(insecureSkipVerify + ","); }
    if (pathname != null) { sb.append("pathname:"); sb.append(pathname + ","); }
    if (secretRef != null) { sb.append("secretRef:"); sb.append(secretRef + ","); }
    if (sourceNamespaces != null && !sourceNamespaces.isEmpty()) { sb.append("sourceNamespaces:"); sb.append(sourceNamespaces + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withInsecureSkipVerify() {
    return withInsecureSkipVerify(true);
  }
  public class ConfigMapRefNested<N> extends ObjectReferenceFluent<ConfigMapRefNested<N>> implements Nested<N>{
    ConfigMapRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ChannelSpecFluent.this.withConfigMapRef(builder.build());
    }
    
    public N endConfigMapRef() {
      return and();
    }
    
  
  }
  public class GatesNested<N> extends ChannelGateFluent<GatesNested<N>> implements Nested<N>{
    GatesNested(ChannelGate item) {
      this.builder = new ChannelGateBuilder(this, item);
    }
    ChannelGateBuilder builder;
    
    public N and() {
      return (N) ChannelSpecFluent.this.withGates(builder.build());
    }
    
    public N endGates() {
      return and();
    }
    
  
  }
  public class SecretRefNested<N> extends ObjectReferenceFluent<SecretRefNested<N>> implements Nested<N>{
    SecretRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ChannelSpecFluent.this.withSecretRef(builder.build());
    }
    
    public N endSecretRef() {
      return and();
    }
    
  
  }

}