package io.fabric8.openclustermanagement.api.model.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class OverridesFluent<A extends OverridesFluent<A>> extends BaseFluent<A>{
  public OverridesFluent() {
  }
  
  public OverridesFluent(Overrides instance) {
    this.copyInstance(instance);
  }
  private String packageAlias;
  private String packageName;
  private ArrayList<PackageOverrideBuilder> packageOverrides = new ArrayList<PackageOverrideBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Overrides instance) {
    instance = (instance != null ? instance : new Overrides());
    if (instance != null) {
          this.withPackageAlias(instance.getPackageAlias());
          this.withPackageName(instance.getPackageName());
          this.withPackageOverrides(instance.getPackageOverrides());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getPackageAlias() {
    return this.packageAlias;
  }
  
  public A withPackageAlias(String packageAlias) {
    this.packageAlias = packageAlias;
    return (A) this;
  }
  
  public boolean hasPackageAlias() {
    return this.packageAlias != null;
  }
  
  public String getPackageName() {
    return this.packageName;
  }
  
  public A withPackageName(String packageName) {
    this.packageName = packageName;
    return (A) this;
  }
  
  public boolean hasPackageName() {
    return this.packageName != null;
  }
  
  public A addToPackageOverrides(int index,PackageOverride item) {
    if (this.packageOverrides == null) {this.packageOverrides = new ArrayList<PackageOverrideBuilder>();}
    PackageOverrideBuilder builder = new PackageOverrideBuilder(item);
    if (index < 0 || index >= packageOverrides.size()) { _visitables.get("packageOverrides").add(builder); packageOverrides.add(builder); } else { _visitables.get("packageOverrides").add(index, builder); packageOverrides.add(index, builder);}
    return (A)this;
  }
  
  public A setToPackageOverrides(int index,PackageOverride item) {
    if (this.packageOverrides == null) {this.packageOverrides = new ArrayList<PackageOverrideBuilder>();}
    PackageOverrideBuilder builder = new PackageOverrideBuilder(item);
    if (index < 0 || index >= packageOverrides.size()) { _visitables.get("packageOverrides").add(builder); packageOverrides.add(builder); } else { _visitables.get("packageOverrides").set(index, builder); packageOverrides.set(index, builder);}
    return (A)this;
  }
  
  public A addToPackageOverrides(io.fabric8.openclustermanagement.api.model.apps.v1.PackageOverride... items) {
    if (this.packageOverrides == null) {this.packageOverrides = new ArrayList<PackageOverrideBuilder>();}
    for (PackageOverride item : items) {PackageOverrideBuilder builder = new PackageOverrideBuilder(item);_visitables.get("packageOverrides").add(builder);this.packageOverrides.add(builder);} return (A)this;
  }
  
  public A addAllToPackageOverrides(Collection<PackageOverride> items) {
    if (this.packageOverrides == null) {this.packageOverrides = new ArrayList<PackageOverrideBuilder>();}
    for (PackageOverride item : items) {PackageOverrideBuilder builder = new PackageOverrideBuilder(item);_visitables.get("packageOverrides").add(builder);this.packageOverrides.add(builder);} return (A)this;
  }
  
  public A removeFromPackageOverrides(io.fabric8.openclustermanagement.api.model.apps.v1.PackageOverride... items) {
    if (this.packageOverrides == null) return (A)this;
    for (PackageOverride item : items) {PackageOverrideBuilder builder = new PackageOverrideBuilder(item);_visitables.get("packageOverrides").remove(builder); this.packageOverrides.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPackageOverrides(Collection<PackageOverride> items) {
    if (this.packageOverrides == null) return (A)this;
    for (PackageOverride item : items) {PackageOverrideBuilder builder = new PackageOverrideBuilder(item);_visitables.get("packageOverrides").remove(builder); this.packageOverrides.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPackageOverrides(Predicate<PackageOverrideBuilder> predicate) {
    if (packageOverrides == null) return (A) this;
    final Iterator<PackageOverrideBuilder> each = packageOverrides.iterator();
    final List visitables = _visitables.get("packageOverrides");
    while (each.hasNext()) {
      PackageOverrideBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PackageOverride> buildPackageOverrides() {
    return this.packageOverrides != null ? build(packageOverrides) : null;
  }
  
  public PackageOverride buildPackageOverride(int index) {
    return this.packageOverrides.get(index).build();
  }
  
  public PackageOverride buildFirstPackageOverride() {
    return this.packageOverrides.get(0).build();
  }
  
  public PackageOverride buildLastPackageOverride() {
    return this.packageOverrides.get(packageOverrides.size() - 1).build();
  }
  
  public PackageOverride buildMatchingPackageOverride(Predicate<PackageOverrideBuilder> predicate) {
      for (PackageOverrideBuilder item : packageOverrides) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPackageOverride(Predicate<PackageOverrideBuilder> predicate) {
      for (PackageOverrideBuilder item : packageOverrides) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPackageOverrides(List<PackageOverride> packageOverrides) {
    if (this.packageOverrides != null) {
      this._visitables.get("packageOverrides").clear();
    }
    if (packageOverrides != null) {
        this.packageOverrides = new ArrayList();
        for (PackageOverride item : packageOverrides) {
          this.addToPackageOverrides(item);
        }
    } else {
      this.packageOverrides = null;
    }
    return (A) this;
  }
  
  public A withPackageOverrides(io.fabric8.openclustermanagement.api.model.apps.v1.PackageOverride... packageOverrides) {
    if (this.packageOverrides != null) {
        this.packageOverrides.clear();
        _visitables.remove("packageOverrides");
    }
    if (packageOverrides != null) {
      for (PackageOverride item : packageOverrides) {
        this.addToPackageOverrides(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPackageOverrides() {
    return this.packageOverrides != null && !this.packageOverrides.isEmpty();
  }
  
  public PackageOverridesNested<A> addNewPackageOverride() {
    return new PackageOverridesNested(-1, null);
  }
  
  public PackageOverridesNested<A> addNewPackageOverrideLike(PackageOverride item) {
    return new PackageOverridesNested(-1, item);
  }
  
  public PackageOverridesNested<A> setNewPackageOverrideLike(int index,PackageOverride item) {
    return new PackageOverridesNested(index, item);
  }
  
  public PackageOverridesNested<A> editPackageOverride(int index) {
    if (packageOverrides.size() <= index) throw new RuntimeException("Can't edit packageOverrides. Index exceeds size.");
    return setNewPackageOverrideLike(index, buildPackageOverride(index));
  }
  
  public PackageOverridesNested<A> editFirstPackageOverride() {
    if (packageOverrides.size() == 0) throw new RuntimeException("Can't edit first packageOverrides. The list is empty.");
    return setNewPackageOverrideLike(0, buildPackageOverride(0));
  }
  
  public PackageOverridesNested<A> editLastPackageOverride() {
    int index = packageOverrides.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last packageOverrides. The list is empty.");
    return setNewPackageOverrideLike(index, buildPackageOverride(index));
  }
  
  public PackageOverridesNested<A> editMatchingPackageOverride(Predicate<PackageOverrideBuilder> predicate) {
    int index = -1;
    for (int i=0;i<packageOverrides.size();i++) { 
    if (predicate.test(packageOverrides.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching packageOverrides. No match found.");
    return setNewPackageOverrideLike(index, buildPackageOverride(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    OverridesFluent that = (OverridesFluent) o;
    if (!java.util.Objects.equals(packageAlias, that.packageAlias)) return false;
    if (!java.util.Objects.equals(packageName, that.packageName)) return false;
    if (!java.util.Objects.equals(packageOverrides, that.packageOverrides)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(packageAlias,  packageName,  packageOverrides,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (packageAlias != null) { sb.append("packageAlias:"); sb.append(packageAlias + ","); }
    if (packageName != null) { sb.append("packageName:"); sb.append(packageName + ","); }
    if (packageOverrides != null && !packageOverrides.isEmpty()) { sb.append("packageOverrides:"); sb.append(packageOverrides + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PackageOverridesNested<N> extends PackageOverrideFluent<PackageOverridesNested<N>> implements Nested<N>{
    PackageOverridesNested(int index,PackageOverride item) {
      this.index = index;
      this.builder = new PackageOverrideBuilder(this, item);
    }
    PackageOverrideBuilder builder;
    int index;
    
    public N and() {
      return (N) OverridesFluent.this.setToPackageOverrides(index,builder.build());
    }
    
    public N endPackageOverride() {
      return and();
    }
    
  
  }

}