package io.fabric8.openclustermanagement.api.model.apps.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PackageFilterBuilder extends PackageFilterFluent<PackageFilterBuilder> implements VisitableBuilder<PackageFilter,PackageFilterBuilder>{
  public PackageFilterBuilder() {
    this(new PackageFilter());
  }
  
  public PackageFilterBuilder(PackageFilterFluent<?> fluent) {
    this(fluent, new PackageFilter());
  }
  
  public PackageFilterBuilder(PackageFilterFluent<?> fluent,PackageFilter instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PackageFilterBuilder(PackageFilter instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PackageFilterFluent<?> fluent;
  
  public PackageFilter build() {
    PackageFilter buildable = new PackageFilter(fluent.getAnnotations(),fluent.buildFilterRef(),fluent.buildLabelSelector(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}