package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ManagedClusterBuilder extends ManagedClusterFluent<ManagedClusterBuilder> implements VisitableBuilder<ManagedCluster,ManagedClusterBuilder>{
  public ManagedClusterBuilder() {
    this(new ManagedCluster());
  }
  
  public ManagedClusterBuilder(ManagedClusterFluent<?> fluent) {
    this(fluent, new ManagedCluster());
  }
  
  public ManagedClusterBuilder(ManagedClusterFluent<?> fluent,ManagedCluster instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ManagedClusterBuilder(ManagedCluster instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ManagedClusterFluent<?> fluent;
  
  public ManagedCluster build() {
    ManagedCluster buildable = new ManagedCluster(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}