package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ManagedClusterVersionBuilder extends ManagedClusterVersionFluent<ManagedClusterVersionBuilder> implements VisitableBuilder<ManagedClusterVersion,ManagedClusterVersionBuilder>{
  public ManagedClusterVersionBuilder() {
    this(new ManagedClusterVersion());
  }
  
  public ManagedClusterVersionBuilder(ManagedClusterVersionFluent<?> fluent) {
    this(fluent, new ManagedClusterVersion());
  }
  
  public ManagedClusterVersionBuilder(ManagedClusterVersionFluent<?> fluent,ManagedClusterVersion instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ManagedClusterVersionBuilder(ManagedClusterVersion instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ManagedClusterVersionFluent<?> fluent;
  
  public ManagedClusterVersion build() {
    ManagedClusterVersion buildable = new ManagedClusterVersion(fluent.getKubernetes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}