package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TaintBuilder extends TaintFluent<TaintBuilder> implements VisitableBuilder<Taint,TaintBuilder>{
  public TaintBuilder() {
    this(new Taint());
  }
  
  public TaintBuilder(TaintFluent<?> fluent) {
    this(fluent, new Taint());
  }
  
  public TaintBuilder(TaintFluent<?> fluent,Taint instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TaintBuilder(Taint instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TaintFluent<?> fluent;
  
  public Taint build() {
    Taint buildable = new Taint(fluent.getEffect(),fluent.getKey(),fluent.getTimeAdded(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}