package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AddOnPlacementScoreStatusFluent<A extends AddOnPlacementScoreStatusFluent<A>> extends BaseFluent<A>{
  public AddOnPlacementScoreStatusFluent() {
  }
  
  public AddOnPlacementScoreStatusFluent(AddOnPlacementScoreStatus instance) {
    this.copyInstance(instance);
  }
  private List<Condition> conditions = new ArrayList<Condition>();
  private ArrayList<AddOnPlacementScoreItemBuilder> scores = new ArrayList<AddOnPlacementScoreItemBuilder>();
  private String validUntil;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AddOnPlacementScoreStatus instance) {
    instance = (instance != null ? instance : new AddOnPlacementScoreStatus());
    if (instance != null) {
          this.withConditions(instance.getConditions());
          this.withScores(instance.getScores());
          this.withValidUntil(instance.getValidUntil());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) { this.conditions.remove(item);} return (A)this;
  }
  
  public List<Condition> getConditions() {
    return this.conditions;
  }
  
  public Condition getCondition(int index) {
    return this.conditions.get(index);
  }
  
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<Condition> predicate) {
      for (Condition item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (Condition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (Condition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public A addToScores(int index,AddOnPlacementScoreItem item) {
    if (this.scores == null) {this.scores = new ArrayList<AddOnPlacementScoreItemBuilder>();}
    AddOnPlacementScoreItemBuilder builder = new AddOnPlacementScoreItemBuilder(item);
    if (index < 0 || index >= scores.size()) { _visitables.get("scores").add(builder); scores.add(builder); } else { _visitables.get("scores").add(index, builder); scores.add(index, builder);}
    return (A)this;
  }
  
  public A setToScores(int index,AddOnPlacementScoreItem item) {
    if (this.scores == null) {this.scores = new ArrayList<AddOnPlacementScoreItemBuilder>();}
    AddOnPlacementScoreItemBuilder builder = new AddOnPlacementScoreItemBuilder(item);
    if (index < 0 || index >= scores.size()) { _visitables.get("scores").add(builder); scores.add(builder); } else { _visitables.get("scores").set(index, builder); scores.set(index, builder);}
    return (A)this;
  }
  
  public A addToScores(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.AddOnPlacementScoreItem... items) {
    if (this.scores == null) {this.scores = new ArrayList<AddOnPlacementScoreItemBuilder>();}
    for (AddOnPlacementScoreItem item : items) {AddOnPlacementScoreItemBuilder builder = new AddOnPlacementScoreItemBuilder(item);_visitables.get("scores").add(builder);this.scores.add(builder);} return (A)this;
  }
  
  public A addAllToScores(Collection<AddOnPlacementScoreItem> items) {
    if (this.scores == null) {this.scores = new ArrayList<AddOnPlacementScoreItemBuilder>();}
    for (AddOnPlacementScoreItem item : items) {AddOnPlacementScoreItemBuilder builder = new AddOnPlacementScoreItemBuilder(item);_visitables.get("scores").add(builder);this.scores.add(builder);} return (A)this;
  }
  
  public A removeFromScores(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.AddOnPlacementScoreItem... items) {
    if (this.scores == null) return (A)this;
    for (AddOnPlacementScoreItem item : items) {AddOnPlacementScoreItemBuilder builder = new AddOnPlacementScoreItemBuilder(item);_visitables.get("scores").remove(builder); this.scores.remove(builder);} return (A)this;
  }
  
  public A removeAllFromScores(Collection<AddOnPlacementScoreItem> items) {
    if (this.scores == null) return (A)this;
    for (AddOnPlacementScoreItem item : items) {AddOnPlacementScoreItemBuilder builder = new AddOnPlacementScoreItemBuilder(item);_visitables.get("scores").remove(builder); this.scores.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromScores(Predicate<AddOnPlacementScoreItemBuilder> predicate) {
    if (scores == null) return (A) this;
    final Iterator<AddOnPlacementScoreItemBuilder> each = scores.iterator();
    final List visitables = _visitables.get("scores");
    while (each.hasNext()) {
      AddOnPlacementScoreItemBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<AddOnPlacementScoreItem> buildScores() {
    return this.scores != null ? build(scores) : null;
  }
  
  public AddOnPlacementScoreItem buildScore(int index) {
    return this.scores.get(index).build();
  }
  
  public AddOnPlacementScoreItem buildFirstScore() {
    return this.scores.get(0).build();
  }
  
  public AddOnPlacementScoreItem buildLastScore() {
    return this.scores.get(scores.size() - 1).build();
  }
  
  public AddOnPlacementScoreItem buildMatchingScore(Predicate<AddOnPlacementScoreItemBuilder> predicate) {
      for (AddOnPlacementScoreItemBuilder item : scores) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingScore(Predicate<AddOnPlacementScoreItemBuilder> predicate) {
      for (AddOnPlacementScoreItemBuilder item : scores) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withScores(List<AddOnPlacementScoreItem> scores) {
    if (this.scores != null) {
      this._visitables.get("scores").clear();
    }
    if (scores != null) {
        this.scores = new ArrayList();
        for (AddOnPlacementScoreItem item : scores) {
          this.addToScores(item);
        }
    } else {
      this.scores = null;
    }
    return (A) this;
  }
  
  public A withScores(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.AddOnPlacementScoreItem... scores) {
    if (this.scores != null) {
        this.scores.clear();
        _visitables.remove("scores");
    }
    if (scores != null) {
      for (AddOnPlacementScoreItem item : scores) {
        this.addToScores(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasScores() {
    return this.scores != null && !this.scores.isEmpty();
  }
  
  public A addNewScore(String name,Integer value) {
    return (A)addToScores(new AddOnPlacementScoreItem(name, value));
  }
  
  public ScoresNested<A> addNewScore() {
    return new ScoresNested(-1, null);
  }
  
  public ScoresNested<A> addNewScoreLike(AddOnPlacementScoreItem item) {
    return new ScoresNested(-1, item);
  }
  
  public ScoresNested<A> setNewScoreLike(int index,AddOnPlacementScoreItem item) {
    return new ScoresNested(index, item);
  }
  
  public ScoresNested<A> editScore(int index) {
    if (scores.size() <= index) throw new RuntimeException("Can't edit scores. Index exceeds size.");
    return setNewScoreLike(index, buildScore(index));
  }
  
  public ScoresNested<A> editFirstScore() {
    if (scores.size() == 0) throw new RuntimeException("Can't edit first scores. The list is empty.");
    return setNewScoreLike(0, buildScore(0));
  }
  
  public ScoresNested<A> editLastScore() {
    int index = scores.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last scores. The list is empty.");
    return setNewScoreLike(index, buildScore(index));
  }
  
  public ScoresNested<A> editMatchingScore(Predicate<AddOnPlacementScoreItemBuilder> predicate) {
    int index = -1;
    for (int i=0;i<scores.size();i++) { 
    if (predicate.test(scores.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching scores. No match found.");
    return setNewScoreLike(index, buildScore(index));
  }
  
  public String getValidUntil() {
    return this.validUntil;
  }
  
  public A withValidUntil(String validUntil) {
    this.validUntil = validUntil;
    return (A) this;
  }
  
  public boolean hasValidUntil() {
    return this.validUntil != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AddOnPlacementScoreStatusFluent that = (AddOnPlacementScoreStatusFluent) o;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(scores, that.scores)) return false;
    if (!java.util.Objects.equals(validUntil, that.validUntil)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(conditions,  scores,  validUntil,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (scores != null && !scores.isEmpty()) { sb.append("scores:"); sb.append(scores + ","); }
    if (validUntil != null) { sb.append("validUntil:"); sb.append(validUntil + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ScoresNested<N> extends AddOnPlacementScoreItemFluent<ScoresNested<N>> implements Nested<N>{
    ScoresNested(int index,AddOnPlacementScoreItem item) {
      this.index = index;
      this.builder = new AddOnPlacementScoreItemBuilder(this, item);
    }
    AddOnPlacementScoreItemBuilder builder;
    int index;
    
    public N and() {
      return (N) AddOnPlacementScoreStatusFluent.this.setToScores(index,builder.build());
    }
    
    public N endScore() {
      return and();
    }
    
  
  }

}