package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RolloutConfigFluent<A extends RolloutConfigFluent<A>> extends BaseFluent<A>{
  public RolloutConfigFluent() {
  }
  
  public RolloutConfigFluent(RolloutConfig instance) {
    this.copyInstance(instance);
  }
  private IntOrStringBuilder maxFailures;
  private Duration minSuccessTime;
  private String progressDeadline;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(RolloutConfig instance) {
    instance = (instance != null ? instance : new RolloutConfig());
    if (instance != null) {
          this.withMaxFailures(instance.getMaxFailures());
          this.withMinSuccessTime(instance.getMinSuccessTime());
          this.withProgressDeadline(instance.getProgressDeadline());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public IntOrString buildMaxFailures() {
    return this.maxFailures != null ? this.maxFailures.build() : null;
  }
  
  public A withMaxFailures(IntOrString maxFailures) {
    this._visitables.remove("maxFailures");
    if (maxFailures != null) {
        this.maxFailures = new IntOrStringBuilder(maxFailures);
        this._visitables.get("maxFailures").add(this.maxFailures);
    } else {
        this.maxFailures = null;
        this._visitables.get("maxFailures").remove(this.maxFailures);
    }
    return (A) this;
  }
  
  public boolean hasMaxFailures() {
    return this.maxFailures != null;
  }
  
  public A withNewMaxFailures(Object value) {
    return (A)withMaxFailures(new IntOrString(value));
  }
  
  public MaxFailuresNested<A> withNewMaxFailures() {
    return new MaxFailuresNested(null);
  }
  
  public MaxFailuresNested<A> withNewMaxFailuresLike(IntOrString item) {
    return new MaxFailuresNested(item);
  }
  
  public MaxFailuresNested<A> editMaxFailures() {
    return withNewMaxFailuresLike(java.util.Optional.ofNullable(buildMaxFailures()).orElse(null));
  }
  
  public MaxFailuresNested<A> editOrNewMaxFailures() {
    return withNewMaxFailuresLike(java.util.Optional.ofNullable(buildMaxFailures()).orElse(new IntOrStringBuilder().build()));
  }
  
  public MaxFailuresNested<A> editOrNewMaxFailuresLike(IntOrString item) {
    return withNewMaxFailuresLike(java.util.Optional.ofNullable(buildMaxFailures()).orElse(item));
  }
  
  public Duration getMinSuccessTime() {
    return this.minSuccessTime;
  }
  
  public A withMinSuccessTime(Duration minSuccessTime) {
    this.minSuccessTime = minSuccessTime;
    return (A) this;
  }
  
  public boolean hasMinSuccessTime() {
    return this.minSuccessTime != null;
  }
  
  public String getProgressDeadline() {
    return this.progressDeadline;
  }
  
  public A withProgressDeadline(String progressDeadline) {
    this.progressDeadline = progressDeadline;
    return (A) this;
  }
  
  public boolean hasProgressDeadline() {
    return this.progressDeadline != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RolloutConfigFluent that = (RolloutConfigFluent) o;
    if (!java.util.Objects.equals(maxFailures, that.maxFailures)) return false;
    if (!java.util.Objects.equals(minSuccessTime, that.minSuccessTime)) return false;
    if (!java.util.Objects.equals(progressDeadline, that.progressDeadline)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(maxFailures,  minSuccessTime,  progressDeadline,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (maxFailures != null) { sb.append("maxFailures:"); sb.append(maxFailures + ","); }
    if (minSuccessTime != null) { sb.append("minSuccessTime:"); sb.append(minSuccessTime + ","); }
    if (progressDeadline != null) { sb.append("progressDeadline:"); sb.append(progressDeadline + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MaxFailuresNested<N> extends IntOrStringFluent<MaxFailuresNested<N>> implements Nested<N>{
    MaxFailuresNested(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    IntOrStringBuilder builder;
    
    public N and() {
      return (N) RolloutConfigFluent.this.withMaxFailures(builder.build());
    }
    
    public N endMaxFailures() {
      return and();
    }
    
  
  }

}