package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RolloutProgressivePerGroupFluent<A extends RolloutProgressivePerGroupFluent<A>> extends BaseFluent<A>{
  public RolloutProgressivePerGroupFluent() {
  }
  
  public RolloutProgressivePerGroupFluent(RolloutProgressivePerGroup instance) {
    this.copyInstance(instance);
  }
  private ArrayList<MandatoryDecisionGroupBuilder> mandatoryDecisionGroups = new ArrayList<MandatoryDecisionGroupBuilder>();
  private IntOrStringBuilder maxFailures;
  private Duration minSuccessTime;
  private String progressDeadline;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(RolloutProgressivePerGroup instance) {
    instance = (instance != null ? instance : new RolloutProgressivePerGroup());
    if (instance != null) {
          this.withMandatoryDecisionGroups(instance.getMandatoryDecisionGroups());
          this.withMaxFailures(instance.getMaxFailures());
          this.withMinSuccessTime(instance.getMinSuccessTime());
          this.withProgressDeadline(instance.getProgressDeadline());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToMandatoryDecisionGroups(int index,MandatoryDecisionGroup item) {
    if (this.mandatoryDecisionGroups == null) {this.mandatoryDecisionGroups = new ArrayList<MandatoryDecisionGroupBuilder>();}
    MandatoryDecisionGroupBuilder builder = new MandatoryDecisionGroupBuilder(item);
    if (index < 0 || index >= mandatoryDecisionGroups.size()) { _visitables.get("mandatoryDecisionGroups").add(builder); mandatoryDecisionGroups.add(builder); } else { _visitables.get("mandatoryDecisionGroups").add(index, builder); mandatoryDecisionGroups.add(index, builder);}
    return (A)this;
  }
  
  public A setToMandatoryDecisionGroups(int index,MandatoryDecisionGroup item) {
    if (this.mandatoryDecisionGroups == null) {this.mandatoryDecisionGroups = new ArrayList<MandatoryDecisionGroupBuilder>();}
    MandatoryDecisionGroupBuilder builder = new MandatoryDecisionGroupBuilder(item);
    if (index < 0 || index >= mandatoryDecisionGroups.size()) { _visitables.get("mandatoryDecisionGroups").add(builder); mandatoryDecisionGroups.add(builder); } else { _visitables.get("mandatoryDecisionGroups").set(index, builder); mandatoryDecisionGroups.set(index, builder);}
    return (A)this;
  }
  
  public A addToMandatoryDecisionGroups(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.MandatoryDecisionGroup... items) {
    if (this.mandatoryDecisionGroups == null) {this.mandatoryDecisionGroups = new ArrayList<MandatoryDecisionGroupBuilder>();}
    for (MandatoryDecisionGroup item : items) {MandatoryDecisionGroupBuilder builder = new MandatoryDecisionGroupBuilder(item);_visitables.get("mandatoryDecisionGroups").add(builder);this.mandatoryDecisionGroups.add(builder);} return (A)this;
  }
  
  public A addAllToMandatoryDecisionGroups(Collection<MandatoryDecisionGroup> items) {
    if (this.mandatoryDecisionGroups == null) {this.mandatoryDecisionGroups = new ArrayList<MandatoryDecisionGroupBuilder>();}
    for (MandatoryDecisionGroup item : items) {MandatoryDecisionGroupBuilder builder = new MandatoryDecisionGroupBuilder(item);_visitables.get("mandatoryDecisionGroups").add(builder);this.mandatoryDecisionGroups.add(builder);} return (A)this;
  }
  
  public A removeFromMandatoryDecisionGroups(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.MandatoryDecisionGroup... items) {
    if (this.mandatoryDecisionGroups == null) return (A)this;
    for (MandatoryDecisionGroup item : items) {MandatoryDecisionGroupBuilder builder = new MandatoryDecisionGroupBuilder(item);_visitables.get("mandatoryDecisionGroups").remove(builder); this.mandatoryDecisionGroups.remove(builder);} return (A)this;
  }
  
  public A removeAllFromMandatoryDecisionGroups(Collection<MandatoryDecisionGroup> items) {
    if (this.mandatoryDecisionGroups == null) return (A)this;
    for (MandatoryDecisionGroup item : items) {MandatoryDecisionGroupBuilder builder = new MandatoryDecisionGroupBuilder(item);_visitables.get("mandatoryDecisionGroups").remove(builder); this.mandatoryDecisionGroups.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromMandatoryDecisionGroups(Predicate<MandatoryDecisionGroupBuilder> predicate) {
    if (mandatoryDecisionGroups == null) return (A) this;
    final Iterator<MandatoryDecisionGroupBuilder> each = mandatoryDecisionGroups.iterator();
    final List visitables = _visitables.get("mandatoryDecisionGroups");
    while (each.hasNext()) {
      MandatoryDecisionGroupBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MandatoryDecisionGroup> buildMandatoryDecisionGroups() {
    return this.mandatoryDecisionGroups != null ? build(mandatoryDecisionGroups) : null;
  }
  
  public MandatoryDecisionGroup buildMandatoryDecisionGroup(int index) {
    return this.mandatoryDecisionGroups.get(index).build();
  }
  
  public MandatoryDecisionGroup buildFirstMandatoryDecisionGroup() {
    return this.mandatoryDecisionGroups.get(0).build();
  }
  
  public MandatoryDecisionGroup buildLastMandatoryDecisionGroup() {
    return this.mandatoryDecisionGroups.get(mandatoryDecisionGroups.size() - 1).build();
  }
  
  public MandatoryDecisionGroup buildMatchingMandatoryDecisionGroup(Predicate<MandatoryDecisionGroupBuilder> predicate) {
      for (MandatoryDecisionGroupBuilder item : mandatoryDecisionGroups) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingMandatoryDecisionGroup(Predicate<MandatoryDecisionGroupBuilder> predicate) {
      for (MandatoryDecisionGroupBuilder item : mandatoryDecisionGroups) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMandatoryDecisionGroups(List<MandatoryDecisionGroup> mandatoryDecisionGroups) {
    if (this.mandatoryDecisionGroups != null) {
      this._visitables.get("mandatoryDecisionGroups").clear();
    }
    if (mandatoryDecisionGroups != null) {
        this.mandatoryDecisionGroups = new ArrayList();
        for (MandatoryDecisionGroup item : mandatoryDecisionGroups) {
          this.addToMandatoryDecisionGroups(item);
        }
    } else {
      this.mandatoryDecisionGroups = null;
    }
    return (A) this;
  }
  
  public A withMandatoryDecisionGroups(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.MandatoryDecisionGroup... mandatoryDecisionGroups) {
    if (this.mandatoryDecisionGroups != null) {
        this.mandatoryDecisionGroups.clear();
        _visitables.remove("mandatoryDecisionGroups");
    }
    if (mandatoryDecisionGroups != null) {
      for (MandatoryDecisionGroup item : mandatoryDecisionGroups) {
        this.addToMandatoryDecisionGroups(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasMandatoryDecisionGroups() {
    return this.mandatoryDecisionGroups != null && !this.mandatoryDecisionGroups.isEmpty();
  }
  
  public A addNewMandatoryDecisionGroup(Integer groupIndex,String groupName) {
    return (A)addToMandatoryDecisionGroups(new MandatoryDecisionGroup(groupIndex, groupName));
  }
  
  public MandatoryDecisionGroupsNested<A> addNewMandatoryDecisionGroup() {
    return new MandatoryDecisionGroupsNested(-1, null);
  }
  
  public MandatoryDecisionGroupsNested<A> addNewMandatoryDecisionGroupLike(MandatoryDecisionGroup item) {
    return new MandatoryDecisionGroupsNested(-1, item);
  }
  
  public MandatoryDecisionGroupsNested<A> setNewMandatoryDecisionGroupLike(int index,MandatoryDecisionGroup item) {
    return new MandatoryDecisionGroupsNested(index, item);
  }
  
  public MandatoryDecisionGroupsNested<A> editMandatoryDecisionGroup(int index) {
    if (mandatoryDecisionGroups.size() <= index) throw new RuntimeException("Can't edit mandatoryDecisionGroups. Index exceeds size.");
    return setNewMandatoryDecisionGroupLike(index, buildMandatoryDecisionGroup(index));
  }
  
  public MandatoryDecisionGroupsNested<A> editFirstMandatoryDecisionGroup() {
    if (mandatoryDecisionGroups.size() == 0) throw new RuntimeException("Can't edit first mandatoryDecisionGroups. The list is empty.");
    return setNewMandatoryDecisionGroupLike(0, buildMandatoryDecisionGroup(0));
  }
  
  public MandatoryDecisionGroupsNested<A> editLastMandatoryDecisionGroup() {
    int index = mandatoryDecisionGroups.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last mandatoryDecisionGroups. The list is empty.");
    return setNewMandatoryDecisionGroupLike(index, buildMandatoryDecisionGroup(index));
  }
  
  public MandatoryDecisionGroupsNested<A> editMatchingMandatoryDecisionGroup(Predicate<MandatoryDecisionGroupBuilder> predicate) {
    int index = -1;
    for (int i=0;i<mandatoryDecisionGroups.size();i++) { 
    if (predicate.test(mandatoryDecisionGroups.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching mandatoryDecisionGroups. No match found.");
    return setNewMandatoryDecisionGroupLike(index, buildMandatoryDecisionGroup(index));
  }
  
  public IntOrString buildMaxFailures() {
    return this.maxFailures != null ? this.maxFailures.build() : null;
  }
  
  public A withMaxFailures(IntOrString maxFailures) {
    this._visitables.remove("maxFailures");
    if (maxFailures != null) {
        this.maxFailures = new IntOrStringBuilder(maxFailures);
        this._visitables.get("maxFailures").add(this.maxFailures);
    } else {
        this.maxFailures = null;
        this._visitables.get("maxFailures").remove(this.maxFailures);
    }
    return (A) this;
  }
  
  public boolean hasMaxFailures() {
    return this.maxFailures != null;
  }
  
  public A withNewMaxFailures(Object value) {
    return (A)withMaxFailures(new IntOrString(value));
  }
  
  public MaxFailuresNested<A> withNewMaxFailures() {
    return new MaxFailuresNested(null);
  }
  
  public MaxFailuresNested<A> withNewMaxFailuresLike(IntOrString item) {
    return new MaxFailuresNested(item);
  }
  
  public MaxFailuresNested<A> editMaxFailures() {
    return withNewMaxFailuresLike(java.util.Optional.ofNullable(buildMaxFailures()).orElse(null));
  }
  
  public MaxFailuresNested<A> editOrNewMaxFailures() {
    return withNewMaxFailuresLike(java.util.Optional.ofNullable(buildMaxFailures()).orElse(new IntOrStringBuilder().build()));
  }
  
  public MaxFailuresNested<A> editOrNewMaxFailuresLike(IntOrString item) {
    return withNewMaxFailuresLike(java.util.Optional.ofNullable(buildMaxFailures()).orElse(item));
  }
  
  public Duration getMinSuccessTime() {
    return this.minSuccessTime;
  }
  
  public A withMinSuccessTime(Duration minSuccessTime) {
    this.minSuccessTime = minSuccessTime;
    return (A) this;
  }
  
  public boolean hasMinSuccessTime() {
    return this.minSuccessTime != null;
  }
  
  public String getProgressDeadline() {
    return this.progressDeadline;
  }
  
  public A withProgressDeadline(String progressDeadline) {
    this.progressDeadline = progressDeadline;
    return (A) this;
  }
  
  public boolean hasProgressDeadline() {
    return this.progressDeadline != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RolloutProgressivePerGroupFluent that = (RolloutProgressivePerGroupFluent) o;
    if (!java.util.Objects.equals(mandatoryDecisionGroups, that.mandatoryDecisionGroups)) return false;
    if (!java.util.Objects.equals(maxFailures, that.maxFailures)) return false;
    if (!java.util.Objects.equals(minSuccessTime, that.minSuccessTime)) return false;
    if (!java.util.Objects.equals(progressDeadline, that.progressDeadline)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(mandatoryDecisionGroups,  maxFailures,  minSuccessTime,  progressDeadline,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (mandatoryDecisionGroups != null && !mandatoryDecisionGroups.isEmpty()) { sb.append("mandatoryDecisionGroups:"); sb.append(mandatoryDecisionGroups + ","); }
    if (maxFailures != null) { sb.append("maxFailures:"); sb.append(maxFailures + ","); }
    if (minSuccessTime != null) { sb.append("minSuccessTime:"); sb.append(minSuccessTime + ","); }
    if (progressDeadline != null) { sb.append("progressDeadline:"); sb.append(progressDeadline + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class MandatoryDecisionGroupsNested<N> extends MandatoryDecisionGroupFluent<MandatoryDecisionGroupsNested<N>> implements Nested<N>{
    MandatoryDecisionGroupsNested(int index,MandatoryDecisionGroup item) {
      this.index = index;
      this.builder = new MandatoryDecisionGroupBuilder(this, item);
    }
    MandatoryDecisionGroupBuilder builder;
    int index;
    
    public N and() {
      return (N) RolloutProgressivePerGroupFluent.this.setToMandatoryDecisionGroups(index,builder.build());
    }
    
    public N endMandatoryDecisionGroup() {
      return and();
    }
    
  
  }
  public class MaxFailuresNested<N> extends IntOrStringFluent<MaxFailuresNested<N>> implements Nested<N>{
    MaxFailuresNested(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    IntOrStringBuilder builder;
    
    public N and() {
      return (N) RolloutProgressivePerGroupFluent.this.withMaxFailures(builder.build());
    }
    
    public N endMaxFailures() {
      return and();
    }
    
  
  }

}