package io.fabric8.openclustermanagement.api.model.cluster.v1beta1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClusterClaimSelectorFluent<A extends ClusterClaimSelectorFluent<A>> extends BaseFluent<A>{
  public ClusterClaimSelectorFluent() {
  }
  
  public ClusterClaimSelectorFluent(ClusterClaimSelector instance) {
    this.copyInstance(instance);
  }
  private List<LabelSelectorRequirement> matchExpressions = new ArrayList<LabelSelectorRequirement>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClusterClaimSelector instance) {
    instance = (instance != null ? instance : new ClusterClaimSelector());
    if (instance != null) {
          this.withMatchExpressions(instance.getMatchExpressions());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToMatchExpressions(int index,LabelSelectorRequirement item) {
    if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<LabelSelectorRequirement>();}
    this.matchExpressions.add(index, item);
    return (A)this;
  }
  
  public A setToMatchExpressions(int index,LabelSelectorRequirement item) {
    if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<LabelSelectorRequirement>();}
    this.matchExpressions.set(index, item); return (A)this;
  }
  
  public A addToMatchExpressions(io.fabric8.kubernetes.api.model.LabelSelectorRequirement... items) {
    if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<LabelSelectorRequirement>();}
    for (LabelSelectorRequirement item : items) {this.matchExpressions.add(item);} return (A)this;
  }
  
  public A addAllToMatchExpressions(Collection<LabelSelectorRequirement> items) {
    if (this.matchExpressions == null) {this.matchExpressions = new ArrayList<LabelSelectorRequirement>();}
    for (LabelSelectorRequirement item : items) {this.matchExpressions.add(item);} return (A)this;
  }
  
  public A removeFromMatchExpressions(io.fabric8.kubernetes.api.model.LabelSelectorRequirement... items) {
    if (this.matchExpressions == null) return (A)this;
    for (LabelSelectorRequirement item : items) { this.matchExpressions.remove(item);} return (A)this;
  }
  
  public A removeAllFromMatchExpressions(Collection<LabelSelectorRequirement> items) {
    if (this.matchExpressions == null) return (A)this;
    for (LabelSelectorRequirement item : items) { this.matchExpressions.remove(item);} return (A)this;
  }
  
  public List<LabelSelectorRequirement> getMatchExpressions() {
    return this.matchExpressions;
  }
  
  public LabelSelectorRequirement getMatchExpression(int index) {
    return this.matchExpressions.get(index);
  }
  
  public LabelSelectorRequirement getFirstMatchExpression() {
    return this.matchExpressions.get(0);
  }
  
  public LabelSelectorRequirement getLastMatchExpression() {
    return this.matchExpressions.get(matchExpressions.size() - 1);
  }
  
  public LabelSelectorRequirement getMatchingMatchExpression(Predicate<LabelSelectorRequirement> predicate) {
      for (LabelSelectorRequirement item : matchExpressions) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingMatchExpression(Predicate<LabelSelectorRequirement> predicate) {
      for (LabelSelectorRequirement item : matchExpressions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withMatchExpressions(List<LabelSelectorRequirement> matchExpressions) {
    if (matchExpressions != null) {
        this.matchExpressions = new ArrayList();
        for (LabelSelectorRequirement item : matchExpressions) {
          this.addToMatchExpressions(item);
        }
    } else {
      this.matchExpressions = null;
    }
    return (A) this;
  }
  
  public A withMatchExpressions(io.fabric8.kubernetes.api.model.LabelSelectorRequirement... matchExpressions) {
    if (this.matchExpressions != null) {
        this.matchExpressions.clear();
        _visitables.remove("matchExpressions");
    }
    if (matchExpressions != null) {
      for (LabelSelectorRequirement item : matchExpressions) {
        this.addToMatchExpressions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasMatchExpressions() {
    return this.matchExpressions != null && !this.matchExpressions.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClusterClaimSelectorFluent that = (ClusterClaimSelectorFluent) o;
    if (!java.util.Objects.equals(matchExpressions, that.matchExpressions)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(matchExpressions,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (matchExpressions != null && !matchExpressions.isEmpty()) { sb.append("matchExpressions:"); sb.append(matchExpressions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}