package io.fabric8.openclustermanagement.api.model.cluster.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterPredicateBuilder extends ClusterPredicateFluent<ClusterPredicateBuilder> implements VisitableBuilder<ClusterPredicate,ClusterPredicateBuilder>{
  public ClusterPredicateBuilder() {
    this(new ClusterPredicate());
  }
  
  public ClusterPredicateBuilder(ClusterPredicateFluent<?> fluent) {
    this(fluent, new ClusterPredicate());
  }
  
  public ClusterPredicateBuilder(ClusterPredicateFluent<?> fluent,ClusterPredicate instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterPredicateBuilder(ClusterPredicate instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterPredicateFluent<?> fluent;
  
  public ClusterPredicate build() {
    ClusterPredicate buildable = new ClusterPredicate(fluent.buildRequiredClusterSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}